/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.os.Parcel;
import android.os.Parcelable;

public class HdmiDeviceInfo
implements Parcelable {
    public static final int ADDR_INTERNAL = 0;
    public static final Parcelable.Creator<HdmiDeviceInfo> CREATOR = new Parcelable.Creator<HdmiDeviceInfo>(){

        @Override
        public HdmiDeviceInfo createFromParcel(Parcel parcel) {
            int n = parcel.readInt();
            int n2 = parcel.readInt();
            int n3 = parcel.readInt();
            switch (n) {
                default: {
                    return null;
                }
                case 0: {
                    int n4 = parcel.readInt();
                    int n5 = parcel.readInt();
                    int n6 = parcel.readInt();
                    int n7 = parcel.readInt();
                    return new HdmiDeviceInfo(n4, n2, n3, n5, n6, parcel.readString(), n7);
                }
                case 1: {
                    int n8 = parcel.readInt();
                    return new HdmiDeviceInfo(n2, n3, parcel.readInt(), n8);
                }
                case 2: 
            }
            return new HdmiDeviceInfo(n2, n3);
        }

        public HdmiDeviceInfo[] newArray(int n) {
            return new HdmiDeviceInfo[n];
        }
    };
    public static final int DEVICE_AUDIO_SYSTEM = 5;
    public static final int DEVICE_INACTIVE = -1;
    public static final int DEVICE_PLAYBACK = 4;
    public static final int DEVICE_PURE_CEC_SWITCH = 6;
    public static final int DEVICE_RECORDER = 1;
    public static final int DEVICE_RESERVED = 2;
    public static final int DEVICE_TUNER = 3;
    public static final int DEVICE_TV = 0;
    public static final int DEVICE_VIDEO_PROCESSOR = 7;
    private static final int HDMI_DEVICE_TYPE_CEC = 0;
    private static final int HDMI_DEVICE_TYPE_HARDWARE = 2;
    private static final int HDMI_DEVICE_TYPE_MHL = 1;
    private static final int ID_OFFSET_CEC = 0;
    private static final int ID_OFFSET_HARDWARE = 192;
    private static final int ID_OFFSET_MHL = 128;
    public static final int PATH_INTERNAL = 0;
    public static final int PATH_INVALID = 65535;
    public static final int PORT_INVALID = -1;
    private final int mAdopterId;
    private final int mDeviceId;
    private final int mDevicePowerStatus;
    private final int mDeviceType;
    private final String mDisplayName;
    private final int mHdmiDeviceType;
    private final int mId;
    private final int mLogicalAddress;
    private final int mPhysicalAddress;
    private final int mPortId;
    private final int mVendorId;

    public HdmiDeviceInfo(int n, int n2) {
        this.mHdmiDeviceType = 2;
        this.mPhysicalAddress = n;
        this.mPortId = n2;
        this.mId = HdmiDeviceInfo.idForHardware(n2);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "HDMI" + n2;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4) {
        this.mHdmiDeviceType = 1;
        this.mPhysicalAddress = n;
        this.mPortId = n2;
        this.mId = HdmiDeviceInfo.idForMhlDevice(n2);
        this.mLogicalAddress = -1;
        this.mDeviceType = 2;
        this.mVendorId = 0;
        this.mDevicePowerStatus = -1;
        this.mDisplayName = "Mobile";
        this.mDeviceId = n3;
        this.mAdopterId = n4;
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4, int n5, String string2) {
        this(n, n2, n3, n4, n5, string2, -1);
    }

    public HdmiDeviceInfo(int n, int n2, int n3, int n4, int n5, String string2, int n6) {
        this.mHdmiDeviceType = 0;
        this.mPhysicalAddress = n2;
        this.mPortId = n3;
        this.mId = HdmiDeviceInfo.idForCecDevice(n);
        this.mLogicalAddress = n;
        this.mDeviceType = n4;
        this.mVendorId = n5;
        this.mDevicePowerStatus = n6;
        this.mDisplayName = string2;
        this.mDeviceId = -1;
        this.mAdopterId = -1;
    }

    public static int idForCecDevice(int n) {
        return n + 0;
    }

    public static int idForHardware(int n) {
        return n + 192;
    }

    public static int idForMhlDevice(int n) {
        return n + 128;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block3: {
            block2: {
                if (!(object instanceof HdmiDeviceInfo)) break block2;
                HdmiDeviceInfo hdmiDeviceInfo = (HdmiDeviceInfo)object;
                if (this.mHdmiDeviceType == hdmiDeviceInfo.mHdmiDeviceType && this.mPhysicalAddress == hdmiDeviceInfo.mPhysicalAddress && this.mPortId == hdmiDeviceInfo.mPortId && this.mLogicalAddress == hdmiDeviceInfo.mLogicalAddress && this.mDeviceType == hdmiDeviceInfo.mDeviceType && this.mVendorId == hdmiDeviceInfo.mVendorId && this.mDevicePowerStatus == hdmiDeviceInfo.mDevicePowerStatus && this.mDisplayName.equals(hdmiDeviceInfo.mDisplayName) && this.mDeviceId == hdmiDeviceInfo.mDeviceId && this.mAdopterId == hdmiDeviceInfo.mAdopterId) break block3;
            }
            return false;
        }
        return true;
    }

    public int getAdopterId() {
        return this.mAdopterId;
    }

    public int getDeviceId() {
        return this.mDeviceId;
    }

    public int getDevicePowerStatus() {
        return this.mDevicePowerStatus;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public int getId() {
        return this.mId;
    }

    public int getLogicalAddress() {
        return this.mLogicalAddress;
    }

    public int getPhysicalAddress() {
        return this.mPhysicalAddress;
    }

    public int getPortId() {
        return this.mPortId;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    public boolean isCecDevice() {
        return this.mHdmiDeviceType == 0;
    }

    public boolean isMhlDevice() {
        return this.mHdmiDeviceType == 1;
    }

    public boolean isSourceType() {
        return this.mDeviceType == 4 || this.mDeviceType == 1 || this.mDeviceType == 3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.mHdmiDeviceType) {
            default: {
                return "";
            }
            case 0: {
                stringBuffer.append("CEC: ");
                StringBuffer stringBuffer2 = stringBuffer.append("logical_address: ");
                Object[] objectArray = new Object[]{this.mLogicalAddress};
                stringBuffer2.append(String.format("0x%02X", objectArray));
                stringBuffer.append(" ");
                stringBuffer.append("device_type: ").append(this.mDeviceType).append(" ");
                stringBuffer.append("vendor_id: ").append(this.mVendorId).append(" ");
                stringBuffer.append("display_name: ").append(this.mDisplayName).append(" ");
                stringBuffer.append("power_status: ").append(this.mDevicePowerStatus).append(" ");
                break;
            }
            case 1: {
                stringBuffer.append("MHL: ");
                StringBuffer stringBuffer3 = stringBuffer.append("device_id: ");
                Object[] objectArray = new Object[]{this.mDeviceId};
                stringBuffer3.append(String.format("0x%04X", objectArray)).append(" ");
                StringBuffer stringBuffer4 = stringBuffer.append("adopter_id: ");
                Object[] objectArray2 = new Object[]{this.mAdopterId};
                stringBuffer4.append(String.format("0x%04X", objectArray2)).append(" ");
                break;
            }
            case 2: {
                stringBuffer.append("Hardware: ");
            }
        }
        StringBuffer stringBuffer5 = stringBuffer.append("physical_address: ");
        Object[] objectArray = new Object[]{this.mPhysicalAddress};
        stringBuffer5.append(String.format("0x%04X", objectArray));
        stringBuffer.append(" ");
        stringBuffer.append("port_id: ").append(this.mPortId);
        return stringBuffer.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mHdmiDeviceType);
        parcel.writeInt(this.mPhysicalAddress);
        parcel.writeInt(this.mPortId);
        switch (this.mHdmiDeviceType) {
            default: {
                return;
            }
            case 0: {
                parcel.writeInt(this.mLogicalAddress);
                parcel.writeInt(this.mDeviceType);
                parcel.writeInt(this.mVendorId);
                parcel.writeInt(this.mDevicePowerStatus);
                parcel.writeString(this.mDisplayName);
                return;
            }
            case 1: 
        }
        parcel.writeInt(this.mDeviceId);
        parcel.writeInt(this.mAdopterId);
    }
}

