/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class TypeReference<T> {
    private final int mHash;
    private final Type mType;

    protected TypeReference() {
        this.mType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    private TypeReference(Type type) {
        this.mType = type;
        if (TypeReference.containsTypeVariable(this.mType)) {
            throw new IllegalArgumentException("Including a type variable in a type reference is not allowed");
        }
        this.mHash = this.mType.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean containsTypeVariable(Type type) {
        if (type == null) return false;
        if (type instanceof TypeVariable) {
            return true;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.getTypeParameters().length == 0) return TypeReference.containsTypeVariable(clazz.getDeclaringClass());
            return true;
        }
        if (!(type instanceof ParameterizedType)) {
            WildcardType wildcardType;
            if (!(type instanceof WildcardType) || !TypeReference.containsTypeVariable((wildcardType = (WildcardType)type).getLowerBounds()) && !TypeReference.containsTypeVariable(wildcardType.getUpperBounds())) return false;
            return true;
        } else {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                if (!TypeReference.containsTypeVariable(typeArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean containsTypeVariable(Type[] typeArray) {
        if (typeArray != null) {
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                if (!TypeReference.containsTypeVariable(typeArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> TypeReference<T> createSpecializedTypeReference(Class<T> clazz) {
        return new SpecializedTypeReference<T>(clazz);
    }

    public static TypeReference<?> createSpecializedTypeReference(Type type) {
        return new SpecializedBaseTypeReference(type);
    }

    private static final Class<?> getArrayClass(Class<?> clazz) {
        return Array.newInstance(clazz, 0).getClass();
    }

    private static Type getComponentType(Type type) {
        Preconditions.checkNotNull(type, "type must not be null");
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof ParameterizedType) {
            return null;
        }
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof WildcardType) {
            throw new UnsupportedOperationException("TODO: support wild card components");
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get component type for type " + type));
    }

    private static final Class<?> getRawType(Type type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            return TypeReference.getArrayClass(TypeReference.getRawType(((GenericArrayType)type).getGenericComponentType()));
        }
        if (type instanceof WildcardType) {
            return TypeReference.getRawType(((WildcardType)type).getUpperBounds());
        }
        if (type instanceof TypeVariable) {
            throw new AssertionError((Object)"Type variables are not allowed in type references");
        }
        throw new AssertionError((Object)("Unhandled branch to get raw type for type " + type));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Class<?> getRawType(Type[] typeArray) {
        if (typeArray == null) {
            return null;
        }
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = TypeReference.getRawType(typeArray[n2]);
            if (clazz != null) return clazz;
            ++n2;
        }
        return null;
    }

    private static void toString(Type type, StringBuilder stringBuilder) {
        if (type == null) {
            return;
        }
        if (type instanceof TypeVariable) {
            stringBuilder.append(((TypeVariable)type).getName());
            return;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            stringBuilder.append(clazz.getName());
            TypeReference.toString(clazz.getTypeParameters(), stringBuilder);
            return;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            stringBuilder.append(((Class)parameterizedType.getRawType()).getName());
            TypeReference.toString(parameterizedType.getActualTypeArguments(), stringBuilder);
            return;
        }
        if (type instanceof GenericArrayType) {
            TypeReference.toString(((GenericArrayType)type).getGenericComponentType(), stringBuilder);
            stringBuilder.append("[]");
            return;
        }
        stringBuilder.append(type.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void toString(Type[] typeArray, StringBuilder stringBuilder) {
        if (typeArray == null || typeArray.length == 0) {
            return;
        }
        stringBuilder.append("<");
        int n = 0;
        while (true) {
            if (n >= typeArray.length) {
                stringBuilder.append(">");
                return;
            }
            TypeReference.toString(typeArray[n], stringBuilder);
            if (n != -1 + typeArray.length) {
                stringBuilder.append(", ");
            }
            ++n;
        }
    }

    public boolean equals(Object object) {
        return object instanceof TypeReference && this.mType.equals(((TypeReference)object).mType);
    }

    public TypeReference<?> getComponentType() {
        Type type = TypeReference.getComponentType(this.mType);
        if (type != null) {
            return TypeReference.createSpecializedTypeReference(type);
        }
        return null;
    }

    public final Class<? super T> getRawType() {
        return TypeReference.getRawType(this.mType);
    }

    public Type getType() {
        return this.mType;
    }

    public int hashCode() {
        return this.mHash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TypeReference<");
        TypeReference.toString(this.getType(), stringBuilder);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    private static class SpecializedBaseTypeReference
    extends TypeReference {
        public SpecializedBaseTypeReference(Type type) {
            super(type);
        }
    }

    private static class SpecializedTypeReference<T>
    extends TypeReference<T> {
        public SpecializedTypeReference(Class<T> clazz) {
            super(clazz);
        }
    }
}

