/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.utils;

import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.Decorator;
import android.os.DeadObjectException;
import android.os.RemoteException;
import java.lang.reflect.Method;

public class CameraBinderDecorator {
    public static final int ALREADY_EXISTS = -17;
    public static final int BAD_VALUE = -22;
    public static final int DEAD_OBJECT = -32;
    public static final int EACCES = -13;
    public static final int EBUSY = -16;
    public static final int ENODEV = -19;
    public static final int EOPNOTSUPP = -95;
    public static final int EUSERS = -87;
    public static final int INVALID_OPERATION = -38;
    public static final int NO_ERROR = 0;
    public static final int PERMISSION_DENIED = -1;
    public static final int TIMED_OUT = -110;

    public static <T> T newInstance(T t) {
        return Decorator.newInstance(t, new CameraBinderDecoratorListener());
    }

    public static void throwOnError(int n) {
        switch (n) {
            default: {
                if (n >= 0) break;
                Object[] objectArray = new Object[]{n};
                throw new UnsupportedOperationException(String.format("Unknown error %d", objectArray));
            }
            case -1: {
                throw new SecurityException("Lacking privileges to access camera service");
            }
            case -22: {
                throw new IllegalArgumentException("Bad argument passed to camera service");
            }
            case -32: {
                throw new CameraRuntimeException(2);
            }
            case -110: {
                throw new CameraRuntimeException(3, "Operation timed out in camera service");
            }
            case -13: {
                throw new CameraRuntimeException(1);
            }
            case -16: {
                throw new CameraRuntimeException(4);
            }
            case -87: {
                throw new CameraRuntimeException(5);
            }
            case -19: {
                throw new CameraRuntimeException(2);
            }
            case -95: {
                throw new CameraRuntimeException(1000);
            }
            case -38: {
                throw new CameraRuntimeException(3, "Illegal state encountered in camera service.");
            }
            case -17: 
            case 0: 
        }
    }

    static class CameraBinderDecoratorListener
    implements Decorator.DecoratorListener {
        CameraBinderDecoratorListener() {
        }

        @Override
        public void onAfterInvocation(Method method, Object[] objectArray, Object object) {
            if (method.getReturnType() == Integer.TYPE) {
                CameraBinderDecorator.throwOnError((Integer)object);
            }
        }

        @Override
        public void onBeforeInvocation(Method method, Object[] objectArray) {
        }

        @Override
        public boolean onCatchException(Method method, Object[] objectArray, Throwable throwable) {
            if (throwable instanceof DeadObjectException) {
                throw new CameraRuntimeException(2, "Process hosting the camera service has died unexpectedly", throwable);
            }
            if (throwable instanceof RemoteException) {
                throw new UnsupportedOperationException("An unknown RemoteException was thrown which should never happen.", throwable);
            }
            return false;
        }

        @Override
        public void onFinally(Method method, Object[] objectArray) {
        }
    }
}

