/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.utils.TypeReference;
import java.nio.ByteBuffer;

public class MarshalQueryableMeteringRectangle
implements MarshalQueryable<MeteringRectangle> {
    private static final int SIZE = 20;

    @Override
    public Marshaler<MeteringRectangle> createMarshaler(TypeReference<MeteringRectangle> typeReference, int n) {
        return new MarshalerMeteringRectangle(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<MeteringRectangle> typeReference, int n) {
        return n == 1 && MeteringRectangle.class.equals((Object)typeReference.getType());
    }

    private class MarshalerMeteringRectangle
    extends Marshaler<MeteringRectangle> {
        protected MarshalerMeteringRectangle(TypeReference<MeteringRectangle> typeReference, int n) {
            super(MarshalQueryableMeteringRectangle.this, typeReference, n);
        }

        @Override
        public int getNativeSize() {
            return 20;
        }

        @Override
        public void marshal(MeteringRectangle meteringRectangle, ByteBuffer byteBuffer) {
            int n = meteringRectangle.getX();
            int n2 = meteringRectangle.getY();
            int n3 = n + meteringRectangle.getWidth();
            int n4 = n2 + meteringRectangle.getHeight();
            int n5 = meteringRectangle.getMeteringWeight();
            byteBuffer.putInt(n);
            byteBuffer.putInt(n2);
            byteBuffer.putInt(n3);
            byteBuffer.putInt(n4);
            byteBuffer.putInt(n5);
        }

        @Override
        public MeteringRectangle unmarshal(ByteBuffer byteBuffer) {
            int n = byteBuffer.getInt();
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            int n4 = byteBuffer.getInt();
            int n5 = byteBuffer.getInt();
            return new MeteringRectangle(n, n2, n3 - n, n4 - n2, n5);
        }
    }
}

