/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal.impl;

import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import android.util.Log;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class MarshalQueryableArray<T>
implements MarshalQueryable<T> {
    private static final String TAG = MarshalQueryableArray.class.getSimpleName();
    private static final boolean VERBOSE = Log.isLoggable(TAG, 2);

    @Override
    public Marshaler<T> createMarshaler(TypeReference<T> typeReference, int n) {
        return new MarshalerArray(typeReference, n);
    }

    @Override
    public boolean isTypeMappingSupported(TypeReference<T> typeReference, int n) {
        return typeReference.getRawType().isArray();
    }

    private class MarshalerArray
    extends Marshaler<T> {
        private final Class<T> mClass;
        private final Class<?> mComponentClass;
        private final Marshaler<?> mComponentMarshaler;

        protected MarshalerArray(TypeReference<T> typeReference, int n) {
            super(MarshalQueryableArray.this, typeReference, n);
            this.mClass = typeReference.getRawType();
            TypeReference<?> typeReference2 = typeReference.getComponentType();
            this.mComponentMarshaler = MarshalRegistry.getMarshaler(typeReference2, this.mNativeType);
            this.mComponentClass = typeReference2.getRawType();
        }

        private <TElem> int calculateElementMarshalSize(Marshaler<TElem> marshaler, Object object, int n) {
            return marshaler.calculateMarshalSize(Array.get(object, n));
        }

        private Object copyListToArray(ArrayList<?> arrayList, Object object) {
            return arrayList.toArray((Object[])object);
        }

        private <TElem> void marshalArrayElement(Marshaler<TElem> marshaler, ByteBuffer byteBuffer, Object object, int n) {
            marshaler.marshal(Array.get(object, n), byteBuffer);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int calculateMarshalSize(T t) {
            int n = this.mComponentMarshaler.getNativeSize();
            int n2 = Array.getLength(t);
            if (n != Marshaler.NATIVE_SIZE_DYNAMIC) {
                return n * n2;
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                n3 += this.calculateElementMarshalSize(this.mComponentMarshaler, t, n4);
                ++n4;
            }
            return n3;
        }

        @Override
        public int getNativeSize() {
            return NATIVE_SIZE_DYNAMIC;
        }

        @Override
        public void marshal(T t, ByteBuffer byteBuffer) {
            int n = Array.getLength(t);
            for (int i = 0; i < n; ++i) {
                this.marshalArrayElement(this.mComponentMarshaler, byteBuffer, t, i);
            }
        }

        @Override
        public T unmarshal(ByteBuffer byteBuffer) {
            Object object;
            int n = this.mComponentMarshaler.getNativeSize();
            if (n != Marshaler.NATIVE_SIZE_DYNAMIC) {
                int n2 = byteBuffer.remaining();
                int n3 = n2 / n;
                if (n2 % n != 0) {
                    throw new UnsupportedOperationException("Arrays for " + this.mTypeReference + " must be packed tighly into a multiple of " + n + "; but there are " + n2 % n + " left over bytes");
                }
                if (VERBOSE) {
                    String string2 = TAG;
                    Object[] objectArray = new Object[]{n3, n, n2, this.mClass};
                    Log.v(string2, String.format("Attempting to unpack array (count = %d, element size = %d, bytes remaining = %d) for type %s", objectArray));
                }
                object = Array.newInstance(this.mComponentClass, n3);
                for (int i = 0; i < n3; ++i) {
                    Array.set(object, i, this.mComponentMarshaler.unmarshal(byteBuffer));
                }
            } else {
                ArrayList arrayList = new ArrayList();
                while (byteBuffer.hasRemaining()) {
                    arrayList.add(this.mComponentMarshaler.unmarshal(byteBuffer));
                }
                int n4 = arrayList.size();
                object = this.copyListToArray(arrayList, Array.newInstance(this.mComponentClass, n4));
            }
            if (byteBuffer.remaining() != 0) {
                Log.e(TAG, "Trailing bytes (" + byteBuffer.remaining() + ") left over after unpacking " + this.mClass);
            }
            return this.mClass.cast(object);
        }
    }
}

