/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.marshal;

import android.hardware.camera2.marshal.MarshalHelpers;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.utils.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MarshalRegistry {
    private static HashMap<MarshalToken<?>, Marshaler<?>> sMarshalerMap;
    private static List<MarshalQueryable<?>> sRegisteredMarshalQueryables;

    static {
        sRegisteredMarshalQueryables = new ArrayList();
        sMarshalerMap = new HashMap();
    }

    private MarshalRegistry() {
        throw new AssertionError();
    }

    public static <T> Marshaler<T> getMarshaler(TypeReference<T> typeReference, int n) {
        MarshalToken<T> marshalToken = new MarshalToken<T>(typeReference, n);
        Marshaler<?> marshaler = sMarshalerMap.get(marshalToken);
        if (sRegisteredMarshalQueryables.size() == 0) {
            throw new AssertionError((Object)"No available query marshalers registered");
        }
        if (marshaler == null) {
            for (MarshalQueryable<?> marshalQueryable : sRegisteredMarshalQueryables) {
                if (!marshalQueryable.isTypeMappingSupported(typeReference, n)) continue;
                marshaler = marshalQueryable.createMarshaler(typeReference, n);
                break;
            }
            if (marshaler == null) {
                throw new UnsupportedOperationException("Could not find marshaler that matches the requested combination of type reference " + typeReference + " and native type " + MarshalHelpers.toStringNativeType(n));
            }
            sMarshalerMap.put(marshalToken, marshaler);
        }
        return marshaler;
    }

    public static <T> void registerMarshalQueryable(MarshalQueryable<T> marshalQueryable) {
        sRegisteredMarshalQueryables.add(marshalQueryable);
    }

    private static class MarshalToken<T> {
        private final int hash;
        final int nativeType;
        final TypeReference<T> typeReference;

        public MarshalToken(TypeReference<T> typeReference, int n) {
            this.typeReference = typeReference;
            this.nativeType = n;
            this.hash = n ^ typeReference.hashCode();
        }

        public boolean equals(Object object) {
            boolean bl = object instanceof MarshalToken;
            boolean bl2 = false;
            if (bl) {
                MarshalToken marshalToken = (MarshalToken)object;
                boolean bl3 = this.typeReference.equals(marshalToken.typeReference);
                bl2 = false;
                if (bl3) {
                    int n = this.nativeType;
                    int n2 = marshalToken.nativeType;
                    bl2 = false;
                    if (n == n2) {
                        bl2 = true;
                    }
                }
            }
            return bl2;
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

