/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.CaptureCollector;
import android.hardware.camera2.legacy.GLThreadManager;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.LegacyFaceDetectMapper;
import android.hardware.camera2.legacy.LegacyFocusStateMapper;
import android.hardware.camera2.legacy.LegacyMetadataMapper;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyResultMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.legacy.RequestHandlerThread;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestQueue;
import android.hardware.camera2.utils.LongParcelable;
import android.hardware.camera2.utils.SizeAreaComparator;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class RequestThreadManager {
    private static final float ASPECT_RATIO_TOLERANCE = 0.01f;
    private static final boolean DEBUG = false;
    private static final int JPEG_FRAME_TIMEOUT = 3000;
    private static final int MAX_IN_FLIGHT_REQUESTS = 2;
    private static final int MSG_CLEANUP = 3;
    private static final int MSG_CONFIGURE_OUTPUTS = 1;
    private static final int MSG_SUBMIT_CAPTURE_REQUEST = 2;
    private static final int PREVIEW_FRAME_TIMEOUT = 1000;
    private static final int REQUEST_COMPLETE_TIMEOUT = 3000;
    private static final boolean USE_BLOB_FORMAT_OVERRIDE = true;
    private static final boolean VERBOSE;
    private final String TAG;
    private final List<Surface> mCallbackOutputs;
    private final Camera mCamera;
    private final int mCameraId;
    private final CaptureCollector mCaptureCollector;
    private final CameraCharacteristics mCharacteristics;
    private final CameraDeviceState mDeviceState;
    private Surface mDummySurface;
    private SurfaceTexture mDummyTexture;
    private final Camera.ErrorCallback mErrorCallback;
    private final LegacyFaceDetectMapper mFaceDetectMapper;
    private final LegacyFocusStateMapper mFocusStateMapper;
    private GLThreadManager mGLThreadManager;
    private final Object mIdleLock;
    private Size mIntermediateBufferSize;
    private final Camera.PictureCallback mJpegCallback;
    private final Camera.ShutterCallback mJpegShutterCallback;
    private final List<Long> mJpegSurfaceIds;
    private LegacyRequest mLastRequest = null;
    private Camera.Parameters mParams;
    private final FpsCounter mPrevCounter;
    private final SurfaceTexture.OnFrameAvailableListener mPreviewCallback;
    private final List<Surface> mPreviewOutputs = new ArrayList<Surface>();
    private boolean mPreviewRunning = false;
    private SurfaceTexture mPreviewTexture;
    private final ConditionVariable mReceivedJpeg;
    private final FpsCounter mRequestCounter;
    private final Handler.Callback mRequestHandlerCb;
    private final RequestQueue mRequestQueue;
    private final RequestHandlerThread mRequestThread;

    static {
        DEBUG = Log.isLoggable("HAL1ShimLogging", 3);
        VERBOSE = Log.isLoggable("HAL1ShimLogging", 2);
    }

    public RequestThreadManager(int n, Camera camera, CameraCharacteristics cameraCharacteristics, CameraDeviceState cameraDeviceState) {
        String string2;
        this.mCallbackOutputs = new ArrayList<Surface>();
        this.mJpegSurfaceIds = new ArrayList<Long>();
        this.mRequestQueue = new RequestQueue(this.mJpegSurfaceIds);
        this.mIdleLock = new Object();
        this.mPrevCounter = new FpsCounter("Incoming Preview");
        this.mRequestCounter = new FpsCounter("Incoming Requests");
        this.mErrorCallback = new Camera.ErrorCallback(){

            @Override
            public void onError(int n, Camera camera) {
                Log.e(RequestThreadManager.this.TAG, "Received error " + n + " from the Camera1 ErrorCallback");
                RequestThreadManager.this.mDeviceState.setError(1);
            }
        };
        this.mReceivedJpeg = new ConditionVariable(false);
        this.mJpegCallback = new Camera.PictureCallback(){

            @Override
            public void onPictureTaken(byte[] byArray, Camera camera) {
                Log.i(RequestThreadManager.this.TAG, "Received jpeg.");
                Pair<RequestHolder, Long> pair = RequestThreadManager.this.mCaptureCollector.jpegProduced();
                if (pair == null || pair.first == null) {
                    Log.e(RequestThreadManager.this.TAG, "Dropping jpeg frame.");
                    return;
                }
                RequestHolder requestHolder = (RequestHolder)pair.first;
                long l = (Long)pair.second;
                for (Surface surface : requestHolder.getHolderTargets()) {
                    try {
                        if (!LegacyCameraDevice.containsSurfaceId(surface, RequestThreadManager.this.mJpegSurfaceIds)) continue;
                        Log.i(RequestThreadManager.this.TAG, "Producing jpeg buffer...");
                        int n = 0xFFFFFFFC & 3 + (byArray.length + LegacyCameraDevice.nativeGetJpegFooterSize());
                        LegacyCameraDevice.setNextTimestamp(surface, l);
                        LegacyCameraDevice.setSurfaceFormat(surface, 1);
                        int n2 = 0xFFFFFFF0 & 15 + (int)Math.ceil(Math.sqrt(n));
                        LegacyCameraDevice.setSurfaceDimens(surface, n2, n2);
                        LegacyCameraDevice.produceFrame(surface, byArray, n2, n2, 33);
                    }
                    catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                        Log.w(RequestThreadManager.this.TAG, "Surface abandoned, dropping frame. ", bufferQueueAbandonedException);
                    }
                }
                RequestThreadManager.this.mReceivedJpeg.open();
            }
        };
        this.mJpegShutterCallback = new Camera.ShutterCallback(){

            @Override
            public void onShutter() {
                RequestThreadManager.this.mCaptureCollector.jpegCaptured(SystemClock.elapsedRealtimeNanos());
            }
        };
        this.mPreviewCallback = new SurfaceTexture.OnFrameAvailableListener(){

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                if (DEBUG) {
                    RequestThreadManager.this.mPrevCounter.countAndLog();
                }
                RequestThreadManager.this.mGLThreadManager.queueNewFrame();
            }
        };
        this.mRequestHandlerCb = new Handler.Callback(){
            private boolean mCleanup = false;
            private final LegacyResultMapper mMapper = new LegacyResultMapper();

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Handled duff style switch with additional control
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean handleMessage(Message var1_1) {
                block52: {
                    block54: {
                        block53: {
                            block48: {
                                block49: {
                                    block50: {
                                        block51: {
                                            if (this.mCleanup) {
                                                return true;
                                            }
                                            if (RequestThreadManager.access$500()) {
                                                Log.d(RequestThreadManager.access$000(RequestThreadManager.this), "Request thread handling message:" + var1_1.what);
                                            }
                                            var2_2 = 0L;
                                            if (RequestThreadManager.access$500()) {
                                                var2_2 = SystemClock.elapsedRealtimeNanos();
                                            }
                                            cfr_temp_0 = 0;
                                            block26: do {
                                                switch (cfr_temp_0 == 0 ? var1_1.what : cfr_temp_0) {
                                                    default: {
                                                        throw new AssertionError((Object)("Unhandled message " + var1_1.what + " on RequestThread."));
                                                    }
                                                    case 1: {
                                                        var50_3 = (ConfigureHolder)var1_1.obj;
                                                        if (var50_3.surfaces == null) ** GOTO lbl29
                                                        var51_4 = var50_3.surfaces.size();
lbl18:
                                                        // 2 sources

                                                        while (true) {
                                                            Log.i(RequestThreadManager.access$000(RequestThreadManager.this), "Configure outputs: " + var51_4 + " surfaces configured.");
                                                            if (!RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(3000L, TimeUnit.MILLISECONDS)) {
                                                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while queueing configure request.");
                                                                RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    case -1: {
                                                        return true;
                                                    }
lbl29:
                                                    // 1 sources

                                                    var51_4 = 0;
                                                    ** continue;
                                                    catch (InterruptedException var53_6) {
                                                        Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Interrupted while waiting for requests to complete.");
                                                        RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                                                        return true;
                                                    }
                                                    RequestThreadManager.access$800(RequestThreadManager.this, var50_3.surfaces);
                                                    var50_3.condition.open();
                                                    if (RequestThreadManager.access$500() == false) return true;
                                                    var55_5 = SystemClock.elapsedRealtimeNanos() - var2_2;
                                                    Log.d(RequestThreadManager.access$000(RequestThreadManager.this), "Configure took " + var55_5 + " ns");
                                                    cfr_temp_0 = -1;
                                                    continue block26;
                                                    case 2: {
                                                        var7_7 = RequestThreadManager.access$900(RequestThreadManager.this).getHandler();
                                                        var8_8 = RequestThreadManager.access$1000(RequestThreadManager.this).getNext();
                                                        if (var8_8 != null) ** GOTO lbl70
                                                        try {
                                                            if (!RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(3000L, TimeUnit.MILLISECONDS)) {
                                                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while waiting for prior requests to complete.");
                                                                RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                                                            }
                                                        }
                                                        catch (InterruptedException var44_10) {
                                                            Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Interrupted while waiting for requests to complete: ", var44_10);
                                                            RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                                                            cfr_temp_0 = -1;
                                                            continue block26;
                                                        }
                                                        var46_9 = RequestThreadManager.access$1100(RequestThreadManager.this);
                                                        synchronized (var46_9) {
                                                            var8_8 = RequestThreadManager.access$1000(RequestThreadManager.this).getNext();
                                                            if (var8_8 == null) {
                                                                RequestThreadManager.access$100(RequestThreadManager.this).setIdle();
                                                                // MONITOREXIT @DISABLED, blocks:[16, 40, 26, 11, 12] lbl67 : MonitorExitStatement: MONITOREXIT : var46_9
                                                                cfr_temp_0 = -1;
                                                                continue block26;
                                                            }
                                                        }
lbl70:
                                                        // 3 sources

                                                        if (var8_8 != null) {
                                                            var7_7.sendEmptyMessage(2);
                                                        }
                                                        var9_11 = ((BurstHolder)var8_8.first).produceRequestHolders((Long)var8_8.second).iterator();
lbl74:
                                                        // 5 sources

                                                        while (true) {
                                                            if (var9_11.hasNext()) {
                                                                var13_14 = var9_11.next();
                                                                var14_15 = var13_14.getRequest();
                                                                if (RequestThreadManager.access$1200(RequestThreadManager.this) != null) {
                                                                    var42_13 = RequestThreadManager.access$1200((RequestThreadManager)RequestThreadManager.this).captureRequest;
                                                                    var18_19 = false;
                                                                    if (var42_13 == var14_15) break block48;
                                                                }
                                                                var15_16 = ParameterUtils.convertSize(RequestThreadManager.access$1300(RequestThreadManager.this).getPreviewSize());
                                                                var16_17 = new LegacyRequest(RequestThreadManager.access$1400(RequestThreadManager.this), var14_15, var15_16, RequestThreadManager.access$1300(RequestThreadManager.this));
                                                                LegacyMetadataMapper.convertRequestMetadata(var16_17);
                                                                var17_18 = RequestThreadManager.access$1300(RequestThreadManager.this).same(var16_17.parameters);
                                                                var18_19 = false;
                                                                if (var17_18) break block49;
                                                                RequestThreadManager.access$1500(RequestThreadManager.this).setParameters(var16_17.parameters);
                                                                var18_19 = true;
                                                                break block50;
                                                            }
lbl92:
                                                            // 6 sources

                                                            while (true) {
                                                                if (RequestThreadManager.access$500() == false) return true;
                                                                var10_23 = SystemClock.elapsedRealtimeNanos() - var2_2;
                                                                Log.d(RequestThreadManager.access$000(RequestThreadManager.this), "Capture request took " + var10_23 + " ns");
                                                                RequestThreadManager.access$2100(RequestThreadManager.this).countAndLog();
                                                                cfr_temp_0 = -1;
                                                                continue block26;
                                                                break;
                                                            }
                                                            break;
                                                        }
                                                    }
                                                    case 3: 
                                                }
                                                break;
                                            } while (true);
                                            this.mCleanup = true;
                                            try {
                                                if (RequestThreadManager.access$200(RequestThreadManager.this).waitForEmpty(3000L, TimeUnit.MILLISECONDS)) break block51;
                                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while queueing cleanup request.");
                                                RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                                            }
                                            catch (InterruptedException var4_27) {
                                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Interrupted while waiting for requests to complete: ", var4_27);
                                                RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                                                ** continue;
                                            }
                                        }
lbl115:
                                        // 2 sources

                                        while (true) {
                                            if (RequestThreadManager.access$700(RequestThreadManager.this) != null) {
                                                RequestThreadManager.access$700(RequestThreadManager.this).quit();
                                            }
                                            if (RequestThreadManager.access$1500(RequestThreadManager.this) != null) {
                                                RequestThreadManager.access$1500(RequestThreadManager.this).release();
                                            }
                                            RequestThreadManager.access$2300(RequestThreadManager.this, RequestThreadManager.access$2200(RequestThreadManager.this));
                                            return true;
                                        }
                                    }
                                    RequestThreadManager.access$1302(RequestThreadManager.this, var16_17.parameters);
                                }
                                RequestThreadManager.access$1202(RequestThreadManager.this, var16_17);
                            }
                            ** try [egrp 5[TRYBLOCK] [7, 8 : 722->787)] { 
lbl130:
                            // 1 sources

                            break block53;
lbl131:
                            // 1 sources

                            catch (IOException var22_22) {
                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Received device exception: ", var22_22);
                                RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                                ** GOTO lbl92
                            }
lbl136:
                            // 1 sources

                            catch (InterruptedException var20_24) {
                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Interrupted during capture: ", var20_24);
                                RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                                ** GOTO lbl92
                            }
                            catch (RuntimeException var38_12) {
                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Exception while setting camera parameters: ", var38_12);
                                var13_14.failRequest();
                                RequestThreadManager.access$100(RequestThreadManager.this).setCaptureStart(var13_14, 0L, 3);
                                ** GOTO lbl74
                            }
                        }
                        if (RequestThreadManager.access$200(RequestThreadManager.this).queueRequest(var13_14, RequestThreadManager.access$1200(RequestThreadManager.this), 3000L, TimeUnit.MILLISECONDS)) break block54;
                        Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while queueing capture request.");
                        var13_14.failRequest();
                        RequestThreadManager.access$100(RequestThreadManager.this).setCaptureStart(var13_14, 0L, 3);
                        ** GOTO lbl74
                    }
                    if (var13_14.hasPreviewTargets()) {
                        RequestThreadManager.access$1600(RequestThreadManager.this, var13_14);
                    }
                    if (!var13_14.hasJpegTargets()) ** GOTO lbl167
                    while (!RequestThreadManager.access$200(RequestThreadManager.this).waitForPreviewsEmpty(1000L, TimeUnit.MILLISECONDS)) {
                        Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while waiting for preview requests to complete.");
                        RequestThreadManager.access$200(RequestThreadManager.this).failNextPreview();
                    }
                    {
                        RequestThreadManager.access$400(RequestThreadManager.this).close();
                        RequestThreadManager.access$1700(RequestThreadManager.this, var13_14);
lbl167:
                        // 2 sources

                        RequestThreadManager.access$1800(RequestThreadManager.this).processFaceDetectMode(var14_15, RequestThreadManager.access$1300(RequestThreadManager.this));
                        RequestThreadManager.access$1900(RequestThreadManager.this).processRequestTriggers(var14_15, RequestThreadManager.access$1300(RequestThreadManager.this));
                        if (var13_14.hasJpegTargets()) {
                            RequestThreadManager.access$2000(RequestThreadManager.this, var13_14);
                            if (!RequestThreadManager.access$400(RequestThreadManager.this).block(3000L)) {
                                Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Hit timeout for jpeg callback!");
                                RequestThreadManager.access$200(RequestThreadManager.this).failNextJpeg();
                            }
                        }
                        if (!var18_19) break block52;
                    }
                    if (RequestThreadManager.access$500()) {
                        Log.d(RequestThreadManager.access$000(RequestThreadManager.this), "Params changed -- getting new Parameters from HAL.");
                    }
                    try {
                        RequestThreadManager.access$1302(RequestThreadManager.this, RequestThreadManager.access$1500(RequestThreadManager.this).getParameters());
                    }
                    catch (RuntimeException var30_25) {
                        Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Received device exception: ", var30_25);
                        RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                        ** continue;
                    }
                    RequestThreadManager.access$1200(RequestThreadManager.this).setParameters(RequestThreadManager.access$1300(RequestThreadManager.this));
                }
                var24_20 = new MutableLong(0L);
                try {}
                catch (InterruptedException var25_26) {
                    Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Interrupted waiting for request completion: ", var25_26);
                    RequestThreadManager.access$100(RequestThreadManager.this).setError(1);
                    ** GOTO lbl92
                }
                if (!RequestThreadManager.access$200(RequestThreadManager.this).waitForRequestCompleted(var13_14, 3000L, TimeUnit.MILLISECONDS, var24_20)) {
                    Log.e(RequestThreadManager.access$000(RequestThreadManager.this), "Timed out while waiting for request to complete.");
                    RequestThreadManager.access$200(RequestThreadManager.this).failAll();
                }
                var27_21 = this.mMapper.cachedConvertResultMetadata(RequestThreadManager.access$1200(RequestThreadManager.this), var24_20.value);
                RequestThreadManager.access$1900(RequestThreadManager.this).mapResultTriggers(var27_21);
                RequestThreadManager.access$1800(RequestThreadManager.this).mapResultFaces(var27_21, RequestThreadManager.access$1200(RequestThreadManager.this));
                if (var13_14.requestFailed()) ** GOTO lbl74
                RequestThreadManager.access$100(RequestThreadManager.this).setCaptureResult(var13_14, var27_21, -1);
                ** while (true)
            }
        };
        this.mCamera = Preconditions.checkNotNull(camera, "camera must not be null");
        this.mCameraId = n;
        this.mCharacteristics = Preconditions.checkNotNull(cameraCharacteristics, "characteristics must not be null");
        Object[] objectArray = new Object[]{n};
        this.TAG = string2 = String.format("RequestThread-%d", objectArray);
        this.mDeviceState = Preconditions.checkNotNull(cameraDeviceState, "deviceState must not be null");
        this.mFocusStateMapper = new LegacyFocusStateMapper(this.mCamera);
        this.mFaceDetectMapper = new LegacyFaceDetectMapper(this.mCamera, this.mCharacteristics);
        this.mCaptureCollector = new CaptureCollector(2, this.mDeviceState);
        this.mRequestThread = new RequestHandlerThread(string2, this.mRequestHandlerCb);
        this.mCamera.setErrorCallback(this.mErrorCallback);
    }

    static /* synthetic */ RequestQueue access$1000(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mRequestQueue;
    }

    static /* synthetic */ Object access$1100(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mIdleLock;
    }

    static /* synthetic */ LegacyRequest access$1200(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mLastRequest;
    }

    static /* synthetic */ LegacyRequest access$1202(RequestThreadManager requestThreadManager, LegacyRequest legacyRequest) {
        requestThreadManager.mLastRequest = legacyRequest;
        return legacyRequest;
    }

    static /* synthetic */ Camera.Parameters access$1300(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mParams;
    }

    static /* synthetic */ Camera.Parameters access$1302(RequestThreadManager requestThreadManager, Camera.Parameters parameters) {
        requestThreadManager.mParams = parameters;
        return parameters;
    }

    static /* synthetic */ CameraCharacteristics access$1400(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mCharacteristics;
    }

    static /* synthetic */ Camera access$1500(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mCamera;
    }

    static /* synthetic */ void access$1600(RequestThreadManager requestThreadManager, RequestHolder requestHolder) throws IOException {
        requestThreadManager.doPreviewCapture(requestHolder);
    }

    static /* synthetic */ void access$1700(RequestThreadManager requestThreadManager, RequestHolder requestHolder) throws IOException {
        requestThreadManager.doJpegCapturePrepare(requestHolder);
    }

    static /* synthetic */ LegacyFaceDetectMapper access$1800(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mFaceDetectMapper;
    }

    static /* synthetic */ LegacyFocusStateMapper access$1900(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mFocusStateMapper;
    }

    static /* synthetic */ void access$2000(RequestThreadManager requestThreadManager, RequestHolder requestHolder) {
        requestThreadManager.doJpegCapture(requestHolder);
    }

    static /* synthetic */ FpsCounter access$2100(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mRequestCounter;
    }

    static /* synthetic */ List access$2200(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mCallbackOutputs;
    }

    static /* synthetic */ void access$2300(RequestThreadManager requestThreadManager, Collection collection) {
        requestThreadManager.resetJpegSurfaceFormats(collection);
    }

    static /* synthetic */ void access$800(RequestThreadManager requestThreadManager, Collection collection) {
        requestThreadManager.configureOutputs(collection);
    }

    static /* synthetic */ RequestHandlerThread access$900(RequestThreadManager requestThreadManager) {
        return requestThreadManager.mRequestThread;
    }

    private Size calculatePictureSize(Collection<Surface> collection, Camera.Parameters parameters) {
        ArrayList<Size> arrayList = new ArrayList<Size>();
        for (Surface surface : collection) {
            try {
                if (!LegacyCameraDevice.containsSurfaceId(surface, this.mJpegSurfaceIds)) continue;
                arrayList.add(LegacyCameraDevice.getSurfaceSize(surface));
            }
            catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                Log.w(this.TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
            }
        }
        if (!arrayList.isEmpty()) {
            int n = -1;
            int n2 = -1;
            for (Size size : arrayList) {
                if (size.getWidth() > n) {
                    n = size.getWidth();
                }
                if (size.getHeight() <= n2) continue;
                n2 = size.getHeight();
            }
            Size size = new Size(n, n2);
            List<Size> list = ParameterUtils.convertSizeList(parameters.getSupportedPictureSizes());
            ArrayList<Size> arrayList2 = new ArrayList<Size>();
            for (Size size2 : list) {
                if (size2.getWidth() < n || size2.getHeight() < n2) continue;
                arrayList2.add(size2);
            }
            if (arrayList2.isEmpty()) {
                throw new AssertionError((Object)("Could not find any supported JPEG sizes large enough to fit " + size));
            }
            Size size3 = Collections.min(arrayList2, new SizeAreaComparator());
            if (!size3.equals(size)) {
                Log.w(this.TAG, String.format("configureOutputs - Will need to crop picture %s into smallest bound size %s", size3, size));
            }
            return size3;
        }
        return null;
    }

    private static boolean checkAspectRatiosMatch(Size size, Size size2) {
        return Math.abs((float)size.getWidth() / (float)size.getHeight() - (float)size2.getWidth() / (float)size2.getHeight()) < 0.01f;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureOutputs(Collection<Surface> var1_1) {
        block28: {
            block27: {
                block26: {
                    block25: {
                        if (RequestThreadManager.DEBUG) {
                            var41_2 = var1_1 == null ? "null" : var1_1.size() + " surfaces";
                            Log.d(this.TAG, "configureOutputs with " + var41_2);
                        }
                        this.stopPreview();
                        try {
                            this.mCamera.setPreviewTexture(null);
lbl8:
                            // 2 sources

                            while (true) {
                                if (this.mGLThreadManager != null) {
                                    this.mGLThreadManager.waitUntilStarted();
                                    this.mGLThreadManager.ignoreNewFrames();
                                    this.mGLThreadManager.waitUntilIdle();
                                }
                                this.resetJpegSurfaceFormats(this.mCallbackOutputs);
                                this.mPreviewOutputs.clear();
                                this.mCallbackOutputs.clear();
                                this.mJpegSurfaceIds.clear();
                                this.mPreviewTexture = null;
                                var4_4 = this.mCharacteristics.get(CameraCharacteristics.LENS_FACING);
                                var5_5 = this.mCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                                if (var1_1 == null) break block25;
                                var33_6 = var1_1.iterator();
                                break;
                            }
                        }
                        catch (IOException var2_3) {
                            Log.w(this.TAG, "Failed to clear prior SurfaceTexture, may cause GL deadlock: ", var2_3);
                            ** continue;
                        }
                        while (var33_6.hasNext()) {
                            var34_7 = var33_6.next();
                            var37_9 = LegacyCameraDevice.detectSurfaceType(var34_7);
                            LegacyCameraDevice.setSurfaceOrientation(var34_7, var4_4, var5_5);
                            switch (var37_9) {
                                default: {
                                    this.mPreviewOutputs.add(var34_7);
                                }
                                case 33: 
                            }
                            try {
                                LegacyCameraDevice.setSurfaceFormat(var34_7, 1);
                                this.mJpegSurfaceIds.add(LegacyCameraDevice.getSurfaceId(var34_7));
                                this.mCallbackOutputs.add(var34_7);
                            }
                            catch (LegacyExceptionUtils.BufferQueueAbandonedException var35_8) {
                                Log.w(this.TAG, "Surface abandoned, skipping...", var35_8);
                            }
                        }
                    }
                    try {
                        this.mParams = this.mCamera.getParameters();
                    }
                    catch (RuntimeException var6_15) {
                        Log.e(this.TAG, "Received device exception: ", var6_15);
                        this.mDeviceState.setError(1);
                        return;
                    }
                    var8_10 = this.getPhotoPreviewFpsRange(this.mParams.getSupportedPreviewFpsRange());
                    if (RequestThreadManager.DEBUG) {
                        Log.d(this.TAG, "doPreviewCapture - Selected range [" + var8_10[0] + "," + var8_10[1] + "]");
                    }
                    this.mParams.setPreviewFpsRange(var8_10[0], var8_10[1]);
                    if (this.mPreviewOutputs.size() <= 0) break block26;
                    var9_11 = new ArrayList<Size>(var1_1.size());
                    var10_12 = this.mPreviewOutputs.iterator();
                    break block27;
                }
                this.mIntermediateBufferSize = null;
                if (RequestThreadManager.DEBUG) {
                    Log.d(this.TAG, "No Intermediate buffer selected, no preview outputs were configured");
                }
                break block28;
            }
            while (var10_12.hasNext()) {
                var27_13 = var10_12.next();
                try {
                    var9_11.add(LegacyCameraDevice.getSurfaceSize(var27_13));
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException var28_14) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", var28_14);
                }
            }
            var11_16 = SizeAreaComparator.findLargestByArea(var9_11);
            var12_17 = ParameterUtils.getLargestSupportedJpegSizeByArea(this.mParams);
            var13_18 = ParameterUtils.convertSizeList(this.mParams.getSupportedPreviewSizes());
            var14_19 = (long)var11_16.getHeight() * (long)var11_16.getWidth();
            var16_20 = SizeAreaComparator.findLargestByArea(var13_18);
            for (Size var22_22 : var13_18) {
                var23_23 = var22_22.getWidth() * var22_22.getHeight();
                var25_24 = var16_20.getWidth() * var16_20.getHeight();
                if (!RequestThreadManager.checkAspectRatiosMatch(var12_17, var22_22) || var23_23 >= var25_24 || var23_23 < var14_19) continue;
                var16_20 = var22_22;
            }
            this.mIntermediateBufferSize = var16_20;
            this.mParams.setPreviewSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
            if (RequestThreadManager.DEBUG) {
                Log.d(this.TAG, "Intermediate buffer selected with dimens: " + var16_20.toString());
            }
        }
        if ((var18_25 = this.calculatePictureSize(this.mCallbackOutputs, this.mParams)) != null) {
            Log.i(this.TAG, "configureOutputs - set take picture size to " + var18_25);
            this.mParams.setPictureSize(var18_25.getWidth(), var18_25.getHeight());
        }
        if (this.mGLThreadManager == null) {
            this.mGLThreadManager = var19_26 = new GLThreadManager(this.mCameraId, var4_4, this.mDeviceState);
            this.mGLThreadManager.start();
        }
        this.mGLThreadManager.waitUntilStarted();
        this.mGLThreadManager.setConfigurationAndWait(this.mPreviewOutputs, this.mCaptureCollector);
        this.mGLThreadManager.allowNewFrames();
        this.mPreviewTexture = this.mGLThreadManager.getCurrentSurfaceTexture();
        if (this.mPreviewTexture != null) {
            this.mPreviewTexture.setOnFrameAvailableListener(this.mPreviewCallback);
        }
        this.mCamera.setParameters(this.mParams);
    }

    private void createDummySurface() {
        if (this.mDummyTexture == null || this.mDummySurface == null) {
            this.mDummyTexture = new SurfaceTexture(0);
            this.mDummyTexture.setDefaultBufferSize(640, 480);
            this.mDummySurface = new Surface(this.mDummyTexture);
        }
    }

    private void doJpegCapture(RequestHolder requestHolder) {
        if (DEBUG) {
            Log.d(this.TAG, "doJpegCapturePrepare");
        }
        this.mCamera.takePicture(this.mJpegShutterCallback, null, this.mJpegCallback);
        this.mPreviewRunning = false;
    }

    private void doJpegCapturePrepare(RequestHolder requestHolder) throws IOException {
        if (DEBUG) {
            Log.d(this.TAG, "doJpegCapturePrepare - preview running? " + this.mPreviewRunning);
        }
        if (!this.mPreviewRunning) {
            if (DEBUG) {
                Log.d(this.TAG, "doJpegCapture - create fake surface");
            }
            this.createDummySurface();
            this.mCamera.setPreviewTexture(this.mDummyTexture);
            this.startPreview();
        }
    }

    private void doPreviewCapture(RequestHolder requestHolder) throws IOException {
        if (VERBOSE) {
            Log.v(this.TAG, "doPreviewCapture - preview running? " + this.mPreviewRunning);
        }
        if (this.mPreviewRunning) {
            return;
        }
        if (this.mPreviewTexture == null) {
            throw new IllegalStateException("Preview capture called with no preview surfaces configured.");
        }
        this.mPreviewTexture.setDefaultBufferSize(this.mIntermediateBufferSize.getWidth(), this.mIntermediateBufferSize.getHeight());
        this.mCamera.setPreviewTexture(this.mPreviewTexture);
        this.startPreview();
    }

    private int[] getPhotoPreviewFpsRange(List<int[]> list) {
        if (list.size() == 0) {
            Log.e(this.TAG, "No supported frame rates returned!");
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int[] nArray : list) {
            int n5 = nArray[0];
            int n6 = nArray[1];
            if (n6 > n2 || n6 == n2 && n5 > n) {
                n = n5;
                n2 = n6;
                n3 = n4;
            }
            ++n4;
        }
        return list.get(n3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetJpegSurfaceFormats(Collection<Surface> collection) {
        if (collection != null) {
            for (Surface surface : collection) {
                try {
                    LegacyCameraDevice.setSurfaceFormat(surface, 33);
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                    Log.w(this.TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
                }
            }
        }
    }

    private void startPreview() {
        if (VERBOSE) {
            Log.v(this.TAG, "startPreview - preview running? " + this.mPreviewRunning);
        }
        if (!this.mPreviewRunning) {
            this.mCamera.startPreview();
            this.mPreviewRunning = true;
        }
    }

    private void stopPreview() {
        if (VERBOSE) {
            Log.v(this.TAG, "stopPreview - preview running? " + this.mPreviewRunning);
        }
        if (this.mPreviewRunning) {
            this.mCamera.stopPreview();
            this.mPreviewRunning = false;
        }
    }

    public long cancelRepeating(int n) {
        return this.mRequestQueue.stopRepeating(n);
    }

    public void configure(Collection<Surface> collection) {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        ConditionVariable conditionVariable = new ConditionVariable(false);
        handler.sendMessage(handler.obtainMessage(1, 0, 0, new ConfigureHolder(conditionVariable, collection)));
        conditionVariable.block();
    }

    public long flush() {
        Log.i(this.TAG, "Flushing all pending requests.");
        long l = this.mRequestQueue.stopRepeating();
        this.mCaptureCollector.failAll();
        return l;
    }

    public void quit() {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        handler.sendMessageAtFrontOfQueue(handler.obtainMessage(3));
        this.mRequestThread.quitSafely();
        try {
            this.mRequestThread.join();
            return;
        }
        catch (InterruptedException interruptedException) {
            String string2 = this.TAG;
            Object[] objectArray = new Object[]{this.mRequestThread.getName(), this.mRequestThread.getId()};
            Log.e(string2, String.format("Thread %s (%d) interrupted while quitting.", objectArray));
            return;
        }
    }

    public void start() {
        this.mRequestThread.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submitCaptureRequests(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        Handler handler = this.mRequestThread.waitAndGetHandler();
        Object object = this.mIdleLock;
        synchronized (object) {
            int n = this.mRequestQueue.submit(list, bl, longParcelable);
            handler.sendEmptyMessage(2);
            return n;
        }
    }

    private static class ConfigureHolder {
        public final ConditionVariable condition;
        public final Collection<Surface> surfaces;

        public ConfigureHolder(ConditionVariable conditionVariable, Collection<Surface> collection) {
            this.condition = conditionVariable;
            this.surfaces = collection;
        }
    }

    public static class FpsCounter {
        private static final long NANO_PER_SECOND = 1000000000L;
        private static final String TAG = "FpsCounter";
        private int mFrameCount = 0;
        private double mLastFps = 0.0;
        private long mLastPrintTime = 0L;
        private long mLastTime = 0L;
        private final String mStreamType;

        public FpsCounter(String string2) {
            this.mStreamType = string2;
        }

        public double checkFps() {
            synchronized (this) {
                double d = this.mLastFps;
                return d;
            }
        }

        public void countAndLog() {
            synchronized (this) {
                this.countFrame();
                this.staggeredLog();
                return;
            }
        }

        public void countFrame() {
            synchronized (this) {
                this.mFrameCount = 1 + this.mFrameCount;
                long l = SystemClock.elapsedRealtimeNanos();
                if (this.mLastTime == 0L) {
                    this.mLastTime = l;
                }
                if (l > 1000000000L + this.mLastTime) {
                    long l2 = l - this.mLastTime;
                    this.mLastFps = (double)this.mFrameCount * (1.0E9 / (double)l2);
                    this.mFrameCount = 0;
                    this.mLastTime = l;
                }
                return;
            }
        }

        public void staggeredLog() {
            synchronized (this) {
                if (this.mLastTime > 5000000000L + this.mLastPrintTime) {
                    this.mLastPrintTime = this.mLastTime;
                    Log.d(TAG, "FPS for " + this.mStreamType + " stream: " + this.mLastFps);
                }
                return;
            }
        }
    }
}

