/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.BurstHolder;
import android.hardware.camera2.utils.LongParcelable;
import android.util.Log;
import android.util.Pair;
import java.util.ArrayDeque;
import java.util.List;

public class RequestQueue {
    private static final long INVALID_FRAME = -1L;
    private static final String TAG = "RequestQueue";
    private long mCurrentFrameNumber = 0L;
    private long mCurrentRepeatingFrameNumber = -1L;
    private int mCurrentRequestId = 0;
    private final List<Long> mJpegSurfaceIds;
    private BurstHolder mRepeatingRequest = null;
    private final ArrayDeque<BurstHolder> mRequestQueue = new ArrayDeque();

    public RequestQueue(List<Long> list) {
        this.mJpegSurfaceIds = list;
    }

    private long calculateLastFrame(int n) {
        long l = this.mCurrentFrameNumber;
        for (BurstHolder burstHolder : this.mRequestQueue) {
            l += (long)burstHolder.getNumberOfRequests();
            if (burstHolder.getRequestId() != n) continue;
            return l - 1L;
        }
        throw new IllegalStateException("At least one request must be in the queue to calculate frame number");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<BurstHolder, Long> getNext() {
        synchronized (this) {
            BurstHolder burstHolder;
            block8: {
                burstHolder = this.mRequestQueue.poll();
                if (burstHolder != null) break block8;
                if (this.mRepeatingRequest == null) break block8;
                burstHolder = this.mRepeatingRequest;
                this.mCurrentRepeatingFrameNumber = this.mCurrentFrameNumber + (long)burstHolder.getNumberOfRequests();
            }
            if (burstHolder == null) {
                return null;
            }
            Pair<BurstHolder, Long> pair = new Pair<BurstHolder, Long>(burstHolder, this.mCurrentFrameNumber);
            this.mCurrentFrameNumber += (long)burstHolder.getNumberOfRequests();
            return pair;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long stopRepeating() {
        synchronized (this) {
            block4: {
                if (this.mRepeatingRequest != null) break block4;
                Log.e(TAG, "cancel failed: no repeating request exists.");
                return -1L;
            }
            long l = this.stopRepeating(this.mRepeatingRequest.getRequestId());
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long stopRepeating(int n) {
        synchronized (this) {
            long l = -1L;
            if (this.mRepeatingRequest != null && this.mRepeatingRequest.getRequestId() == n) {
                this.mRepeatingRequest = null;
                l = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
                this.mCurrentRepeatingFrameNumber = -1L;
                Log.i(TAG, "Repeating capture request cancelled.");
            } else {
                Log.e(TAG, "cancel failed: no repeating request exists for request id: " + n);
            }
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int submit(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        synchronized (this) {
            int n = this.mCurrentRequestId;
            this.mCurrentRequestId = n + 1;
            BurstHolder burstHolder = new BurstHolder(n, bl, list, this.mJpegSurfaceIds);
            long l = -1L;
            if (burstHolder.isRepeating()) {
                Log.i(TAG, "Repeating capture request set.");
                if (this.mRepeatingRequest != null) {
                    l = this.mCurrentRepeatingFrameNumber == -1L ? -1L : this.mCurrentRepeatingFrameNumber - 1L;
                }
                this.mCurrentRepeatingFrameNumber = -1L;
                this.mRepeatingRequest = burstHolder;
            } else {
                long l2;
                this.mRequestQueue.offer(burstHolder);
                l = l2 = this.calculateLastFrame(burstHolder.getRequestId());
            }
            longParcelable.setNumber(l);
            return n;
        }
    }
}

