/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.legacy.LegacyCameraDevice;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.util.Log;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.Collection;

public class RequestHolder {
    private static final String TAG = "RequestHolder";
    private volatile boolean mFailed = false;
    private final long mFrameNumber;
    private final int mNumJpegTargets;
    private final int mNumPreviewTargets;
    private final boolean mRepeating;
    private final CaptureRequest mRequest;
    private final int mRequestId;
    private final int mSubsequeceId;

    private RequestHolder(int n, int n2, CaptureRequest captureRequest, boolean bl, long l, int n3, int n4) {
        this.mRepeating = bl;
        this.mRequest = captureRequest;
        this.mRequestId = n;
        this.mSubsequeceId = n2;
        this.mFrameNumber = l;
        this.mNumJpegTargets = n3;
        this.mNumPreviewTargets = n4;
    }

    public void failRequest() {
        Log.w(TAG, "Capture failed for request: " + this.getRequestId());
        this.mFailed = true;
    }

    public long getFrameNumber() {
        return this.mFrameNumber;
    }

    public Collection<Surface> getHolderTargets() {
        return this.getRequest().getTargets();
    }

    public CaptureRequest getRequest() {
        return this.mRequest;
    }

    public int getRequestId() {
        return this.mRequestId;
    }

    public int getSubsequeceId() {
        return this.mSubsequeceId;
    }

    public boolean hasJpegTargets() {
        return this.mNumJpegTargets > 0;
    }

    public boolean hasPreviewTargets() {
        return this.mNumPreviewTargets > 0;
    }

    public boolean isRepeating() {
        return this.mRepeating;
    }

    public int numJpegTargets() {
        return this.mNumJpegTargets;
    }

    public int numPreviewTargets() {
        return this.mNumPreviewTargets;
    }

    public boolean requestFailed() {
        return this.mFailed;
    }

    public static final class Builder {
        private final Collection<Long> mJpegSurfaceIds;
        private final int mNumJpegTargets;
        private final int mNumPreviewTargets;
        private final boolean mRepeating;
        private final CaptureRequest mRequest;
        private final int mRequestId;
        private final int mSubsequenceId;

        public Builder(int n, int n2, CaptureRequest captureRequest, boolean bl, Collection<Long> collection) {
            Preconditions.checkNotNull(captureRequest, "request must not be null");
            this.mRequestId = n;
            this.mSubsequenceId = n2;
            this.mRequest = captureRequest;
            this.mRepeating = bl;
            this.mJpegSurfaceIds = collection;
            this.mNumJpegTargets = this.numJpegTargets(this.mRequest);
            this.mNumPreviewTargets = this.numPreviewTargets(this.mRequest);
        }

        private boolean jpegType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return LegacyCameraDevice.containsSurfaceId(surface, this.mJpegSurfaceIds);
        }

        private int numJpegTargets(CaptureRequest captureRequest) {
            int n = 0;
            for (Surface surface : captureRequest.getTargets()) {
                try {
                    boolean bl = this.jpegType(surface);
                    if (!bl) continue;
                    ++n;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                    Log.d(RequestHolder.TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
                }
            }
            return n;
        }

        private int numPreviewTargets(CaptureRequest captureRequest) {
            int n = 0;
            for (Surface surface : captureRequest.getTargets()) {
                try {
                    boolean bl = this.previewType(surface);
                    if (!bl) continue;
                    ++n;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                    Log.d(RequestHolder.TAG, "Surface abandoned, skipping...", bufferQueueAbandonedException);
                }
            }
            return n;
        }

        private boolean previewType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
            return !this.jpegType(surface);
        }

        public RequestHolder build(long l) {
            return new RequestHolder(this.mRequestId, this.mSubsequenceId, this.mRequest, this.mRepeating, l, this.mNumJpegTargets, this.mNumPreviewTargets);
        }
    }
}

