/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.os.SystemClock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;

class PerfMeasurement {
    public static final int DEFAULT_MAX_QUERIES = 3;
    private static final long FAILED_TIMING = -2L;
    private static final long NO_DURATION_YET = -1L;
    private static final String TAG = "PerfMeasurement";
    private ArrayList<Long> mCollectedCpuDurations;
    private ArrayList<Long> mCollectedGpuDurations = new ArrayList();
    private ArrayList<Long> mCollectedTimestamps;
    private int mCompletedQueryCount = 0;
    private Queue<Long> mCpuDurationsQueue;
    private final long mNativeContext;
    private long mStartTimeNs;
    private Queue<Long> mTimestampQueue;

    public PerfMeasurement() {
        this.mCollectedCpuDurations = new ArrayList();
        this.mCollectedTimestamps = new ArrayList();
        this.mTimestampQueue = new LinkedList<Long>();
        this.mCpuDurationsQueue = new LinkedList<Long>();
        this.mNativeContext = PerfMeasurement.nativeCreateContext(3);
    }

    public PerfMeasurement(int n) {
        this.mCollectedCpuDurations = new ArrayList();
        this.mCollectedTimestamps = new ArrayList();
        this.mTimestampQueue = new LinkedList<Long>();
        this.mCpuDurationsQueue = new LinkedList<Long>();
        if (n < 1) {
            throw new IllegalArgumentException("maxQueries is less than 1");
        }
        this.mNativeContext = PerfMeasurement.nativeCreateContext(n);
    }

    private long getNextGlDuration() {
        long l = PerfMeasurement.nativeGetNextGlDuration(this.mNativeContext);
        if (l > 0L) {
            this.mCompletedQueryCount = 1 + this.mCompletedQueryCount;
        }
        return l;
    }

    public static boolean isGlTimingSupported() {
        return PerfMeasurement.nativeQuerySupport();
    }

    private static native long nativeCreateContext(int var0);

    private static native void nativeDeleteContext(long var0);

    protected static native long nativeGetNextGlDuration(long var0);

    private static native boolean nativeQuerySupport();

    protected static native void nativeStartGlTimer(long var0);

    protected static native void nativeStopGlTimer(long var0);

    public void addTimestamp(long l) {
        this.mTimestampQueue.add(l);
    }

    /*
     * Exception decompiling
     */
    public void dumpPerformanceData(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [10 : 180->185)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void finalize() {
        PerfMeasurement.nativeDeleteContext(this.mNativeContext);
    }

    public int getCompletedQueryCount() {
        return this.mCompletedQueryCount;
    }

    public void startTimer() {
        PerfMeasurement.nativeStartGlTimer(this.mNativeContext);
        this.mStartTimeNs = SystemClock.elapsedRealtimeNanos();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void stopTimer() {
        long l = -1L;
        long l2 = SystemClock.elapsedRealtimeNanos();
        this.mCpuDurationsQueue.add(l2 - this.mStartTimeNs);
        PerfMeasurement.nativeStopGlTimer(this.mNativeContext);
        long l3 = this.getNextGlDuration();
        if (l3 > 0L) {
            this.mCollectedGpuDurations.add(l3);
            ArrayList<Long> arrayList = this.mCollectedTimestamps;
            long l4 = this.mTimestampQueue.isEmpty() ? l : this.mTimestampQueue.poll();
            arrayList.add(l4);
            ArrayList<Long> arrayList2 = this.mCollectedCpuDurations;
            if (!this.mCpuDurationsQueue.isEmpty()) {
                l = this.mCpuDurationsQueue.poll();
            }
            arrayList2.add(l);
        }
        if (l3 == -2L) {
            if (!this.mTimestampQueue.isEmpty()) {
                this.mTimestampQueue.poll();
            }
            if (!this.mCpuDurationsQueue.isEmpty()) {
                this.mCpuDurationsQueue.poll();
            }
        }
    }
}

