/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.hardware.Camera;
import android.hardware.CameraInfo;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.legacy.LegacyRequest;
import android.hardware.camera2.legacy.LegacyRequestMapper;
import android.hardware.camera2.legacy.ParameterUtils;
import android.hardware.camera2.legacy.SizeAreaComparator;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.utils.ArrayUtils;
import android.hardware.camera2.utils.ListUtils;
import android.hardware.camera2.utils.ParamsUtils;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SizeF;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class LegacyMetadataMapper {
    private static final long APPROXIMATE_CAPTURE_DELAY_MS = 200L;
    private static final long APPROXIMATE_JPEG_ENCODE_TIME_MS = 600L;
    private static final long APPROXIMATE_SENSOR_AREA_PX = 0x800000L;
    public static final int HAL_PIXEL_FORMAT_BGRA_8888 = 5;
    public static final int HAL_PIXEL_FORMAT_BLOB = 33;
    public static final int HAL_PIXEL_FORMAT_IMPLEMENTATION_DEFINED = 34;
    public static final int HAL_PIXEL_FORMAT_RGBA_8888 = 1;
    private static final float LENS_INFO_MINIMUM_FOCUS_DISTANCE_FIXED_FOCUS = 0.0f;
    static final boolean LIE_ABOUT_AE_MAX_REGIONS = false;
    static final boolean LIE_ABOUT_AE_STATE = false;
    static final boolean LIE_ABOUT_AF = false;
    static final boolean LIE_ABOUT_AF_MAX_REGIONS = false;
    static final boolean LIE_ABOUT_AWB = false;
    static final boolean LIE_ABOUT_AWB_STATE = false;
    private static final long NS_PER_MS = 1000000L;
    private static final float PREVIEW_ASPECT_RATIO_TOLERANCE = 0.01f;
    private static final int REQUEST_MAX_NUM_INPUT_STREAMS_COUNT = 0;
    private static final int REQUEST_MAX_NUM_OUTPUT_STREAMS_COUNT_PROC = 3;
    private static final int REQUEST_MAX_NUM_OUTPUT_STREAMS_COUNT_PROC_STALL = 1;
    private static final int REQUEST_MAX_NUM_OUTPUT_STREAMS_COUNT_RAW = 0;
    private static final int REQUEST_PIPELINE_MAX_DEPTH_HAL1 = 3;
    private static final int REQUEST_PIPELINE_MAX_DEPTH_OURS = 3;
    private static final String TAG = "LegacyMetadataMapper";
    static final int UNKNOWN_MODE = -1;
    private static final boolean VERBOSE = Log.isLoggable("LegacyMetadataMapper", 2);
    private static final int[] sAllowedTemplates;
    private static final int[] sEffectModes;
    private static final String[] sLegacyEffectMode;
    private static final String[] sLegacySceneModes;
    private static final int[] sSceneModes;

    static {
        sLegacySceneModes = new String[]{"auto", "action", "portrait", "landscape", "night", "night-portrait", "theatre", "beach", "snow", "sunset", "steadyphoto", "fireworks", "sports", "party", "candlelight", "barcode", "hdr"};
        sSceneModes = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 18};
        sLegacyEffectMode = new String[]{"none", "mono", "negative", "solarize", "sepia", "posterize", "whiteboard", "blackboard", "aqua"};
        sEffectModes = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        sAllowedTemplates = new int[]{1, 2, 3};
    }

    private static void appendStreamConfig(ArrayList<StreamConfiguration> arrayList, int n, List<Camera.Size> list) {
        for (Camera.Size size : list) {
            arrayList.add(new StreamConfiguration(n, size.width, size.height, false));
        }
    }

    private static long calculateJpegStallDuration(Camera.Size size) {
        return 200000000L + 71L * ((long)size.width * (long)size.height);
    }

    private static int[] convertAeFpsRangeToLegacy(Range<Integer> range) {
        int[] nArray = new int[]{range.getLower(), range.getUpper()};
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    static String convertAfModeToLegacy(int n, List<String> list) {
        if (list == null || list.isEmpty()) {
            Log.w(TAG, "No focus modes supported; API1 bug");
            return null;
        }
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = "auto";
                break;
            }
            case 4: {
                string2 = "continuous-picture";
                break;
            }
            case 3: {
                string2 = "continuous-video";
                break;
            }
            case 5: {
                string2 = "edof";
                break;
            }
            case 2: {
                string2 = "macro";
                break;
            }
            case 0: {
                if (list.contains("fixed")) {
                    string2 = "fixed";
                    break;
                }
                string2 = "infinity";
                break;
            }
        }
        if (list.contains(string2)) return string2;
        String string3 = list.get(0);
        Object[] objectArray = new Object[]{n, string3};
        Log.w(TAG, String.format("convertAfModeToLegacy - ignoring unsupported mode %d, defaulting to %s", objectArray));
        return string3;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private static int convertAntiBandingMode(String var0) {
        block15: {
            if (var0 == null) {
                return -1;
            }
            switch (var0.hashCode()) {
                case 109935: {
                    if (!var0.equals("off")) ** GOTO lbl16
                    var1_1 = 0;
                    break block15;
                }
                case 1628397: {
                    if (!var0.equals("50hz")) ** GOTO lbl16
                    var1_1 = 1;
                    break block15;
                }
                case 1658188: {
                    if (!var0.equals("60hz")) ** GOTO lbl16
                    var1_1 = 2;
                    break block15;
                }
lbl16:
                // 4 sources

                default: {
                    ** GOTO lbl-1000
                }
                case 3005871: 
            }
            if (var0.equals("auto")) {
                var1_1 = 3;
            } else lbl-1000:
            // 2 sources

            {
                var1_1 = -1;
            }
        }
        switch (var1_1) {
            default: {
                Log.w("LegacyMetadataMapper", "convertAntiBandingMode - Unknown antibanding mode " + var0);
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: 
        }
        return 3;
    }

    static int convertAntiBandingModeOrDefault(String string2) {
        int n = LegacyMetadataMapper.convertAntiBandingMode(string2);
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    static int convertEffectModeFromLegacy(String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = ArrayUtils.getArrayIndex(sLegacyEffectMode, string2);
        if (n < 0) {
            return -1;
        }
        return sEffectModes[n];
    }

    static String convertEffectModeToLegacy(int n) {
        int n2 = ArrayUtils.getArrayIndex(sEffectModes, n);
        if (n2 < 0) {
            return null;
        }
        return sLegacyEffectMode[n2];
    }

    public static void convertRequestMetadata(LegacyRequest legacyRequest) {
        LegacyRequestMapper.convertRequestMetadata(legacyRequest);
    }

    static int convertSceneModeFromLegacy(String string2) {
        if (string2 == null) {
            return 0;
        }
        int n = ArrayUtils.getArrayIndex(sLegacySceneModes, string2);
        if (n < 0) {
            return -1;
        }
        return sSceneModes[n];
    }

    static String convertSceneModeToLegacy(int n) {
        if (n == 1) {
            return "auto";
        }
        int n2 = ArrayUtils.getArrayIndex(sSceneModes, n);
        if (n2 < 0) {
            return null;
        }
        return sLegacySceneModes[n2];
    }

    public static CameraCharacteristics createCharacteristics(Camera.Parameters parameters, Camera.CameraInfo cameraInfo) {
        Preconditions.checkNotNull(parameters, "parameters must not be null");
        Preconditions.checkNotNull(cameraInfo, "info must not be null");
        String string2 = parameters.flatten();
        CameraInfo cameraInfo2 = new CameraInfo();
        cameraInfo2.info = cameraInfo;
        return LegacyMetadataMapper.createCharacteristics(string2, cameraInfo2);
    }

    public static CameraCharacteristics createCharacteristics(String string2, CameraInfo cameraInfo) {
        Preconditions.checkNotNull(string2, "parameters must not be null");
        Preconditions.checkNotNull(cameraInfo, "info must not be null");
        Preconditions.checkNotNull(cameraInfo.info, "info.info must not be null");
        CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
        LegacyMetadataMapper.mapCharacteristicsFromInfo(cameraMetadataNative, cameraInfo.info);
        Camera.Parameters parameters = Camera.getEmptyParameters();
        parameters.unflatten(string2);
        LegacyMetadataMapper.mapCharacteristicsFromParameters(cameraMetadataNative, parameters);
        if (VERBOSE) {
            Log.v(TAG, "createCharacteristics metadata:");
            Log.v(TAG, "--------------------------------------------------- (start)");
            cameraMetadataNative.dumpToLog();
            Log.v(TAG, "--------------------------------------------------- (end)");
        }
        return new CameraCharacteristics(cameraMetadataNative);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CameraMetadataNative createRequestTemplate(CameraCharacteristics cameraCharacteristics, int n) {
        int n2;
        int n3;
        if (!ArrayUtils.contains(sAllowedTemplates, n)) {
            throw new IllegalArgumentException("templateId out of range");
        }
        CameraMetadataNative cameraMetadataNative = new CameraMetadataNative();
        cameraMetadataNative.set(CaptureRequest.CONTROL_AWB_MODE, Integer.valueOf(1));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_ANTIBANDING_MODE, Integer.valueOf(3));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_LOCK, Boolean.valueOf(false));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AF_TRIGGER, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AWB_MODE, Integer.valueOf(1));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AWB_LOCK, Boolean.valueOf(false));
        Rect rect = cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        MeteringRectangle[] meteringRectangleArray = new MeteringRectangle[]{new MeteringRectangle(0, 0, -1 + rect.width(), -1 + rect.height(), 0)};
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_REGIONS, meteringRectangleArray);
        cameraMetadataNative.set(CaptureRequest.CONTROL_AWB_REGIONS, meteringRectangleArray);
        cameraMetadataNative.set(CaptureRequest.CONTROL_AF_REGIONS, meteringRectangleArray);
        switch (n) {
            default: {
                throw new AssertionError((Object)"Impossible; keep in sync with sAllowedTemplates");
            }
            case 1: {
                n3 = 1;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
            case 3: {
                n3 = 3;
            }
        }
        cameraMetadataNative.set(CaptureRequest.CONTROL_CAPTURE_INTENT, Integer.valueOf(n3));
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_MODE, Integer.valueOf(1));
        cameraMetadataNative.set(CaptureRequest.CONTROL_MODE, Integer.valueOf(1));
        Float f = cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        if (f != null && f.floatValue() == 0.0f) {
            n2 = 0;
        } else {
            n2 = 1;
            if (n == 3 || n == 4) {
                if (ArrayUtils.contains(cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES), 3)) {
                    n2 = 3;
                }
            } else if ((n == 1 || n == 2) && ArrayUtils.contains(cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES), 4)) {
                n2 = 4;
            }
        }
        if (VERBOSE) {
            Log.v(TAG, "createRequestTemplate (templateId=" + n + ")," + " afMode=" + n2 + ", minimumFocusDistance=" + f);
        }
        cameraMetadataNative.set(CaptureRequest.CONTROL_AF_MODE, Integer.valueOf(n2));
        Range<Integer>[] rangeArray = cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        Range<Integer> range = rangeArray[0];
        for (Range<Integer> range2 : rangeArray) {
            if (range.getUpper() < range2.getUpper()) {
                range = range2;
                continue;
            }
            if (range.getUpper() != range2.getUpper() || range.getLower() >= range2.getLower()) continue;
            range = range2;
        }
        cameraMetadataNative.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, range);
        cameraMetadataNative.set(CaptureRequest.CONTROL_SCENE_MODE, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.STATISTICS_FACE_DETECT_MODE, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.FLASH_MODE, Integer.valueOf(0));
        cameraMetadataNative.set(CaptureRequest.NOISE_REDUCTION_MODE, Integer.valueOf(1));
        cameraMetadataNative.set(CaptureRequest.LENS_FOCAL_LENGTH, Float.valueOf(cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS)[0]));
        Size[] sizeArray = cameraCharacteristics.get(CameraCharacteristics.JPEG_AVAILABLE_THUMBNAIL_SIZES);
        CaptureRequest.Key<Size> key = CaptureRequest.JPEG_THUMBNAIL_SIZE;
        Size size = sizeArray.length > 1 ? sizeArray[1] : sizeArray[0];
        cameraMetadataNative.set(key, size);
        return cameraMetadataNative;
    }

    private static int[] getTagsForKeys(CameraCharacteristics.Key<?>[] keyArray) {
        int[] nArray = new int[keyArray.length];
        for (int i = 0; i < keyArray.length; ++i) {
            nArray[i] = keyArray[i].getNativeKey().getTag();
        }
        return nArray;
    }

    private static int[] getTagsForKeys(CaptureRequest.Key<?>[] keyArray) {
        int[] nArray = new int[keyArray.length];
        for (int i = 0; i < keyArray.length; ++i) {
            nArray[i] = keyArray[i].getNativeKey().getTag();
        }
        return nArray;
    }

    private static int[] getTagsForKeys(CaptureResult.Key<?>[] keyArray) {
        int[] nArray = new int[keyArray.length];
        for (int i = 0; i < keyArray.length; ++i) {
            nArray[i] = keyArray[i].getNativeKey().getTag();
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapCharacteristicsFromInfo(CameraMetadataNative cameraMetadataNative, Camera.CameraInfo cameraInfo) {
        CameraCharacteristics.Key<Integer> key = CameraCharacteristics.LENS_FACING;
        int n = cameraInfo.facing == 0 ? 1 : 0;
        cameraMetadataNative.set(key, Integer.valueOf(n));
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_ORIENTATION, Integer.valueOf(cameraInfo.orientation));
    }

    private static void mapCharacteristicsFromParameters(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        cameraMetadataNative.set(CameraCharacteristics.COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES, new int[]{1});
        LegacyMetadataMapper.mapControlAe(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapControlAf(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapControlAwb(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapControlOther(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapLens(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapFlash(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapJpeg(cameraMetadataNative, parameters);
        cameraMetadataNative.set(CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES, new int[]{1});
        LegacyMetadataMapper.mapScaler(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapSensor(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapStatistics(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapSync(cameraMetadataNative, parameters);
        cameraMetadataNative.set(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, Integer.valueOf(2));
        LegacyMetadataMapper.mapScalerStreamConfigs(cameraMetadataNative, parameters);
        LegacyMetadataMapper.mapRequest(cameraMetadataNative, parameters);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapControlAe(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        List<int[]> list;
        List<String> list2 = parameters.getSupportedAntibanding();
        if (list2 == null || list2.size() <= 0) {
            cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES, new int[0]);
        } else {
            int[] nArray = new int[list2.size()];
            int n = 0;
            for (String string2 : list2) {
                int n2 = LegacyMetadataMapper.convertAntiBandingMode(string2);
                if (n2 == -1) {
                    StringBuilder stringBuilder = new StringBuilder().append("Antibanding mode ");
                    if (string2 == null) {
                        string2 = "NULL";
                    }
                    Log.w(TAG, stringBuilder.append(string2).append(" not supported, skipping...").toString());
                    continue;
                }
                int n3 = n + 1;
                nArray[n] = n2;
                n = n3;
            }
            cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES, Arrays.copyOf(nArray, n));
        }
        if ((list = parameters.getSupportedPreviewFpsRange()) == null) {
            throw new AssertionError((Object)"Supported FPS ranges cannot be null.");
        }
        int n = list.size();
        if (n <= 0) {
            throw new AssertionError((Object)"At least one FPS range must be supported.");
        }
        Range[] rangeArray = new Range[n];
        int n4 = 0;
        for (int[] nArray : list) {
            int n5 = n4 + 1;
            rangeArray[n4] = Range.create(nArray[0], nArray[1]);
            n4 = n5;
        }
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES, rangeArray);
        int[] nArray = ArrayUtils.convertStringListToIntArray(parameters.getSupportedFlashModes(), new String[]{"off", "auto", "on", "red-eye", "torch"}, new int[]{1, 2, 3, 4});
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{1};
        }
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES, nArray);
        int n6 = parameters.getMinExposureCompensation();
        int n7 = parameters.getMaxExposureCompensation();
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE, Range.create(n6, n7));
        float f = parameters.getExposureCompensationStep();
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP, ParamsUtils.createRational(f));
    }

    private static void mapControlAf(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        List<Integer> list = ArrayUtils.convertStringListToIntList(parameters.getSupportedFocusModes(), new String[]{"auto", "continuous-picture", "continuous-video", "edof", "infinity", "macro", "fixed"}, new int[]{1, 4, 3, 5, 0, 2, 0});
        if (list == null || list.size() == 0) {
            Log.w(TAG, "No AF modes supported (HAL bug); defaulting to AF_MODE_OFF only");
            list = new ArrayList<Integer>(1);
            list.add(0);
        }
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, ArrayUtils.toIntArray(list));
        if (VERBOSE) {
            Log.v(TAG, "mapControlAf - control.afAvailableModes set to " + ListUtils.listToString(list));
        }
    }

    private static void mapControlAwb(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        List<Integer> list = ArrayUtils.convertStringListToIntList(parameters.getSupportedWhiteBalance(), new String[]{"auto", "incandescent", "fluorescent", "warm-fluorescent", "daylight", "cloudy-daylight", "twilight", "shade"}, new int[]{1, 2, 3, 4, 5, 6, 7, 8});
        if (list == null || list.size() == 0) {
            Log.w(TAG, "No AWB modes supported (HAL bug); defaulting to AWB_MODE_AUTO only");
            list = new ArrayList<Integer>(1);
            list.add(1);
        }
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES, ArrayUtils.toIntArray(list));
        if (VERBOSE) {
            Log.v(TAG, "mapControlAwb - control.awbAvailableModes set to " + ListUtils.listToString(list));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapControlOther(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        int[] nArray = parameters.isVideoStabilizationSupported() ? new int[]{0, 1} : new int[]{0};
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES, nArray);
        int[] nArray2 = new int[]{parameters.getMaxNumMeteringAreas(), 0, parameters.getMaxNumFocusAreas()};
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_MAX_REGIONS, nArray2);
        List<String> list = parameters.getSupportedColorEffects();
        int[] nArray3 = list == null ? new int[]{} : ArrayUtils.convertStringListToIntArray(list, sLegacyEffectMode, sEffectModes);
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AVAILABLE_EFFECTS, nArray3);
        List<Integer> list2 = ArrayUtils.convertStringListToIntList(parameters.getSupportedSceneModes(), sLegacySceneModes, sSceneModes);
        if (list2 == null) {
            list2 = new ArrayList<Integer>();
            list2.add(0);
        }
        if (parameters.getMaxNumDetectedFaces() > 0) {
            list2.add(1);
        }
        cameraMetadataNative.set(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES, ArrayUtils.toIntArray(list2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapFlash(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        List<String> list = parameters.getSupportedFlashModes();
        boolean bl = false;
        if (list != null) {
            bl = !ListUtils.listElementsEqualTo(list, "off");
        }
        cameraMetadataNative.set(CameraCharacteristics.FLASH_INFO_AVAILABLE, Boolean.valueOf(bl));
    }

    private static void mapJpeg(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        List<Camera.Size> list = parameters.getSupportedJpegThumbnailSizes();
        if (list != null) {
            Size[] sizeArray = ParameterUtils.convertSizeListToArray(list);
            Arrays.sort(sizeArray, new android.hardware.camera2.utils.SizeAreaComparator());
            cameraMetadataNative.set(CameraCharacteristics.JPEG_AVAILABLE_THUMBNAIL_SIZES, sizeArray);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapLens(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        if (VERBOSE) {
            Log.v(TAG, "mapLens - focus-mode='" + parameters.getFocusMode() + "'");
        }
        if ("fixed".equals(parameters.getFocusMode())) {
            cameraMetadataNative.set(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE, Float.valueOf(0.0f));
            if (VERBOSE) {
                Log.v(TAG, "mapLens - lens.info.minimumFocusDistance = 0");
            }
        } else if (VERBOSE) {
            Log.v(TAG, "mapLens - lens.info.minimumFocusDistance is unknown");
        }
        float[] fArray = new float[]{parameters.getFocalLength()};
        cameraMetadataNative.set(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS, fArray);
    }

    private static void mapRequest(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        int[] nArray = new int[]{0};
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES, nArray);
        CameraCharacteristics.Key[] keyArray = new CameraCharacteristics.Key[]{CameraCharacteristics.COLOR_CORRECTION_AVAILABLE_ABERRATION_MODES, CameraCharacteristics.CONTROL_AE_AVAILABLE_ANTIBANDING_MODES, CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES, CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES, CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE, CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP, CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES, CameraCharacteristics.CONTROL_AVAILABLE_EFFECTS, CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES, CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES, CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES, CameraCharacteristics.CONTROL_MAX_REGIONS, CameraCharacteristics.FLASH_INFO_AVAILABLE, CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL, CameraCharacteristics.JPEG_AVAILABLE_THUMBNAIL_SIZES, CameraCharacteristics.LENS_FACING, CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS, CameraCharacteristics.NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES, CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES, CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS, CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT, CameraCharacteristics.REQUEST_PIPELINE_MAX_DEPTH, CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM, CameraCharacteristics.SCALER_CROPPING_TYPE, CameraCharacteristics.SENSOR_AVAILABLE_TEST_PATTERN_MODES, CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE, CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE, CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE, CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE, CameraCharacteristics.SENSOR_ORIENTATION, CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES, CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT, CameraCharacteristics.SYNC_MAX_LATENCY};
        ArrayList<CameraCharacteristics.Key> arrayList = new ArrayList<CameraCharacteristics.Key>(Arrays.asList(keyArray));
        if (cameraMetadataNative.get(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE) != null) {
            arrayList.add(CameraCharacteristics.LENS_INFO_MINIMUM_FOCUS_DISTANCE);
        }
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_AVAILABLE_CHARACTERISTICS_KEYS, LegacyMetadataMapper.getTagsForKeys(arrayList.toArray(new CameraCharacteristics.Key[0])));
        CaptureRequest.Key[] keyArray2 = new CaptureRequest.Key[]{CaptureRequest.COLOR_CORRECTION_ABERRATION_MODE, CaptureRequest.CONTROL_AE_ANTIBANDING_MODE, CaptureRequest.CONTROL_AE_EXPOSURE_COMPENSATION, CaptureRequest.CONTROL_AE_LOCK, CaptureRequest.CONTROL_AE_MODE, CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, CaptureRequest.CONTROL_AF_MODE, CaptureRequest.CONTROL_AF_TRIGGER, CaptureRequest.CONTROL_AWB_LOCK, CaptureRequest.CONTROL_AWB_MODE, CaptureRequest.CONTROL_CAPTURE_INTENT, CaptureRequest.CONTROL_EFFECT_MODE, CaptureRequest.CONTROL_MODE, CaptureRequest.CONTROL_SCENE_MODE, CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, CaptureRequest.FLASH_MODE, CaptureRequest.JPEG_GPS_COORDINATES, CaptureRequest.JPEG_GPS_PROCESSING_METHOD, CaptureRequest.JPEG_GPS_TIMESTAMP, CaptureRequest.JPEG_ORIENTATION, CaptureRequest.JPEG_QUALITY, CaptureRequest.JPEG_THUMBNAIL_QUALITY, CaptureRequest.JPEG_THUMBNAIL_SIZE, CaptureRequest.LENS_FOCAL_LENGTH, CaptureRequest.NOISE_REDUCTION_MODE, CaptureRequest.SCALER_CROP_REGION, CaptureRequest.STATISTICS_FACE_DETECT_MODE};
        ArrayList<CaptureRequest.Key> arrayList2 = new ArrayList<CaptureRequest.Key>(Arrays.asList(keyArray2));
        if (parameters.getMaxNumMeteringAreas() > 0) {
            arrayList2.add(CaptureRequest.CONTROL_AE_REGIONS);
        }
        if (parameters.getMaxNumFocusAreas() > 0) {
            arrayList2.add(CaptureRequest.CONTROL_AF_REGIONS);
        }
        CaptureRequest.Key[] keyArray3 = new CaptureRequest.Key[arrayList2.size()];
        arrayList2.toArray(keyArray3);
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_AVAILABLE_REQUEST_KEYS, LegacyMetadataMapper.getTagsForKeys(keyArray3));
        CaptureResult.Key[] keyArray4 = new CaptureResult.Key[]{CaptureResult.COLOR_CORRECTION_ABERRATION_MODE, CaptureResult.CONTROL_AE_ANTIBANDING_MODE, CaptureResult.CONTROL_AE_EXPOSURE_COMPENSATION, CaptureResult.CONTROL_AE_LOCK, CaptureResult.CONTROL_AE_MODE, CaptureResult.CONTROL_AF_MODE, CaptureResult.CONTROL_AF_STATE, CaptureResult.CONTROL_AWB_MODE, CaptureResult.CONTROL_AWB_LOCK, CaptureResult.CONTROL_MODE, CaptureResult.FLASH_MODE, CaptureResult.JPEG_GPS_COORDINATES, CaptureResult.JPEG_GPS_PROCESSING_METHOD, CaptureResult.JPEG_GPS_TIMESTAMP, CaptureResult.JPEG_ORIENTATION, CaptureResult.JPEG_QUALITY, CaptureResult.JPEG_THUMBNAIL_QUALITY, CaptureResult.LENS_FOCAL_LENGTH, CaptureResult.NOISE_REDUCTION_MODE, CaptureResult.REQUEST_PIPELINE_DEPTH, CaptureResult.SCALER_CROP_REGION, CaptureResult.SENSOR_TIMESTAMP, CaptureResult.STATISTICS_FACE_DETECT_MODE};
        ArrayList<CaptureResult.Key> arrayList3 = new ArrayList<CaptureResult.Key>(Arrays.asList(keyArray4));
        if (parameters.getMaxNumMeteringAreas() > 0) {
            arrayList3.add(CaptureResult.CONTROL_AE_REGIONS);
        }
        if (parameters.getMaxNumFocusAreas() > 0) {
            arrayList3.add(CaptureResult.CONTROL_AF_REGIONS);
        }
        CaptureResult.Key[] keyArray5 = new CaptureResult.Key[arrayList3.size()];
        arrayList3.toArray(keyArray5);
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_AVAILABLE_RESULT_KEYS, LegacyMetadataMapper.getTagsForKeys(keyArray5));
        int[] nArray2 = new int[]{0, 3, 1};
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS, nArray2);
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_MAX_NUM_INPUT_STREAMS, Integer.valueOf(0));
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_PARTIAL_RESULT_COUNT, Integer.valueOf(1));
        cameraMetadataNative.set(CameraCharacteristics.REQUEST_PIPELINE_MAX_DEPTH, Byte.valueOf((byte)6));
    }

    private static void mapScaler(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        cameraMetadataNative.set(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM, Float.valueOf(ParameterUtils.getMaxZoomRatio(parameters)));
        cameraMetadataNative.set(CameraCharacteristics.SCALER_CROPPING_TYPE, Integer.valueOf(0));
    }

    private static void mapScalerStreamConfigs(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        ArrayList<StreamConfiguration> arrayList = new ArrayList<StreamConfiguration>();
        List<Camera.Size> list = parameters.getSupportedPreviewSizes();
        List<Camera.Size> list2 = parameters.getSupportedPictureSizes();
        SizeAreaComparator sizeAreaComparator = new SizeAreaComparator();
        Collections.sort(list, sizeAreaComparator);
        Camera.Size size = SizeAreaComparator.findLargestByArea(list2);
        float f = 1.0f * (float)size.width / (float)size.height;
        if (VERBOSE) {
            Object[] objectArray = new Object[]{size.width, size.height, Float.valueOf(f)};
            Log.v(TAG, String.format("mapScalerStreamConfigs - largest JPEG area %dx%d, AR=%f", objectArray));
        }
        while (!list.isEmpty()) {
            int n = -1 + list.size();
            Camera.Size size2 = list.get(n);
            float f2 = 1.0f * (float)size2.width / (float)size2.height;
            if (!(Math.abs(f - f2) >= 0.01f)) break;
            list.remove(n);
            if (!VERBOSE) continue;
            Object[] objectArray = new Object[]{size2.width, size2.height, Float.valueOf(f2)};
            Log.v(TAG, String.format("mapScalerStreamConfigs - removed preview size %dx%d, AR=%f was not the same", objectArray));
        }
        if (list.isEmpty()) {
            Log.w(TAG, "mapScalerStreamConfigs - failed to find any preview size matching JPEG aspect ratio " + f);
            list = parameters.getSupportedPreviewSizes();
        }
        Comparator<Camera.Size> comparator = Collections.reverseOrder(sizeAreaComparator);
        Collections.sort(list, comparator);
        LegacyMetadataMapper.appendStreamConfig(arrayList, 34, list);
        LegacyMetadataMapper.appendStreamConfig(arrayList, 35, list);
        for (int n : parameters.getSupportedPreviewFormats()) {
            if (ImageFormat.isPublicFormat(n)) {
                LegacyMetadataMapper.appendStreamConfig(arrayList, n, list);
                continue;
            }
            Object[] objectArray = new Object[]{n};
            Log.w(TAG, String.format("mapStreamConfigs - Skipping non-public format %x", objectArray));
        }
        LegacyMetadataMapper.appendStreamConfig(arrayList, 33, parameters.getSupportedPictureSizes());
        cameraMetadataNative.set(CameraCharacteristics.SCALER_AVAILABLE_STREAM_CONFIGURATIONS, arrayList.toArray(new StreamConfiguration[0]));
        cameraMetadataNative.set(CameraCharacteristics.SCALER_AVAILABLE_MIN_FRAME_DURATIONS, new StreamConfigurationDuration[0]);
        StreamConfigurationDuration[] streamConfigurationDurationArray = new StreamConfigurationDuration[list2.size()];
        int n = 0;
        long l = -1L;
        for (Camera.Size size3 : list2) {
            long l2 = LegacyMetadataMapper.calculateJpegStallDuration(size3);
            int n2 = n + 1;
            streamConfigurationDurationArray[n] = new StreamConfigurationDuration(33, size3.width, size3.height, l2);
            if (l < l2) {
                l = l2;
            }
            n = n2;
        }
        cameraMetadataNative.set(CameraCharacteristics.SCALER_AVAILABLE_STALL_DURATIONS, streamConfigurationDurationArray);
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_INFO_MAX_FRAME_DURATION, Long.valueOf(l));
    }

    private static void mapSensor(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        Size size = ParameterUtils.getLargestSupportedJpegSizeByArea(parameters);
        Rect rect = ParamsUtils.createRect(size);
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE, rect);
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_AVAILABLE_TEST_PATTERN_MODES, new int[]{0});
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_INFO_PIXEL_ARRAY_SIZE, size);
        float f = parameters.getFocalLength();
        double d = Math.PI * (double)parameters.getHorizontalViewAngle() / 180.0;
        double d2 = Math.PI * (double)parameters.getVerticalViewAngle() / 180.0;
        float f2 = (float)Math.abs((double)(2.0f * f) * Math.tan(d2 / 2.0));
        float f3 = (float)Math.abs((double)(2.0f * f) * Math.tan(d / 2.0));
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE, new SizeF(f3, f2));
        cameraMetadataNative.set(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE, Integer.valueOf(0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void mapStatistics(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        int[] nArray = parameters.getMaxNumDetectedFaces() > 0 ? new int[]{0, 1} : new int[]{0};
        cameraMetadataNative.set(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES, nArray);
        cameraMetadataNative.set(CameraCharacteristics.STATISTICS_INFO_MAX_FACE_COUNT, Integer.valueOf(parameters.getMaxNumDetectedFaces()));
    }

    private static void mapSync(CameraMetadataNative cameraMetadataNative, Camera.Parameters parameters) {
        cameraMetadataNative.set(CameraCharacteristics.SYNC_MAX_LATENCY, Integer.valueOf(-1));
    }
}

