/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.legacy;

import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.ICameraDeviceCallbacks;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.legacy.CameraDeviceState;
import android.hardware.camera2.legacy.LegacyExceptionUtils;
import android.hardware.camera2.legacy.RequestHolder;
import android.hardware.camera2.legacy.RequestThreadManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.utils.ArrayUtils;
import android.hardware.camera2.utils.CameraRuntimeException;
import android.hardware.camera2.utils.LongParcelable;
import android.os.ConditionVariable;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.RemoteException;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class LegacyCameraDevice
implements AutoCloseable {
    private static final boolean DEBUG = false;
    public static final String DEBUG_PROP = "HAL1ShimLogging";
    private static final int ILLEGAL_VALUE = -1;
    private final String TAG;
    private final Handler mCallbackHandler;
    private final HandlerThread mCallbackHandlerThread;
    private final int mCameraId;
    private boolean mClosed = false;
    private List<Surface> mConfiguredSurfaces;
    private final ICameraDeviceCallbacks mDeviceCallbacks;
    private final CameraDeviceState mDeviceState = new CameraDeviceState();
    private final ConditionVariable mIdle = new ConditionVariable(true);
    private final RequestThreadManager mRequestThreadManager;
    private final Handler mResultHandler;
    private final HandlerThread mResultThread = new HandlerThread("ResultThread");
    private final CameraDeviceState.CameraDeviceStateListener mStateListener;
    private final CameraCharacteristics mStaticCharacteristics;

    static {
        DEBUG = Log.isLoggable(DEBUG_PROP, 3);
    }

    public LegacyCameraDevice(int n, Camera camera, CameraCharacteristics cameraCharacteristics, ICameraDeviceCallbacks iCameraDeviceCallbacks) {
        this.mCallbackHandlerThread = new HandlerThread("CallbackThread");
        this.mStateListener = new CameraDeviceState.CameraDeviceStateListener(){

            @Override
            public void onBusy() {
                LegacyCameraDevice.this.mIdle.close();
                if (DEBUG) {
                    Log.d(LegacyCameraDevice.this.TAG, "onBusy called");
                }
            }

            @Override
            public void onCaptureResult(final CameraMetadataNative cameraMetadataNative, final RequestHolder requestHolder) {
                final CaptureResultExtras captureResultExtras = LegacyCameraDevice.this.getExtrasFromRequest(requestHolder);
                LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            Log.d(LegacyCameraDevice.this.TAG, "doing onCaptureResult callback for request " + requestHolder.getRequestId());
                        }
                        try {
                            LegacyCameraDevice.this.mDeviceCallbacks.onResultReceived(cameraMetadataNative, captureResultExtras);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", remoteException);
                        }
                    }
                });
            }

            @Override
            public void onCaptureStarted(final RequestHolder requestHolder, final long l) {
                final CaptureResultExtras captureResultExtras = LegacyCameraDevice.this.getExtrasFromRequest(requestHolder);
                LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            Log.d(LegacyCameraDevice.this.TAG, "doing onCaptureStarted callback for request " + requestHolder.getRequestId());
                        }
                        try {
                            LegacyCameraDevice.this.mDeviceCallbacks.onCaptureStarted(captureResultExtras, l);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", remoteException);
                        }
                    }
                });
            }

            @Override
            public void onConfiguring() {
                if (DEBUG) {
                    Log.d(LegacyCameraDevice.this.TAG, "doing onConfiguring callback.");
                }
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onError(final int n, final RequestHolder requestHolder) {
                if (DEBUG) {
                    Log.d(LegacyCameraDevice.this.TAG, "onError called, errorCode = " + n);
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        LegacyCameraDevice.this.mIdle.open();
                        if (!DEBUG) break;
                        Log.d(LegacyCameraDevice.this.TAG, "onError - opening idle");
                    }
                }
                final CaptureResultExtras captureResultExtras = LegacyCameraDevice.this.getExtrasFromRequest(requestHolder);
                LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            Log.d(LegacyCameraDevice.this.TAG, "doing onError callback for request " + requestHolder.getRequestId() + ", with error code " + n);
                        }
                        try {
                            LegacyCameraDevice.this.mDeviceCallbacks.onDeviceError(n, captureResultExtras);
                            return;
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException("Received remote exception during onCameraError callback: ", remoteException);
                        }
                    }
                });
            }

            @Override
            public void onIdle() {
                if (DEBUG) {
                    Log.d(LegacyCameraDevice.this.TAG, "onIdle called");
                }
                LegacyCameraDevice.this.mIdle.open();
                LegacyCameraDevice.this.mResultHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (DEBUG) {
                            Log.d(LegacyCameraDevice.this.TAG, "doing onIdle callback.");
                        }
                        try {
                            LegacyCameraDevice.this.mDeviceCallbacks.onDeviceIdle();
                            return;
                        }
                        catch (RemoteException remoteException) {
                            throw new IllegalStateException("Received remote exception during onCameraIdle callback: ", remoteException);
                        }
                    }
                });
            }
        };
        this.mCameraId = n;
        this.mDeviceCallbacks = iCameraDeviceCallbacks;
        Object[] objectArray = new Object[]{this.mCameraId};
        this.TAG = String.format("CameraDevice-%d-LE", objectArray);
        this.mResultThread.start();
        this.mResultHandler = new Handler(this.mResultThread.getLooper());
        this.mCallbackHandlerThread.start();
        this.mCallbackHandler = new Handler(this.mCallbackHandlerThread.getLooper());
        this.mDeviceState.setCameraDeviceCallbacks(this.mCallbackHandler, this.mStateListener);
        this.mStaticCharacteristics = cameraCharacteristics;
        this.mRequestThreadManager = new RequestThreadManager(n, camera, cameraCharacteristics, this.mDeviceState);
        this.mRequestThreadManager.start();
    }

    static void configureSurface(Surface surface, int n, int n2, int n3) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(n, "width must be positive.");
        Preconditions.checkArgumentPositive(n2, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeConfigureSurface(surface, n, n2, n3));
    }

    static boolean containsSurfaceId(Surface surface, Collection<Long> collection) {
        return collection.contains(LegacyCameraDevice.getSurfaceId(surface));
    }

    static int detectSurfaceType(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        return LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceType(surface));
    }

    private CaptureResultExtras getExtrasFromRequest(RequestHolder requestHolder) {
        if (requestHolder == null) {
            return new CaptureResultExtras(-1, -1, -1, -1, -1L, -1);
        }
        return new CaptureResultExtras(requestHolder.getRequestId(), requestHolder.getSubsequeceId(), 0, 0, requestHolder.getFrameNumber(), 1);
    }

    static long getSurfaceId(Surface surface) {
        Preconditions.checkNotNull(surface);
        return LegacyCameraDevice.nativeGetSurfaceId(surface);
    }

    static List<Long> getSurfaceIds(Collection<Surface> collection) {
        if (collection == null) {
            throw new NullPointerException("Null argument surfaces");
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        Iterator<Surface> iterator = collection.iterator();
        while (iterator.hasNext()) {
            long l = LegacyCameraDevice.getSurfaceId(iterator.next());
            if (l == 0L) {
                throw new IllegalStateException("Configured surface had null native GraphicBufferProducer pointer!");
            }
            arrayList.add(l);
        }
        return arrayList;
    }

    static Size getSurfaceSize(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        int[] nArray = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectSurfaceDimens(surface, nArray));
        return new Size(nArray[0], nArray[1]);
    }

    static Size getTextureSize(SurfaceTexture surfaceTexture) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surfaceTexture);
        int[] nArray = new int[2];
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeDetectTextureDimens(surfaceTexture, nArray));
        return new Size(nArray[0], nArray[1]);
    }

    private static native int nativeConfigureSurface(Surface var0, int var1, int var2, int var3);

    private static native int nativeDetectSurfaceDimens(Surface var0, int[] var1);

    private static native int nativeDetectSurfaceType(Surface var0);

    private static native int nativeDetectTextureDimens(SurfaceTexture var0, int[] var1);

    static native int nativeGetJpegFooterSize();

    private static native long nativeGetSurfaceId(Surface var0);

    private static native int nativeProduceFrame(Surface var0, byte[] var1, int var2, int var3, int var4);

    private static native int nativeSetNextTimestamp(Surface var0, long var1);

    private static native int nativeSetSurfaceDimens(Surface var0, int var1, int var2);

    private static native int nativeSetSurfaceFormat(Surface var0, int var1);

    private static native int nativeSetSurfaceOrientation(Surface var0, int var1, int var2);

    static boolean needsConversion(Surface surface) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        int n = LegacyCameraDevice.detectSurfaceType(surface);
        return n == 35 || n == 842094169 || n == 17;
    }

    static void produceFrame(Surface surface, byte[] byArray, int n, int n2, int n3) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkNotNull(byArray);
        Preconditions.checkArgumentPositive(n, "width must be positive.");
        Preconditions.checkArgumentPositive(n2, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeProduceFrame(surface, byArray, n, n2, n3));
    }

    static void setNextTimestamp(Surface surface, long l) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetNextTimestamp(surface, l));
    }

    static void setSurfaceDimens(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        Preconditions.checkArgumentPositive(n, "width must be positive.");
        Preconditions.checkArgumentPositive(n2, "height must be positive.");
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceDimens(surface, n, n2));
    }

    static void setSurfaceFormat(Surface surface, int n) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceFormat(surface, n));
    }

    static void setSurfaceOrientation(Surface surface, int n, int n2) throws LegacyExceptionUtils.BufferQueueAbandonedException {
        Preconditions.checkNotNull(surface);
        LegacyExceptionUtils.throwOnError(LegacyCameraDevice.nativeSetSurfaceOrientation(surface, n, n2));
    }

    public long cancelRequest(int n) {
        return this.mRequestThreadManager.cancelRepeating(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        this.mRequestThreadManager.quit();
        this.mCallbackHandlerThread.quitSafely();
        this.mResultThread.quitSafely();
        try {
            this.mCallbackHandlerThread.join();
        }
        catch (InterruptedException interruptedException) {
            String string2 = this.TAG;
            Object[] objectArray = new Object[]{this.mCallbackHandlerThread.getName(), this.mCallbackHandlerThread.getId()};
            Log.e(string2, String.format("Thread %s (%d) interrupted while quitting.", objectArray));
        }
        try {
            this.mResultThread.join();
        }
        catch (InterruptedException interruptedException) {
            String string3 = this.TAG;
            Object[] objectArray = new Object[]{this.mResultThread.getName(), this.mResultThread.getId()};
            Log.e(string3, String.format("Thread %s (%d) interrupted while quitting.", objectArray));
        }
        this.mClosed = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int configureOutputs(List<Surface> list) {
        if (list != null) {
            for (Surface surface : list) {
                if (surface == null) {
                    Log.e(this.TAG, "configureOutputs - null outputs are not allowed");
                    return -22;
                }
                StreamConfigurationMap streamConfigurationMap = this.mStaticCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                try {
                    String string2;
                    Size size = LegacyCameraDevice.getSurfaceSize(surface);
                    int n = LegacyCameraDevice.detectSurfaceType(surface);
                    Object[] objectArray = streamConfigurationMap.getOutputSizes(n);
                    if (objectArray == null) {
                        if (n >= 1 && n <= 5) {
                            objectArray = streamConfigurationMap.getOutputSizes(35);
                        } else if (n == 33) {
                            objectArray = streamConfigurationMap.getOutputSizes(256);
                        }
                    }
                    if (ArrayUtils.contains(objectArray, size)) continue;
                    String string3 = objectArray == null ? "format is invalid." : (string2 = "size not in valid set: " + Arrays.toString(objectArray));
                    String string4 = this.TAG;
                    Object[] objectArray2 = new Object[]{size.getWidth(), size.getHeight(), n, string3};
                    Log.e(string4, String.format("Surface with size (w=%d, h=%d) and format 0x%x is not valid, %s", objectArray2));
                    return -22;
                }
                catch (LegacyExceptionUtils.BufferQueueAbandonedException bufferQueueAbandonedException) {
                    Log.e(this.TAG, "Surface bufferqueue is abandoned, cannot configure as output: ", bufferQueueAbandonedException);
                    return -22;
                }
            }
        }
        boolean bl = this.mDeviceState.setConfiguring();
        boolean bl2 = false;
        if (bl) {
            this.mRequestThreadManager.configure(list);
            bl2 = this.mDeviceState.setIdle();
        }
        if (!bl2) {
            return -38;
        }
        ArrayList<Surface> arrayList = list != null ? new ArrayList<Surface>(list) : null;
        this.mConfiguredSurfaces = arrayList;
        return 0;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
            return;
        }
        catch (CameraRuntimeException cameraRuntimeException) {
            Log.e(this.TAG, "Got error while trying to finalize, ignoring: " + cameraRuntimeException.getMessage());
            return;
        }
        finally {
            super.finalize();
        }
    }

    public long flush() {
        long l = this.mRequestThreadManager.flush();
        this.waitUntilIdle();
        return l;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public int submitRequest(CaptureRequest captureRequest, boolean bl, LongParcelable longParcelable) {
        ArrayList<CaptureRequest> arrayList = new ArrayList<CaptureRequest>();
        arrayList.add(captureRequest);
        return this.submitRequestList(arrayList, bl, longParcelable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int submitRequestList(List<CaptureRequest> list, boolean bl, LongParcelable longParcelable) {
        if (list == null || list.isEmpty()) {
            Log.e(this.TAG, "submitRequestList - Empty/null requests are not allowed");
            return -22;
        }
        List<Object> list2 = this.mConfiguredSurfaces == null ? new ArrayList() : LegacyCameraDevice.getSurfaceIds(this.mConfiguredSurfaces);
        Iterator<CaptureRequest> iterator = list.iterator();
        block0: while (true) {
            Surface surface;
            if (!iterator.hasNext()) {
                this.mIdle.close();
                return this.mRequestThreadManager.submitCaptureRequests(list, bl, longParcelable);
            }
            CaptureRequest captureRequest = iterator.next();
            if (captureRequest.getTargets().isEmpty()) {
                Log.e(this.TAG, "submitRequestList - Each request must have at least one Surface target");
                return -22;
            }
            Iterator<Surface> iterator2 = captureRequest.getTargets().iterator();
            do {
                if (!iterator2.hasNext()) continue block0;
                surface = iterator2.next();
                if (surface == null) {
                    Log.e(this.TAG, "submitRequestList - Null Surface targets are not allowed");
                    return -22;
                }
                if (this.mConfiguredSurfaces != null) continue;
                Log.e(this.TAG, "submitRequestList - must configure  device with valid surfaces before submitting requests");
                return -38;
            } while (LegacyCameraDevice.containsSurfaceId(surface, list2));
            break;
        }
        Log.e(this.TAG, "submitRequestList - cannot use a surface that wasn't configured");
        return -22;
    }

    public void waitUntilIdle() {
        this.mIdle.block();
    }
}

