/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.graphics.Rect;
import android.hardware.camera2.CameraMetadata;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.PublicKey;
import android.hardware.camera2.impl.SyntheticKey;
import android.hardware.camera2.params.ColorSpaceTransform;
import android.hardware.camera2.params.MeteringRectangle;
import android.hardware.camera2.params.RggbChannelVector;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.HashCodeHelpers;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public final class CaptureRequest
extends CameraMetadata<Key<?>>
implements Parcelable {
    @PublicKey
    public static final Key<Boolean> BLACK_LEVEL_LOCK;
    @PublicKey
    public static final Key<Integer> COLOR_CORRECTION_ABERRATION_MODE;
    @PublicKey
    public static final Key<RggbChannelVector> COLOR_CORRECTION_GAINS;
    @PublicKey
    public static final Key<Integer> COLOR_CORRECTION_MODE;
    @PublicKey
    public static final Key<ColorSpaceTransform> COLOR_CORRECTION_TRANSFORM;
    @PublicKey
    public static final Key<Integer> CONTROL_AE_ANTIBANDING_MODE;
    @PublicKey
    public static final Key<Integer> CONTROL_AE_EXPOSURE_COMPENSATION;
    @PublicKey
    public static final Key<Boolean> CONTROL_AE_LOCK;
    @PublicKey
    public static final Key<Integer> CONTROL_AE_MODE;
    @PublicKey
    public static final Key<Integer> CONTROL_AE_PRECAPTURE_TRIGGER;
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AE_REGIONS;
    @PublicKey
    public static final Key<Range<Integer>> CONTROL_AE_TARGET_FPS_RANGE;
    @PublicKey
    public static final Key<Integer> CONTROL_AF_MODE;
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AF_REGIONS;
    @PublicKey
    public static final Key<Integer> CONTROL_AF_TRIGGER;
    @PublicKey
    public static final Key<Boolean> CONTROL_AWB_LOCK;
    @PublicKey
    public static final Key<Integer> CONTROL_AWB_MODE;
    @PublicKey
    public static final Key<MeteringRectangle[]> CONTROL_AWB_REGIONS;
    @PublicKey
    public static final Key<Integer> CONTROL_CAPTURE_INTENT;
    @PublicKey
    public static final Key<Integer> CONTROL_EFFECT_MODE;
    @PublicKey
    public static final Key<Integer> CONTROL_MODE;
    @PublicKey
    public static final Key<Integer> CONTROL_SCENE_MODE;
    @PublicKey
    public static final Key<Integer> CONTROL_VIDEO_STABILIZATION_MODE;
    public static final Parcelable.Creator<CaptureRequest> CREATOR;
    @PublicKey
    public static final Key<Integer> EDGE_MODE;
    @PublicKey
    public static final Key<Integer> FLASH_MODE;
    @PublicKey
    public static final Key<Integer> HOT_PIXEL_MODE;
    public static final Key<double[]> JPEG_GPS_COORDINATES;
    @PublicKey
    @SyntheticKey
    public static final Key<Location> JPEG_GPS_LOCATION;
    public static final Key<String> JPEG_GPS_PROCESSING_METHOD;
    public static final Key<Long> JPEG_GPS_TIMESTAMP;
    @PublicKey
    public static final Key<Integer> JPEG_ORIENTATION;
    @PublicKey
    public static final Key<Byte> JPEG_QUALITY;
    @PublicKey
    public static final Key<Byte> JPEG_THUMBNAIL_QUALITY;
    @PublicKey
    public static final Key<Size> JPEG_THUMBNAIL_SIZE;
    public static final Key<Boolean> LED_TRANSMIT;
    @PublicKey
    public static final Key<Float> LENS_APERTURE;
    @PublicKey
    public static final Key<Float> LENS_FILTER_DENSITY;
    @PublicKey
    public static final Key<Float> LENS_FOCAL_LENGTH;
    @PublicKey
    public static final Key<Float> LENS_FOCUS_DISTANCE;
    @PublicKey
    public static final Key<Integer> LENS_OPTICAL_STABILIZATION_MODE;
    @PublicKey
    public static final Key<Integer> NOISE_REDUCTION_MODE;
    public static final Key<Integer> REQUEST_ID;
    @PublicKey
    public static final Key<Rect> SCALER_CROP_REGION;
    @PublicKey
    public static final Key<Long> SENSOR_EXPOSURE_TIME;
    @PublicKey
    public static final Key<Long> SENSOR_FRAME_DURATION;
    @PublicKey
    public static final Key<Integer> SENSOR_SENSITIVITY;
    @PublicKey
    public static final Key<int[]> SENSOR_TEST_PATTERN_DATA;
    @PublicKey
    public static final Key<Integer> SENSOR_TEST_PATTERN_MODE;
    @PublicKey
    public static final Key<Integer> SHADING_MODE;
    @PublicKey
    public static final Key<Integer> STATISTICS_FACE_DETECT_MODE;
    @PublicKey
    public static final Key<Boolean> STATISTICS_HOT_PIXEL_MAP_MODE;
    @PublicKey
    public static final Key<Integer> STATISTICS_LENS_SHADING_MAP_MODE;
    @PublicKey
    @SyntheticKey
    public static final Key<TonemapCurve> TONEMAP_CURVE;
    public static final Key<float[]> TONEMAP_CURVE_BLUE;
    public static final Key<float[]> TONEMAP_CURVE_GREEN;
    public static final Key<float[]> TONEMAP_CURVE_RED;
    @PublicKey
    public static final Key<Integer> TONEMAP_MODE;
    private final CameraMetadataNative mSettings;
    private final HashSet<Surface> mSurfaceSet;
    private Object mUserTag;

    static {
        CREATOR = new Parcelable.Creator<CaptureRequest>(){

            @Override
            public CaptureRequest createFromParcel(Parcel parcel) {
                CaptureRequest captureRequest = new CaptureRequest();
                captureRequest.readFromParcel(parcel);
                return captureRequest;
            }

            public CaptureRequest[] newArray(int n) {
                return new CaptureRequest[n];
            }
        };
        COLOR_CORRECTION_MODE = new Key<Integer>("android.colorCorrection.mode", Integer.TYPE);
        COLOR_CORRECTION_TRANSFORM = new Key<ColorSpaceTransform>("android.colorCorrection.transform", ColorSpaceTransform.class);
        COLOR_CORRECTION_GAINS = new Key<RggbChannelVector>("android.colorCorrection.gains", RggbChannelVector.class);
        COLOR_CORRECTION_ABERRATION_MODE = new Key<Integer>("android.colorCorrection.aberrationMode", Integer.TYPE);
        CONTROL_AE_ANTIBANDING_MODE = new Key<Integer>("android.control.aeAntibandingMode", Integer.TYPE);
        CONTROL_AE_EXPOSURE_COMPENSATION = new Key<Integer>("android.control.aeExposureCompensation", Integer.TYPE);
        CONTROL_AE_LOCK = new Key<Boolean>("android.control.aeLock", Boolean.TYPE);
        CONTROL_AE_MODE = new Key<Integer>("android.control.aeMode", Integer.TYPE);
        CONTROL_AE_REGIONS = new Key<MeteringRectangle[]>("android.control.aeRegions", MeteringRectangle[].class);
        CONTROL_AE_TARGET_FPS_RANGE = new Key<Range<Integer>>("android.control.aeTargetFpsRange", new TypeReference<Range<Integer>>(){});
        CONTROL_AE_PRECAPTURE_TRIGGER = new Key<Integer>("android.control.aePrecaptureTrigger", Integer.TYPE);
        CONTROL_AF_MODE = new Key<Integer>("android.control.afMode", Integer.TYPE);
        CONTROL_AF_REGIONS = new Key<MeteringRectangle[]>("android.control.afRegions", MeteringRectangle[].class);
        CONTROL_AF_TRIGGER = new Key<Integer>("android.control.afTrigger", Integer.TYPE);
        CONTROL_AWB_LOCK = new Key<Boolean>("android.control.awbLock", Boolean.TYPE);
        CONTROL_AWB_MODE = new Key<Integer>("android.control.awbMode", Integer.TYPE);
        CONTROL_AWB_REGIONS = new Key<MeteringRectangle[]>("android.control.awbRegions", MeteringRectangle[].class);
        CONTROL_CAPTURE_INTENT = new Key<Integer>("android.control.captureIntent", Integer.TYPE);
        CONTROL_EFFECT_MODE = new Key<Integer>("android.control.effectMode", Integer.TYPE);
        CONTROL_MODE = new Key<Integer>("android.control.mode", Integer.TYPE);
        CONTROL_SCENE_MODE = new Key<Integer>("android.control.sceneMode", Integer.TYPE);
        CONTROL_VIDEO_STABILIZATION_MODE = new Key<Integer>("android.control.videoStabilizationMode", Integer.TYPE);
        EDGE_MODE = new Key<Integer>("android.edge.mode", Integer.TYPE);
        FLASH_MODE = new Key<Integer>("android.flash.mode", Integer.TYPE);
        HOT_PIXEL_MODE = new Key<Integer>("android.hotPixel.mode", Integer.TYPE);
        JPEG_GPS_LOCATION = new Key<Location>("android.jpeg.gpsLocation", Location.class);
        JPEG_GPS_COORDINATES = new Key<double[]>("android.jpeg.gpsCoordinates", double[].class);
        JPEG_GPS_PROCESSING_METHOD = new Key<String>("android.jpeg.gpsProcessingMethod", String.class);
        JPEG_GPS_TIMESTAMP = new Key<Long>("android.jpeg.gpsTimestamp", Long.TYPE);
        JPEG_ORIENTATION = new Key<Integer>("android.jpeg.orientation", Integer.TYPE);
        JPEG_QUALITY = new Key<Byte>("android.jpeg.quality", Byte.TYPE);
        JPEG_THUMBNAIL_QUALITY = new Key<Byte>("android.jpeg.thumbnailQuality", Byte.TYPE);
        JPEG_THUMBNAIL_SIZE = new Key<Size>("android.jpeg.thumbnailSize", Size.class);
        LENS_APERTURE = new Key<Float>("android.lens.aperture", Float.TYPE);
        LENS_FILTER_DENSITY = new Key<Float>("android.lens.filterDensity", Float.TYPE);
        LENS_FOCAL_LENGTH = new Key<Float>("android.lens.focalLength", Float.TYPE);
        LENS_FOCUS_DISTANCE = new Key<Float>("android.lens.focusDistance", Float.TYPE);
        LENS_OPTICAL_STABILIZATION_MODE = new Key<Integer>("android.lens.opticalStabilizationMode", Integer.TYPE);
        NOISE_REDUCTION_MODE = new Key<Integer>("android.noiseReduction.mode", Integer.TYPE);
        REQUEST_ID = new Key<Integer>("android.request.id", Integer.TYPE);
        SCALER_CROP_REGION = new Key<Rect>("android.scaler.cropRegion", Rect.class);
        SENSOR_EXPOSURE_TIME = new Key<Long>("android.sensor.exposureTime", Long.TYPE);
        SENSOR_FRAME_DURATION = new Key<Long>("android.sensor.frameDuration", Long.TYPE);
        SENSOR_SENSITIVITY = new Key<Integer>("android.sensor.sensitivity", Integer.TYPE);
        SENSOR_TEST_PATTERN_DATA = new Key<int[]>("android.sensor.testPatternData", int[].class);
        SENSOR_TEST_PATTERN_MODE = new Key<Integer>("android.sensor.testPatternMode", Integer.TYPE);
        SHADING_MODE = new Key<Integer>("android.shading.mode", Integer.TYPE);
        STATISTICS_FACE_DETECT_MODE = new Key<Integer>("android.statistics.faceDetectMode", Integer.TYPE);
        STATISTICS_HOT_PIXEL_MAP_MODE = new Key<Boolean>("android.statistics.hotPixelMapMode", Boolean.TYPE);
        STATISTICS_LENS_SHADING_MAP_MODE = new Key<Integer>("android.statistics.lensShadingMapMode", Integer.TYPE);
        TONEMAP_CURVE_BLUE = new Key<float[]>("android.tonemap.curveBlue", float[].class);
        TONEMAP_CURVE_GREEN = new Key<float[]>("android.tonemap.curveGreen", float[].class);
        TONEMAP_CURVE_RED = new Key<float[]>("android.tonemap.curveRed", float[].class);
        TONEMAP_CURVE = new Key<TonemapCurve>("android.tonemap.curve", TonemapCurve.class);
        TONEMAP_MODE = new Key<Integer>("android.tonemap.mode", Integer.TYPE);
        LED_TRANSMIT = new Key<Boolean>("android.led.transmit", Boolean.TYPE);
        BLACK_LEVEL_LOCK = new Key<Boolean>("android.blackLevel.lock", Boolean.TYPE);
    }

    private CaptureRequest() {
        this.mSettings = new CameraMetadataNative();
        this.mSurfaceSet = new HashSet();
    }

    private CaptureRequest(CaptureRequest captureRequest) {
        this.mSettings = new CameraMetadataNative(captureRequest.mSettings);
        this.mSurfaceSet = (HashSet)captureRequest.mSurfaceSet.clone();
        this.mUserTag = captureRequest.mUserTag;
    }

    private CaptureRequest(CameraMetadataNative cameraMetadataNative) {
        this.mSettings = CameraMetadataNative.move(cameraMetadataNative);
        this.mSurfaceSet = new HashSet();
    }

    static /* synthetic */ Object access$502(CaptureRequest captureRequest, Object object) {
        captureRequest.mUserTag = object;
        return object;
    }

    private boolean equals(CaptureRequest captureRequest) {
        return captureRequest != null && Objects.equals(this.mUserTag, captureRequest.mUserTag) && this.mSurfaceSet.equals(captureRequest.mSurfaceSet) && this.mSettings.equals(captureRequest.mSettings);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readFromParcel(Parcel parcel) {
        this.mSettings.readFromParcel(parcel);
        this.mSurfaceSet.clear();
        Parcelable[] parcelableArray = parcel.readParcelableArray(Surface.class.getClassLoader());
        if (parcelableArray != null) {
            int n = parcelableArray.length;
            for (int i = 0; i < n; ++i) {
                Surface surface = (Surface)parcelableArray[i];
                this.mSurfaceSet.add(surface);
            }
        }
    }

    public boolean containsTarget(Surface surface) {
        return this.mSurfaceSet.contains(surface);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof CaptureRequest && this.equals((CaptureRequest)object);
    }

    public <T> T get(Key<T> key) {
        return this.mSettings.get(key);
    }

    @Override
    protected Class<Key<?>> getKeyClass() {
        return Key.class;
    }

    @Override
    public List<Key<?>> getKeys() {
        return super.getKeys();
    }

    @Override
    protected <T> T getProtected(Key<?> key) {
        return (T)this.mSettings.get(key);
    }

    public Object getTag() {
        return this.mUserTag;
    }

    public Collection<Surface> getTargets() {
        return Collections.unmodifiableCollection(this.mSurfaceSet);
    }

    public int hashCode() {
        return HashCodeHelpers.hashCode(this.mSettings, this.mSurfaceSet, this.mUserTag);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.mSettings.writeToParcel(parcel, n);
        parcel.writeParcelableArray(this.mSurfaceSet.toArray(new Surface[this.mSurfaceSet.size()]), n);
    }

    public static final class Builder {
        private final CaptureRequest mRequest;

        public Builder(CameraMetadataNative cameraMetadataNative) {
            this.mRequest = new CaptureRequest(cameraMetadataNative);
        }

        public void addTarget(Surface surface) {
            this.mRequest.mSurfaceSet.add(surface);
        }

        public CaptureRequest build() {
            return new CaptureRequest(this.mRequest);
        }

        public <T> T get(Key<T> key) {
            return this.mRequest.mSettings.get(key);
        }

        public boolean isEmpty() {
            return this.mRequest.mSettings.isEmpty();
        }

        public void removeTarget(Surface surface) {
            this.mRequest.mSurfaceSet.remove(surface);
        }

        public <T> void set(Key<T> key, T t) {
            this.mRequest.mSettings.set(key, t);
        }

        public void setTag(Object object) {
            CaptureRequest.access$502(this.mRequest, object);
        }
    }

    public static final class Key<T> {
        private final CameraMetadataNative.Key<T> mKey;

        Key(CameraMetadataNative.Key<?> key) {
            this.mKey = key;
        }

        public Key(String string2, TypeReference<T> typeReference) {
            this.mKey = new CameraMetadataNative.Key<T>(string2, typeReference);
        }

        public Key(String string2, Class<T> clazz) {
            this.mKey = new CameraMetadataNative.Key<T>(string2, clazz);
        }

        public final boolean equals(Object object) {
            return object instanceof Key && ((Key)object).mKey.equals(this.mKey);
        }

        public String getName() {
            return this.mKey.getName();
        }

        public CameraMetadataNative.Key<T> getNativeKey() {
            return this.mKey;
        }

        public final int hashCode() {
            return this.mKey.hashCode();
        }
    }
}

