/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import android.util.StateSet;
import com.android.internal.R;
import java.io.IOException;
import java.util.Arrays;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawable
extends DrawableContainer {
    private static final boolean DEBUG = false;
    private static final boolean DEFAULT_DITHER = true;
    private static final String TAG = StateListDrawable.class.getSimpleName();
    private boolean mMutated;
    private StateListState mStateListState;

    public StateListDrawable() {
        this(null, null);
    }

    StateListDrawable(StateListState stateListState) {
        if (stateListState != null) {
            this.setConstantState(stateListState);
        }
    }

    private StateListDrawable(StateListState stateListState, Resources resources) {
        this.setConstantState(new StateListState(stateListState, this, resources));
        this.onStateChange(this.getState());
    }

    public void addState(int[] nArray, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(nArray, drawable2);
            this.onStateChange(this.getState());
        }
    }

    public int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    public Drawable getStateDrawable(int n) {
        return this.mStateListState.getChild(n);
    }

    public int getStateDrawableIndex(int[] nArray) {
        return this.mStateListState.indexOfStateSet(nArray);
    }

    StateListState getStateListState() {
        return this.mStateListState;
    }

    public int[] getStateSet(int n) {
        return this.mStateListState.mStateSets[n];
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray typedArray = StateListDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.StateListDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 1);
        this.mStateListState.setVariablePadding(typedArray.getBoolean(2, false));
        this.mStateListState.setConstantSize(typedArray.getBoolean(3, false));
        this.mStateListState.setEnterFadeDuration(typedArray.getInt(4, 0));
        this.mStateListState.setExitFadeDuration(typedArray.getInt(5, 0));
        this.setDither(typedArray.getBoolean(0, true));
        this.setAutoMirrored(typedArray.getBoolean(6, false));
        typedArray.recycle();
        int n = 1 + xmlPullParser.getDepth();
        while (true) {
            Drawable drawable2;
            int[] nArray;
            block10: {
                int n2;
                int n3;
                int n4;
                if ((n4 = xmlPullParser.next()) != 1 && ((n3 = xmlPullParser.getDepth()) >= n || n4 != 3)) {
                    if (n4 != 2 || n3 > n || !xmlPullParser.getName().equals("item")) continue;
                } else {
                    this.onStateChange(this.getState());
                    return;
                }
                int n5 = 0;
                int n6 = attributeSet.getAttributeCount();
                int[] nArray2 = new int[n6];
                int n7 = 0;
                int n8 = 0;
                while (true) {
                    int n9;
                    int n10;
                    if (n7 >= n6 || (n10 = attributeSet.getAttributeNameResource(n7)) == 0) {
                        nArray = StateSet.trimStateSet(nArray2, n8);
                        if (n5 == 0) break;
                        drawable2 = resources.getDrawable(n5, theme);
                        break block10;
                    }
                    if (n10 == 0x1010199) {
                        n5 = attributeSet.getAttributeResourceValue(n7, 0);
                        n9 = n8;
                    } else {
                        n9 = n8 + 1;
                        if (!attributeSet.getAttributeBooleanValue(n7, false)) {
                            n10 = -n10;
                        }
                        nArray2[n8] = n10;
                    }
                    ++n7;
                    n8 = n9;
                }
                while ((n2 = xmlPullParser.next()) == 4) {
                }
                if (n2 != 2) {
                    throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
            }
            this.mStateListState.addStateSet(nArray, drawable2);
        }
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            int[][] nArray = this.mStateListState.mStateSets;
            int n = nArray.length;
            this.mStateListState.mStateSets = new int[n][];
            for (int i = 0; i < n; ++i) {
                int[] nArray2 = nArray[i];
                if (nArray2 == null) continue;
                this.mStateListState.mStateSets[i] = (int[])nArray2.clone();
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        int n = this.mStateListState.indexOfStateSet(nArray);
        if (n < 0) {
            n = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        if (this.selectDrawable(n)) {
            return true;
        }
        return super.onStateChange(nArray);
    }

    void setConstantState(StateListState stateListState) {
        super.setConstantState(stateListState);
        this.mStateListState = stateListState;
    }

    @Override
    public void setLayoutDirection(int n) {
        super.setLayoutDirection(n);
        this.mStateListState.setLayoutDirection(n);
    }

    static class StateListState
    extends DrawableContainer.DrawableContainerState {
        int[][] mStateSets;

        StateListState(StateListState stateListState, StateListDrawable stateListDrawable, Resources resources) {
            super(stateListState, stateListDrawable, resources);
            if (stateListState != null) {
                this.mStateSets = (int[][])Arrays.copyOf(stateListState.mStateSets, stateListState.mStateSets.length);
                return;
            }
            this.mStateSets = new int[this.getCapacity()][];
        }

        int addStateSet(int[] nArray, Drawable drawable2) {
            int n = this.addChild(drawable2);
            this.mStateSets[n] = nArray;
            return n;
        }

        @Override
        public void growArray(int n, int n2) {
            super.growArray(n, n2);
            int[][] nArrayArray = new int[n2][];
            System.arraycopy(this.mStateSets, 0, nArrayArray, 0, n);
            this.mStateSets = nArrayArray;
        }

        int indexOfStateSet(int[] nArray) {
            int[][] nArray2 = this.mStateSets;
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (!StateSet.stateSetMatches(nArray2[i], nArray)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Drawable newDrawable() {
            return new StateListDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new StateListDrawable(this, resources);
        }
    }
}

