/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ShapeDrawable
extends Drawable {
    private boolean mMutated;
    private ShapeState mShapeState;
    private PorterDuffColorFilter mTintFilter;

    public ShapeDrawable() {
        this(new ShapeState(null), null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private ShapeDrawable(ShapeState shapeState, Resources resources, Resources.Theme theme) {
        if (theme != null && shapeState.canApplyTheme()) {
            this.mShapeState = new ShapeState(shapeState);
            this.applyTheme(theme);
        } else {
            this.mShapeState = shapeState;
        }
        this.initializeWithState(shapeState, resources);
    }

    public ShapeDrawable(Shape shape) {
        this(new ShapeState(null), null, null);
        this.mShapeState.mShape = shape;
    }

    private void initializeWithState(ShapeState shapeState, Resources resources) {
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, shapeState.mTint, shapeState.mTintMode);
    }

    private static int modulateAlpha(int n, int n2) {
        return n * (n2 + (n2 >>> 7)) >>> 8;
    }

    private void updateShape() {
        if (this.mShapeState.mShape != null) {
            Rect rect = this.getBounds();
            int n = rect.width();
            int n2 = rect.height();
            this.mShapeState.mShape.resize(n, n2);
            if (this.mShapeState.mShaderFactory != null) {
                this.mShapeState.mPaint.setShader(this.mShapeState.mShaderFactory.resize(n, n2));
            }
        }
        this.invalidateSelf();
    }

    private void updateStateFromTypedArray(TypedArray typedArray) {
        ColorStateList colorStateList;
        ShapeState shapeState = this.mShapeState;
        Paint paint = shapeState.mPaint;
        shapeState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        shapeState.mThemeAttrs = typedArray.extractThemeAttrs();
        paint.setColor(typedArray.getColor(4, paint.getColor()));
        paint.setDither(typedArray.getBoolean(0, paint.isDither()));
        this.setIntrinsicWidth((int)typedArray.getDimension(3, shapeState.mIntrinsicWidth));
        this.setIntrinsicHeight((int)typedArray.getDimension(2, shapeState.mIntrinsicHeight));
        int n = typedArray.getInt(5, -1);
        if (n != -1) {
            shapeState.mTintMode = Drawable.parseTintMode(n, PorterDuff.Mode.SRC_IN);
        }
        if ((colorStateList = typedArray.getColorStateList(1)) != null) {
            shapeState.mTint = colorStateList;
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        ShapeState shapeState = this.mShapeState;
        if (shapeState == null || shapeState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(shapeState.mThemeAttrs, R.styleable.ShapeDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        this.initializeWithState(shapeState, theme.getResources());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Rect rect = this.getBounds();
        ShapeState shapeState = this.mShapeState;
        Paint paint = shapeState.mPaint;
        int n = paint.getAlpha();
        paint.setAlpha(ShapeDrawable.modulateAlpha(n, shapeState.mAlpha));
        if (paint.getAlpha() != 0 || paint.getXfermode() != null || paint.hasShadowLayer()) {
            boolean bl;
            if (this.mTintFilter != null && paint.getColorFilter() == null) {
                paint.setColorFilter(this.mTintFilter);
                bl = true;
            } else {
                bl = false;
            }
            if (shapeState.mShape != null) {
                int n2 = canvas.save();
                canvas.translate(rect.left, rect.top);
                this.onDraw(shapeState.mShape, canvas, paint);
                canvas.restoreToCount(n2);
            } else {
                canvas.drawRect(rect, paint);
            }
            if (bl) {
                paint.setColorFilter(null);
            }
        }
        paint.setAlpha(n);
    }

    @Override
    public int getAlpha() {
        return this.mShapeState.mAlpha;
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.mChangingConfigurations;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mShapeState.mIntrinsicHeight;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mShapeState.mIntrinsicWidth;
    }

    @Override
    public int getOpacity() {
        Paint paint;
        if (this.mShapeState.mShape == null && (paint = this.mShapeState.mPaint).getXfermode() == null) {
            int n = paint.getAlpha();
            if (n == 0) {
                return -2;
            }
            if (n == 255) {
                return -1;
            }
        }
        return -3;
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.mShapeState.mShape != null) {
            this.mShapeState.mShape.getOutline(outline);
            outline.setAlpha((float)this.getAlpha() / 255.0f);
        }
    }

    @Override
    public boolean getPadding(Rect rect) {
        if (this.mShapeState.mPadding != null) {
            rect.set(this.mShapeState.mPadding);
            return true;
        }
        return super.getPadding(rect);
    }

    public Paint getPaint() {
        return this.mShapeState.mPaint;
    }

    public ShaderFactory getShaderFactory() {
        return this.mShapeState.mShaderFactory;
    }

    public Shape getShape() {
        return this.mShapeState.mShape;
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        super.inflate(resources, xmlPullParser, attributeSet, theme);
        TypedArray typedArray = ShapeDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.ShapeDrawable);
        this.updateStateFromTypedArray(typedArray);
        typedArray.recycle();
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            String string2;
            if (n != 2 || this.inflateTag(string2 = xmlPullParser.getName(), resources, xmlPullParser, attributeSet)) continue;
            Log.w("drawable", "Unknown element: " + string2 + " for ShapeDrawable " + this);
        }
        this.initializeWithState(this.mShapeState, resources);
    }

    protected boolean inflateTag(String string2, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet) {
        if ("padding".equals(string2)) {
            TypedArray typedArray = resources.obtainAttributes(attributeSet, R.styleable.ShapeDrawablePadding);
            this.setPadding(typedArray.getDimensionPixelOffset(0, 0), typedArray.getDimensionPixelOffset(1, 0), typedArray.getDimensionPixelOffset(2, 0), typedArray.getDimensionPixelOffset(3, 0));
            typedArray.recycle();
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        ShapeState shapeState = this.mShapeState;
        return super.isStateful() || shapeState.mTint != null && shapeState.mTint.isStateful();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Drawable mutate() {
        if (this.mMutated || super.mutate() != this) return this;
        this.mShapeState.mPaint = this.mShapeState.mPaint != null ? new Paint(this.mShapeState.mPaint) : new Paint(1);
        this.mShapeState.mPadding = this.mShapeState.mPadding != null ? new Rect(this.mShapeState.mPadding) : new Rect();
        try {
            this.mShapeState.mShape = this.mShapeState.mShape.clone();
            this.mMutated = true;
            return this;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        super.onBoundsChange(rect);
        this.updateShape();
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        shape.draw(canvas, paint);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        ShapeState shapeState = this.mShapeState;
        if (shapeState.mTint != null && shapeState.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, shapeState.mTint, shapeState.mTintMode);
            return true;
        }
        return false;
    }

    @Override
    public void setAlpha(int n) {
        this.mShapeState.mAlpha = n;
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mShapeState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    public void setDither(boolean bl) {
        this.mShapeState.mPaint.setDither(bl);
        this.invalidateSelf();
    }

    public void setIntrinsicHeight(int n) {
        this.mShapeState.mIntrinsicHeight = n;
        this.invalidateSelf();
    }

    public void setIntrinsicWidth(int n) {
        this.mShapeState.mIntrinsicWidth = n;
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPadding(int n, int n2, int n3, int n4) {
        if ((n4 | (n3 | (n | n2))) == 0) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(n, n2, n3, n4);
        }
        this.invalidateSelf();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPadding(Rect rect) {
        if (rect == null) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(rect);
        }
        this.invalidateSelf();
    }

    public void setShaderFactory(ShaderFactory shaderFactory) {
        this.mShapeState.mShaderFactory = shaderFactory;
    }

    public void setShape(Shape shape) {
        this.mShapeState.mShape = shape;
        this.updateShape();
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mShapeState.mTint = colorStateList;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, colorStateList, this.mShapeState.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mShapeState.mTintMode = mode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mShapeState.mTint, mode);
        this.invalidateSelf();
    }

    public static abstract class ShaderFactory {
        public abstract Shader resize(int var1, int var2);
    }

    static final class ShapeState
    extends Drawable.ConstantState {
        int mAlpha = 255;
        int mChangingConfigurations;
        int mIntrinsicHeight;
        int mIntrinsicWidth;
        Rect mPadding;
        Paint mPaint;
        ShaderFactory mShaderFactory;
        Shape mShape;
        int[] mThemeAttrs;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;

        ShapeState(ShapeState shapeState) {
            if (shapeState != null) {
                this.mThemeAttrs = shapeState.mThemeAttrs;
                this.mPaint = shapeState.mPaint;
                this.mShape = shapeState.mShape;
                this.mTint = shapeState.mTint;
                this.mTintMode = shapeState.mTintMode;
                this.mPadding = shapeState.mPadding;
                this.mIntrinsicWidth = shapeState.mIntrinsicWidth;
                this.mIntrinsicHeight = shapeState.mIntrinsicHeight;
                this.mAlpha = shapeState.mAlpha;
                this.mShaderFactory = shapeState.mShaderFactory;
                return;
            }
            this.mPaint = new Paint(1);
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new ShapeDrawable(this, null, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new ShapeDrawable(this, resources, null);
        }

        @Override
        public Drawable newDrawable(Resources resources, Resources.Theme theme) {
            return new ShapeDrawable(this, resources, theme);
        }
    }
}

