/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends Drawable
implements Drawable.Callback {
    private InsetState mInsetState;
    private boolean mMutated;
    private final Rect mTmpRect = new Rect();

    InsetDrawable() {
        this(null, null);
    }

    public InsetDrawable(Drawable drawable2, int n) {
        this(drawable2, n, n, n, n);
    }

    public InsetDrawable(Drawable drawable2, int n, int n2, int n3, int n4) {
        this(null, null);
        this.mInsetState.mDrawable = drawable2;
        this.mInsetState.mInsetLeft = n;
        this.mInsetState.mInsetTop = n2;
        this.mInsetState.mInsetRight = n3;
        this.mInsetState.mInsetBottom = n4;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
    }

    private InsetDrawable(InsetState insetState, Resources resources) {
        this.mInsetState = new InsetState(insetState, this, resources);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateStateFromTypedArray(TypedArray typedArray) throws XmlPullParserException {
        InsetState insetState = this.mInsetState;
        insetState.mChangingConfigurations |= typedArray.getChangingConfigurations();
        insetState.mThemeAttrs = typedArray.extractThemeAttrs();
        int n = typedArray.getIndexCount();
        int n2 = 0;
        while (n2 < n) {
            int n3 = typedArray.getIndex(n2);
            switch (n3) {
                case 1: {
                    Drawable drawable2 = typedArray.getDrawable(n3);
                    if (drawable2 == null) break;
                    insetState.mDrawable = drawable2;
                    drawable2.setCallback(this);
                    break;
                }
                case 6: {
                    int n4 = typedArray.getDimensionPixelOffset(n3, Integer.MIN_VALUE);
                    if (n4 == Integer.MIN_VALUE) break;
                    insetState.mInsetLeft = n4;
                    insetState.mInsetTop = n4;
                    insetState.mInsetRight = n4;
                    insetState.mInsetBottom = n4;
                    break;
                }
                case 2: {
                    insetState.mInsetLeft = typedArray.getDimensionPixelOffset(n3, insetState.mInsetLeft);
                    break;
                }
                case 4: {
                    insetState.mInsetTop = typedArray.getDimensionPixelOffset(n3, insetState.mInsetTop);
                    break;
                }
                case 3: {
                    insetState.mInsetRight = typedArray.getDimensionPixelOffset(n3, insetState.mInsetRight);
                    break;
                }
                case 5: {
                    insetState.mInsetBottom = typedArray.getDimensionPixelOffset(n3, insetState.mInsetBottom);
                    break;
                }
            }
            ++n2;
        }
        return;
    }

    private void verifyRequiredAttributes(TypedArray typedArray) throws XmlPullParserException {
        if (this.mInsetState.mDrawable == null && (this.mInsetState.mThemeAttrs == null || this.mInsetState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(typedArray.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
        }
    }

    @Override
    public void applyTheme(Resources.Theme theme) {
        super.applyTheme(theme);
        InsetState insetState = this.mInsetState;
        if (insetState == null || insetState.mThemeAttrs == null) {
            return;
        }
        TypedArray typedArray = theme.resolveAttributes(insetState.mThemeAttrs, R.styleable.InsetDrawable);
        try {
            this.updateStateFromTypedArray(typedArray);
            this.verifyRequiredAttributes(typedArray);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new RuntimeException(xmlPullParserException);
        }
        finally {
            typedArray.recycle();
        }
    }

    @Override
    public boolean canApplyTheme() {
        return this.mInsetState != null && this.mInsetState.mThemeAttrs != null;
    }

    @Override
    public void draw(Canvas canvas) {
        this.mInsetState.mDrawable.draw(canvas);
    }

    @Override
    public int getAlpha() {
        return this.mInsetState.mDrawable.getAlpha();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mInsetState.mChangingConfigurations | this.mInsetState.mDrawable.getChangingConfigurations();
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        if (this.mInsetState.canConstantState()) {
            this.mInsetState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mInsetState;
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mInsetState.mDrawable;
    }

    @Override
    public void getHotspotBounds(Rect rect) {
        this.mInsetState.mDrawable.getHotspotBounds(rect);
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mInsetState.mDrawable.getIntrinsicHeight();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mInsetState.mDrawable.getIntrinsicWidth();
    }

    @Override
    public int getOpacity() {
        return this.mInsetState.mDrawable.getOpacity();
    }

    @Override
    public Insets getOpticalInsets() {
        Insets insets = super.getOpticalInsets();
        return Insets.of(insets.left + this.mInsetState.mInsetLeft, insets.top + this.mInsetState.mInsetTop, insets.right + this.mInsetState.mInsetRight, insets.bottom + this.mInsetState.mInsetBottom);
    }

    @Override
    public void getOutline(Outline outline) {
        this.mInsetState.mDrawable.getOutline(outline);
    }

    @Override
    public boolean getPadding(Rect rect) {
        boolean bl = this.mInsetState.mDrawable.getPadding(rect);
        rect.left += this.mInsetState.mInsetLeft;
        rect.right += this.mInsetState.mInsetRight;
        rect.top += this.mInsetState.mInsetTop;
        rect.bottom += this.mInsetState.mInsetBottom;
        return bl || (this.mInsetState.mInsetLeft | this.mInsetState.mInsetRight | this.mInsetState.mInsetTop | this.mInsetState.mInsetBottom) != 0;
    }

    @Override
    public void inflate(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray typedArray = InsetDrawable.obtainAttributes(resources, theme, attributeSet, R.styleable.InsetDrawable);
        super.inflateWithAttributes(resources, xmlPullParser, typedArray, 0);
        this.mInsetState.mDrawable = null;
        this.updateStateFromTypedArray(typedArray);
        if (this.mInsetState.mDrawable == null) {
            Drawable drawable2;
            int n;
            while ((n = xmlPullParser.next()) == 4) {
            }
            if (n != 2) {
                throw new XmlPullParserException(xmlPullParser.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
            }
            this.mInsetState.mDrawable = drawable2 = Drawable.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
            drawable2.setCallback(this);
        }
        this.verifyRequiredAttributes(typedArray);
        typedArray.recycle();
    }

    @Override
    public void invalidateDrawable(Drawable drawable2) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable(this);
        }
    }

    @Override
    public boolean isStateful() {
        return this.mInsetState.mDrawable.isStateful();
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mInsetState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    protected void onBoundsChange(Rect rect) {
        Rect rect2 = this.mTmpRect;
        rect2.set(rect);
        rect2.left += this.mInsetState.mInsetLeft;
        rect2.top += this.mInsetState.mInsetTop;
        rect2.right -= this.mInsetState.mInsetRight;
        rect2.bottom -= this.mInsetState.mInsetBottom;
        this.mInsetState.mDrawable.setBounds(rect2.left, rect2.top, rect2.right, rect2.bottom);
    }

    @Override
    protected boolean onLevelChange(int n) {
        return this.mInsetState.mDrawable.setLevel(n);
    }

    @Override
    protected boolean onStateChange(int[] nArray) {
        boolean bl = this.mInsetState.mDrawable.setState(nArray);
        this.onBoundsChange(this.getBounds());
        return bl;
    }

    @Override
    public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable(this, runnable, l);
        }
    }

    @Override
    public void setAlpha(int n) {
        this.mInsetState.mDrawable.setAlpha(n);
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mInsetState.mDrawable.setColorFilter(colorFilter);
    }

    @Override
    public void setHotspot(float f, float f2) {
        this.mInsetState.mDrawable.setHotspot(f, f2);
    }

    @Override
    public void setHotspotBounds(int n, int n2, int n3, int n4) {
        this.mInsetState.mDrawable.setHotspotBounds(n, n2, n3, n4);
    }

    @Override
    public void setLayoutDirection(int n) {
        this.mInsetState.mDrawable.setLayoutDirection(n);
    }

    @Override
    public void setTintList(ColorStateList colorStateList) {
        this.mInsetState.mDrawable.setTintList(colorStateList);
    }

    @Override
    public void setTintMode(PorterDuff.Mode mode) {
        this.mInsetState.mDrawable.setTintMode(mode);
    }

    @Override
    public boolean setVisible(boolean bl, boolean bl2) {
        this.mInsetState.mDrawable.setVisible(bl, bl2);
        return super.setVisible(bl, bl2);
    }

    @Override
    public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable(this, runnable);
        }
    }

    static final class InsetState
    extends Drawable.ConstantState {
        boolean mCanConstantState;
        int mChangingConfigurations;
        boolean mCheckedConstantState;
        Drawable mDrawable;
        int mInsetBottom;
        int mInsetLeft;
        int mInsetRight;
        int mInsetTop;
        int[] mThemeAttrs;

        /*
         * Enabled aggressive block sorting
         */
        InsetState(InsetState insetState, InsetDrawable insetDrawable, Resources resources) {
            if (insetState != null) {
                this.mThemeAttrs = insetState.mThemeAttrs;
                this.mChangingConfigurations = insetState.mChangingConfigurations;
                this.mDrawable = resources != null ? insetState.mDrawable.getConstantState().newDrawable(resources) : insetState.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback(insetDrawable);
                this.mDrawable.setLayoutDirection(insetState.mDrawable.getLayoutDirection());
                this.mDrawable.setBounds(insetState.mDrawable.getBounds());
                this.mDrawable.setLevel(insetState.mDrawable.getLevel());
                this.mInsetLeft = insetState.mInsetLeft;
                this.mInsetTop = insetState.mInsetTop;
                this.mInsetRight = insetState.mInsetRight;
                this.mInsetBottom = insetState.mInsetBottom;
                this.mCanConstantState = true;
                this.mCheckedConstantState = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                boolean bl = this.mDrawable.getConstantState() != null;
                this.mCanConstantState = bl;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        @Override
        public Drawable newDrawable() {
            return new InsetDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources resources) {
            return new InsetDrawable(this, resources);
        }
    }
}

