/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import java.lang.ref.WeakReference;

public class SurfaceTexture {
    private final Looper mCreatorLooper = Looper.myLooper();
    private long mFrameAvailableListener;
    private Handler mOnFrameAvailableHandler;
    private long mProducer;
    private long mSurfaceTexture;

    static {
        SurfaceTexture.nativeClassInit();
    }

    public SurfaceTexture(int n) {
        this(n, false);
    }

    public SurfaceTexture(int n, boolean bl) {
        this.nativeInit(false, n, bl, new WeakReference<SurfaceTexture>(this));
    }

    public SurfaceTexture(boolean bl) {
        this.nativeInit(true, 0, bl, new WeakReference<SurfaceTexture>(this));
    }

    private native int nativeAttachToGLContext(int var1);

    private static native void nativeClassInit();

    private native int nativeDetachFromGLContext();

    private native void nativeFinalize();

    private native int nativeGetQueuedCount();

    private native long nativeGetTimestamp();

    private native void nativeGetTransformMatrix(float[] var1);

    private native void nativeInit(boolean var1, int var2, boolean var3, WeakReference<SurfaceTexture> var4) throws Surface.OutOfResourcesException;

    private native void nativeRelease();

    private native void nativeReleaseTexImage();

    private native void nativeSetDefaultBufferSize(int var1, int var2);

    private native void nativeUpdateTexImage();

    private static void postEventFromNative(WeakReference<SurfaceTexture> weakReference) {
        Handler handler;
        SurfaceTexture surfaceTexture = (SurfaceTexture)weakReference.get();
        if (surfaceTexture != null && (handler = surfaceTexture.mOnFrameAvailableHandler) != null) {
            handler.sendEmptyMessage(0);
        }
    }

    public void attachToGLContext(int n) {
        if (this.nativeAttachToGLContext(n) != 0) {
            throw new RuntimeException("Error during attachToGLContext (see logcat for details)");
        }
    }

    public void detachFromGLContext() {
        if (this.nativeDetachFromGLContext() != 0) {
            throw new RuntimeException("Error during detachFromGLContext (see logcat for details)");
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeFinalize();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp();
    }

    public void getTransformMatrix(float[] fArray) {
        if (fArray.length != 16) {
            throw new IllegalArgumentException();
        }
        this.nativeGetTransformMatrix(fArray);
    }

    public void release() {
        this.nativeRelease();
    }

    public void releaseTexImage() {
        this.nativeReleaseTexImage();
    }

    public void setDefaultBufferSize(int n, int n2) {
        this.nativeSetDefaultBufferSize(n, n2);
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener onFrameAvailableListener) {
        this.setOnFrameAvailableListener(onFrameAvailableListener, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setOnFrameAvailableListener(final OnFrameAvailableListener onFrameAvailableListener, Handler handler) {
        if (onFrameAvailableListener == null) {
            this.mOnFrameAvailableHandler = null;
            return;
        }
        Looper looper = handler != null ? handler.getLooper() : (this.mCreatorLooper != null ? this.mCreatorLooper : Looper.getMainLooper());
        this.mOnFrameAvailableHandler = new Handler(looper, null, true){

            @Override
            public void handleMessage(Message message) {
                onFrameAvailableListener.onFrameAvailable(SurfaceTexture.this);
            }
        };
    }

    public void updateTexImage() {
        this.nativeUpdateTexImage();
    }

    public static interface OnFrameAvailableListener {
        public void onFrameAvailable(SurfaceTexture var1);
    }

    @Deprecated
    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String string2) {
            super(string2);
        }
    }
}

