/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;

public class Shader {
    private Matrix mLocalMatrix;
    private long native_instance;

    private static native void nativeDestructor(long var0);

    private static native void nativeSetLocalMatrix(long var0, long var2);

    protected Shader copy() {
        Shader shader = new Shader();
        this.copyLocalMatrix(shader);
        return shader;
    }

    protected void copyLocalMatrix(Shader shader) {
        if (this.mLocalMatrix != null) {
            Matrix matrix = new Matrix();
            this.getLocalMatrix(matrix);
            shader.setLocalMatrix(matrix);
            return;
        }
        shader.setLocalMatrix(null);
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            return;
        }
        finally {
            Shader.nativeDestructor(this.native_instance);
        }
    }

    public boolean getLocalMatrix(Matrix matrix) {
        Matrix matrix2 = this.mLocalMatrix;
        boolean bl = false;
        if (matrix2 != null) {
            matrix.set(this.mLocalMatrix);
            boolean bl2 = this.mLocalMatrix.isIdentity();
            bl = false;
            if (!bl2) {
                bl = true;
            }
        }
        return bl;
    }

    long getNativeInstance() {
        return this.native_instance;
    }

    protected void init(long l) {
        this.native_instance = l;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setLocalMatrix(Matrix matrix) {
        this.mLocalMatrix = matrix;
        long l = this.native_instance;
        long l2 = matrix == null ? 0L : matrix.native_instance;
        Shader.nativeSetLocalMatrix(l, l2);
    }

    public static final class TileMode
    extends Enum<TileMode> {
        private static final /* synthetic */ TileMode[] $VALUES;
        public static final /* enum */ TileMode CLAMP = new TileMode(0);
        public static final /* enum */ TileMode MIRROR;
        public static final /* enum */ TileMode REPEAT;
        final int nativeInt;

        static {
            REPEAT = new TileMode(1);
            MIRROR = new TileMode(2);
            TileMode[] tileModeArray = new TileMode[]{CLAMP, REPEAT, MIRROR};
            $VALUES = tileModeArray;
        }

        private TileMode(int n2) {
            this.nativeInt = n2;
        }

        public static TileMode valueOf(String string2) {
            return Enum.valueOf(TileMode.class, string2);
        }

        public static TileMode[] values() {
            return (TileMode[])$VALUES.clone();
        }
    }
}

