/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.Path;

public class PathMeasure {
    public static final int POSITION_MATRIX_FLAG = 1;
    public static final int TANGENT_MATRIX_FLAG = 2;
    private Path mPath;
    private final long native_instance;

    public PathMeasure() {
        this.mPath = null;
        this.native_instance = PathMeasure.native_create(0L, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public PathMeasure(Path path, boolean bl) {
        this.mPath = path;
        long l = path != null ? path.ni() : 0L;
        this.native_instance = PathMeasure.native_create(l, bl);
    }

    private static native long native_create(long var0, boolean var2);

    private static native void native_destroy(long var0);

    private static native float native_getLength(long var0);

    private static native boolean native_getMatrix(long var0, float var2, long var3, int var5);

    private static native boolean native_getPosTan(long var0, float var2, float[] var3, float[] var4);

    private static native boolean native_getSegment(long var0, float var2, float var3, long var4, boolean var6);

    private static native boolean native_isClosed(long var0);

    private static native boolean native_nextContour(long var0);

    private static native void native_setPath(long var0, long var2, boolean var4);

    protected void finalize() throws Throwable {
        PathMeasure.native_destroy(this.native_instance);
    }

    public float getLength() {
        return PathMeasure.native_getLength(this.native_instance);
    }

    public boolean getMatrix(float f, Matrix matrix, int n) {
        return PathMeasure.native_getMatrix(this.native_instance, f, matrix.native_instance, n);
    }

    public boolean getPosTan(float f, float[] fArray, float[] fArray2) {
        if (fArray != null && fArray.length < 2 || fArray2 != null && fArray2.length < 2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return PathMeasure.native_getPosTan(this.native_instance, f, fArray, fArray2);
    }

    public boolean getSegment(float f, float f2, Path path, boolean bl) {
        path.isSimplePath = false;
        return PathMeasure.native_getSegment(this.native_instance, f, f2, path.ni(), bl);
    }

    public boolean isClosed() {
        return PathMeasure.native_isClosed(this.native_instance);
    }

    public boolean nextContour() {
        return PathMeasure.native_nextContour(this.native_instance);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPath(Path path, boolean bl) {
        this.mPath = path;
        long l = this.native_instance;
        long l2 = path != null ? path.ni() : 0L;
        PathMeasure.native_setPath(l, l2, bl);
    }
}

