/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.Region;

public class Path {
    static final FillType[] sFillTypeArray;
    public boolean isSimplePath = true;
    private Direction mLastDirection = null;
    public final long mNativePath;
    public Region rects;

    static {
        FillType[] fillTypeArray = new FillType[]{FillType.WINDING, FillType.EVEN_ODD, FillType.INVERSE_WINDING, FillType.INVERSE_EVEN_ODD};
        sFillTypeArray = fillTypeArray;
    }

    public Path() {
        this.mNativePath = Path.init1();
    }

    public Path(Path path) {
        long l = 0L;
        if (path != null) {
            l = path.mNativePath;
            this.isSimplePath = path.isSimplePath;
            if (path.rects != null) {
                this.rects = new Region(path.rects);
            }
        }
        this.mNativePath = Path.init2(l);
    }

    private void detectSimplePath(float f, float f2, float f3, float f4, Direction direction) {
        if (this.mLastDirection == null) {
            this.mLastDirection = direction;
        }
        if (this.mLastDirection != direction) {
            this.isSimplePath = false;
            return;
        }
        if (this.rects == null) {
            this.rects = new Region();
        }
        this.rects.op((int)f, (int)f2, (int)f3, (int)f4, Region.Op.UNION);
    }

    private static native void finalizer(long var0);

    private static native long init1();

    private static native long init2(long var0);

    private static native void native_addArc(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void native_addCircle(long var0, float var2, float var3, float var4, int var5);

    private static native void native_addOval(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native void native_addPath(long var0, long var2);

    private static native void native_addPath(long var0, long var2, float var4, float var5);

    private static native void native_addPath(long var0, long var2, long var4);

    private static native void native_addRect(long var0, float var2, float var3, float var4, float var5, int var6);

    private static native void native_addRoundRect(long var0, float var2, float var3, float var4, float var5, float var6, float var7, int var8);

    private static native void native_addRoundRect(long var0, float var2, float var3, float var4, float var5, float[] var6, int var7);

    private static native float[] native_approximate(long var0, float var2);

    private static native void native_arcTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8);

    private static native void native_close(long var0);

    private static native void native_computeBounds(long var0, RectF var2);

    private static native void native_cubicTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native int native_getFillType(long var0);

    private static native void native_incReserve(long var0, int var2);

    private static native boolean native_isConvex(long var0);

    private static native boolean native_isEmpty(long var0);

    private static native boolean native_isRect(long var0, RectF var2);

    private static native void native_lineTo(long var0, float var2, float var3);

    private static native void native_moveTo(long var0, float var2, float var3);

    private static native void native_offset(long var0, float var2, float var3);

    private static native void native_offset(long var0, float var2, float var3, long var4);

    private static native boolean native_op(long var0, long var2, int var4, long var5);

    private static native void native_quadTo(long var0, float var2, float var3, float var4, float var5);

    private static native void native_rCubicTo(long var0, float var2, float var3, float var4, float var5, float var6, float var7);

    private static native void native_rLineTo(long var0, float var2, float var3);

    private static native void native_rMoveTo(long var0, float var2, float var3);

    private static native void native_rQuadTo(long var0, float var2, float var3, float var4, float var5);

    private static native void native_reset(long var0);

    private static native void native_rewind(long var0);

    private static native void native_set(long var0, long var2);

    private static native void native_setFillType(long var0, int var2);

    private static native void native_setLastPoint(long var0, float var2, float var3);

    private static native void native_transform(long var0, long var2);

    private static native void native_transform(long var0, long var2, long var4);

    public void addArc(float f, float f2, float f3, float f4, float f5, float f6) {
        this.isSimplePath = false;
        Path.native_addArc(this.mNativePath, f, f2, f3, f4, f5, f6);
    }

    public void addArc(RectF rectF, float f, float f2) {
        this.addArc(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2);
    }

    public void addCircle(float f, float f2, float f3, Direction direction) {
        this.isSimplePath = false;
        Path.native_addCircle(this.mNativePath, f, f2, f3, direction.nativeInt);
    }

    public void addOval(float f, float f2, float f3, float f4, Direction direction) {
        this.isSimplePath = false;
        Path.native_addOval(this.mNativePath, f, f2, f3, f4, direction.nativeInt);
    }

    public void addOval(RectF rectF, Direction direction) {
        this.addOval(rectF.left, rectF.top, rectF.right, rectF.bottom, direction);
    }

    public void addPath(Path path) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, path.mNativePath);
    }

    public void addPath(Path path, float f, float f2) {
        this.isSimplePath = false;
        Path.native_addPath(this.mNativePath, path.mNativePath, f, f2);
    }

    public void addPath(Path path, Matrix matrix) {
        if (!path.isSimplePath) {
            this.isSimplePath = false;
        }
        Path.native_addPath(this.mNativePath, path.mNativePath, matrix.native_instance);
    }

    public void addRect(float f, float f2, float f3, float f4, Direction direction) {
        this.detectSimplePath(f, f2, f3, f4, direction);
        Path.native_addRect(this.mNativePath, f, f2, f3, f4, direction.nativeInt);
    }

    public void addRect(RectF rectF, Direction direction) {
        this.addRect(rectF.left, rectF.top, rectF.right, rectF.bottom, direction);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Direction direction) {
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, f, f2, f3, f4, f5, f6, direction.nativeInt);
    }

    public void addRoundRect(float f, float f2, float f3, float f4, float[] fArray, Direction direction) {
        if (fArray.length < 8) {
            throw new ArrayIndexOutOfBoundsException("radii[] needs 8 values");
        }
        this.isSimplePath = false;
        Path.native_addRoundRect(this.mNativePath, f, f2, f3, f4, fArray, direction.nativeInt);
    }

    public void addRoundRect(RectF rectF, float f, float f2, Direction direction) {
        this.addRoundRect(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, direction);
    }

    public void addRoundRect(RectF rectF, float[] fArray, Direction direction) {
        if (rectF == null) {
            throw new NullPointerException("need rect parameter");
        }
        this.addRoundRect(rectF.left, rectF.top, rectF.right, rectF.bottom, fArray, direction);
    }

    public float[] approximate(float f) {
        return Path.native_approximate(this.mNativePath, f);
    }

    public void arcTo(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        this.isSimplePath = false;
        Path.native_arcTo(this.mNativePath, f, f2, f3, f4, f5, f6, bl);
    }

    public void arcTo(RectF rectF, float f, float f2) {
        this.arcTo(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, false);
    }

    public void arcTo(RectF rectF, float f, float f2, boolean bl) {
        this.arcTo(rectF.left, rectF.top, rectF.right, rectF.bottom, f, f2, bl);
    }

    public void close() {
        this.isSimplePath = false;
        Path.native_close(this.mNativePath);
    }

    public void computeBounds(RectF rectF, boolean bl) {
        Path.native_computeBounds(this.mNativePath, rectF);
    }

    public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.isSimplePath = false;
        Path.native_cubicTo(this.mNativePath, f, f2, f3, f4, f5, f6);
    }

    protected void finalize() throws Throwable {
        try {
            Path.finalizer(this.mNativePath);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public FillType getFillType() {
        return sFillTypeArray[Path.native_getFillType(this.mNativePath)];
    }

    public void incReserve(int n) {
        Path.native_incReserve(this.mNativePath, n);
    }

    public boolean isConvex() {
        return Path.native_isConvex(this.mNativePath);
    }

    public boolean isEmpty() {
        return Path.native_isEmpty(this.mNativePath);
    }

    public boolean isInverseFillType() {
        return (Path.native_getFillType(this.mNativePath) & FillType.INVERSE_WINDING.nativeInt) != 0;
    }

    public boolean isRect(RectF rectF) {
        return Path.native_isRect(this.mNativePath, rectF);
    }

    public void lineTo(float f, float f2) {
        this.isSimplePath = false;
        Path.native_lineTo(this.mNativePath, f, f2);
    }

    public void moveTo(float f, float f2) {
        Path.native_moveTo(this.mNativePath, f, f2);
    }

    final long ni() {
        return this.mNativePath;
    }

    public void offset(float f, float f2) {
        this.isSimplePath = false;
        Path.native_offset(this.mNativePath, f, f2);
    }

    public void offset(float f, float f2, Path path) {
        long l = 0L;
        if (path != null) {
            l = path.mNativePath;
            path.isSimplePath = false;
        }
        Path.native_offset(this.mNativePath, f, f2, l);
    }

    public boolean op(Path path, Op op) {
        return this.op(this, path, op);
    }

    public boolean op(Path path, Path path2, Op op) {
        if (Path.native_op(path.mNativePath, path2.mNativePath, op.ordinal(), this.mNativePath)) {
            this.isSimplePath = false;
            this.rects = null;
            return true;
        }
        return false;
    }

    public void quadTo(float f, float f2, float f3, float f4) {
        this.isSimplePath = false;
        Path.native_quadTo(this.mNativePath, f, f2, f3, f4);
    }

    public void rCubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.isSimplePath = false;
        Path.native_rCubicTo(this.mNativePath, f, f2, f3, f4, f5, f6);
    }

    public void rLineTo(float f, float f2) {
        this.isSimplePath = false;
        Path.native_rLineTo(this.mNativePath, f, f2);
    }

    public void rMoveTo(float f, float f2) {
        Path.native_rMoveTo(this.mNativePath, f, f2);
    }

    public void rQuadTo(float f, float f2, float f3, float f4) {
        this.isSimplePath = false;
        Path.native_rQuadTo(this.mNativePath, f, f2, f3, f4);
    }

    public void reset() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        FillType fillType = this.getFillType();
        Path.native_reset(this.mNativePath);
        this.setFillType(fillType);
    }

    public void rewind() {
        this.isSimplePath = true;
        this.mLastDirection = null;
        if (this.rects != null) {
            this.rects.setEmpty();
        }
        Path.native_rewind(this.mNativePath);
    }

    public void set(Path path) {
        if (this != path) {
            this.isSimplePath = path.isSimplePath;
            Path.native_set(this.mNativePath, path.mNativePath);
        }
    }

    public void setFillType(FillType fillType) {
        Path.native_setFillType(this.mNativePath, fillType.nativeInt);
    }

    public void setLastPoint(float f, float f2) {
        this.isSimplePath = false;
        Path.native_setLastPoint(this.mNativePath, f, f2);
    }

    public void toggleInverseFillType() {
        int n = Path.native_getFillType(this.mNativePath) ^ FillType.INVERSE_WINDING.nativeInt;
        Path.native_setFillType(this.mNativePath, n);
    }

    public void transform(Matrix matrix) {
        this.isSimplePath = false;
        Path.native_transform(this.mNativePath, matrix.native_instance);
    }

    public void transform(Matrix matrix, Path path) {
        long l = 0L;
        if (path != null) {
            path.isSimplePath = false;
            l = path.mNativePath;
        }
        Path.native_transform(this.mNativePath, matrix.native_instance, l);
    }

    public static final class Direction
    extends Enum<Direction> {
        private static final /* synthetic */ Direction[] $VALUES;
        public static final /* enum */ Direction CCW;
        public static final /* enum */ Direction CW;
        final int nativeInt;

        static {
            CW = new Direction(1);
            CCW = new Direction(2);
            Direction[] directionArray = new Direction[]{CW, CCW};
            $VALUES = directionArray;
        }

        private Direction(int n2) {
            this.nativeInt = n2;
        }

        public static Direction valueOf(String string2) {
            return Enum.valueOf(Direction.class, string2);
        }

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }
    }

    public static final class FillType
    extends Enum<FillType> {
        private static final /* synthetic */ FillType[] $VALUES;
        public static final /* enum */ FillType EVEN_ODD;
        public static final /* enum */ FillType INVERSE_EVEN_ODD;
        public static final /* enum */ FillType INVERSE_WINDING;
        public static final /* enum */ FillType WINDING;
        final int nativeInt;

        static {
            WINDING = new FillType(0);
            EVEN_ODD = new FillType(1);
            INVERSE_WINDING = new FillType(2);
            INVERSE_EVEN_ODD = new FillType(3);
            FillType[] fillTypeArray = new FillType[]{WINDING, EVEN_ODD, INVERSE_WINDING, INVERSE_EVEN_ODD};
            $VALUES = fillTypeArray;
        }

        private FillType(int n2) {
            this.nativeInt = n2;
        }

        public static FillType valueOf(String string2) {
            return Enum.valueOf(FillType.class, string2);
        }

        public static FillType[] values() {
            return (FillType[])$VALUES.clone();
        }
    }

    public static final class Op
    extends Enum<Op> {
        private static final /* synthetic */ Op[] $VALUES;
        public static final /* enum */ Op DIFFERENCE = new Op();
        public static final /* enum */ Op INTERSECT = new Op();
        public static final /* enum */ Op REVERSE_DIFFERENCE;
        public static final /* enum */ Op UNION;
        public static final /* enum */ Op XOR;

        static {
            UNION = new Op();
            XOR = new Op();
            REVERSE_DIFFERENCE = new Op();
            Op[] opArray = new Op[]{DIFFERENCE, INTERSECT, UNION, XOR, REVERSE_DIFFERENCE};
            $VALUES = opArray;
        }

        public static Op valueOf(String string2) {
            return Enum.valueOf(Op.class, string2);
        }

        public static Op[] values() {
            return (Op[])$VALUES.clone();
        }
    }
}

