/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import android.util.DisplayMetrics;
import dalvik.system.VMRuntime;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

public final class Bitmap
implements Parcelable {
    public static final Parcelable.Creator<Bitmap> CREATOR;
    public static final int DENSITY_NONE = 0;
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private static volatile int sDefaultDensity;
    private static volatile Matrix sScaleMatrix;
    public byte[] mBuffer;
    int mDensity = Bitmap.getDefaultDensity();
    private final BitmapFinalizer mFinalizer;
    private int mHeight;
    private final boolean mIsMutable;
    public final long mNativeBitmap;
    private byte[] mNinePatchChunk;
    private NinePatch.InsetStruct mNinePatchInsets;
    private boolean mRecycled;
    private boolean mRequestPremultiplied;
    private int mWidth;

    static {
        sDefaultDensity = -1;
        CREATOR = new Parcelable.Creator<Bitmap>(){

            @Override
            public Bitmap createFromParcel(Parcel parcel) {
                Bitmap bitmap = Bitmap.nativeCreateFromParcel(parcel);
                if (bitmap == null) {
                    throw new RuntimeException("Failed to unparcel Bitmap");
                }
                return bitmap;
            }

            public Bitmap[] newArray(int n) {
                return new Bitmap[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    Bitmap(long l, byte[] byArray, int n, int n2, int n3, boolean bl, boolean bl2, byte[] byArray2, NinePatch.InsetStruct insetStruct) {
        if (l == 0L) {
            throw new RuntimeException("internal error: native bitmap is 0");
        }
        this.mWidth = n;
        this.mHeight = n2;
        this.mIsMutable = bl;
        this.mRequestPremultiplied = bl2;
        this.mBuffer = byArray;
        this.mNativeBitmap = l;
        this.mNinePatchChunk = byArray2;
        this.mNinePatchInsets = insetStruct;
        if (n3 >= 0) {
            this.mDensity = n3;
        }
        int n4 = byArray == null ? this.getByteCount() : 0;
        this.mFinalizer = new BitmapFinalizer(l, n4);
    }

    private void checkPixelAccess(int n, int n2) {
        Bitmap.checkXYSign(n, n2);
        if (n >= this.getWidth()) {
            throw new IllegalArgumentException("x must be < bitmap.width()");
        }
        if (n2 >= this.getHeight()) {
            throw new IllegalArgumentException("y must be < bitmap.height()");
        }
    }

    private void checkPixelsAccess(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        Bitmap.checkXYSign(n, n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (n + n3 > this.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (n2 + n4 > this.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (Math.abs(n6) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n7 = n5 + n6 * (n4 - 1);
        int n8 = nArray.length;
        if (n5 < 0 || n5 + n3 > n8 || n7 < 0 || n7 + n3 > n8) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private void checkRecycled(String string2) {
        if (this.mRecycled) {
            throw new IllegalStateException(string2);
        }
    }

    private static void checkWidthHeight(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("height must be > 0");
        }
    }

    private static void checkXYSign(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("x must be >= 0");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("y must be >= 0");
        }
    }

    public static Bitmap createBitmap(int n, int n2, Config config) {
        return Bitmap.createBitmap(n, n2, config, true);
    }

    private static Bitmap createBitmap(int n, int n2, Config config, boolean bl) {
        return Bitmap.createBitmap(null, n, n2, config, bl);
    }

    public static Bitmap createBitmap(Bitmap bitmap) {
        return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight());
    }

    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4) {
        return Bitmap.createBitmap(bitmap, n, n2, n3, n4, null, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bitmap createBitmap(Bitmap bitmap, int n, int n2, int n3, int n4, Matrix matrix, boolean bl) {
        Paint paint;
        Bitmap bitmap2;
        Bitmap.checkXYSign(n, n2);
        Bitmap.checkWidthHeight(n3, n4);
        if (n + n3 > bitmap.getWidth()) {
            throw new IllegalArgumentException("x + width must be <= bitmap.width()");
        }
        if (n2 + n4 > bitmap.getHeight()) {
            throw new IllegalArgumentException("y + height must be <= bitmap.height()");
        }
        if (!bitmap.isMutable() && n == 0 && n2 == 0 && n3 == bitmap.getWidth() && n4 == bitmap.getHeight() && (matrix == null || matrix.isIdentity())) {
            return bitmap;
        }
        Canvas canvas = new Canvas();
        Rect rect = new Rect(n, n2, n + n3, n2 + n4);
        RectF rectF = new RectF(0.0f, 0.0f, n3, n4);
        Config config = Config.ARGB_8888;
        Config config2 = bitmap.getConfig();
        if (config2 != null) {
            switch (config2) {
                default: {
                    config = Config.ARGB_8888;
                    break;
                }
                case RGB_565: {
                    config = Config.RGB_565;
                    break;
                }
                case ALPHA_8: {
                    config = Config.ALPHA_8;
                }
            }
        }
        if (matrix == null || matrix.isIdentity()) {
            bitmap2 = Bitmap.createBitmap(n3, n4, config, bitmap.hasAlpha());
            paint = null;
        } else {
            boolean bl2 = !matrix.rectStaysRect();
            RectF rectF2 = new RectF();
            matrix.mapRect(rectF2, rectF);
            int n5 = Math.round(rectF2.width());
            int n6 = Math.round(rectF2.height());
            if (bl2) {
                config = Config.ARGB_8888;
            }
            boolean bl3 = bl2 || bitmap.hasAlpha();
            bitmap2 = Bitmap.createBitmap(n5, n6, config, bl3);
            canvas.translate(-rectF2.left, -rectF2.top);
            canvas.concat(matrix);
            paint = new Paint();
            paint.setFilterBitmap(bl);
            if (bl2) {
                paint.setAntiAlias(true);
            }
        }
        bitmap2.mDensity = bitmap.mDensity;
        bitmap2.setHasAlpha(bitmap.hasAlpha());
        bitmap2.setPremultiplied(bitmap.mRequestPremultiplied);
        canvas.setBitmap(bitmap2);
        canvas.drawBitmap(bitmap, rect, rectF, paint);
        canvas.setBitmap(null);
        return bitmap2;
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config) {
        return Bitmap.createBitmap(displayMetrics, n, n2, config, true);
    }

    private static Bitmap createBitmap(DisplayMetrics displayMetrics, int n, int n2, Config config, boolean bl) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bitmap = Bitmap.nativeCreate(null, 0, n, n, n2, config.nativeInt, true);
        if (displayMetrics != null) {
            bitmap.mDensity = displayMetrics.densityDpi;
        }
        bitmap.setHasAlpha(bl);
        if (config == Config.ARGB_8888 && !bl) {
            Bitmap.nativeErase(bitmap.mNativeBitmap, -16777216);
        }
        return bitmap;
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, int n3, int n4, Config config) {
        Bitmap.checkWidthHeight(n3, n4);
        if (Math.abs(n2) < n3) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int n5 = n + n2 * (n4 - 1);
        int n6 = nArray.length;
        if (n < 0 || n + n3 > n6 || n5 < 0 || n5 + n3 > n6) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 <= 0 || n4 <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        Bitmap bitmap = Bitmap.nativeCreate(nArray, n, n2, n3, n4, config.nativeInt, false);
        if (displayMetrics != null) {
            bitmap.mDensity = displayMetrics.densityDpi;
        }
        return bitmap;
    }

    public static Bitmap createBitmap(DisplayMetrics displayMetrics, int[] nArray, int n, int n2, Config config) {
        return Bitmap.createBitmap(displayMetrics, nArray, 0, n, n, n2, config);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, int n3, int n4, Config config) {
        return Bitmap.createBitmap(null, nArray, n, n2, n3, n4, config);
    }

    public static Bitmap createBitmap(int[] nArray, int n, int n2, Config config) {
        return Bitmap.createBitmap(null, nArray, 0, n, n, n2, config);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Bitmap createScaledBitmap(Bitmap bitmap, int n, int n2, boolean bl) {
        // MONITORENTER : android.graphics.Bitmap.class
        Matrix matrix = sScaleMatrix;
        sScaleMatrix = null;
        // MONITOREXIT : android.graphics.Bitmap.class
        if (matrix == null) {
            matrix = new Matrix();
        }
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        matrix.setScale((float)n / (float)n3, (float)n2 / (float)n4);
        Bitmap bitmap2 = Bitmap.createBitmap(bitmap, 0, 0, n3, n4, matrix, bl);
        // MONITORENTER : android.graphics.Bitmap.class
        if (sScaleMatrix == null) {
            sScaleMatrix = matrix;
        }
        // MONITOREXIT : android.graphics.Bitmap.class
        return bitmap2;
    }

    static int getDefaultDensity() {
        if (sDefaultDensity >= 0) {
            return sDefaultDensity;
        }
        sDefaultDensity = DisplayMetrics.DENSITY_DEVICE;
        return sDefaultDensity;
    }

    private static native boolean nativeCompress(long var0, int var2, int var3, OutputStream var4, byte[] var5);

    private static native int nativeConfig(long var0);

    private static native Bitmap nativeCopy(long var0, int var2, boolean var3);

    private static native void nativeCopyPixelsFromBuffer(long var0, Buffer var2);

    private static native void nativeCopyPixelsToBuffer(long var0, Buffer var2);

    private static native Bitmap nativeCreate(int[] var0, int var1, int var2, int var3, int var4, int var5, boolean var6);

    private static native Bitmap nativeCreateFromParcel(Parcel var0);

    private static native void nativeDestructor(long var0);

    private static native void nativeErase(long var0, int var2);

    private static native Bitmap nativeExtractAlpha(long var0, long var2, int[] var4);

    private static native int nativeGenerationId(long var0);

    private static native int nativeGetPixel(long var0, int var2, int var3);

    private static native void nativeGetPixels(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native boolean nativeHasAlpha(long var0);

    private static native boolean nativeHasMipMap(long var0);

    private static native boolean nativeIsPremultiplied(long var0);

    private static native void nativePrepareToDraw(long var0);

    private static native void nativeReconfigure(long var0, int var2, int var3, int var4, int var5, boolean var6);

    private static native boolean nativeRecycle(long var0);

    private static native int nativeRowBytes(long var0);

    private static native boolean nativeSameAs(long var0, long var2);

    private static native void nativeSetHasAlpha(long var0, boolean var2, boolean var3);

    private static native void nativeSetHasMipMap(long var0, boolean var2);

    private static native void nativeSetPixel(long var0, int var2, int var3, int var4);

    private static native void nativeSetPixels(long var0, int[] var2, int var3, int var4, int var5, int var6, int var7, int var8);

    private static native void nativeSetPremultiplied(long var0, boolean var2);

    private static native boolean nativeWriteToParcel(long var0, boolean var2, int var3, Parcel var4);

    public static int scaleFromDensity(int n, int n2, int n3) {
        if (n2 == 0 || n3 == 0 || n2 == n3) {
            return n;
        }
        return (n * n3 + (n2 >> 1)) / n2;
    }

    public static void setDefaultDensity(int n) {
        sDefaultDensity = n;
    }

    public boolean compress(CompressFormat compressFormat, int n, OutputStream outputStream) {
        this.checkRecycled("Can't compress a recycled bitmap");
        if (outputStream == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        Trace.traceBegin(8192L, "Bitmap.compress");
        boolean bl = Bitmap.nativeCompress(this.mNativeBitmap, compressFormat.nativeInt, n, outputStream, new byte[4096]);
        Trace.traceEnd(8192L);
        return bl;
    }

    public Bitmap copy(Config config, boolean bl) {
        this.checkRecycled("Can't copy a recycled bitmap");
        Bitmap bitmap = Bitmap.nativeCopy(this.mNativeBitmap, config.nativeInt, bl);
        if (bitmap != null) {
            bitmap.setPremultiplied(this.mRequestPremultiplied);
            bitmap.mDensity = this.mDensity;
        }
        return bitmap;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyPixelsFromBuffer(Buffer buffer) {
        long l;
        long l2;
        int n;
        this.checkRecycled("copyPixelsFromBuffer called on recycled bitmap");
        int n2 = buffer.remaining();
        if (buffer instanceof ByteBuffer) {
            n = 0;
        } else if (buffer instanceof ShortBuffer) {
            n = 1;
        } else {
            if (!(buffer instanceof IntBuffer)) {
                throw new RuntimeException("unsupported Buffer subclass");
            }
            n = 2;
        }
        if ((l2 = (long)n2 << n) < (l = (long)this.getByteCount())) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsFromBuffer(this.mNativeBitmap, buffer);
        buffer.position((int)((long)buffer.position() + (l >> n)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void copyPixelsToBuffer(Buffer buffer) {
        long l;
        long l2;
        int n;
        int n2 = buffer.remaining();
        if (buffer instanceof ByteBuffer) {
            n = 0;
        } else if (buffer instanceof ShortBuffer) {
            n = 1;
        } else {
            if (!(buffer instanceof IntBuffer)) {
                throw new RuntimeException("unsupported Buffer subclass");
            }
            n = 2;
        }
        if ((l2 = (long)n2 << n) < (l = (long)this.getByteCount())) {
            throw new RuntimeException("Buffer not large enough for pixels");
        }
        Bitmap.nativeCopyPixelsToBuffer(this.mNativeBitmap, buffer);
        buffer.position((int)((long)buffer.position() + (l >> n)));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void eraseColor(int n) {
        this.checkRecycled("Can't erase a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException("cannot erase immutable bitmaps");
        }
        Bitmap.nativeErase(this.mNativeBitmap, n);
    }

    public Bitmap extractAlpha() {
        return this.extractAlpha(null, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Bitmap extractAlpha(Paint paint, int[] nArray) {
        this.checkRecycled("Can't extractAlpha on a recycled bitmap");
        long l = paint != null ? paint.mNativePaint : 0L;
        Bitmap bitmap = Bitmap.nativeExtractAlpha(this.mNativeBitmap, l, nArray);
        if (bitmap == null) {
            throw new RuntimeException("Failed to extractAlpha on Bitmap");
        }
        bitmap.mDensity = this.mDensity;
        return bitmap;
    }

    public final int getAllocationByteCount() {
        if (this.mBuffer == null) {
            return this.getByteCount();
        }
        return this.mBuffer.length;
    }

    public final int getByteCount() {
        return this.getRowBytes() * this.getHeight();
    }

    public final Config getConfig() {
        return Config.nativeToConfig(Bitmap.nativeConfig(this.mNativeBitmap));
    }

    public int getDensity() {
        return this.mDensity;
    }

    public int getGenerationId() {
        return Bitmap.nativeGenerationId(this.mNativeBitmap);
    }

    public final int getHeight() {
        return this.mHeight;
    }

    public byte[] getNinePatchChunk() {
        return this.mNinePatchChunk;
    }

    public NinePatch.InsetStruct getNinePatchInsets() {
        return this.mNinePatchInsets;
    }

    public void getOpticalInsets(Rect rect) {
        if (this.mNinePatchInsets == null) {
            rect.setEmpty();
            return;
        }
        rect.set(this.mNinePatchInsets.opticalRect);
    }

    public int getPixel(int n, int n2) {
        this.checkRecycled("Can't call getPixel() on a recycled bitmap");
        this.checkPixelAccess(n, n2);
        return Bitmap.nativeGetPixel(this.mNativeBitmap, n, n2);
    }

    public void getPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkRecycled("Can't call getPixels() on a recycled bitmap");
        if (n5 == 0 || n6 == 0) {
            return;
        }
        this.checkPixelsAccess(n3, n4, n5, n6, n, n2, nArray);
        Bitmap.nativeGetPixels(this.mNativeBitmap, nArray, n, n2, n3, n4, n5, n6);
    }

    public final int getRowBytes() {
        return Bitmap.nativeRowBytes(this.mNativeBitmap);
    }

    public int getScaledHeight(int n) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, n);
    }

    public int getScaledHeight(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, canvas.mDensity);
    }

    public int getScaledHeight(DisplayMetrics displayMetrics) {
        return Bitmap.scaleFromDensity(this.getHeight(), this.mDensity, displayMetrics.densityDpi);
    }

    public int getScaledWidth(int n) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, n);
    }

    public int getScaledWidth(Canvas canvas) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, canvas.mDensity);
    }

    public int getScaledWidth(DisplayMetrics displayMetrics) {
        return Bitmap.scaleFromDensity(this.getWidth(), this.mDensity, displayMetrics.densityDpi);
    }

    public final int getWidth() {
        return this.mWidth;
    }

    public final boolean hasAlpha() {
        return Bitmap.nativeHasAlpha(this.mNativeBitmap);
    }

    public final boolean hasMipMap() {
        return Bitmap.nativeHasMipMap(this.mNativeBitmap);
    }

    public final boolean isMutable() {
        return this.mIsMutable;
    }

    public final boolean isPremultiplied() {
        return Bitmap.nativeIsPremultiplied(this.mNativeBitmap);
    }

    public final boolean isRecycled() {
        return this.mRecycled;
    }

    final long ni() {
        return this.mNativeBitmap;
    }

    public void prepareToDraw() {
        Bitmap.nativePrepareToDraw(this.mNativeBitmap);
    }

    public void reconfigure(int n, int n2, Config config) {
        this.checkRecycled("Can't call reconfigure() on a recycled bitmap");
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width and height must be > 0");
        }
        if (!this.isMutable()) {
            throw new IllegalStateException("only mutable bitmaps may be reconfigured");
        }
        if (this.mBuffer == null) {
            throw new IllegalStateException("native-backed bitmaps may not be reconfigured");
        }
        Bitmap.nativeReconfigure(this.mNativeBitmap, n, n2, config.nativeInt, this.mBuffer.length, this.mRequestPremultiplied);
        this.mWidth = n;
        this.mHeight = n2;
    }

    public void recycle() {
        if (!this.mRecycled) {
            if (Bitmap.nativeRecycle(this.mNativeBitmap)) {
                this.mBuffer = null;
                this.mNinePatchChunk = null;
            }
            this.mRecycled = true;
        }
    }

    void reinit(int n, int n2, boolean bl) {
        this.mWidth = n;
        this.mHeight = n2;
        this.mRequestPremultiplied = bl;
    }

    public boolean sameAs(Bitmap bitmap) {
        return this == bitmap || bitmap != null && Bitmap.nativeSameAs(this.mNativeBitmap, bitmap.mNativeBitmap);
    }

    public void setConfig(Config config) {
        this.reconfigure(this.getWidth(), this.getHeight(), config);
    }

    public void setDensity(int n) {
        this.mDensity = n;
    }

    public void setHasAlpha(boolean bl) {
        Bitmap.nativeSetHasAlpha(this.mNativeBitmap, bl, this.mRequestPremultiplied);
    }

    public final void setHasMipMap(boolean bl) {
        Bitmap.nativeSetHasMipMap(this.mNativeBitmap, bl);
    }

    public void setHeight(int n) {
        this.reconfigure(this.getWidth(), n, this.getConfig());
    }

    public void setNinePatchChunk(byte[] byArray) {
        this.mNinePatchChunk = byArray;
    }

    public void setPixel(int n, int n2, int n3) {
        this.checkRecycled("Can't call setPixel() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        this.checkPixelAccess(n, n2);
        Bitmap.nativeSetPixel(this.mNativeBitmap, n, n2, n3);
    }

    public void setPixels(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.checkRecycled("Can't call setPixels() on a recycled bitmap");
        if (!this.isMutable()) {
            throw new IllegalStateException();
        }
        if (n5 == 0 || n6 == 0) {
            return;
        }
        this.checkPixelsAccess(n3, n4, n5, n6, n, n2, nArray);
        Bitmap.nativeSetPixels(this.mNativeBitmap, nArray, n, n2, n3, n4, n5, n6);
    }

    public final void setPremultiplied(boolean bl) {
        this.mRequestPremultiplied = bl;
        Bitmap.nativeSetPremultiplied(this.mNativeBitmap, bl);
    }

    public void setWidth(int n) {
        this.reconfigure(n, this.getHeight(), this.getConfig());
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        this.checkRecycled("Can't parcel a recycled bitmap");
        if (!Bitmap.nativeWriteToParcel(this.mNativeBitmap, this.mIsMutable, this.mDensity, parcel)) {
            throw new RuntimeException("native writeToParcel failed");
        }
    }

    private static class BitmapFinalizer {
        private final int mNativeAllocationByteCount;
        private final long mNativeBitmap;

        BitmapFinalizer(long l, int n) {
            this.mNativeBitmap = l;
            this.mNativeAllocationByteCount = n;
            if (this.mNativeAllocationByteCount != 0) {
                VMRuntime.getRuntime().registerNativeAllocation(this.mNativeAllocationByteCount);
            }
        }

        public void finalize() {
            try {
                super.finalize();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
            finally {
                if (this.mNativeAllocationByteCount != 0) {
                    VMRuntime.getRuntime().registerNativeFree(this.mNativeAllocationByteCount);
                }
                Bitmap.nativeDestructor(this.mNativeBitmap);
            }
        }
    }

    public static final class CompressFormat
    extends Enum<CompressFormat> {
        private static final /* synthetic */ CompressFormat[] $VALUES;
        public static final /* enum */ CompressFormat JPEG = new CompressFormat(0);
        public static final /* enum */ CompressFormat PNG = new CompressFormat(1);
        public static final /* enum */ CompressFormat WEBP = new CompressFormat(2);
        final int nativeInt;

        static {
            CompressFormat[] compressFormatArray = new CompressFormat[]{JPEG, PNG, WEBP};
            $VALUES = compressFormatArray;
        }

        private CompressFormat(int n2) {
            this.nativeInt = n2;
        }

        public static CompressFormat valueOf(String string2) {
            return Enum.valueOf(CompressFormat.class, string2);
        }

        public static CompressFormat[] values() {
            return (CompressFormat[])$VALUES.clone();
        }
    }

    public static final class Config
    extends Enum<Config> {
        private static final /* synthetic */ Config[] $VALUES;
        public static final /* enum */ Config ALPHA_8 = new Config(1);
        @Deprecated
        public static final /* enum */ Config ARGB_4444;
        public static final /* enum */ Config ARGB_8888;
        public static final /* enum */ Config RGB_565;
        private static Config[] sConfigs;
        final int nativeInt;

        static {
            RGB_565 = new Config(3);
            ARGB_4444 = new Config(4);
            ARGB_8888 = new Config(5);
            Config[] configArray = new Config[]{ALPHA_8, RGB_565, ARGB_4444, ARGB_8888};
            $VALUES = configArray;
            Config[] configArray2 = new Config[]{null, ALPHA_8, null, RGB_565, ARGB_4444, ARGB_8888};
            sConfigs = configArray2;
        }

        private Config(int n2) {
            this.nativeInt = n2;
        }

        static Config nativeToConfig(int n) {
            return sConfigs[n];
        }

        public static Config valueOf(String string2) {
            return Enum.valueOf(Config.class, string2);
        }

        public static Config[] values() {
            return (Config[])$VALUES.clone();
        }
    }
}

