/*
 * Decompiled with CFR 0.152.
 */
package android.gesture;

import android.content.Context;
import android.content.res.TypedArray;
import android.gesture.Gesture;
import android.gesture.GesturePoint;
import android.gesture.GestureStroke;
import android.gesture.GestureUtils;
import android.gesture.OrientedBoundingBox;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.util.ArrayList;

public class GestureOverlayView
extends FrameLayout {
    private static final boolean DITHER_FLAG = true;
    private static final int FADE_ANIMATION_RATE = 16;
    private static final boolean GESTURE_RENDERING_ANTIALIAS = true;
    public static final int GESTURE_STROKE_TYPE_MULTIPLE = 1;
    public static final int GESTURE_STROKE_TYPE_SINGLE = 0;
    public static final int ORIENTATION_HORIZONTAL = 0;
    public static final int ORIENTATION_VERTICAL = 1;
    private int mCertainGestureColor = -256;
    private int mCurrentColor;
    private Gesture mCurrentGesture;
    private float mCurveEndX;
    private float mCurveEndY;
    private long mFadeDuration = 150L;
    private boolean mFadeEnabled = true;
    private long mFadeOffset = 420L;
    private float mFadingAlpha = 1.0f;
    private boolean mFadingHasStarted;
    private final FadeOutRunnable mFadingOut;
    private long mFadingStart;
    private final Paint mGesturePaint = new Paint();
    private float mGestureStrokeAngleThreshold = 40.0f;
    private float mGestureStrokeLengthThreshold = 50.0f;
    private float mGestureStrokeSquarenessTreshold = 0.275f;
    private int mGestureStrokeType = 0;
    private float mGestureStrokeWidth = 12.0f;
    private boolean mGestureVisible = true;
    private boolean mHandleGestureActions;
    private boolean mInterceptEvents = true;
    private final AccelerateDecelerateInterpolator mInterpolator;
    private final Rect mInvalidRect = new Rect();
    private int mInvalidateExtraBorder = 10;
    private boolean mIsFadingOut = false;
    private boolean mIsGesturing = false;
    private boolean mIsListeningForGestures;
    private final ArrayList<OnGestureListener> mOnGestureListeners;
    private final ArrayList<OnGesturePerformedListener> mOnGesturePerformedListeners;
    private final ArrayList<OnGesturingListener> mOnGesturingListeners;
    private int mOrientation = 1;
    private final Path mPath = new Path();
    private boolean mPreviousWasGesturing = false;
    private boolean mResetGesture;
    private final ArrayList<GesturePoint> mStrokeBuffer = new ArrayList(100);
    private float mTotalLength;
    private int mUncertainGestureColor = 1224736512;
    private float mX;
    private float mY;

    public GestureOverlayView(Context context) {
        super(context);
        this.mOnGestureListeners = new ArrayList();
        this.mOnGesturePerformedListeners = new ArrayList();
        this.mOnGesturingListeners = new ArrayList();
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = new FadeOutRunnable();
        this.init();
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843807);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public GestureOverlayView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mOnGestureListeners = new ArrayList();
        this.mOnGesturePerformedListeners = new ArrayList();
        this.mOnGesturingListeners = new ArrayList();
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mFadingOut = new FadeOutRunnable();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GestureOverlayView, n, n2);
        this.mGestureStrokeWidth = typedArray.getFloat(1, this.mGestureStrokeWidth);
        this.mInvalidateExtraBorder = Math.max(1, -1 + (int)this.mGestureStrokeWidth);
        this.mCertainGestureColor = typedArray.getColor(2, this.mCertainGestureColor);
        this.mUncertainGestureColor = typedArray.getColor(3, this.mUncertainGestureColor);
        this.mFadeDuration = typedArray.getInt(5, (int)this.mFadeDuration);
        this.mFadeOffset = typedArray.getInt(4, (int)this.mFadeOffset);
        this.mGestureStrokeType = typedArray.getInt(6, this.mGestureStrokeType);
        this.mGestureStrokeLengthThreshold = typedArray.getFloat(7, this.mGestureStrokeLengthThreshold);
        this.mGestureStrokeAngleThreshold = typedArray.getFloat(9, this.mGestureStrokeAngleThreshold);
        this.mGestureStrokeSquarenessTreshold = typedArray.getFloat(8, this.mGestureStrokeSquarenessTreshold);
        this.mInterceptEvents = typedArray.getBoolean(10, this.mInterceptEvents);
        this.mFadeEnabled = typedArray.getBoolean(11, this.mFadeEnabled);
        this.mOrientation = typedArray.getInt(0, this.mOrientation);
        typedArray.recycle();
        this.init();
    }

    static /* synthetic */ float access$1002(GestureOverlayView gestureOverlayView, float f) {
        gestureOverlayView.mFadingAlpha = f;
        return f;
    }

    static /* synthetic */ boolean access$102(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mIsFadingOut = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1202(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mResetGesture = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mPreviousWasGesturing = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(GestureOverlayView gestureOverlayView, boolean bl) {
        gestureOverlayView.mFadingHasStarted = bl;
        return bl;
    }

    static /* synthetic */ Gesture access$802(GestureOverlayView gestureOverlayView, Gesture gesture) {
        gestureOverlayView.mCurrentGesture = gesture;
        return gesture;
    }

    private void cancelGesture(MotionEvent motionEvent) {
        ArrayList<OnGestureListener> arrayList = this.mOnGestureListeners;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).onGestureCancelled(this, motionEvent);
        }
        this.clear(false);
    }

    private void clear(boolean bl, boolean bl2, boolean bl3) {
        this.setPaintAlpha(255);
        this.removeCallbacks(this.mFadingOut);
        this.mResetGesture = false;
        this.mFadingOut.fireActionPerformed = bl2;
        this.mFadingOut.resetMultipleStrokes = false;
        if (bl && this.mCurrentGesture != null) {
            this.mFadingAlpha = 1.0f;
            this.mIsFadingOut = true;
            this.mFadingHasStarted = false;
            this.mFadingStart = AnimationUtils.currentAnimationTimeMillis() + this.mFadeOffset;
            this.postDelayed(this.mFadingOut, this.mFadeOffset);
            return;
        }
        this.mFadingAlpha = 1.0f;
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        if (bl3) {
            this.mCurrentGesture = null;
            this.mPath.rewind();
            this.invalidate();
            return;
        }
        if (bl2) {
            this.postDelayed(this.mFadingOut, this.mFadeOffset);
            return;
        }
        if (this.mGestureStrokeType == 1) {
            this.mFadingOut.resetMultipleStrokes = true;
            this.postDelayed(this.mFadingOut, this.mFadeOffset);
            return;
        }
        this.mCurrentGesture = null;
        this.mPath.rewind();
        this.invalidate();
    }

    private void fireOnGesturePerformed() {
        ArrayList<OnGesturePerformedListener> arrayList = this.mOnGesturePerformedListeners;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).onGesturePerformed(this, this.mCurrentGesture);
        }
    }

    private void init() {
        this.setWillNotDraw(false);
        Paint paint = this.mGesturePaint;
        paint.setAntiAlias(true);
        paint.setColor(this.mCertainGestureColor);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeJoin(Paint.Join.ROUND);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeWidth(this.mGestureStrokeWidth);
        paint.setDither(true);
        this.mCurrentColor = this.mCertainGestureColor;
        this.setPaintAlpha(255);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processEvent(MotionEvent motionEvent) {
        boolean bl = true;
        switch (motionEvent.getAction()) {
            default: {
                return false;
            }
            case 0: {
                this.touchDown(motionEvent);
                this.invalidate();
                return bl;
            }
            case 2: {
                if (!this.mIsListeningForGestures) return false;
                Rect rect = this.touchMove(motionEvent);
                if (rect == null) return bl;
                this.invalidate(rect);
                return bl;
            }
            case 1: {
                if (!this.mIsListeningForGestures) return false;
                this.touchUp(motionEvent, false);
                this.invalidate();
                return bl;
            }
            case 3: 
        }
        if (!this.mIsListeningForGestures) return false;
        this.touchUp(motionEvent, bl);
        this.invalidate();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setCurrentColor(int n) {
        this.mCurrentColor = n;
        if (this.mFadingHasStarted) {
            this.setPaintAlpha((int)(255.0f * this.mFadingAlpha));
        } else {
            this.setPaintAlpha(255);
        }
        this.invalidate();
    }

    private void setPaintAlpha(int n) {
        int n2 = (n + (n >> 7)) * (this.mCurrentColor >>> 24) >> 8;
        this.mGesturePaint.setColor(this.mCurrentColor << 8 >>> 8 | n2 << 24);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void touchDown(MotionEvent motionEvent) {
        this.mIsListeningForGestures = true;
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        this.mX = f;
        this.mY = f2;
        this.mTotalLength = 0.0f;
        this.mIsGesturing = false;
        if (this.mGestureStrokeType == 0 || this.mResetGesture) {
            if (this.mHandleGestureActions) {
                this.setCurrentColor(this.mUncertainGestureColor);
            }
            this.mResetGesture = false;
            this.mCurrentGesture = null;
            this.mPath.rewind();
        } else if ((this.mCurrentGesture == null || this.mCurrentGesture.getStrokesCount() == 0) && this.mHandleGestureActions) {
            this.setCurrentColor(this.mUncertainGestureColor);
        }
        if (this.mFadingHasStarted) {
            this.cancelClearAnimation();
        } else if (this.mIsFadingOut) {
            this.setPaintAlpha(255);
            this.mIsFadingOut = false;
            this.mFadingHasStarted = false;
            this.removeCallbacks(this.mFadingOut);
        }
        if (this.mCurrentGesture == null) {
            this.mCurrentGesture = new Gesture();
        }
        this.mStrokeBuffer.add(new GesturePoint(f, f2, motionEvent.getEventTime()));
        this.mPath.moveTo(f, f2);
        int n = this.mInvalidateExtraBorder;
        this.mInvalidRect.set((int)f - n, (int)f2 - n, n + (int)f, n + (int)f2);
        this.mCurveEndX = f;
        this.mCurveEndY = f2;
        ArrayList<OnGestureListener> arrayList = this.mOnGestureListeners;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            arrayList.get(n3).onGestureStarted(this, motionEvent);
            ++n3;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect touchMove(MotionEvent motionEvent) {
        Rect rect;
        block10: {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            block9: {
                f8 = motionEvent.getX();
                f7 = motionEvent.getY();
                f6 = this.mX;
                f5 = this.mY;
                f4 = Math.abs(f8 - f6);
                f3 = Math.abs(f7 - f5);
                if (f4 >= 3.0f) break block9;
                float f9 = f3 - 3.0f;
                float f10 = f9 == 0.0f ? 0 : (f9 > 0.0f ? 1 : -1);
                rect = null;
                if (f10 < 0) break block10;
            }
            rect = this.mInvalidRect;
            int n = this.mInvalidateExtraBorder;
            rect.set((int)this.mCurveEndX - n, (int)this.mCurveEndY - n, n + (int)this.mCurveEndX, n + (int)this.mCurveEndY);
            this.mCurveEndX = f2 = (f8 + f6) / 2.0f;
            this.mCurveEndY = f = (f7 + f5) / 2.0f;
            this.mPath.quadTo(f6, f5, f2, f);
            rect.union((int)f6 - n, (int)f5 - n, n + (int)f6, n + (int)f5);
            rect.union((int)f2 - n, (int)f - n, n + (int)f2, n + (int)f);
            this.mX = f8;
            this.mY = f7;
            ArrayList<GesturePoint> arrayList = this.mStrokeBuffer;
            GesturePoint gesturePoint = new GesturePoint(f8, f7, motionEvent.getEventTime());
            arrayList.add(gesturePoint);
            if (this.mHandleGestureActions && !this.mIsGesturing) {
                this.mTotalLength += (float)Math.sqrt(f4 * f4 + f3 * f3);
                if (this.mTotalLength > this.mGestureStrokeLengthThreshold) {
                    OrientedBoundingBox orientedBoundingBox = GestureUtils.computeOrientedBoundingBox(this.mStrokeBuffer);
                    float f11 = Math.abs(orientedBoundingBox.orientation);
                    if (f11 > 90.0f) {
                        f11 = 180.0f - f11;
                    }
                    if (orientedBoundingBox.squareness > this.mGestureStrokeSquarenessTreshold || (this.mOrientation == 1 ? f11 < this.mGestureStrokeAngleThreshold : f11 > this.mGestureStrokeAngleThreshold)) {
                        this.mIsGesturing = true;
                        this.setCurrentColor(this.mCertainGestureColor);
                        ArrayList<OnGesturingListener> arrayList2 = this.mOnGesturingListeners;
                        int n2 = arrayList2.size();
                        for (int i = 0; i < n2; ++i) {
                            arrayList2.get(i).onGesturingStarted(this);
                        }
                    }
                }
            }
            ArrayList<OnGestureListener> arrayList3 = this.mOnGestureListeners;
            int n3 = arrayList3.size();
            for (int i = 0; i < n3; ++i) {
                arrayList3.get(i).onGesture(this, motionEvent);
            }
        }
        return rect;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void touchUp(MotionEvent motionEvent, boolean bl) {
        boolean bl2 = true;
        this.mIsListeningForGestures = false;
        if (this.mCurrentGesture != null) {
            this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
            if (!bl) {
                ArrayList<OnGestureListener> arrayList = this.mOnGestureListeners;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.get(i).onGestureEnded(this, motionEvent);
                }
                boolean bl3 = this.mHandleGestureActions && this.mFadeEnabled ? bl2 : false;
                if (!this.mHandleGestureActions || !this.mIsGesturing) {
                    bl2 = false;
                }
                this.clear(bl3, bl2, false);
            } else {
                this.cancelGesture(motionEvent);
            }
        } else {
            this.cancelGesture(motionEvent);
        }
        this.mStrokeBuffer.clear();
        this.mPreviousWasGesturing = this.mIsGesturing;
        this.mIsGesturing = false;
        ArrayList<OnGesturingListener> arrayList = this.mOnGesturingListeners;
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            arrayList.get(n2).onGesturingEnded(this);
            ++n2;
        }
        return;
    }

    public void addOnGestureListener(OnGestureListener onGestureListener) {
        this.mOnGestureListeners.add(onGestureListener);
    }

    public void addOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        this.mOnGesturePerformedListeners.add(onGesturePerformedListener);
        if (this.mOnGesturePerformedListeners.size() > 0) {
            this.mHandleGestureActions = true;
        }
    }

    public void addOnGesturingListener(OnGesturingListener onGesturingListener) {
        this.mOnGesturingListeners.add(onGesturingListener);
    }

    public void cancelClearAnimation() {
        this.setPaintAlpha(255);
        this.mIsFadingOut = false;
        this.mFadingHasStarted = false;
        this.removeCallbacks(this.mFadingOut);
        this.mPath.rewind();
        this.mCurrentGesture = null;
    }

    public void cancelGesture() {
        this.mIsListeningForGestures = false;
        this.mCurrentGesture.addStroke(new GestureStroke(this.mStrokeBuffer));
        long l = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain(l, l, 3, 0.0f, 0.0f, 0);
        ArrayList<OnGestureListener> arrayList = this.mOnGestureListeners;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            arrayList.get(i).onGestureCancelled(this, motionEvent);
        }
        motionEvent.recycle();
        this.clear(false);
        this.mIsGesturing = false;
        this.mPreviousWasGesturing = false;
        this.mStrokeBuffer.clear();
        ArrayList<OnGesturingListener> arrayList2 = this.mOnGesturingListeners;
        int n2 = arrayList2.size();
        for (int i = 0; i < n2; ++i) {
            arrayList2.get(i).onGesturingEnded(this);
        }
    }

    public void clear(boolean bl) {
        this.clear(bl, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) {
            return super.dispatchTouchEvent(motionEvent);
        }
        boolean bl = (this.mIsGesturing || this.mCurrentGesture != null && this.mCurrentGesture.getStrokesCount() > 0 && this.mPreviousWasGesturing) && this.mInterceptEvents;
        this.processEvent(motionEvent);
        if (bl) {
            motionEvent.setAction(3);
        }
        super.dispatchTouchEvent(motionEvent);
        return true;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mCurrentGesture != null && this.mGestureVisible) {
            canvas.drawPath(this.mPath, this.mGesturePaint);
        }
    }

    public ArrayList<GesturePoint> getCurrentStroke() {
        return this.mStrokeBuffer;
    }

    public long getFadeOffset() {
        return this.mFadeOffset;
    }

    public Gesture getGesture() {
        return this.mCurrentGesture;
    }

    public int getGestureColor() {
        return this.mCertainGestureColor;
    }

    public Paint getGesturePaint() {
        return this.mGesturePaint;
    }

    public Path getGesturePath() {
        return this.mPath;
    }

    public Path getGesturePath(Path path) {
        path.set(this.mPath);
        return path;
    }

    public float getGestureStrokeAngleThreshold() {
        return this.mGestureStrokeAngleThreshold;
    }

    public float getGestureStrokeLengthThreshold() {
        return this.mGestureStrokeLengthThreshold;
    }

    public float getGestureStrokeSquarenessTreshold() {
        return this.mGestureStrokeSquarenessTreshold;
    }

    public int getGestureStrokeType() {
        return this.mGestureStrokeType;
    }

    public float getGestureStrokeWidth() {
        return this.mGestureStrokeWidth;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public int getUncertainGestureColor() {
        return this.mUncertainGestureColor;
    }

    public boolean isEventsInterceptionEnabled() {
        return this.mInterceptEvents;
    }

    public boolean isFadeEnabled() {
        return this.mFadeEnabled;
    }

    public boolean isGestureVisible() {
        return this.mGestureVisible;
    }

    public boolean isGesturing() {
        return this.mIsGesturing;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelClearAnimation();
    }

    public void removeAllOnGestureListeners() {
        this.mOnGestureListeners.clear();
    }

    public void removeAllOnGesturePerformedListeners() {
        this.mOnGesturePerformedListeners.clear();
        this.mHandleGestureActions = false;
    }

    public void removeAllOnGesturingListeners() {
        this.mOnGesturingListeners.clear();
    }

    public void removeOnGestureListener(OnGestureListener onGestureListener) {
        this.mOnGestureListeners.remove(onGestureListener);
    }

    public void removeOnGesturePerformedListener(OnGesturePerformedListener onGesturePerformedListener) {
        this.mOnGesturePerformedListeners.remove(onGesturePerformedListener);
        if (this.mOnGesturePerformedListeners.size() <= 0) {
            this.mHandleGestureActions = false;
        }
    }

    public void removeOnGesturingListener(OnGesturingListener onGesturingListener) {
        this.mOnGesturingListeners.remove(onGesturingListener);
    }

    public void setEventsInterceptionEnabled(boolean bl) {
        this.mInterceptEvents = bl;
    }

    public void setFadeEnabled(boolean bl) {
        this.mFadeEnabled = bl;
    }

    public void setFadeOffset(long l) {
        this.mFadeOffset = l;
    }

    public void setGesture(Gesture gesture) {
        if (this.mCurrentGesture != null) {
            this.clear(false);
        }
        this.setCurrentColor(this.mCertainGestureColor);
        this.mCurrentGesture = gesture;
        Path path = this.mCurrentGesture.toPath();
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        this.mPath.rewind();
        this.mPath.addPath(path, -rectF.left + ((float)this.getWidth() - rectF.width()) / 2.0f, -rectF.top + ((float)this.getHeight() - rectF.height()) / 2.0f);
        this.mResetGesture = true;
        this.invalidate();
    }

    public void setGestureColor(int n) {
        this.mCertainGestureColor = n;
    }

    public void setGestureStrokeAngleThreshold(float f) {
        this.mGestureStrokeAngleThreshold = f;
    }

    public void setGestureStrokeLengthThreshold(float f) {
        this.mGestureStrokeLengthThreshold = f;
    }

    public void setGestureStrokeSquarenessTreshold(float f) {
        this.mGestureStrokeSquarenessTreshold = f;
    }

    public void setGestureStrokeType(int n) {
        this.mGestureStrokeType = n;
    }

    public void setGestureStrokeWidth(float f) {
        this.mGestureStrokeWidth = f;
        this.mInvalidateExtraBorder = Math.max(1, -1 + (int)f);
        this.mGesturePaint.setStrokeWidth(f);
    }

    public void setGestureVisible(boolean bl) {
        this.mGestureVisible = bl;
    }

    public void setOrientation(int n) {
        this.mOrientation = n;
    }

    public void setUncertainGestureColor(int n) {
        this.mUncertainGestureColor = n;
    }

    private class FadeOutRunnable
    implements Runnable {
        boolean fireActionPerformed;
        boolean resetMultipleStrokes;

        private FadeOutRunnable() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (GestureOverlayView.this.mIsFadingOut) {
                long l = AnimationUtils.currentAnimationTimeMillis() - GestureOverlayView.this.mFadingStart;
                if (l > GestureOverlayView.this.mFadeDuration) {
                    if (this.fireActionPerformed) {
                        GestureOverlayView.this.fireOnGesturePerformed();
                    }
                    GestureOverlayView.access$502(GestureOverlayView.this, false);
                    GestureOverlayView.access$102(GestureOverlayView.this, false);
                    GestureOverlayView.access$602(GestureOverlayView.this, false);
                    GestureOverlayView.this.mPath.rewind();
                    GestureOverlayView.access$802(GestureOverlayView.this, null);
                    GestureOverlayView.this.setPaintAlpha(255);
                } else {
                    GestureOverlayView.access$602(GestureOverlayView.this, true);
                    float f = Math.max(0.0f, Math.min(1.0f, (float)l / (float)GestureOverlayView.this.mFadeDuration));
                    GestureOverlayView.access$1002(GestureOverlayView.this, 1.0f - GestureOverlayView.this.mInterpolator.getInterpolation(f));
                    GestureOverlayView.this.setPaintAlpha((int)(255.0f * GestureOverlayView.this.mFadingAlpha));
                    GestureOverlayView.this.postDelayed(this, 16L);
                }
            } else if (this.resetMultipleStrokes) {
                GestureOverlayView.access$1202(GestureOverlayView.this, true);
            } else {
                GestureOverlayView.this.fireOnGesturePerformed();
                GestureOverlayView.access$602(GestureOverlayView.this, false);
                GestureOverlayView.this.mPath.rewind();
                GestureOverlayView.access$802(GestureOverlayView.this, null);
                GestureOverlayView.access$502(GestureOverlayView.this, false);
                GestureOverlayView.this.setPaintAlpha(255);
            }
            GestureOverlayView.this.invalidate();
        }
    }

    public static interface OnGestureListener {
        public void onGesture(GestureOverlayView var1, MotionEvent var2);

        public void onGestureCancelled(GestureOverlayView var1, MotionEvent var2);

        public void onGestureEnded(GestureOverlayView var1, MotionEvent var2);

        public void onGestureStarted(GestureOverlayView var1, MotionEvent var2);
    }

    public static interface OnGesturePerformedListener {
        public void onGesturePerformed(GestureOverlayView var1, Gesture var2);
    }

    public static interface OnGesturingListener {
        public void onGesturingEnded(GestureOverlayView var1);

        public void onGesturingStarted(GestureOverlayView var1);
    }
}

