/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.videosrc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.GLFrame;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.GenerateFinalPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.Matrix;
import android.util.Log;
import java.io.IOException;
import java.util.List;

public class CameraSource
extends Filter {
    private static final int NEWFRAME_TIMEOUT = 100;
    private static final int NEWFRAME_TIMEOUT_REPEAT = 10;
    private static final String TAG = "CameraSource";
    private static final String mFrameShader = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nuniform samplerExternalOES tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n}\n";
    private static final float[] mSourceCoords = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private Camera mCamera;
    private GLFrame mCameraFrame;
    @GenerateFieldPort(hasDefault=true, name="id")
    private int mCameraId = 0;
    private Camera.Parameters mCameraParameters;
    private float[] mCameraTransform;
    @GenerateFieldPort(hasDefault=true, name="framerate")
    private int mFps = 30;
    private ShaderProgram mFrameExtractor;
    @GenerateFieldPort(hasDefault=true, name="height")
    private int mHeight = 240;
    private final boolean mLogVerbose;
    private float[] mMappedCoords;
    private boolean mNewFrameAvailable;
    private MutableFrameFormat mOutputFormat;
    private SurfaceTexture mSurfaceTexture;
    @GenerateFinalPort(hasDefault=true, name="waitForNewFrame")
    private boolean mWaitForNewFrame = true;
    @GenerateFieldPort(hasDefault=true, name="width")
    private int mWidth = 320;
    private SurfaceTexture.OnFrameAvailableListener onCameraFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrameAvailable(SurfaceTexture surfaceTexture) {
            if (CameraSource.this.mLogVerbose) {
                Log.v(CameraSource.TAG, "New frame from camera");
            }
            CameraSource cameraSource = CameraSource.this;
            synchronized (cameraSource) {
                CameraSource.access$102(CameraSource.this, true);
                CameraSource.this.notify();
                return;
            }
        }
    };

    public CameraSource(String string2) {
        super(string2);
        this.mCameraTransform = new float[16];
        this.mMappedCoords = new float[16];
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    static /* synthetic */ boolean access$102(CameraSource cameraSource, boolean bl) {
        cameraSource.mNewFrameAvailable = bl;
        return bl;
    }

    private void createFormats() {
        this.mOutputFormat = ImageFormat.create(this.mWidth, this.mHeight, 3, 3);
    }

    private int[] findClosestFpsRange(int n, Camera.Parameters parameters) {
        List<int[]> list = parameters.getSupportedPreviewFpsRange();
        int[] nArray = list.get(0);
        for (int[] nArray2 : list) {
            if (nArray2[0] >= n * 1000 || nArray2[1] <= n * 1000 || nArray2[0] <= nArray[0] || nArray2[1] >= nArray[1]) continue;
            nArray = nArray2;
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Requested fps: " + n + ".Closest frame rate range: [" + (double)nArray[0] / 1000.0 + "," + (double)nArray[1] / 1000.0 + "]");
        }
        return nArray;
    }

    private int[] findClosestSize(int n, int n2, Camera.Parameters parameters) {
        List<Camera.Size> list = parameters.getSupportedPreviewSizes();
        int n3 = -1;
        int n4 = -1;
        int n5 = list.get((int)0).width;
        int n6 = list.get((int)0).height;
        for (Camera.Size size : list) {
            if (size.width <= n && size.height <= n2 && size.width >= n3 && size.height >= n4) {
                n3 = size.width;
                n4 = size.height;
            }
            if (size.width >= n5 || size.height >= n6) continue;
            n5 = size.width;
            n6 = size.height;
        }
        if (n3 == -1) {
            n3 = n5;
            n4 = n6;
        }
        if (this.mLogVerbose) {
            Log.v(TAG, "Requested resolution: (" + n + ", " + n2 + "). Closest match: (" + n3 + ", " + n4 + ").");
        }
        return new int[]{n3, n4};
    }

    @Override
    public void close(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Closing");
        }
        this.mCamera.release();
        this.mCamera = null;
        this.mSurfaceTexture.release();
        this.mSurfaceTexture = null;
    }

    @Override
    public void fieldPortValueUpdated(String string2, FilterContext filterContext) {
        if (string2.equals("framerate")) {
            this.getCameraParameters();
            int[] nArray = this.findClosestFpsRange(this.mFps, this.mCameraParameters);
            this.mCameraParameters.setPreviewFpsRange(nArray[0], nArray[1]);
            this.mCamera.setParameters(this.mCameraParameters);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Camera.Parameters getCameraParameters() {
        synchronized (this) {
            if (this.mCameraParameters == null) {
                Camera camera = this.mCamera;
                boolean bl = false;
                if (camera == null) {
                    this.mCamera = Camera.open(this.mCameraId);
                    bl = true;
                }
                this.mCameraParameters = this.mCamera.getParameters();
                if (bl) {
                    this.mCamera.release();
                    this.mCamera = null;
                }
            }
            int[] nArray = this.findClosestSize(this.mWidth, this.mHeight, this.mCameraParameters);
            this.mWidth = nArray[0];
            this.mHeight = nArray[1];
            this.mCameraParameters.setPreviewSize(this.mWidth, this.mHeight);
            int[] nArray2 = this.findClosestFpsRange(this.mFps, this.mCameraParameters);
            this.mCameraParameters.setPreviewFpsRange(nArray2[0], nArray2[1]);
            return this.mCameraParameters;
        }
    }

    @Override
    public void open(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Opening");
        }
        this.mCamera = Camera.open(this.mCameraId);
        this.getCameraParameters();
        this.mCamera.setParameters(this.mCameraParameters);
        this.createFormats();
        this.mCameraFrame = (GLFrame)filterContext.getFrameManager().newBoundFrame(this.mOutputFormat, 104, 0L);
        this.mSurfaceTexture = new SurfaceTexture(this.mCameraFrame.getTextureId());
        try {
            this.mCamera.setPreviewTexture(this.mSurfaceTexture);
            this.mSurfaceTexture.setOnFrameAvailableListener(this.onCameraFrameAvailableListener);
            this.mNewFrameAvailable = false;
            this.mCamera.startPreview();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not bind camera surface texture: " + iOException.getMessage() + "!");
        }
    }

    @Override
    public void prepare(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Preparing");
        }
        this.mFrameExtractor = new ShaderProgram(filterContext, mFrameShader);
    }

    @Override
    public void process(FilterContext filterContext) {
        if (this.mLogVerbose) {
            Log.v(TAG, "Processing new frame");
        }
        if (this.mWaitForNewFrame) {
            while (!this.mNewFrameAvailable) {
                if (10 == 0) {
                    throw new RuntimeException("Timeout waiting for new frame");
                }
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    if (!this.mLogVerbose) continue;
                    Log.v(TAG, "Interrupted while waiting for new frame");
                }
            }
            this.mNewFrameAvailable = false;
            if (this.mLogVerbose) {
                Log.v(TAG, "Got new frame");
            }
        }
        this.mSurfaceTexture.updateTexImage();
        if (this.mLogVerbose) {
            Log.v(TAG, "Using frame extractor in thread: " + Thread.currentThread());
        }
        this.mSurfaceTexture.getTransformMatrix(this.mCameraTransform);
        Matrix.multiplyMM(this.mMappedCoords, 0, this.mCameraTransform, 0, mSourceCoords, 0);
        this.mFrameExtractor.setSourceRegion(this.mMappedCoords[0], this.mMappedCoords[1], this.mMappedCoords[4], this.mMappedCoords[5], this.mMappedCoords[8], this.mMappedCoords[9], this.mMappedCoords[12], this.mMappedCoords[13]);
        Frame frame = filterContext.getFrameManager().newFrame(this.mOutputFormat);
        this.mFrameExtractor.process(this.mCameraFrame, frame);
        long l = this.mSurfaceTexture.getTimestamp();
        if (this.mLogVerbose) {
            Log.v(TAG, "Timestamp: " + (double)l / 1.0E9 + " s");
        }
        frame.setTimestamp(l);
        this.pushOutput("video", frame);
        frame.release();
        if (this.mLogVerbose) {
            Log.v(TAG, "Done processing new frame");
        }
    }

    public void setCameraParameters(Camera.Parameters parameters) {
        synchronized (this) {
            parameters.setPreviewSize(this.mWidth, this.mHeight);
            this.mCameraParameters = parameters;
            if (this.isOpen()) {
                this.mCamera.setParameters(this.mCameraParameters);
            }
            return;
        }
    }

    @Override
    public void setupPorts() {
        this.addOutputPort("video", ImageFormat.create(3, 3));
    }

    @Override
    public void tearDown(FilterContext filterContext) {
        if (this.mCameraFrame != null) {
            this.mCameraFrame.release();
        }
    }
}

