/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.NativeProgram;
import android.filterfw.core.Program;

public class ToRGBAFilter
extends Filter {
    private int mInputBPP;
    private FrameFormat mLastFormat = null;
    private Program mProgram;

    public ToRGBAFilter(String string2) {
        super(string2);
    }

    public void createProgram(FilterContext filterContext, FrameFormat frameFormat) {
        this.mInputBPP = frameFormat.getBytesPerSample();
        if (this.mLastFormat != null && this.mLastFormat.getBytesPerSample() == this.mInputBPP) {
            return;
        }
        this.mLastFormat = frameFormat;
        switch (this.mInputBPP) {
            default: {
                throw new RuntimeException("Unsupported BytesPerPixel: " + this.mInputBPP + "!");
            }
            case 1: {
                this.mProgram = new NativeProgram("filterpack_imageproc", "gray_to_rgba");
                return;
            }
            case 3: 
        }
        this.mProgram = new NativeProgram("filterpack_imageproc", "rgb_to_rgba");
    }

    public FrameFormat getConvertedFormat(FrameFormat frameFormat) {
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        mutableFrameFormat.setMetaValue("colorspace", 3);
        mutableFrameFormat.setBytesPerSample(4);
        return mutableFrameFormat;
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return this.getConvertedFormat(frameFormat);
    }

    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        this.createProgram(filterContext, frame.getFormat());
        Frame frame2 = filterContext.getFrameManager().newFrame(this.getConvertedFormat(frame.getFormat()));
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat(2, 2);
        mutableFrameFormat.setDimensionCount(2);
        this.addMaskedInputPort("image", mutableFrameFormat);
        this.addOutputBasedOnInput("image", "image");
    }
}

