/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.geometry.Point;
import android.filterfw.geometry.Quad;

public class FixedRotationFilter
extends Filter {
    private ShaderProgram mProgram = null;
    @GenerateFieldPort(hasDefault=true, name="rotation")
    private int mRotation = 0;

    public FixedRotationFilter(String string2) {
        super(string2);
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        return frameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        Quad quad;
        Frame frame = this.pullInput("image");
        if (this.mRotation == 0) {
            this.pushOutput("image", frame);
            return;
        }
        FrameFormat frameFormat = frame.getFormat();
        if (this.mProgram == null) {
            this.mProgram = ShaderProgram.createIdentity(filterContext);
        }
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        int n = frameFormat.getWidth();
        int n2 = frameFormat.getHeight();
        Point point = new Point(0.0f, 0.0f);
        Point point2 = new Point(1.0f, 0.0f);
        Point point3 = new Point(0.0f, 1.0f);
        Point point4 = new Point(1.0f, 1.0f);
        switch (Math.round((float)this.mRotation / 90.0f) % 4) {
            default: {
                quad = new Quad(point, point2, point3, point4);
                break;
            }
            case 1: {
                quad = new Quad(point3, point, point4, point2);
                mutableFrameFormat.setDimensions(n2, n);
                break;
            }
            case 2: {
                quad = new Quad(point4, point3, point2, point);
                break;
            }
            case 3: {
                quad = new Quad(point2, point4, point, point3);
                mutableFrameFormat.setDimensions(n2, n);
            }
        }
        Frame frame2 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        this.mProgram.setSourceRegion(quad);
        this.mProgram.process(frame, frame2);
        this.pushOutput("image", frame2);
        frame2.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3, 3));
        this.addOutputBasedOnInput("image", "image");
    }
}

