/*
 * Decompiled with CFR 0.152.
 */
package android.filterpacks.imageproc;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.GenerateFieldPort;
import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.Program;
import android.filterfw.core.ShaderProgram;
import android.filterfw.format.ImageFormat;
import android.filterfw.format.ObjectFormat;
import android.filterfw.geometry.Quad;

public class CropFilter
extends Filter {
    @GenerateFieldPort(name="fillblack")
    private boolean mFillBlack = false;
    private final String mFragShader;
    private FrameFormat mLastFormat = null;
    @GenerateFieldPort(name="oheight")
    private int mOutputHeight = -1;
    @GenerateFieldPort(name="owidth")
    private int mOutputWidth = -1;
    private Program mProgram;

    public CropFilter(String string2) {
        super(string2);
        this.mFragShader = "precision mediump float;\nuniform sampler2D tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  const vec2 lo = vec2(0.0, 0.0);\n  const vec2 hi = vec2(1.0, 1.0);\n  const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);\n  bool out_of_bounds =\n    any(lessThan(v_texcoord, lo)) ||\n    any(greaterThan(v_texcoord, hi));\n  if (out_of_bounds) {\n    gl_FragColor = black;\n  } else {\n    gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n  }\n}\n";
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void createProgram(FilterContext filterContext, FrameFormat frameFormat) {
        block6: {
            block5: {
                if (this.mLastFormat != null && this.mLastFormat.getTarget() == frameFormat.getTarget()) break block5;
                this.mLastFormat = frameFormat;
                this.mProgram = null;
                switch (frameFormat.getTarget()) {
                    default: {
                        break;
                    }
                    case 3: {
                        this.mProgram = this.mFillBlack ? new ShaderProgram(filterContext, "precision mediump float;\nuniform sampler2D tex_sampler_0;\nvarying vec2 v_texcoord;\nvoid main() {\n  const vec2 lo = vec2(0.0, 0.0);\n  const vec2 hi = vec2(1.0, 1.0);\n  const vec4 black = vec4(0.0, 0.0, 0.0, 1.0);\n  bool out_of_bounds =\n    any(lessThan(v_texcoord, lo)) ||\n    any(greaterThan(v_texcoord, hi));\n  if (out_of_bounds) {\n    gl_FragColor = black;\n  } else {\n    gl_FragColor = texture2D(tex_sampler_0, v_texcoord);\n  }\n}\n") : ShaderProgram.createIdentity(filterContext);
                    }
                }
                if (this.mProgram == null) break block6;
            }
            return;
        }
        throw new RuntimeException("Could not create a program for crop filter " + this + "!");
    }

    @Override
    public FrameFormat getOutputFormat(String string2, FrameFormat frameFormat) {
        MutableFrameFormat mutableFrameFormat = frameFormat.mutableCopy();
        mutableFrameFormat.setDimensions(0, 0);
        return mutableFrameFormat;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void process(FilterContext filterContext) {
        Frame frame = this.pullInput("image");
        Frame frame2 = this.pullInput("box");
        this.createProgram(filterContext, frame.getFormat());
        Quad quad = (Quad)frame2.getObjectValue();
        MutableFrameFormat mutableFrameFormat = frame.getFormat().mutableCopy();
        int n = this.mOutputWidth == -1 ? mutableFrameFormat.getWidth() : this.mOutputWidth;
        int n2 = this.mOutputHeight == -1 ? mutableFrameFormat.getHeight() : this.mOutputHeight;
        mutableFrameFormat.setDimensions(n, n2);
        Frame frame3 = filterContext.getFrameManager().newFrame(mutableFrameFormat);
        if (this.mProgram instanceof ShaderProgram) {
            ((ShaderProgram)this.mProgram).setSourceRegion(quad);
        }
        this.mProgram.process(frame, frame3);
        this.pushOutput("image", frame3);
        frame3.release();
    }

    @Override
    public void setupPorts() {
        this.addMaskedInputPort("image", ImageFormat.create(3));
        this.addMaskedInputPort("box", ObjectFormat.fromClass(Quad.class, 1));
        this.addOutputBasedOnInput("image", "image");
    }
}

