/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.geometry;

import android.filterfw.geometry.Point;
import android.filterfw.geometry.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Quad {
    public Point p0;
    public Point p1;
    public Point p2;
    public Point p3;

    public Quad() {
    }

    public Quad(Point point, Point point2, Point point3, Point point4) {
        this.p0 = point;
        this.p1 = point2;
        this.p2 = point3;
        this.p3 = point4;
    }

    public boolean IsInUnitRange() {
        return this.p0.IsInUnitRange() && this.p1.IsInUnitRange() && this.p2.IsInUnitRange() && this.p3.IsInUnitRange();
    }

    public Rectangle boundingBox() {
        Float[] floatArray = new Float[]{Float.valueOf(this.p0.x), Float.valueOf(this.p1.x), Float.valueOf(this.p2.x), Float.valueOf(this.p3.x)};
        List<Float> list = Arrays.asList(floatArray);
        Float[] floatArray2 = new Float[]{Float.valueOf(this.p0.y), Float.valueOf(this.p1.y), Float.valueOf(this.p2.y), Float.valueOf(this.p3.y)};
        List<Float> list2 = Arrays.asList(floatArray2);
        float f = Collections.min(list).floatValue();
        float f2 = Collections.min(list2).floatValue();
        float f3 = Collections.max(list).floatValue();
        float f4 = Collections.max(list2).floatValue();
        return new Rectangle(f, f2, f3 - f, f4 - f2);
    }

    public float getBoundingHeight() {
        Float[] floatArray = new Float[]{Float.valueOf(this.p0.y), Float.valueOf(this.p1.y), Float.valueOf(this.p2.y), Float.valueOf(this.p3.y)};
        List<Float> list = Arrays.asList(floatArray);
        return Collections.max(list).floatValue() - Collections.min(list).floatValue();
    }

    public float getBoundingWidth() {
        Float[] floatArray = new Float[]{Float.valueOf(this.p0.x), Float.valueOf(this.p1.x), Float.valueOf(this.p2.x), Float.valueOf(this.p3.x)};
        List<Float> list = Arrays.asList(floatArray);
        return Collections.max(list).floatValue() - Collections.min(list).floatValue();
    }

    public Quad scaled(float f) {
        return new Quad(this.p0.times(f), this.p1.times(f), this.p2.times(f), this.p3.times(f));
    }

    public Quad scaled(float f, float f2) {
        return new Quad(this.p0.mult(f, f2), this.p1.mult(f, f2), this.p2.mult(f, f2), this.p3.mult(f, f2));
    }

    public String toString() {
        return "{" + this.p0 + ", " + this.p1 + ", " + this.p2 + ", " + this.p3 + "}";
    }

    public Quad translated(float f, float f2) {
        return new Quad(this.p0.plus(f, f2), this.p1.plus(f, f2), this.p2.plus(f, f2), this.p3.plus(f, f2));
    }

    public Quad translated(Point point) {
        return new Quad(this.p0.plus(point), this.p1.plus(point), this.p2.plus(point), this.p3.plus(point));
    }
}

