/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.format;

import android.filterfw.core.MutableFrameFormat;
import android.filterfw.core.NativeBuffer;

public class ObjectFormat {
    private static int bytesPerSampleForClass(Class clazz, int n) {
        if (n == 2) {
            if (!NativeBuffer.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Native object-based formats must be of a NativeBuffer subclass! (Received class: " + clazz + ").");
            }
            try {
                int n2 = ((NativeBuffer)clazz.newInstance()).getElementSize();
                return n2;
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not determine the size of an element in a native object-based frame of type " + clazz + "! Perhaps it is missing a " + "default constructor?");
            }
        }
        return 1;
    }

    public static MutableFrameFormat fromClass(Class clazz, int n) {
        return ObjectFormat.fromClass(clazz, 0, n);
    }

    public static MutableFrameFormat fromClass(Class clazz, int n, int n2) {
        MutableFrameFormat mutableFrameFormat = new MutableFrameFormat(8, n2);
        mutableFrameFormat.setObjectClass(ObjectFormat.getBoxedClass(clazz));
        if (n != 0) {
            mutableFrameFormat.setDimensions(n);
        }
        mutableFrameFormat.setBytesPerSample(ObjectFormat.bytesPerSampleForClass(clazz, n2));
        return mutableFrameFormat;
    }

    public static MutableFrameFormat fromObject(Object object, int n) {
        if (object == null) {
            return new MutableFrameFormat(8, n);
        }
        return ObjectFormat.fromClass(object.getClass(), 0, n);
    }

    public static MutableFrameFormat fromObject(Object object, int n, int n2) {
        if (object == null) {
            return new MutableFrameFormat(8, n2);
        }
        return ObjectFormat.fromClass(object.getClass(), n, n2);
    }

    private static Class getBoxedClass(Class clazz) {
        block11: {
            block10: {
                if (!clazz.isPrimitive()) break block10;
                if (clazz != Boolean.TYPE) break block11;
                clazz = Boolean.class;
            }
            return clazz;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        throw new IllegalArgumentException("Unknown primitive type: " + clazz.getSimpleName() + "!");
    }
}

