/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class VertexFrame
extends Frame {
    private int vertexFrameId = -1;

    static {
        System.loadLibrary("filterfw");
    }

    VertexFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        if (this.getFormat().getSize() <= 0) {
            throw new IllegalArgumentException("Initializing vertex frame with zero size!");
        }
        if (!this.nativeAllocate(this.getFormat().getSize())) {
            throw new RuntimeException("Could not allocate vertex frame!");
        }
    }

    private native int getNativeVboId();

    private native boolean nativeAllocate(int var1);

    private native boolean nativeDeallocate();

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native boolean setNativeFloats(float[] var1);

    private native boolean setNativeInts(int[] var1);

    @Override
    public Bitmap getBitmap() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public ByteBuffer getData() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public float[] getFloats() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public int[] getInts() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    @Override
    public Object getObjectValue() {
        throw new RuntimeException("Vertex frames do not support reading data!");
    }

    public int getVboId() {
        return this.getNativeVboId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasNativeAllocation() {
        synchronized (this) {
            int n = this.vertexFrameId;
            if (n == -1) return false;
            return true;
        }
    }

    @Override
    protected void releaseNativeAllocation() {
        synchronized (this) {
            this.nativeDeallocate();
            this.vertexFrameId = -1;
            return;
        }
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        throw new RuntimeException("Unsupported: Cannot set vertex frame bitmap value!");
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        this.assertFrameMutable();
        byte[] byArray = byteBuffer.array();
        if (this.getFormat().getSize() != byArray.length) {
            throw new RuntimeException("Data size in setData does not match vertex frame size!");
        }
        if (!this.setNativeData(byArray, n, n2)) {
            throw new RuntimeException("Could not set vertex frame data!");
        }
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        super.setDataFromFrame(frame);
    }

    @Override
    public void setFloats(float[] fArray) {
        this.assertFrameMutable();
        if (!this.setNativeFloats(fArray)) {
            throw new RuntimeException("Could not set int values for vertex frame!");
        }
    }

    @Override
    public void setInts(int[] nArray) {
        this.assertFrameMutable();
        if (!this.setNativeInts(nArray)) {
            throw new RuntimeException("Could not set int values for vertex frame!");
        }
    }

    public String toString() {
        return "VertexFrame (" + this.getFormat() + ") with VBO ID " + this.getVboId();
    }
}

