/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.format.ObjectFormat;
import android.graphics.Bitmap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class SerializedFrame
extends Frame {
    private static final int INITIAL_CAPACITY = 64;
    private DirectByteOutputStream mByteOutputStream;
    private ObjectOutputStream mObjectOut;

    SerializedFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        this.setReusable(false);
        try {
            this.mByteOutputStream = new DirectByteOutputStream(64);
            this.mObjectOut = new ObjectOutputStream(this.mByteOutputStream);
            this.mByteOutputStream.markHeaderEnd();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not create serialization streams for SerializedFrame!", iOException);
        }
    }

    private final Object deserializeObjectValue() {
        try {
            Object object = new ObjectInputStream(this.mByteOutputStream.getInputStream()).readObject();
            return object;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not deserialize object in " + this + "!", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unable to deserialize object of unknown class in " + this + "!", classNotFoundException);
        }
    }

    private final void serializeObjectValue(Object object) {
        try {
            this.mByteOutputStream.reset();
            this.mObjectOut.writeObject(object);
            this.mObjectOut.flush();
            this.mObjectOut.close();
            return;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not serialize object " + object + " in " + this + "!", iOException);
        }
    }

    static SerializedFrame wrapObject(Object object, FrameManager frameManager) {
        SerializedFrame serializedFrame = new SerializedFrame(ObjectFormat.fromObject(object, 1), frameManager);
        serializedFrame.setObjectValue(object);
        return serializedFrame;
    }

    @Override
    public Bitmap getBitmap() {
        Object object = this.deserializeObjectValue();
        if (object instanceof Bitmap) {
            return (Bitmap)object;
        }
        return null;
    }

    @Override
    public ByteBuffer getData() {
        Object object = this.deserializeObjectValue();
        if (object instanceof ByteBuffer) {
            return (ByteBuffer)object;
        }
        return null;
    }

    @Override
    public float[] getFloats() {
        Object object = this.deserializeObjectValue();
        if (object instanceof float[]) {
            return (float[])object;
        }
        return null;
    }

    @Override
    public int[] getInts() {
        Object object = this.deserializeObjectValue();
        if (object instanceof int[]) {
            return (int[])object;
        }
        return null;
    }

    @Override
    public Object getObjectValue() {
        return this.deserializeObjectValue();
    }

    @Override
    protected boolean hasNativeAllocation() {
        return false;
    }

    @Override
    protected void releaseNativeAllocation() {
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.setGenericObjectValue(bitmap);
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        this.assertFrameMutable();
        this.setGenericObjectValue(ByteBuffer.wrap(byteBuffer.array(), n, n2));
    }

    @Override
    public void setFloats(float[] fArray) {
        this.assertFrameMutable();
        this.setGenericObjectValue(fArray);
    }

    @Override
    protected void setGenericObjectValue(Object object) {
        this.serializeObjectValue(object);
    }

    @Override
    public void setInts(int[] nArray) {
        this.assertFrameMutable();
        this.setGenericObjectValue(nArray);
    }

    public String toString() {
        return "SerializedFrame (" + this.getFormat() + ")";
    }

    private class DirectByteInputStream
    extends InputStream {
        private byte[] mBuffer;
        private int mPos = 0;
        private int mSize;

        public DirectByteInputStream(byte[] byArray, int n) {
            this.mBuffer = byArray;
            this.mSize = n;
        }

        @Override
        public final int available() {
            return this.mSize - this.mPos;
        }

        @Override
        public final int read() {
            if (this.mPos < this.mSize) {
                byte[] byArray = this.mBuffer;
                int n = this.mPos;
                this.mPos = n + 1;
                return 0xFF & byArray[n];
            }
            return -1;
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) {
            if (this.mPos >= this.mSize) {
                return -1;
            }
            if (n2 + this.mPos > this.mSize) {
                n2 = this.mSize - this.mPos;
            }
            System.arraycopy((byte[])this.mBuffer, (int)this.mPos, (byte[])byArray, (int)n, (int)n2);
            this.mPos = n2 + this.mPos;
            return n2;
        }

        @Override
        public final long skip(long l) {
            if (l + (long)this.mPos > (long)this.mSize) {
                l = this.mSize - this.mPos;
            }
            if (l < 0L) {
                return 0L;
            }
            this.mPos = (int)(l + (long)this.mPos);
            return l;
        }
    }

    private class DirectByteOutputStream
    extends OutputStream {
        private byte[] mBuffer = null;
        private int mDataOffset = 0;
        private int mOffset = 0;

        public DirectByteOutputStream(int n) {
            this.mBuffer = new byte[n];
        }

        private final void ensureFit(int n) {
            if (n + this.mOffset > this.mBuffer.length) {
                byte[] byArray = this.mBuffer;
                this.mBuffer = new byte[Math.max(n + this.mOffset, 2 * this.mBuffer.length)];
                System.arraycopy((byte[])byArray, (int)0, (byte[])this.mBuffer, (int)0, (int)this.mOffset);
            }
        }

        public byte[] getByteArray() {
            return this.mBuffer;
        }

        public final DirectByteInputStream getInputStream() {
            return new DirectByteInputStream(this.mBuffer, this.mOffset);
        }

        public final int getSize() {
            return this.mOffset;
        }

        public final void markHeaderEnd() {
            this.mDataOffset = this.mOffset;
        }

        public final void reset() {
            this.mOffset = this.mDataOffset;
        }

        @Override
        public final void write(int n) {
            this.ensureFit(1);
            byte[] byArray = this.mBuffer;
            int n2 = this.mOffset;
            this.mOffset = n2 + 1;
            byArray[n2] = (byte)n;
        }

        @Override
        public final void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }

        @Override
        public final void write(byte[] byArray, int n, int n2) {
            this.ensureFit(n2);
            System.arraycopy((byte[])byArray, (int)n, (byte[])this.mBuffer, (int)this.mOffset, (int)n2);
            this.mOffset = n2 + this.mOffset;
        }
    }
}

