/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLFrame;
import android.filterfw.core.NativeBuffer;
import android.filterfw.core.SimpleFrame;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public class NativeFrame
extends Frame {
    private int nativeFrameId = -1;

    static {
        System.loadLibrary("filterfw");
    }

    /*
     * Enabled aggressive block sorting
     */
    NativeFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
        int n = frameFormat.getSize();
        this.nativeAllocate(n);
        boolean bl = n != 0;
        this.setReusable(bl);
    }

    private native boolean getNativeBitmap(Bitmap var1, int var2, int var3);

    private native boolean getNativeBuffer(NativeBuffer var1);

    private native int getNativeCapacity();

    private native byte[] getNativeData(int var1);

    private native float[] getNativeFloats(int var1);

    private native int[] getNativeInts(int var1);

    private native boolean nativeAllocate(int var1);

    private native boolean nativeCopyFromGL(GLFrame var1);

    private native boolean nativeCopyFromNative(NativeFrame var1);

    private native boolean nativeDeallocate();

    private static native int nativeFloatSize();

    private static native int nativeIntSize();

    private native boolean setNativeBitmap(Bitmap var1, int var2, int var3);

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native boolean setNativeFloats(float[] var1);

    private native boolean setNativeInts(int[] var1);

    @Override
    public Bitmap getBitmap() {
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to get Bitmap for non 2-dimensional native frame!");
        }
        Bitmap bitmap = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(bitmap, bitmap.getByteCount(), this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not get bitmap data from native frame!");
        }
        return bitmap;
    }

    @Override
    public int getCapacity() {
        return this.getNativeCapacity();
    }

    @Override
    public ByteBuffer getData() {
        byte[] byArray = this.getNativeData(this.getFormat().getSize());
        if (byArray == null) {
            return null;
        }
        return ByteBuffer.wrap(byArray);
    }

    @Override
    public float[] getFloats() {
        return this.getNativeFloats(this.getFormat().getSize());
    }

    @Override
    public int[] getInts() {
        return this.getNativeInts(this.getFormat().getSize());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getObjectValue() {
        NativeBuffer nativeBuffer;
        block5: {
            if (this.getFormat().getBaseType() != 8) {
                return this.getData();
            }
            Class clazz = this.getFormat().getObjectClass();
            if (clazz == null) {
                throw new RuntimeException("Attempting to get object data from frame that does not specify a structure object class!");
            }
            if (!NativeBuffer.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("NativeFrame object class must be a subclass of NativeBuffer!");
            }
            try {
                nativeBuffer = (NativeBuffer)clazz.newInstance();
                if (this.getNativeBuffer(nativeBuffer)) break block5;
                throw new RuntimeException("Could not get the native structured data for frame!");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not instantiate new structure instance of type '" + clazz + "'!");
            }
        }
        nativeBuffer.attachToFrame(this);
        return nativeBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasNativeAllocation() {
        synchronized (this) {
            int n = this.nativeFrameId;
            if (n == -1) return false;
            return true;
        }
    }

    @Override
    protected void releaseNativeAllocation() {
        synchronized (this) {
            this.nativeDeallocate();
            this.nativeFrameId = -1;
            return;
        }
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        if (this.getFormat().getNumberOfDimensions() != 2) {
            throw new RuntimeException("Attempting to set Bitmap for non 2-dimensional native frame!");
        }
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match native frame dimensions!");
        }
        Bitmap bitmap2 = NativeFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(bitmap2, bitmap2.getByteCount(), this.getFormat().getBytesPerSample())) {
            throw new RuntimeException("Could not set native frame bitmap data!");
        }
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        this.assertFrameMutable();
        byte[] byArray = byteBuffer.array();
        if (n2 + n > byteBuffer.limit()) {
            throw new RuntimeException("Offset and length exceed buffer size in native setData: " + (n2 + n) + " bytes given, but only " + byteBuffer.limit() + " bytes available!");
        }
        if (this.getFormat().getSize() != n2) {
            throw new RuntimeException("Data size in setData does not match native frame size: Frame size is " + this.getFormat().getSize() + " bytes, but " + n2 + " bytes given!");
        }
        if (!this.setNativeData(byArray, n, n2)) {
            throw new RuntimeException("Could not set native frame data!");
        }
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to " + "smaller native frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
            return;
        }
        if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
            return;
        }
        if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
            return;
        }
        super.setDataFromFrame(frame);
    }

    @Override
    public void setFloats(float[] fArray) {
        this.assertFrameMutable();
        if (fArray.length * NativeFrame.nativeFloatSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + fArray.length + " floats. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeFloatSize() + " floats).");
        }
        if (!this.setNativeFloats(fArray)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    @Override
    public void setInts(int[] nArray) {
        this.assertFrameMutable();
        if (nArray.length * NativeFrame.nativeIntSize() > this.getFormat().getSize()) {
            throw new RuntimeException("NativeFrame cannot hold " + nArray.length + " integers. (Can only hold " + this.getFormat().getSize() / NativeFrame.nativeIntSize() + " integers).");
        }
        if (!this.setNativeInts(nArray)) {
            throw new RuntimeException("Could not set int values for native frame!");
        }
    }

    public String toString() {
        return "NativeFrame id: " + this.nativeFrameId + " (" + this.getFormat() + ") of size " + this.getCapacity();
    }
}

