/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.graphics.Bitmap;
import java.nio.ByteBuffer;

public abstract class Frame {
    public static final int NO_BINDING = 0;
    public static final long TIMESTAMP_NOT_SET = -2L;
    public static final long TIMESTAMP_UNKNOWN = -1L;
    private long mBindingId = 0L;
    private int mBindingType = 0;
    private FrameFormat mFormat;
    private FrameManager mFrameManager;
    private boolean mReadOnly = false;
    private int mRefCount = 1;
    private boolean mReusable = false;
    private long mTimestamp = -2L;

    Frame(FrameFormat frameFormat, FrameManager frameManager) {
        this.mFormat = frameFormat.mutableCopy();
        this.mFrameManager = frameManager;
    }

    Frame(FrameFormat frameFormat, FrameManager frameManager, int n, long l) {
        this.mFormat = frameFormat.mutableCopy();
        this.mFrameManager = frameManager;
        this.mBindingType = n;
        this.mBindingId = l;
    }

    protected static Bitmap convertBitmapToRGBA(Bitmap bitmap) {
        if (bitmap.getConfig() == Bitmap.Config.ARGB_8888) {
            return bitmap;
        }
        Bitmap bitmap2 = bitmap.copy(Bitmap.Config.ARGB_8888, false);
        if (bitmap2 == null) {
            throw new RuntimeException("Error converting bitmap to RGBA!");
        }
        if (bitmap2.getRowBytes() != 4 * bitmap2.getWidth()) {
            throw new RuntimeException("Unsupported row byte count in bitmap!");
        }
        return bitmap2;
    }

    protected void assertFrameMutable() {
        if (this.isReadOnly()) {
            throw new RuntimeException("Attempting to modify read-only frame!");
        }
    }

    final int decRefCount() {
        this.mRefCount = -1 + this.mRefCount;
        return this.mRefCount;
    }

    public long getBindingId() {
        return this.mBindingId;
    }

    public int getBindingType() {
        return this.mBindingType;
    }

    public abstract Bitmap getBitmap();

    public int getCapacity() {
        return this.getFormat().getSize();
    }

    public abstract ByteBuffer getData();

    public abstract float[] getFloats();

    public FrameFormat getFormat() {
        return this.mFormat;
    }

    public FrameManager getFrameManager() {
        return this.mFrameManager;
    }

    public abstract int[] getInts();

    public abstract Object getObjectValue();

    public int getRefCount() {
        return this.mRefCount;
    }

    public long getTimestamp() {
        return this.mTimestamp;
    }

    protected abstract boolean hasNativeAllocation();

    final int incRefCount() {
        this.mRefCount = 1 + this.mRefCount;
        return this.mRefCount;
    }

    public boolean isReadOnly() {
        return this.mReadOnly;
    }

    final boolean isReusable() {
        return this.mReusable;
    }

    final void markReadOnly() {
        this.mReadOnly = true;
    }

    protected void onFrameFetch() {
    }

    protected void onFrameStore() {
    }

    public Frame release() {
        if (frame.mFrameManager != null) {
            Frame frame = frame.mFrameManager.releaseFrame(frame);
        }
        return frame;
    }

    protected abstract void releaseNativeAllocation();

    protected boolean requestResize(int[] nArray) {
        return false;
    }

    protected void reset(FrameFormat frameFormat) {
        this.mFormat = frameFormat.mutableCopy();
        this.mReadOnly = false;
        this.mRefCount = 1;
    }

    public Frame retain() {
        if (frame.mFrameManager != null) {
            Frame frame = frame.mFrameManager.retainFrame(frame);
        }
        return frame;
    }

    public abstract void setBitmap(Bitmap var1);

    public void setData(ByteBuffer byteBuffer) {
        this.setData(byteBuffer, 0, byteBuffer.limit());
    }

    public abstract void setData(ByteBuffer var1, int var2, int var3);

    public void setData(byte[] byArray, int n, int n2) {
        this.setData(ByteBuffer.wrap(byArray, n, n2));
    }

    public void setDataFromFrame(Frame frame) {
        this.setData(frame.getData());
    }

    public abstract void setFloats(float[] var1);

    protected void setFormat(FrameFormat frameFormat) {
        this.mFormat = frameFormat.mutableCopy();
    }

    protected void setGenericObjectValue(Object object) {
        throw new RuntimeException("Cannot set object value of unsupported type: " + object.getClass());
    }

    public abstract void setInts(int[] var1);

    public void setObjectValue(Object object) {
        this.assertFrameMutable();
        if (object instanceof int[]) {
            this.setInts((int[])object);
            return;
        }
        if (object instanceof float[]) {
            this.setFloats((float[])object);
            return;
        }
        if (object instanceof ByteBuffer) {
            this.setData((ByteBuffer)object);
            return;
        }
        if (object instanceof Bitmap) {
            this.setBitmap((Bitmap)object);
            return;
        }
        this.setGenericObjectValue(object);
    }

    protected void setReusable(boolean bl) {
        this.mReusable = bl;
    }

    public void setTimestamp(long l) {
        this.mTimestamp = l;
    }
}

