/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Filter;
import android.filterfw.core.FilterContext;
import android.filterfw.core.Frame;
import android.filterfw.core.InputPort;
import java.lang.reflect.Field;

public class FieldPort
extends InputPort {
    protected Field mField;
    protected boolean mHasFrame;
    protected Object mValue;
    protected boolean mValueWaiting = false;

    public FieldPort(Filter filter, String string2, Field field, boolean bl) {
        super(filter, string2);
        this.mField = field;
        this.mHasFrame = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean acceptsFrame() {
        synchronized (this) {
            boolean bl = this.mValueWaiting;
            if (bl) return false;
            return true;
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public Object getTarget() {
        try {
            Object object = this.mField.get(this.mFilter);
            return object;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    @Override
    public boolean hasFrame() {
        synchronized (this) {
            boolean bl = this.mHasFrame;
            return bl;
        }
    }

    @Override
    public Frame pullFrame() {
        synchronized (this) {
            throw new RuntimeException("Cannot pull frame on " + this + "!");
        }
    }

    @Override
    public void pushFrame(Frame frame) {
        this.setFieldFrame(frame, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setFieldFrame(Frame frame, boolean bl) {
        synchronized (this) {
            this.assertPortIsOpen();
            this.checkFrameType(frame, bl);
            Object object = frame.getObjectValue();
            if (object == null && this.mValue != null || !object.equals(this.mValue)) {
                this.mValue = object;
                this.mValueWaiting = true;
            }
            this.mHasFrame = true;
            return;
        }
    }

    @Override
    public void setFrame(Frame frame) {
        this.setFieldFrame(frame, true);
    }

    @Override
    public String toString() {
        return "field " + super.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void transfer(FilterContext filterContext) {
        synchronized (this) {
            boolean bl = this.mValueWaiting;
            if (bl) {
                try {
                    this.mField.set(this.mFilter, this.mValue);
                    this.mValueWaiting = false;
                    if (filterContext != null) {
                        this.mFilter.notifyFieldPortValueUpdated(this.mName, filterContext);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException("Access to field '" + this.mField.getName() + "' was denied!");
                }
            }
            return;
        }
    }
}

