/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmConvertedStatus;
import android.drm.DrmManagerClient;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.UnknownServiceException;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.Streams;

public class DrmOutputStream
extends OutputStream {
    private static final String TAG = "DrmOutputStream";
    private final DrmManagerClient mClient;
    private final FileDescriptor mFd;
    private final ParcelFileDescriptor mPfd;
    private int mSessionId = -1;

    public DrmOutputStream(DrmManagerClient drmManagerClient, ParcelFileDescriptor parcelFileDescriptor, String string2) throws IOException {
        this.mClient = drmManagerClient;
        this.mPfd = parcelFileDescriptor;
        this.mFd = parcelFileDescriptor.getFileDescriptor();
        this.mSessionId = this.mClient.openConvertSession(string2);
        if (this.mSessionId == -1) {
            throw new UnknownServiceException("Failed to open DRM session for " + string2);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mSessionId == -1) {
            Log.w(TAG, "Closing stream without finishing");
        }
        this.mPfd.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finish() throws IOException {
        DrmConvertedStatus drmConvertedStatus = this.mClient.closeConvertSession(this.mSessionId);
        if (drmConvertedStatus.statusCode != 1) {
            throw new IOException("Unexpected DRM status: " + drmConvertedStatus.statusCode);
        }
        try {
            Os.lseek(this.mFd, drmConvertedStatus.offset, OsConstants.SEEK_SET);
        }
        catch (ErrnoException errnoException) {
            errnoException.rethrowAsIOException();
        }
        IoBridge.write((FileDescriptor)this.mFd, (byte[])drmConvertedStatus.convertedData, (int)0, (int)drmConvertedStatus.convertedData.length);
        this.mSessionId = -1;
    }

    @Override
    public void write(int n) throws IOException {
        Streams.writeSingleByte((OutputStream)this, (int)n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2;
        Arrays.checkOffsetAndCount((int)byArray.length, (int)n, (int)n2);
        if (n2 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy((byte[])byArray, (int)n, (byte[])byArray2, (int)0, (int)n2);
        }
        DrmConvertedStatus drmConvertedStatus = this.mClient.convertData(this.mSessionId, byArray2);
        if (drmConvertedStatus.statusCode == 1) {
            IoBridge.write((FileDescriptor)this.mFd, (byte[])drmConvertedStatus.convertedData, (int)0, (int)drmConvertedStatus.convertedData.length);
            return;
        }
        throw new IOException("Unexpected DRM status: " + drmConvertedStatus.statusCode);
    }
}

