/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.drm.DrmConvertedStatus;
import android.drm.DrmErrorEvent;
import android.drm.DrmEvent;
import android.drm.DrmInfo;
import android.drm.DrmInfoEvent;
import android.drm.DrmInfoRequest;
import android.drm.DrmInfoStatus;
import android.drm.DrmRights;
import android.drm.DrmStore;
import android.drm.DrmSupportInfo;
import android.drm.DrmUtils;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class DrmManagerClient {
    private static final int ACTION_PROCESS_DRM_INFO = 1002;
    private static final int ACTION_REMOVE_ALL_RIGHTS = 1001;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_UNKNOWN = -2000;
    public static final int INVALID_SESSION = -1;
    private static final String TAG = "DrmManagerClient";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private Context mContext;
    private EventHandler mEventHandler;
    HandlerThread mEventThread;
    private InfoHandler mInfoHandler;
    HandlerThread mInfoThread;
    private long mNativeContext;
    private OnErrorListener mOnErrorListener;
    private OnEventListener mOnEventListener;
    private OnInfoListener mOnInfoListener;
    private volatile boolean mReleased;
    private int mUniqueId;

    static {
        System.loadLibrary("drmframework_jni");
    }

    public DrmManagerClient(Context context) {
        this.mContext = context;
        this.createEventThreads();
        this.mUniqueId = this._initialize();
        this.mCloseGuard.open("release");
    }

    private native DrmInfo _acquireDrmInfo(int var1, DrmInfoRequest var2);

    private native boolean _canHandle(int var1, String var2, String var3);

    private native int _checkRightsStatus(int var1, String var2, int var3);

    private native DrmConvertedStatus _closeConvertSession(int var1, int var2);

    private native DrmConvertedStatus _convertData(int var1, int var2, byte[] var3);

    private native DrmSupportInfo[] _getAllSupportInfo(int var1);

    private native ContentValues _getConstraints(int var1, String var2, int var3);

    private native int _getDrmObjectType(int var1, String var2, String var3);

    private native ContentValues _getMetadata(int var1, String var2);

    private native String _getOriginalMimeType(int var1, String var2, FileDescriptor var3);

    private native int _initialize();

    private native void _installDrmEngine(int var1, String var2);

    private native int _openConvertSession(int var1, String var2);

    private native DrmInfoStatus _processDrmInfo(int var1, DrmInfo var2);

    private native void _release(int var1);

    private native int _removeAllRights(int var1);

    private native int _removeRights(int var1, String var2);

    private native int _saveRights(int var1, DrmRights var2, String var3, String var4);

    private native void _setIsASUSFLMedia(int var1);

    private native void _setListeners(int var1, Object var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String convertUriToPath(Uri uri) {
        String string2 = null;
        if (uri == null) return string2;
        String string3 = uri.getScheme();
        if (string3 == null) return uri.getPath();
        if (string3.equals("")) return uri.getPath();
        if (string3.equals("file")) {
            return uri.getPath();
        }
        if (string3.equals("http")) {
            return uri.toString();
        }
        if (!string3.equals("content")) {
            throw new IllegalArgumentException("Given Uri scheme is not supported");
        }
        String[] stringArray = new String[]{"_data"};
        Cursor cursor = null;
        try {
            try {
                cursor = this.mContext.getContentResolver().query(uri, stringArray, null, null, null);
                if (cursor == null) throw new IllegalArgumentException("Given Uri could not be found in media store");
                if (cursor.getCount() == 0) throw new IllegalArgumentException("Given Uri could not be found in media store");
                if (!cursor.moveToFirst()) {
                    throw new IllegalArgumentException("Given Uri could not be found in media store");
                }
            }
            catch (SQLiteException sQLiteException) {
                throw new IllegalArgumentException("Given Uri is not formatted in a way so that it can be found in media store.");
            }
        }
        catch (Throwable throwable) {
            if (cursor == null) throw throwable;
            cursor.close();
            throw throwable;
        }
        {
            String string4;
            string2 = string4 = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
            if (cursor == null) return string2;
        }
        cursor.close();
        return string2;
    }

    private void createEventThreads() {
        if (this.mEventHandler == null && this.mInfoHandler == null) {
            this.mInfoThread = new HandlerThread("DrmManagerClient.InfoHandler");
            this.mInfoThread.start();
            this.mInfoHandler = new InfoHandler(this.mInfoThread.getLooper());
            this.mEventThread = new HandlerThread("DrmManagerClient.EventHandler");
            this.mEventThread.start();
            this.mEventHandler = new EventHandler(this.mEventThread.getLooper());
        }
    }

    private void createListeners() {
        this._setListeners(this.mUniqueId, new WeakReference<DrmManagerClient>(this));
    }

    private int getErrorType(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return 2006;
    }

    private int getEventType(int n) {
        switch (n) {
            default: {
                return -1;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        return 1002;
    }

    public static void notify(Object object, int n, int n2, String string2) {
        DrmManagerClient drmManagerClient = (DrmManagerClient)((WeakReference)object).get();
        if (drmManagerClient != null && drmManagerClient.mInfoHandler != null) {
            Message message = drmManagerClient.mInfoHandler.obtainMessage(1, n, n2, string2);
            drmManagerClient.mInfoHandler.sendMessage(message);
        }
    }

    public DrmInfo acquireDrmInfo(DrmInfoRequest drmInfoRequest) {
        if (drmInfoRequest == null || !drmInfoRequest.isValid()) {
            throw new IllegalArgumentException("Given drmInfoRequest is invalid/null");
        }
        return this._acquireDrmInfo(this.mUniqueId, drmInfoRequest);
    }

    public int acquireRights(DrmInfoRequest drmInfoRequest) {
        DrmInfo drmInfo = this.acquireDrmInfo(drmInfoRequest);
        if (drmInfo == null) {
            return -2000;
        }
        return this.processDrmInfo(drmInfo);
    }

    public boolean canHandle(Uri uri, String string2) {
        if (!(uri != null && Uri.EMPTY != uri || string2 != null && !string2.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        return this.canHandle(this.convertUriToPath(uri), string2);
    }

    public boolean canHandle(String string2, String string3) {
        if ((string2 == null || string2.equals("")) && (string3 == null || string3.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._canHandle(this.mUniqueId, string2, string3);
    }

    public int checkRightsStatus(Uri uri) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri));
    }

    public int checkRightsStatus(Uri uri, int n) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.checkRightsStatus(this.convertUriToPath(uri), n);
    }

    public int checkRightsStatus(String string2) {
        return this.checkRightsStatus(string2, 0);
    }

    public int checkRightsStatus(String string2, int n) {
        if (string2 == null || string2.equals("") || !DrmStore.Action.isValid(n)) {
            throw new IllegalArgumentException("Given path or action is not valid");
        }
        return this._checkRightsStatus(this.mUniqueId, string2, n);
    }

    public DrmConvertedStatus closeConvertSession(int n) {
        return this._closeConvertSession(this.mUniqueId, n);
    }

    public DrmConvertedStatus convertData(int n, byte[] byArray) {
        if (byArray == null || byArray.length <= 0) {
            throw new IllegalArgumentException("Given inputData should be non null");
        }
        return this._convertData(this.mUniqueId, n, byArray);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.release();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public String[] getAvailableDrmEngines() {
        DrmSupportInfo[] drmSupportInfoArray = this._getAllSupportInfo(this.mUniqueId);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < drmSupportInfoArray.length; ++i) {
            arrayList.add(drmSupportInfoArray[i].getDescriprition());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public ContentValues getConstraints(Uri uri, int n) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getConstraints(this.convertUriToPath(uri), n);
    }

    public ContentValues getConstraints(String string2, int n) {
        if (string2 == null || string2.equals("") || !DrmStore.Action.isValid(n)) {
            throw new IllegalArgumentException("Given usage or path is invalid/null");
        }
        return this._getConstraints(this.mUniqueId, string2, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDrmObjectType(Uri uri, String string2) {
        if (!(uri != null && Uri.EMPTY != uri || string2 != null && !string2.equals(""))) {
            throw new IllegalArgumentException("Uri or the mimetype should be non null");
        }
        String string3 = "";
        try {
            String string4;
            string3 = string4 = this.convertUriToPath(uri);
            return this.getDrmObjectType(string3, string2);
        }
        catch (Exception exception) {
            Log.w(TAG, "Given Uri could not be found in media store");
            return this.getDrmObjectType(string3, string2);
        }
    }

    public int getDrmObjectType(String string2, String string3) {
        if ((string2 == null || string2.equals("")) && (string3 == null || string3.equals(""))) {
            throw new IllegalArgumentException("Path or the mimetype should be non null");
        }
        return this._getDrmObjectType(this.mUniqueId, string2, string3);
    }

    public ContentValues getMetadata(Uri uri) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Uri should be non null");
        }
        return this.getMetadata(this.convertUriToPath(uri));
    }

    public ContentValues getMetadata(String string2) {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Given path is invalid/null");
        }
        return this._getMetadata(this.mUniqueId, string2);
    }

    public String getOriginalMimeType(Uri uri) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.getOriginalMimeType(this.convertUriToPath(uri));
    }

    /*
     * Unable to fully structure code
     */
    public String getOriginalMimeType(String var1_1) {
        block21: {
            block20: {
                if (var1_1 == null || var1_1.equals("")) {
                    throw new IllegalArgumentException("Given path should be non null");
                }
                var2_2 = null;
                var3_3 = new File(var1_1);
                var9_4 = var3_3.exists();
                var10_5 = null;
                var2_2 = null;
                if (!var9_4) break block20;
                var11_6 = new FileInputStream(var3_3);
                var10_5 = var13_7 = var11_6.getFD();
                var2_2 = var11_6;
            }
            var7_9 = var14_8 = this._getOriginalMimeType(this.mUniqueId, var1_1, var10_5);
            if (var2_2 == null) break block21;
            try {
                var2_2.close();
            }
            catch (IOException var15_15) {
                return var7_9;
            }
        }
        return var7_9;
        catch (IOException var6_10) lbl-1000:
        // 2 sources

        {
            while (true) {
                var7_9 = null;
                if (var2_2 == null) ** continue;
                try {
                    var2_2.close();
                    return null;
                }
                catch (IOException var8_11) {
                    return null;
                }
                break;
            }
        }
        catch (Throwable var4_12) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var2_2 != null) {
                    var2_2.close();
                }
lbl38:
                // 4 sources

                throw var4_13;
            }
        }
        {
            catch (IOException var5_16) {
                ** continue;
            }
        }
        catch (Throwable var4_14) {
            var2_2 = var11_6;
            ** continue;
        }
        catch (IOException var12_17) {
            var2_2 = var11_6;
            ** continue;
        }
    }

    public void installDrmEngine(String string2) {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Given engineFilePath: " + string2 + "is not valid");
        }
        this._installDrmEngine(this.mUniqueId, string2);
    }

    public int openConvertSession(String string2) {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Path or the mimeType should be non null");
        }
        return this._openConvertSession(this.mUniqueId, string2);
    }

    public int processDrmInfo(DrmInfo drmInfo) {
        Message message;
        if (drmInfo == null || !drmInfo.isValid()) {
            throw new IllegalArgumentException("Given drmInfo is invalid/null");
        }
        int n = -2000;
        if (this.mEventHandler != null && this.mEventHandler.sendMessage(message = this.mEventHandler.obtainMessage(1002, drmInfo))) {
            n = 0;
        }
        return n;
    }

    public void release() {
        if (this.mReleased) {
            return;
        }
        this.mReleased = true;
        if (this.mEventHandler != null) {
            this.mEventThread.quit();
            this.mEventThread = null;
        }
        if (this.mInfoHandler != null) {
            this.mInfoThread.quit();
            this.mInfoThread = null;
        }
        this.mEventHandler = null;
        this.mInfoHandler = null;
        this.mOnEventListener = null;
        this.mOnInfoListener = null;
        this.mOnErrorListener = null;
        this._release(this.mUniqueId);
        this.mCloseGuard.close();
    }

    public int removeAllRights() {
        Message message;
        int n = -2000;
        if (this.mEventHandler != null && this.mEventHandler.sendMessage(message = this.mEventHandler.obtainMessage(1001))) {
            n = 0;
        }
        return n;
    }

    public int removeRights(Uri uri) {
        if (uri == null || Uri.EMPTY == uri) {
            throw new IllegalArgumentException("Given uri is not valid");
        }
        return this.removeRights(this.convertUriToPath(uri));
    }

    public int removeRights(String string2) {
        if (string2 == null || string2.equals("")) {
            throw new IllegalArgumentException("Given path should be non null");
        }
        return this._removeRights(this.mUniqueId, string2);
    }

    public int saveRights(DrmRights drmRights, String string2, String string3) throws IOException {
        if (drmRights == null || !drmRights.isValid()) {
            throw new IllegalArgumentException("Given drmRights or contentPath is not valid");
        }
        if (string2 != null && !string2.equals("")) {
            DrmUtils.writeToFile(string2, drmRights.getData());
        }
        return this._saveRights(this.mUniqueId, drmRights, string2, string3);
    }

    public void setIsASUSFLMedia(int n) {
        this._setIsASUSFLMedia(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnErrorListener(OnErrorListener onErrorListener) {
        synchronized (this) {
            this.mOnErrorListener = onErrorListener;
            if (onErrorListener != null) {
                this.createListeners();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnEventListener(OnEventListener onEventListener) {
        synchronized (this) {
            this.mOnEventListener = onEventListener;
            if (onEventListener != null) {
                this.createListeners();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOnInfoListener(OnInfoListener onInfoListener) {
        synchronized (this) {
            this.mOnInfoListener = onInfoListener;
            if (onInfoListener != null) {
                this.createListeners();
            }
            return;
        }
    }

    private class EventHandler
    extends Handler {
        public EventHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            DrmEvent drmEvent;
            DrmErrorEvent drmErrorEvent = null;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            switch (message.what) {
                default: {
                    Log.e(DrmManagerClient.TAG, "Unknown message type " + message.what);
                    return;
                }
                case 1002: {
                    DrmInfo drmInfo = (DrmInfo)message.obj;
                    DrmInfoStatus drmInfoStatus = DrmManagerClient.this._processDrmInfo(DrmManagerClient.this.mUniqueId, drmInfo);
                    hashMap.put("drm_info_status_object", drmInfoStatus);
                    hashMap.put("drm_info_object", drmInfo);
                    if (drmInfoStatus != null && 1 == drmInfoStatus.statusCode) {
                        drmEvent = new DrmEvent(DrmManagerClient.this.mUniqueId, DrmManagerClient.this.getEventType(drmInfoStatus.infoType), null, hashMap);
                        break;
                    }
                    int n = drmInfoStatus != null ? drmInfoStatus.infoType : drmInfo.getInfoType();
                    drmErrorEvent = new DrmErrorEvent(DrmManagerClient.this.mUniqueId, DrmManagerClient.this.getErrorType(n), null, hashMap);
                    drmEvent = null;
                    break;
                }
                case 1001: {
                    if (DrmManagerClient.this._removeAllRights(DrmManagerClient.this.mUniqueId) == 0) {
                        drmEvent = new DrmEvent(DrmManagerClient.this.mUniqueId, 1001, null);
                        drmErrorEvent = null;
                        break;
                    }
                    drmErrorEvent = new DrmErrorEvent(DrmManagerClient.this.mUniqueId, 2007, null);
                    drmEvent = null;
                }
            }
            if (DrmManagerClient.this.mOnEventListener != null && drmEvent != null) {
                DrmManagerClient.this.mOnEventListener.onEvent(DrmManagerClient.this, drmEvent);
            }
            if (DrmManagerClient.this.mOnErrorListener == null || drmErrorEvent == null) return;
            DrmManagerClient.this.mOnErrorListener.onError(DrmManagerClient.this, drmErrorEvent);
        }
    }

    private class InfoHandler
    extends Handler {
        public static final int INFO_EVENT_TYPE = 1;

        public InfoHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            DrmInfoEvent drmInfoEvent = null;
            switch (message.what) {
                default: {
                    Log.e(DrmManagerClient.TAG, "Unknown message type " + message.what);
                    return;
                }
                case 1: {
                    DrmErrorEvent drmErrorEvent;
                    int n = message.arg1;
                    int n2 = message.arg2;
                    String string2 = message.obj.toString();
                    switch (n2) {
                        default: {
                            drmErrorEvent = new DrmErrorEvent(n, n2, string2);
                            break;
                        }
                        case 2: {
                            try {
                                DrmUtils.removeFile(string2);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            drmInfoEvent = new DrmInfoEvent(n, n2, string2);
                            drmErrorEvent = null;
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            drmInfoEvent = new DrmInfoEvent(n, n2, string2);
                            drmErrorEvent = null;
                        }
                    }
                    if (DrmManagerClient.this.mOnInfoListener != null && drmInfoEvent != null) {
                        DrmManagerClient.this.mOnInfoListener.onInfo(DrmManagerClient.this, drmInfoEvent);
                    }
                    if (DrmManagerClient.this.mOnErrorListener == null || drmErrorEvent == null) return;
                    DrmManagerClient.this.mOnErrorListener.onError(DrmManagerClient.this, drmErrorEvent);
                    return;
                }
            }
        }
    }

    public static interface OnErrorListener {
        public void onError(DrmManagerClient var1, DrmErrorEvent var2);
    }

    public static interface OnEventListener {
        public void onEvent(DrmManagerClient var1, DrmEvent var2);
    }

    public static interface OnInfoListener {
        public void onInfo(DrmManagerClient var1, DrmInfoEvent var2);
    }
}

