/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmInfoRequest;
import android.drm.DrmUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class DrmInfo {
    private final HashMap<String, Object> mAttributes = new HashMap();
    private byte[] mData;
    private final int mInfoType;
    private final String mMimeType;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DrmInfo(int n, String string2, String string3) {
        this.mInfoType = n;
        this.mMimeType = string3;
        try {
            this.mData = DrmUtils.readBytes(string2);
        }
        catch (IOException iOException) {
            this.mData = null;
        }
        if (!this.isValid()) {
            String cfr_ignored_0 = "infoType: " + n + "," + "mimeType: " + string3 + "," + "data: " + this.mData;
            throw new IllegalArgumentException();
        }
    }

    public DrmInfo(int n, byte[] byArray, String string2) {
        this.mInfoType = n;
        this.mMimeType = string2;
        this.mData = byArray;
        if (!this.isValid()) {
            throw new IllegalArgumentException("infoType: " + n + "," + "mimeType: " + string2 + "," + "data: " + byArray);
        }
    }

    public Object get(String string2) {
        return this.mAttributes.get(string2);
    }

    public byte[] getData() {
        return this.mData;
    }

    public int getInfoType() {
        return this.mInfoType;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    boolean isValid() {
        return this.mMimeType != null && !this.mMimeType.equals("") && this.mData != null && this.mData.length > 0 && DrmInfoRequest.isValidType(this.mInfoType);
    }

    public Iterator<Object> iterator() {
        return this.mAttributes.values().iterator();
    }

    public Iterator<String> keyIterator() {
        return this.mAttributes.keySet().iterator();
    }

    public void put(String string2, Object object) {
        this.mAttributes.put(string2, object);
    }
}

