/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseErrorHandler;
import android.database.DatabaseUtils;
import android.database.DefaultDatabaseErrorHandler;
import android.database.SQLException;
import android.database.sqlite.SQLiteClosable;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCursorDriver;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseCorruptException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteDirectCursorDriver;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteQuery;
import android.database.sqlite.SQLiteQueryBuilder;
import android.database.sqlite.SQLiteSession;
import android.database.sqlite.SQLiteStatement;
import android.database.sqlite.SQLiteTransactionListener;
import android.os.CancellationSignal;
import android.os.Looper;
import android.text.TextUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Printer;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

public final class SQLiteDatabase
extends SQLiteClosable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int CONFLICT_ABORT = 2;
    public static final int CONFLICT_FAIL = 3;
    public static final int CONFLICT_IGNORE = 4;
    public static final int CONFLICT_NONE = 0;
    public static final int CONFLICT_REPLACE = 5;
    public static final int CONFLICT_ROLLBACK = 1;
    private static final String[] CONFLICT_VALUES;
    public static final int CREATE_IF_NECESSARY = 0x10000000;
    public static final int ENABLE_WRITE_AHEAD_LOGGING = 0x20000000;
    private static final int EVENT_DB_CORRUPT = 75004;
    public static final int MAX_SQL_CACHE_SIZE = 100;
    public static final int NO_LOCALIZED_COLLATORS = 16;
    public static final int OPEN_READONLY = 1;
    public static final int OPEN_READWRITE = 0;
    private static final int OPEN_READ_MASK = 1;
    public static final int SQLITE_MAX_LIKE_PATTERN_LENGTH = 50000;
    private static final String TAG = "SQLiteDatabase";
    private static WeakHashMap<SQLiteDatabase, Object> sActiveDatabases;
    private final CloseGuard mCloseGuardLocked;
    private final SQLiteDatabaseConfiguration mConfigurationLocked;
    private SQLiteConnectionPool mConnectionPoolLocked;
    private final CursorFactory mCursorFactory;
    private final DatabaseErrorHandler mErrorHandler;
    private boolean mHasAttachedDbsLocked;
    private final Object mLock;
    private final ThreadLocal<SQLiteSession> mThreadSession = new ThreadLocal<SQLiteSession>(){

        @Override
        protected SQLiteSession initialValue() {
            return SQLiteDatabase.this.createSession();
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SQLiteDatabase.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        sActiveDatabases = new WeakHashMap();
        CONFLICT_VALUES = new String[]{"", " OR ROLLBACK ", " OR ABORT ", " OR FAIL ", " OR IGNORE ", " OR REPLACE "};
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLiteDatabase(String string2, int n, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        this.mLock = new Object();
        this.mCloseGuardLocked = CloseGuard.get();
        this.mCursorFactory = cursorFactory;
        if (databaseErrorHandler == null) {
            databaseErrorHandler = new DefaultDatabaseErrorHandler();
        }
        this.mErrorHandler = databaseErrorHandler;
        this.mConfigurationLocked = new SQLiteDatabaseConfiguration(string2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void beginTransaction(SQLiteTransactionListener sQLiteTransactionListener, boolean bl) {
        this.acquireReference();
        try {
            SQLiteSession sQLiteSession = this.getThreadSession();
            int n = bl ? 2 : 1;
            sQLiteSession.beginTransaction(n, sQLiteTransactionListener, this.getThreadDefaultConnectionFlags(false), null);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void collectDbStats(ArrayList<SQLiteDebug.DbStats> arrayList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                this.mConnectionPoolLocked.collectDbStats(arrayList);
            }
            return;
        }
    }

    public static SQLiteDatabase create(CursorFactory cursorFactory) {
        return SQLiteDatabase.openDatabase(":memory:", cursorFactory, 0x10000000);
    }

    public static boolean deleteDatabase(File file) {
        File[] fileArray;
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        boolean bl = false | file.delete() | new File(file.getPath() + "-journal").delete() | new File(file.getPath() + "-shm").delete() | new File(file.getPath() + "-wal").delete();
        File file2 = file.getParentFile();
        if (file2 != null && (fileArray = file2.listFiles(new FileFilter(file.getName() + "-mj"){
            final /* synthetic */ String val$prefix;
            {
                this.val$prefix = string2;
            }

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(this.val$prefix);
            }
        })) != null) {
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                bl |= fileArray[i].delete();
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void dispose(boolean bl) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mCloseGuardLocked != null) {
            if (bl) {
                this.mCloseGuardLocked.warnIfOpen();
            }
            this.mCloseGuardLocked.close();
        }
        SQLiteConnectionPool sQLiteConnectionPool = this.mConnectionPoolLocked;
        this.mConnectionPoolLocked = null;
        // MONITOREXIT : object
        if (bl) return;
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        // MONITORENTER : weakHashMap
        sActiveDatabases.remove(this);
        // MONITOREXIT : weakHashMap
        if (sQLiteConnectionPool == null) return;
        sQLiteConnectionPool.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dump(Printer printer, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked != null) {
                printer.println("");
                this.mConnectionPoolLocked.dump(printer, bl);
            }
            return;
        }
    }

    static void dumpAll(Printer printer, boolean bl) {
        Iterator<SQLiteDatabase> iterator = SQLiteDatabase.getActiveDatabases().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(printer, bl);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeSql(String var1_1, Object[] var2_2) throws SQLException {
        this.acquireReference();
        if (DatabaseUtils.getSqlStatementType(var1_1) == 3) {
            var7_3 = this.mLock;
            synchronized (var7_3) {
                var9_4 = this.mHasAttachedDbsLocked;
                var10_5 = false;
                if (!var9_4) {
                    this.mHasAttachedDbsLocked = true;
                    var10_5 = true;
                }
            }
        }
        ** GOTO lbl18
        {
            catch (Throwable var3_8) {
                this.releaseReference();
                throw var3_8;
            }
        }
        {
            if (!var10_5) ** GOTO lbl18
        }
        {
            this.disableWriteAheadLogging();
lbl18:
            // 3 sources

            var4_6 = new SQLiteStatement(this, var1_1, var2_2);
        }
        try {
            var6_7 = var4_6.executeUpdateDelete();
            this.releaseReference();
            return var6_7;
        }
        finally {
            ** try [egrp 4[TRYBLOCK] [7 : 74->79)] { 
lbl25:
            // 1 sources

            var4_6.close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String findEditTable(String string2) {
        if (TextUtils.isEmpty(string2)) throw new IllegalStateException("Invalid tables");
        int n = string2.indexOf(32);
        int n2 = string2.indexOf(44);
        if (n > 0) {
            if (n < n2) return string2.substring(0, n);
            if (n2 < 0) {
                return string2.substring(0, n);
            }
        }
        if (n2 <= 0) return string2;
        if (n2 < n) return string2.substring(0, n2);
        if (n >= 0) return string2;
        return string2.substring(0, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ArrayList<SQLiteDatabase> getActiveDatabases() {
        ArrayList<SQLiteDatabase> arrayList = new ArrayList<SQLiteDatabase>();
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            arrayList.addAll(sActiveDatabases.keySet());
            return arrayList;
        }
    }

    static ArrayList<SQLiteDebug.DbStats> getDbStats() {
        ArrayList<SQLiteDebug.DbStats> arrayList = new ArrayList<SQLiteDebug.DbStats>();
        Iterator<SQLiteDatabase> iterator = SQLiteDatabase.getActiveDatabases().iterator();
        while (iterator.hasNext()) {
            iterator.next().collectDbStats(arrayList);
        }
        return arrayList;
    }

    private static boolean isMainThread() {
        Looper looper = Looper.myLooper();
        return looper != null && looper == Looper.getMainLooper();
    }

    private boolean isReadOnlyLocked() {
        return (1 & this.mConfigurationLocked.openFlags) == 1;
    }

    private void open() {
        try {
            this.openInner();
            return;
        }
        catch (SQLiteDatabaseCorruptException sQLiteDatabaseCorruptException) {
            try {
                this.onCorruption();
                this.openInner();
                return;
            }
            catch (SQLiteException sQLiteException) {
                Log.e(TAG, "Failed to open database '" + this.getLabel() + "'.", sQLiteException);
                this.close();
                throw sQLiteException;
            }
        }
    }

    public static SQLiteDatabase openDatabase(String string2, CursorFactory cursorFactory, int n) {
        return SQLiteDatabase.openDatabase(string2, cursorFactory, n, null);
    }

    public static SQLiteDatabase openDatabase(String string2, CursorFactory cursorFactory, int n, DatabaseErrorHandler databaseErrorHandler) {
        SQLiteDatabase sQLiteDatabase = new SQLiteDatabase(string2, n, cursorFactory, databaseErrorHandler);
        sQLiteDatabase.open();
        return sQLiteDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openInner() {
        Object object = this.mLock;
        synchronized (object) {
            if (!$assertionsDisabled && this.mConnectionPoolLocked != null) {
                throw new AssertionError();
            }
            this.mConnectionPoolLocked = SQLiteConnectionPool.open(this.mConfigurationLocked);
            this.mCloseGuardLocked.open("close");
        }
        WeakHashMap<SQLiteDatabase, Object> weakHashMap = sActiveDatabases;
        synchronized (weakHashMap) {
            sActiveDatabases.put(this, null);
            return;
        }
    }

    public static SQLiteDatabase openOrCreateDatabase(File file, CursorFactory cursorFactory) {
        return SQLiteDatabase.openOrCreateDatabase(file.getPath(), cursorFactory);
    }

    public static SQLiteDatabase openOrCreateDatabase(String string2, CursorFactory cursorFactory) {
        return SQLiteDatabase.openDatabase(string2, cursorFactory, 0x10000000, null);
    }

    public static SQLiteDatabase openOrCreateDatabase(String string2, CursorFactory cursorFactory, DatabaseErrorHandler databaseErrorHandler) {
        return SQLiteDatabase.openDatabase(string2, cursorFactory, 0x10000000, databaseErrorHandler);
    }

    public static int releaseMemory() {
        return SQLiteGlobal.releaseMemory();
    }

    private void throwIfNotOpenLocked() {
        if (this.mConnectionPoolLocked == null) {
            throw new IllegalStateException("The database '" + this.mConfigurationLocked.label + "' is not open.");
        }
    }

    private boolean yieldIfContendedHelper(boolean bl, long l) {
        this.acquireReference();
        try {
            boolean bl2 = this.getThreadSession().yieldTransaction(l, bl, null);
            return bl2;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addCustomFunction(String string2, int n, CustomFunction customFunction) {
        SQLiteCustomFunction sQLiteCustomFunction = new SQLiteCustomFunction(string2, n, customFunction);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            this.mConfigurationLocked.customFunctions.add(sQLiteCustomFunction);
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.mConfigurationLocked.customFunctions.remove(sQLiteCustomFunction);
                throw runtimeException;
            }
        }
    }

    public void beginTransaction() {
        this.beginTransaction(null, true);
    }

    public void beginTransactionNonExclusive() {
        this.beginTransaction(null, false);
    }

    public void beginTransactionWithListener(SQLiteTransactionListener sQLiteTransactionListener) {
        this.beginTransaction(sQLiteTransactionListener, true);
    }

    public void beginTransactionWithListenerNonExclusive(SQLiteTransactionListener sQLiteTransactionListener) {
        this.beginTransaction(sQLiteTransactionListener, false);
    }

    public SQLiteStatement compileStatement(String string2) throws SQLException {
        this.acquireReference();
        try {
            SQLiteStatement sQLiteStatement = new SQLiteStatement(this, string2, null);
            return sQLiteStatement;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SQLiteSession createSession() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            SQLiteConnectionPool sQLiteConnectionPool = this.mConnectionPoolLocked;
            return new SQLiteSession(sQLiteConnectionPool);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int delete(String string2, String string3, String[] stringArray) {
        int n;
        this.acquireReference();
        StringBuilder stringBuilder = new StringBuilder().append("DELETE FROM ").append(string2);
        String string4 = !TextUtils.isEmpty(string3) ? " WHERE " + string3 : "";
        SQLiteStatement sQLiteStatement = new SQLiteStatement(this, stringBuilder.append(string4).toString(), stringArray);
        {
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        try {
            n = sQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            sQLiteStatement.close();
            throw throwable;
        }
        try {
            sQLiteStatement.close();
            return n;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((0x20000000 & this.mConfigurationLocked.openFlags) == 0) {
                return;
            }
            SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration = this.mConfigurationLocked;
            sQLiteDatabaseConfiguration.openFlags = 0xDFFFFFFF & sQLiteDatabaseConfiguration.openFlags;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration2 = this.mConfigurationLocked;
                sQLiteDatabaseConfiguration2.openFlags = 0x20000000 | sQLiteDatabaseConfiguration2.openFlags;
                throw runtimeException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enableWriteAheadLogging() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((0x20000000 & this.mConfigurationLocked.openFlags) != 0) {
                return true;
            }
            if (this.isReadOnlyLocked()) {
                return false;
            }
            if (this.mConfigurationLocked.isInMemoryDb()) {
                Log.i(TAG, "can't enable WAL for memory databases.");
                return false;
            }
            if (this.mHasAttachedDbsLocked) {
                if (Log.isLoggable(TAG, 3)) {
                    Log.d(TAG, "this database: " + this.mConfigurationLocked.label + " has attached databases. can't  enable WAL.");
                }
                return false;
            }
            SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration = this.mConfigurationLocked;
            sQLiteDatabaseConfiguration.openFlags = 0x20000000 | sQLiteDatabaseConfiguration.openFlags;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return true;
            }
            catch (RuntimeException runtimeException) {
                SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration2 = this.mConfigurationLocked;
                sQLiteDatabaseConfiguration2.openFlags = 0xDFFFFFFF & sQLiteDatabaseConfiguration2.openFlags;
                throw runtimeException;
            }
        }
    }

    public void endTransaction() {
        this.acquireReference();
        try {
            this.getThreadSession().endTransaction(null);
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void execSQL(String string2) throws SQLException {
        this.executeSql(string2, null);
    }

    public void execSQL(String string2, Object[] objectArray) throws SQLException {
        if (objectArray == null) {
            throw new IllegalArgumentException("Empty bindArgs");
        }
        this.executeSql(string2, objectArray);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Pair<String, String>> getAttachedDbs() {
        var1_1 = new ArrayList<Pair<String, String>>();
        var2_2 = this.mLock;
        synchronized (var2_2) {
            if (this.mConnectionPoolLocked == null) {
                return null;
            }
            if (!this.mHasAttachedDbsLocked) {
                var1_1.add(new Pair<String, String>("main", this.mConfigurationLocked.path));
                return var1_1;
            }
            this.acquireReference();
        }
        var4_3 = null;
        try {
            var4_3 = this.rawQuery("pragma database_list;", null);
            while (var4_3.moveToNext()) {
                var1_1.add(new Pair<String, String>(var4_3.getString(1), var4_3.getString(2)));
            }
            ** GOTO lbl26
        }
        catch (Throwable var5_4) {
            if (var4_3 == null) throw var5_4;
            var4_3.close();
            throw var5_4;
lbl26:
            // 1 sources

            if (var4_3 == null) return var1_1;
            try {
                var4_3.close();
                return var1_1;
            }
            finally {
                this.releaseReference();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String getLabel() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.label;
        }
    }

    public long getMaximumSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA max_page_count;", null) * this.getPageSize();
    }

    public long getPageSize() {
        return DatabaseUtils.longForQuery(this, "PRAGMA page_size;", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getPath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.path;
        }
    }

    @Deprecated
    public Map<String, String> getSyncedTables() {
        return new HashMap<String, String>(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    int getThreadDefaultConnectionFlags(boolean bl) {
        int n = bl ? 1 : 2;
        if (SQLiteDatabase.isMainThread()) {
            n |= 4;
        }
        return n;
    }

    SQLiteSession getThreadSession() {
        return this.mThreadSession.get();
    }

    public int getVersion() {
        return Long.valueOf(DatabaseUtils.longForQuery(this, "PRAGMA user_version;", null)).intValue();
    }

    public boolean inTransaction() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasTransaction();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    public long insert(String string2, String string3, ContentValues contentValues) {
        try {
            long l = this.insertWithOnConflict(string2, string3, contentValues, 0);
            return l;
        }
        catch (SQLException sQLException) {
            Log.e(TAG, "Error inserting ", sQLException);
            return -1L;
        }
    }

    public long insertOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return this.insertWithOnConflict(string2, string3, contentValues, 0);
    }

    /*
     * Exception decompiling
     */
    public long insertWithOnConflict(String var1_1, String var2_2, ContentValues var3_3, int var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[TRYBLOCK]], but top level block is 19[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDatabaseIntegrityOk() {
        block15: {
            this.acquireReference();
            var1_1 = null;
            try {
                var1_1 = this.getAttachedDbs();
                if (var1_1 == null) {
                    throw new IllegalStateException("databaselist for: " + this.getPath() + " couldn't " + "be retrieved. probably because the database is closed");
                }
            }
            catch (SQLiteException var3_2) {
                var1_1 = new ArrayList<Pair<String, String>>();
                catch (Throwable var2_8) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        this.releaseReference();
                        throw var2_9;
                    }
                }
lbl-1000:
                // 2 sources

                {
                    while (true) {
                        block16: {
                            if (var6_3 >= var1_1.size()) break block16;
                            var7_4 = var1_1.get(var6_3);
                            var8_5 = null;
                            var8_5 = this.compileStatement("PRAGMA " + (String)var7_4.first + ".integrity_check(1);");
                            var10_6 = var8_5.simpleQueryForString();
                            if (var10_6.equalsIgnoreCase("ok")) ** GOTO lbl37
                            Log.e("SQLiteDatabase", "PRAGMA integrity_check on " + (String)var7_4.second + " returned: " + var10_6);
                            if (var8_5 != null) {
                            }
                            ** GOTO lbl35
                            {
                                catch (Throwable var9_7) {
                                    if (var8_5 != null) {
                                        var8_5.close();
                                    }
                                    throw var9_7;
                                }
                                {
                                    var8_5.close();
                                }
lbl35:
                                // 2 sources

                                this.releaseReference();
                                return false;
lbl37:
                                // 1 sources

                                if (var8_5 == null) break block15;
                                var8_5.close();
                                break block15;
                            }
                        }
                        this.releaseReference();
                        return true;
                    }
                    catch (Throwable var2_10) {
                        ** continue;
                    }
                    var1_1.add(new Pair<String, String>("main", this.getPath()));
                }
            }
            var6_3 = 0;
            ** GOTO lbl-1000
        }
        ++var6_3;
        ** while (true)
    }

    public boolean isDbLockedByCurrentThread() {
        this.acquireReference();
        try {
            boolean bl = this.getThreadSession().hasConnection();
            return bl;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean isDbLockedByOtherThreads() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isInMemoryDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfigurationLocked.isInMemoryDb();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOpen() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConnectionPoolLocked == null) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReadOnly() {
        Object object = this.mLock;
        synchronized (object) {
            return this.isReadOnlyLocked();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isWriteAheadLoggingEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if ((0x20000000 & this.mConfigurationLocked.openFlags) == 0) return false;
            return true;
        }
    }

    @Deprecated
    public void markTableSyncable(String string2, String string3) {
    }

    @Deprecated
    public void markTableSyncable(String string2, String string3, String string4) {
    }

    public boolean needUpgrade(int n) {
        return n > this.getVersion();
    }

    @Override
    protected void onAllReferencesReleased() {
        this.dispose(false);
    }

    void onCorruption() {
        EventLog.writeEvent(75004, this.getLabel());
        this.mErrorHandler.onCorruption(this);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6) {
        return this.query(false, string2, stringArray, string3, stringArray2, string4, string5, string6, null);
    }

    public Cursor query(String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return this.query(false, string2, stringArray, string3, stringArray2, string4, string5, string6, string7);
    }

    public Cursor query(boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return this.queryWithFactory(null, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7, null);
    }

    public Cursor query(boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7, CancellationSignal cancellationSignal) {
        return this.queryWithFactory(null, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7, cancellationSignal);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7) {
        return this.queryWithFactory(cursorFactory, bl, string2, stringArray, string3, stringArray2, string4, string5, string6, string7, null);
    }

    public Cursor queryWithFactory(CursorFactory cursorFactory, boolean bl, String string2, String[] stringArray, String string3, String[] stringArray2, String string4, String string5, String string6, String string7, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            Cursor cursor = this.rawQueryWithFactory(cursorFactory, SQLiteQueryBuilder.buildQueryString(bl, string2, stringArray, string3, string4, string5, string6, string7), stringArray2, SQLiteDatabase.findEditTable(string2), cancellationSignal);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    public Cursor rawQuery(String string2, String[] stringArray) {
        return this.rawQueryWithFactory(null, string2, stringArray, null, null);
    }

    public Cursor rawQuery(String string2, String[] stringArray, CancellationSignal cancellationSignal) {
        return this.rawQueryWithFactory(null, string2, stringArray, null, cancellationSignal);
    }

    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string2, String[] stringArray, String string3) {
        return this.rawQueryWithFactory(cursorFactory, string2, stringArray, string3, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cursor rawQueryWithFactory(CursorFactory cursorFactory, String string2, String[] stringArray, String string3, CancellationSignal cancellationSignal) {
        this.acquireReference();
        try {
            SQLiteDirectCursorDriver sQLiteDirectCursorDriver = new SQLiteDirectCursorDriver(this, string2, string3, cancellationSignal);
            if (cursorFactory == null) {
                cursorFactory = this.mCursorFactory;
            }
            Cursor cursor = sQLiteDirectCursorDriver.query(cursorFactory, stringArray);
            return cursor;
        }
        finally {
            this.releaseReference();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reopenReadWrite() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (!this.isReadOnlyLocked()) {
                return;
            }
            int n = this.mConfigurationLocked.openFlags;
            this.mConfigurationLocked.openFlags = 0 | 0xFFFFFFFE & this.mConfigurationLocked.openFlags;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.mConfigurationLocked.openFlags = n;
                throw runtimeException;
            }
        }
    }

    public long replace(String string2, String string3, ContentValues contentValues) {
        try {
            long l = this.insertWithOnConflict(string2, string3, contentValues, 5);
            return l;
        }
        catch (SQLException sQLException) {
            Log.e(TAG, "Error inserting ", sQLException);
            return -1L;
        }
    }

    public long replaceOrThrow(String string2, String string3, ContentValues contentValues) throws SQLException {
        return this.insertWithOnConflict(string2, string3, contentValues, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setForeignKeyConstraintsEnabled(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            if (this.mConfigurationLocked.foreignKeyConstraintsEnabled == bl) {
                return;
            }
            this.mConfigurationLocked.foreignKeyConstraintsEnabled = bl;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration = this.mConfigurationLocked;
                boolean bl2 = !bl;
                sQLiteDatabaseConfiguration.foreignKeyConstraintsEnabled = bl2;
                throw runtimeException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            Locale locale2 = this.mConfigurationLocked.locale;
            this.mConfigurationLocked.locale = locale;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.mConfigurationLocked.locale = locale2;
                throw runtimeException;
            }
        }
    }

    @Deprecated
    public void setLockingEnabled(boolean bl) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaxSqlCacheSize(int n) {
        if (n > 100 || n < 0) {
            throw new IllegalStateException("expected value between 0 and 100");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfNotOpenLocked();
            int n2 = this.mConfigurationLocked.maxSqlCacheSize;
            this.mConfigurationLocked.maxSqlCacheSize = n;
            try {
                this.mConnectionPoolLocked.reconfigure(this.mConfigurationLocked);
                return;
            }
            catch (RuntimeException runtimeException) {
                this.mConfigurationLocked.maxSqlCacheSize = n2;
                throw runtimeException;
            }
        }
    }

    public long setMaximumSize(long l) {
        long l2 = this.getPageSize();
        long l3 = l / l2;
        if (l % l2 != 0L) {
            ++l3;
        }
        return l2 * DatabaseUtils.longForQuery(this, "PRAGMA max_page_count = " + l3, null);
    }

    public void setPageSize(long l) {
        this.execSQL("PRAGMA page_size = " + l);
    }

    public void setTransactionSuccessful() {
        this.acquireReference();
        try {
            this.getThreadSession().setTransactionSuccessful();
            return;
        }
        finally {
            this.releaseReference();
        }
    }

    public void setVersion(int n) {
        this.execSQL("PRAGMA user_version = " + n);
    }

    public String toString() {
        return "SQLiteDatabase: " + this.getPath();
    }

    public int update(String string2, ContentValues contentValues, String string3, String[] stringArray) {
        return this.updateWithOnConflict(string2, contentValues, string3, stringArray, 0);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateWithOnConflict(String string2, ContentValues contentValues, String string3, String[] stringArray, int n) {
        int n2;
        Object[] objectArray;
        StringBuilder stringBuilder;
        block12: {
            if (contentValues == null) throw new IllegalArgumentException("Empty values");
            if (contentValues.size() == 0) {
                throw new IllegalArgumentException("Empty values");
            }
            this.acquireReference();
            stringBuilder = new StringBuilder(120);
            stringBuilder.append("UPDATE ");
            stringBuilder.append(CONFLICT_VALUES[n]);
            stringBuilder.append(string2);
            stringBuilder.append(" SET ");
            int n3 = contentValues.size();
            int n4 = stringArray == null ? n3 : n3 + stringArray.length;
            objectArray = new Object[n4];
            Iterator<String> iterator = contentValues.keySet().iterator();
            int n5 = 0;
            while (iterator.hasNext()) {
                String string4 = iterator.next();
                String string5 = n5 > 0 ? "," : "";
                stringBuilder.append(string5);
                stringBuilder.append(string4);
                int n6 = n5 + 1;
                objectArray[n5] = contentValues.get(string4);
                stringBuilder.append("=?");
                n5 = n6;
            }
            if (stringArray == null) break block12;
            for (int i = n3; i < n4; ++i) {
                objectArray[i] = stringArray[i - n3];
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        if (!TextUtils.isEmpty(string3)) {
            stringBuilder.append(" WHERE ");
            stringBuilder.append(string3);
        }
        SQLiteStatement sQLiteStatement = new SQLiteStatement(this, stringBuilder.toString(), objectArray);
        try {
            n2 = sQLiteStatement.executeUpdateDelete();
        }
        catch (Throwable throwable) {
            sQLiteStatement.close();
            throw throwable;
        }
        try {
            sQLiteStatement.close();
            return n2;
        }
        finally {
            this.releaseReference();
        }
    }

    @Deprecated
    public boolean yieldIfContended() {
        return this.yieldIfContendedHelper(false, -1L);
    }

    public boolean yieldIfContendedSafely() {
        return this.yieldIfContendedHelper(true, -1L);
    }

    public boolean yieldIfContendedSafely(long l) {
        return this.yieldIfContendedHelper(true, l);
    }

    public static interface CursorFactory {
        public Cursor newCursor(SQLiteDatabase var1, SQLiteCursorDriver var2, String var3, SQLiteQuery var4);
    }

    public static interface CustomFunction {
        public void callback(String[] var1);
    }
}

