/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import java.io.Closeable;

public abstract class SQLiteClosable
implements Closeable {
    private int mReferenceCount = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquireReference() {
        synchronized (this) {
            if (this.mReferenceCount <= 0) {
                throw new IllegalStateException("attempt to re-open an already-closed object: " + this);
            }
            this.mReferenceCount = 1 + this.mReferenceCount;
            return;
        }
    }

    @Override
    public void close() {
        this.releaseReference();
    }

    protected abstract void onAllReferencesReleased();

    @Deprecated
    protected void onAllReferencesReleasedFromContainer() {
        this.onAllReferencesReleased();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseReference() {
        boolean bl;
        synchronized (this) {
            int n;
            this.mReferenceCount = n = -1 + this.mReferenceCount;
            if (n != 0) return;
            bl = true;
        }
        if (!bl) return;
        this.onAllReferencesReleased();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public void releaseReferenceFromContainer() {
        boolean bl;
        synchronized (this) {
            int n;
            this.mReferenceCount = n = -1 + this.mReferenceCount;
            if (n != 0) return;
            bl = true;
        }
        if (!bl) return;
        this.onAllReferencesReleasedFromContainer();
    }
}

