/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.AbstractCursor;
import android.database.AbstractWindowedCursor;
import android.database.BulkCursorDescriptor;
import android.database.DatabaseUtils;
import android.database.IBulkCursor;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

public final class BulkCursorToCursorAdaptor
extends AbstractWindowedCursor {
    private static final String TAG = "BulkCursor";
    private IBulkCursor mBulkCursor;
    private String[] mColumns;
    private int mCount;
    private AbstractCursor.SelfContentObserver mObserverBridge = new AbstractCursor.SelfContentObserver(this);
    private boolean mWantsAllOnMoveCalls;

    private void throwIfCursorIsClosed() {
        if (this.mBulkCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() {
        super.close();
        if (this.mBulkCursor == null) return;
        try {
            this.mBulkCursor.close();
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Remote process exception when closing");
            return;
        }
        finally {
            this.mBulkCursor = null;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deactivate() {
        super.deactivate();
        if (this.mBulkCursor == null) return;
        try {
            this.mBulkCursor.deactivate();
            return;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Remote process exception when deactivating");
            return;
        }
    }

    @Override
    public String[] getColumnNames() {
        this.throwIfCursorIsClosed();
        return this.mColumns;
    }

    @Override
    public int getCount() {
        this.throwIfCursorIsClosed();
        return this.mCount;
    }

    @Override
    public Bundle getExtras() {
        this.throwIfCursorIsClosed();
        try {
            Bundle bundle = this.mBulkCursor.getExtras();
            return bundle;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException(remoteException);
        }
    }

    public IContentObserver getObserver() {
        return this.mObserverBridge.getContentObserver();
    }

    public void initialize(BulkCursorDescriptor bulkCursorDescriptor) {
        this.mBulkCursor = bulkCursorDescriptor.cursor;
        this.mColumns = bulkCursorDescriptor.columnNames;
        this.mRowIdColumnIndex = DatabaseUtils.findRowIdColumnIndex(this.mColumns);
        this.mWantsAllOnMoveCalls = bulkCursorDescriptor.wantsAllOnMoveCalls;
        this.mCount = bulkCursorDescriptor.count;
        if (bulkCursorDescriptor.window != null) {
            this.setWindow(bulkCursorDescriptor.window);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean onMove(int n, int n2) {
        this.throwIfCursorIsClosed();
        try {
            if (this.mWindow == null || n2 < this.mWindow.getStartPosition() || n2 >= this.mWindow.getStartPosition() + this.mWindow.getNumRows()) {
                this.setWindow(this.mBulkCursor.getWindow(n2));
                return this.mWindow != null;
            } else {
                if (!this.mWantsAllOnMoveCalls) return this.mWindow != null;
                this.mBulkCursor.onMove(n2);
            }
            return this.mWindow != null;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Unable to get window because the remote process is dead");
            return false;
        }
    }

    @Override
    public boolean requery() {
        block3: {
            this.throwIfCursorIsClosed();
            try {
                this.mCount = this.mBulkCursor.requery(this.getObserver());
                if (this.mCount == -1) break block3;
                this.mPos = -1;
                this.closeWindow();
                super.requery();
                return true;
            }
            catch (Exception exception) {
                Log.e(TAG, "Unable to requery because the remote process exception " + exception.getMessage());
                this.deactivate();
                return false;
            }
        }
        this.deactivate();
        return false;
    }

    @Override
    public Bundle respond(Bundle bundle) {
        this.throwIfCursorIsClosed();
        try {
            Bundle bundle2 = this.mBulkCursor.respond(bundle);
            return bundle2;
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "respond() threw RemoteException, returning an empty bundle.", remoteException);
            return Bundle.EMPTY;
        }
    }
}

