/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.StringBlock;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParserException;

final class XmlBlock {
    private static final boolean DEBUG;
    private final AssetManager mAssets;
    private final long mNative;
    private boolean mOpen = true;
    private int mOpenCount = 1;
    final StringBlock mStrings;

    XmlBlock(AssetManager assetManager, long l) {
        this.mAssets = assetManager;
        this.mNative = l;
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(l), false);
    }

    public XmlBlock(byte[] byArray) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(byArray, 0, byArray.length);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    public XmlBlock(byte[] byArray, int n, int n2) {
        this.mAssets = null;
        this.mNative = XmlBlock.nativeCreate(byArray, n, n2);
        this.mStrings = new StringBlock(XmlBlock.nativeGetStringBlock(this.mNative), false);
    }

    static /* synthetic */ int access$008(XmlBlock xmlBlock) {
        int n = xmlBlock.mOpenCount;
        xmlBlock.mOpenCount = n + 1;
        return n;
    }

    private void decOpenCountLocked() {
        this.mOpenCount = -1 + this.mOpenCount;
        if (this.mOpenCount == 0) {
            XmlBlock.nativeDestroy(this.mNative);
            if (this.mAssets != null) {
                this.mAssets.xmlBlockGone(this.hashCode());
            }
        }
    }

    private static final native long nativeCreate(byte[] var0, int var1, int var2);

    private static final native long nativeCreateParseState(long var0);

    private static final native void nativeDestroy(long var0);

    private static final native void nativeDestroyParseState(long var0);

    private static final native int nativeGetAttributeCount(long var0);

    private static final native int nativeGetAttributeData(long var0, int var2);

    private static final native int nativeGetAttributeDataType(long var0, int var2);

    private static final native int nativeGetAttributeIndex(long var0, String var2, String var3);

    private static final native int nativeGetAttributeName(long var0, int var2);

    private static final native int nativeGetAttributeNamespace(long var0, int var2);

    private static final native int nativeGetAttributeResource(long var0, int var2);

    private static final native int nativeGetAttributeStringValue(long var0, int var2);

    private static final native int nativeGetClassAttribute(long var0);

    private static final native int nativeGetIdAttribute(long var0);

    private static final native int nativeGetLineNumber(long var0);

    static final native int nativeGetName(long var0);

    private static final native int nativeGetNamespace(long var0);

    private static final native long nativeGetStringBlock(long var0);

    private static final native int nativeGetStyleAttribute(long var0);

    private static final native int nativeGetText(long var0);

    static final native int nativeNext(long var0);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        synchronized (this) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decOpenCountLocked();
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlResourceParser newParser() {
        synchronized (this) {
            if (this.mNative == 0L) return null;
            return new Parser(XmlBlock.nativeCreateParseState(this.mNative), this);
        }
    }

    final class Parser
    implements XmlResourceParser {
        private final XmlBlock mBlock;
        private boolean mDecNextDepth = false;
        private int mDepth = 0;
        private int mEventType = 0;
        long mParseState;
        private boolean mStarted = false;

        Parser(long l, XmlBlock xmlBlock2) {
            this.mParseState = l;
            this.mBlock = xmlBlock2;
            XmlBlock.access$008(xmlBlock2);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void close() {
            XmlBlock xmlBlock = this.mBlock;
            synchronized (xmlBlock) {
                if (this.mParseState != 0L) {
                    XmlBlock.nativeDestroyParseState(this.mParseState);
                    this.mParseState = 0L;
                    this.mBlock.decOpenCountLocked();
                }
                return;
            }
        }

        @Override
        public void defineEntityReplacementText(String string2, String string3) throws XmlPullParserException {
            throw new XmlPullParserException("defineEntityReplacementText() not supported");
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        @Override
        public boolean getAttributeBooleanValue(int n, boolean bl) {
            int n2 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n2 >= 16 && n2 <= 31) {
                return XmlBlock.nativeGetAttributeData(this.mParseState, n) != 0;
            }
            return bl;
        }

        @Override
        public boolean getAttributeBooleanValue(String string2, String string3, boolean bl) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n >= 0) {
                bl = this.getAttributeBooleanValue(n, bl);
            }
            return bl;
        }

        @Override
        public int getAttributeCount() {
            if (this.mEventType == 2) {
                return XmlBlock.nativeGetAttributeCount(this.mParseState);
            }
            return -1;
        }

        @Override
        public float getAttributeFloatValue(int n, float f) {
            if (XmlBlock.nativeGetAttributeDataType(this.mParseState, n) == 4) {
                return Float.intBitsToFloat(XmlBlock.nativeGetAttributeData(this.mParseState, n));
            }
            throw new RuntimeException("not a float!");
        }

        @Override
        public float getAttributeFloatValue(String string2, String string3, float f) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n >= 0) {
                f = this.getAttributeFloatValue(n, f);
            }
            return f;
        }

        @Override
        public int getAttributeIntValue(int n, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 >= 16 && n3 <= 31) {
                n2 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            }
            return n2;
        }

        @Override
        public int getAttributeIntValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 >= 0) {
                n = this.getAttributeIntValue(n2, n);
            }
            return n;
        }

        @Override
        public int getAttributeListValue(int n, String[] stringArray, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            int n4 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            if (n3 == 3) {
                n4 = XmlUtils.convertValueToList(XmlBlock.this.mStrings.get(n4), stringArray, n2);
            }
            return n4;
        }

        @Override
        public int getAttributeListValue(String string2, String string3, String[] stringArray, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 >= 0) {
                n = this.getAttributeListValue(n2, stringArray, n);
            }
            return n;
        }

        @Override
        public String getAttributeName(int n) {
            int n2 = XmlBlock.nativeGetAttributeName(this.mParseState, n);
            if (n2 >= 0) {
                return XmlBlock.this.mStrings.get(n2).toString();
            }
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }

        @Override
        public int getAttributeNameResource(int n) {
            return XmlBlock.nativeGetAttributeResource(this.mParseState, n);
        }

        @Override
        public String getAttributeNamespace(int n) {
            int n2 = XmlBlock.nativeGetAttributeNamespace(this.mParseState, n);
            if (n2 >= 0) {
                return XmlBlock.this.mStrings.get(n2).toString();
            }
            if (n2 == -1) {
                return "";
            }
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }

        @Override
        public String getAttributePrefix(int n) {
            throw new RuntimeException("getAttributePrefix not supported");
        }

        @Override
        public int getAttributeResourceValue(int n, int n2) {
            if (XmlBlock.nativeGetAttributeDataType(this.mParseState, n) == 1) {
                n2 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            }
            return n2;
        }

        @Override
        public int getAttributeResourceValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 >= 0) {
                n = this.getAttributeResourceValue(n2, n);
            }
            return n;
        }

        @Override
        public String getAttributeType(int n) {
            return "CDATA";
        }

        @Override
        public int getAttributeUnsignedIntValue(int n, int n2) {
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 >= 16 && n3 <= 31) {
                n2 = XmlBlock.nativeGetAttributeData(this.mParseState, n);
            }
            return n2;
        }

        @Override
        public int getAttributeUnsignedIntValue(String string2, String string3, int n) {
            int n2 = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n2 >= 0) {
                n = this.getAttributeUnsignedIntValue(n2, n);
            }
            return n;
        }

        @Override
        public String getAttributeValue(int n) {
            int n2 = XmlBlock.nativeGetAttributeStringValue(this.mParseState, n);
            if (n2 >= 0) {
                return XmlBlock.this.mStrings.get(n2).toString();
            }
            int n3 = XmlBlock.nativeGetAttributeDataType(this.mParseState, n);
            if (n3 == 0) {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
            return TypedValue.coerceToString(n3, XmlBlock.nativeGetAttributeData(this.mParseState, n));
        }

        @Override
        public String getAttributeValue(String string2, String string3) {
            int n = XmlBlock.nativeGetAttributeIndex(this.mParseState, string2, string3);
            if (n >= 0) {
                return this.getAttributeValue(n);
            }
            return null;
        }

        @Override
        public String getClassAttribute() {
            int n = XmlBlock.nativeGetClassAttribute(this.mParseState);
            if (n >= 0) {
                return XmlBlock.this.mStrings.get(n).toString();
            }
            return null;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public int getDepth() {
            return this.mDepth;
        }

        @Override
        public int getEventType() throws XmlPullParserException {
            return this.mEventType;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean getFeature(String string2) {
            return "http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2) || "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2);
        }

        @Override
        public String getIdAttribute() {
            int n = XmlBlock.nativeGetIdAttribute(this.mParseState);
            if (n >= 0) {
                return XmlBlock.this.mStrings.get(n).toString();
            }
            return null;
        }

        @Override
        public int getIdAttributeResourceValue(int n) {
            return this.getAttributeResourceValue(null, "id", n);
        }

        @Override
        public String getInputEncoding() {
            return null;
        }

        @Override
        public int getLineNumber() {
            return XmlBlock.nativeGetLineNumber(this.mParseState);
        }

        @Override
        public String getName() {
            int n = XmlBlock.nativeGetName(this.mParseState);
            if (n >= 0) {
                return XmlBlock.this.mStrings.get(n).toString();
            }
            return null;
        }

        @Override
        public String getNamespace() {
            int n = XmlBlock.nativeGetNamespace(this.mParseState);
            if (n >= 0) {
                return XmlBlock.this.mStrings.get(n).toString();
            }
            return "";
        }

        @Override
        public String getNamespace(String string2) {
            throw new RuntimeException("getNamespace() not supported");
        }

        @Override
        public int getNamespaceCount(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceCount() not supported");
        }

        @Override
        public String getNamespacePrefix(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespacePrefix() not supported");
        }

        @Override
        public String getNamespaceUri(int n) throws XmlPullParserException {
            throw new XmlPullParserException("getNamespaceUri() not supported");
        }

        final CharSequence getPooledString(int n) {
            return XmlBlock.this.mStrings.get(n);
        }

        @Override
        public String getPositionDescription() {
            return "Binary XML file line #" + this.getLineNumber();
        }

        @Override
        public String getPrefix() {
            throw new RuntimeException("getPrefix not supported");
        }

        @Override
        public Object getProperty(String string2) {
            return null;
        }

        @Override
        public int getStyleAttribute() {
            return XmlBlock.nativeGetStyleAttribute(this.mParseState);
        }

        @Override
        public String getText() {
            int n = XmlBlock.nativeGetText(this.mParseState);
            if (n >= 0) {
                return XmlBlock.this.mStrings.get(n).toString();
            }
            return null;
        }

        @Override
        public char[] getTextCharacters(int[] nArray) {
            String string2 = this.getText();
            char[] cArray = null;
            if (string2 != null) {
                nArray[0] = 0;
                nArray[1] = string2.length();
                cArray = new char[string2.length()];
                string2.getChars(0, string2.length(), cArray, 0);
            }
            return cArray;
        }

        @Override
        public boolean isAttributeDefault(int n) {
            return false;
        }

        @Override
        public boolean isEmptyElementTag() throws XmlPullParserException {
            return false;
        }

        @Override
        public boolean isWhitespace() throws XmlPullParserException {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int next() throws XmlPullParserException, IOException {
            if (!this.mStarted) {
                this.mStarted = true;
                return 0;
            }
            if (this.mParseState == 0L) {
                return 1;
            }
            int n = XmlBlock.nativeNext(this.mParseState);
            if (this.mDecNextDepth) {
                this.mDepth = -1 + this.mDepth;
                this.mDecNextDepth = false;
            }
            switch (n) {
                case 2: {
                    this.mDepth = 1 + this.mDepth;
                }
                default: {
                    break;
                }
                case 3: {
                    this.mDecNextDepth = true;
                }
            }
            this.mEventType = n;
            if (n != 1) return n;
            this.close();
            return n;
        }

        @Override
        public int nextTag() throws XmlPullParserException, IOException {
            int n = this.next();
            if (n == 4 && this.isWhitespace()) {
                n = this.next();
            }
            if (n != 2 && n != 3) {
                throw new XmlPullParserException(this.getPositionDescription() + ": expected start or end tag", this, null);
            }
            return n;
        }

        @Override
        public String nextText() throws XmlPullParserException, IOException {
            block8: {
                String string2;
                block7: {
                    int n;
                    block6: {
                        if (this.getEventType() != 2) {
                            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG to read next text", this, null);
                        }
                        n = this.next();
                        if (n != 4) break block6;
                        string2 = this.getText();
                        if (this.next() != 3) {
                            throw new XmlPullParserException(this.getPositionDescription() + ": event TEXT it must be immediately followed by END_TAG", this, null);
                        }
                        break block7;
                    }
                    if (n != 3) break block8;
                    string2 = "";
                }
                return string2;
            }
            throw new XmlPullParserException(this.getPositionDescription() + ": parser must be on START_TAG or TEXT to read text", this, null);
        }

        @Override
        public int nextToken() throws XmlPullParserException, IOException {
            return this.next();
        }

        @Override
        public void require(int n, String string2, String string3) throws XmlPullParserException, IOException {
            if (n != this.getEventType() || string2 != null && !string2.equals(this.getNamespace()) || string3 != null && !string3.equals(this.getName())) {
                throw new XmlPullParserException("expected " + TYPES[n] + this.getPositionDescription());
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void setFeature(String string2, boolean bl) throws XmlPullParserException {
            if ("http://xmlpull.org/v1/doc/features.html#process-namespaces".equals(string2) && bl || "http://xmlpull.org/v1/doc/features.html#report-namespace-prefixes".equals(string2) && bl) {
                return;
            }
            throw new XmlPullParserException("Unsupported feature: " + string2);
        }

        @Override
        public void setInput(InputStream inputStream, String string2) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void setInput(Reader reader) throws XmlPullParserException {
            throw new XmlPullParserException("setInput() not supported");
        }

        @Override
        public void setProperty(String string2, Object object) throws XmlPullParserException {
            throw new XmlPullParserException("setProperty() not supported");
        }
    }
}

