/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.XmlBlock;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.util.XmlUtils;
import java.util.Arrays;

public class TypedArray {
    private final AssetManager mAssets;
    int[] mData;
    int[] mIndices;
    int mLength;
    private final DisplayMetrics mMetrics;
    private boolean mRecycled;
    private final Resources mResources;
    Resources.Theme mTheme;
    TypedValue mValue = new TypedValue();
    XmlBlock.Parser mXml;

    TypedArray(Resources resources, int[] nArray, int[] nArray2, int n) {
        this.mResources = resources;
        this.mMetrics = this.mResources.mMetrics;
        this.mAssets = this.mResources.mAssets;
        this.mData = nArray;
        this.mIndices = nArray2;
        this.mLength = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean getValueAt(int n, TypedValue typedValue) {
        int[] nArray = this.mData;
        int n2 = nArray[n + 0];
        if (n2 == 0) {
            return false;
        }
        typedValue.type = n2;
        typedValue.data = nArray[n + 1];
        typedValue.assetCookie = nArray[n + 2];
        typedValue.resourceId = nArray[n + 3];
        typedValue.changingConfigurations = nArray[n + 4];
        typedValue.density = nArray[n + 5];
        CharSequence charSequence = n2 == 3 ? this.loadStringValueAt(n) : null;
        typedValue.string = charSequence;
        return true;
    }

    private CharSequence loadStringValueAt(int n) {
        int[] nArray = this.mData;
        int n2 = nArray[n + 2];
        if (n2 < 0) {
            if (this.mXml != null) {
                return this.mXml.getPooledString(nArray[n + 1]);
            }
            return null;
        }
        return this.mAssets.getPooledStringForCookie(n2, nArray[n + 1]);
    }

    static TypedArray obtain(Resources resources, int n) {
        TypedArray typedArray = resources.mTypedArrayPool.acquire();
        if (typedArray != null) {
            typedArray.mLength = n;
            typedArray.mRecycled = false;
            int n2 = n * 6;
            if (typedArray.mData.length >= n2) {
                return typedArray;
            }
            typedArray.mData = new int[n2];
            typedArray.mIndices = new int[n + 1];
            return typedArray;
        }
        return new TypedArray(resources, new int[n * 6], new int[n + 1], n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int[] extractThemeAttrs() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = null;
        int[] nArray2 = this.mData;
        int n = this.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 * 6;
            if (nArray2[n3 + 0] == 2) {
                nArray2[n3 + 0] = 0;
                int n4 = nArray2[n3 + 1];
                if (n4 != 0) {
                    if (nArray == null) {
                        nArray = new int[n];
                    }
                    nArray[n2] = n4;
                }
            }
            ++n2;
        }
        return nArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getBoolean(int n, boolean bl) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = nArray[n2 + 0];
        if (n3 == 0) {
            return bl;
        }
        if (n3 >= 16 && n3 <= 31) {
            if (nArray[n2 + 1] == 0) return false;
            return true;
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            Log.w("Resources", "Converting to boolean: " + typedValue);
            return XmlUtils.convertValueToBoolean(typedValue.coerceToString(), bl);
        }
        Log.w("Resources", "getBoolean of bad type: 0x" + Integer.toHexString(n3));
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getChangingConfigurations() {
        int n = 0;
        int[] nArray = this.mData;
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * 6;
            if (nArray[n4 + 0] != 0) {
                n |= nArray[n4 + 4];
            }
            ++n3;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int getColor(int n, int n2) {
        int n3;
        int n4;
        block7: {
            TypedValue typedValue;
            block8: {
                block6: {
                    if (this.mRecycled) {
                        throw new RuntimeException("Cannot make calls to a recycled instance!");
                    }
                    int[] nArray = this.mData;
                    n4 = n * 6;
                    n3 = nArray[n4 + 0];
                    if (n3 == 0) break block6;
                    if (n3 >= 16 && n3 <= 31) {
                        return nArray[n4 + 1];
                    }
                    if (n3 != 3) break block7;
                    typedValue = this.mValue;
                    if (this.getValueAt(n4, typedValue)) break block8;
                }
                return n2;
            }
            return this.mResources.loadColorStateList(typedValue, typedValue.resourceId).getDefaultColor();
        }
        if (n3 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n4);
        }
        throw new UnsupportedOperationException("Can't convert to color: type=0x" + Integer.toHexString(n3));
    }

    public ColorStateList getColorStateList(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n * 6, typedValue)) {
            if (typedValue.type == 2) {
                throw new RuntimeException("Failed to resolve attribute at index " + n);
            }
            return this.mResources.loadColorStateList(typedValue, typedValue.resourceId);
        }
        return null;
    }

    public float getDimension(int n, float f) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = nArray[n2 + 0];
        if (n3 == 0) {
            return f;
        }
        if (n3 == 5) {
            return TypedValue.complexToDimension(nArray[n2 + 1], this.mMetrics);
        }
        if (n3 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n2);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(n3));
    }

    public int getDimensionPixelOffset(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = nArray[n3 + 0];
        if (n4 == 0) {
            return n2;
        }
        if (n4 == 5) {
            return TypedValue.complexToDimensionPixelOffset(nArray[n3 + 1], this.mMetrics);
        }
        if (n4 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n3);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(n4));
    }

    public int getDimensionPixelSize(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = nArray[n3 + 0];
        if (n4 == 0) {
            return n2;
        }
        if (n4 == 5) {
            return TypedValue.complexToDimensionPixelSize(nArray[n3 + 1], this.mMetrics);
        }
        if (n4 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n3);
        }
        throw new UnsupportedOperationException("Can't convert to dimension: type=0x" + Integer.toHexString(n4));
    }

    public Drawable getDrawable(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n * 6, typedValue)) {
            if (typedValue.type == 2) {
                throw new RuntimeException("Failed to resolve attribute at index " + n);
            }
            return this.mResources.loadDrawable(typedValue, typedValue.resourceId, this.mTheme);
        }
        return null;
    }

    public float getFloat(int n, float f) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = nArray[n2 + 0];
        if (n3 == 0) {
            return f;
        }
        if (n3 == 4) {
            return Float.intBitsToFloat(nArray[n2 + 1]);
        }
        if (n3 >= 16 && n3 <= 31) {
            return nArray[n2 + 1];
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            Log.w("Resources", "Converting to float: " + typedValue);
            CharSequence charSequence = typedValue.coerceToString();
            if (charSequence != null) {
                return Float.parseFloat(charSequence.toString());
            }
        }
        Log.w("Resources", "getFloat of bad type: 0x" + Integer.toHexString(n3));
        return f;
    }

    public float getFraction(int n, int n2, int n3, float f) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n4 = n * 6;
        int n5 = nArray[n4 + 0];
        if (n5 == 0) {
            return f;
        }
        if (n5 == 6) {
            return TypedValue.complexToFraction(nArray[n4 + 1], n2, n3);
        }
        if (n5 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n4);
        }
        throw new UnsupportedOperationException("Can't convert to fraction: type=0x" + Integer.toHexString(n5));
    }

    public int getIndex(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[n + 1];
    }

    public int getIndexCount() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mIndices[0];
    }

    public int getInt(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = nArray[n3 + 0];
        if (n4 == 0) {
            return n2;
        }
        if (n4 >= 16 && n4 <= 31) {
            return nArray[n3 + 1];
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n3, typedValue)) {
            Log.w("Resources", "Converting to int: " + typedValue);
            return XmlUtils.convertValueToInt(typedValue.coerceToString(), n2);
        }
        Log.w("Resources", "getInt of bad type: 0x" + Integer.toHexString(n4));
        return n2;
    }

    public int getInteger(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = nArray[n3 + 0];
        if (n4 == 0) {
            return n2;
        }
        if (n4 >= 16 && n4 <= 31) {
            return nArray[n3 + 1];
        }
        if (n4 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n3);
        }
        throw new UnsupportedOperationException("Can't convert to integer: type=0x" + Integer.toHexString(n4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getLayoutDimension(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        int n4 = nArray[n3 + 0];
        if (n4 >= 16 && n4 <= 31) {
            return nArray[n3 + 1];
        }
        if (n4 != 5) return n2;
        return TypedValue.complexToDimensionPixelSize(nArray[n3 + 1], this.mMetrics);
    }

    public int getLayoutDimension(int n, String string2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n2 = n * 6;
        int n3 = nArray[n2 + 0];
        if (n3 >= 16 && n3 <= 31) {
            return nArray[n2 + 1];
        }
        if (n3 == 5) {
            return TypedValue.complexToDimensionPixelSize(nArray[n2 + 1], this.mMetrics);
        }
        if (n3 == 2) {
            throw new RuntimeException("Failed to resolve attribute at index " + n2);
        }
        throw new RuntimeException(this.getPositionDescription() + ": You must supply a " + string2 + " attribute.");
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getNonConfigurationString(int n, int n2) {
        CharSequence charSequence;
        block7: {
            block6: {
                if (this.mRecycled) {
                    throw new RuntimeException("Cannot make calls to a recycled instance!");
                }
                int n3 = n * 6;
                int[] nArray = this.mData;
                int n4 = nArray[n3 + 0];
                if ((nArray[n3 + 4] & ~n2) != 0 || n4 == 0) break block6;
                if (n4 == 3) {
                    return this.loadStringValueAt(n3).toString();
                }
                TypedValue typedValue = this.mValue;
                if (!this.getValueAt(n3, typedValue)) {
                    Log.w("Resources", "getString of bad type: 0x" + Integer.toHexString(n4));
                    return null;
                }
                Log.w("Resources", "Converting to string: " + typedValue);
                charSequence = typedValue.coerceToString();
                if (charSequence != null) break block7;
            }
            return null;
        }
        return charSequence.toString();
    }

    public String getNonResourceString(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n2 = n * 6;
        if (nArray[n2 + 0] == 3 && nArray[n2 + 2] < 0) {
            return this.mXml.getPooledString(nArray[n2 + 1]).toString();
        }
        return null;
    }

    public String getPositionDescription() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        if (this.mXml != null) {
            return this.mXml.getPositionDescription();
        }
        return "<internal>";
    }

    public int getResourceId(int n, int n2) {
        int n3;
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n4 = n * 6;
        if (nArray[n4 + 0] != 0 && (n3 = nArray[n4 + 3]) != 0) {
            return n3;
        }
        return n2;
    }

    public Resources getResources() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getString(int n) {
        CharSequence charSequence;
        block7: {
            block6: {
                if (this.mRecycled) {
                    throw new RuntimeException("Cannot make calls to a recycled instance!");
                }
                int n2 = n * 6;
                int n3 = this.mData[n2 + 0];
                if (n3 == 0) break block6;
                if (n3 == 3) {
                    return this.loadStringValueAt(n2).toString();
                }
                TypedValue typedValue = this.mValue;
                if (!this.getValueAt(n2, typedValue)) {
                    Log.w("Resources", "getString of bad type: 0x" + Integer.toHexString(n3));
                    return null;
                }
                Log.w("Resources", "Converting to string: " + typedValue);
                charSequence = typedValue.coerceToString();
                if (charSequence != null) break block7;
            }
            return null;
        }
        return charSequence.toString();
    }

    public CharSequence getText(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int n2 = n * 6;
        int n3 = this.mData[n2 + 0];
        if (n3 == 0) {
            return null;
        }
        if (n3 == 3) {
            return this.loadStringValueAt(n2);
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n2, typedValue)) {
            Log.w("Resources", "Converting to string: " + typedValue);
            return typedValue.coerceToString();
        }
        Log.w("Resources", "getString of bad type: 0x" + Integer.toHexString(n3));
        return null;
    }

    public CharSequence[] getTextArray(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n * 6, typedValue)) {
            return this.mResources.getTextArray(typedValue.resourceId);
        }
        return null;
    }

    public int getThemeAttributeId(int n, int n2) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int[] nArray = this.mData;
        int n3 = n * 6;
        if (nArray[n3 + 0] == 2) {
            n2 = nArray[n3 + 1];
        }
        return n2;
    }

    public int getType(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int n2 = n * 6;
        return this.mData[n2 + 0];
    }

    public boolean getValue(int n, TypedValue typedValue) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.getValueAt(n * 6, typedValue);
    }

    public boolean hasValue(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        int n2 = n * 6;
        return this.mData[n2 + 0] != 0;
    }

    public int length() {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        return this.mLength;
    }

    public TypedValue peekValue(int n) {
        if (this.mRecycled) {
            throw new RuntimeException("Cannot make calls to a recycled instance!");
        }
        TypedValue typedValue = this.mValue;
        if (this.getValueAt(n * 6, typedValue)) {
            return typedValue;
        }
        return null;
    }

    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        this.mXml = null;
        this.mTheme = null;
        this.mResources.mTypedArrayPool.release(this);
    }

    public String toString() {
        return Arrays.toString(this.mData);
    }
}

