/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.ThemeManager;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.JsonWriter;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ThemePack
implements Cloneable,
Parcelable,
Comparable<ThemePack> {
    public static final Parcelable.Creator<ThemePack> CREATOR;
    private static final String EMPTY_STRING;
    private static final ThemeDescription EMPTY_THEME_DESC;
    private static final String KEY_DEFAULT_PKG = "default";
    private static final String PKG_TAG_THEME_MODULE = "theme-module";
    private static final String PKG_TAG_THEME_MODULE_ASSET_PATH = "asset-path";
    private static final String PKG_TAG_THEME_MODULE_OVERLAY = "overlay";
    private static final String PKG_TAG_THEME_PACK_AUTHOR = "themepack-author";
    private static final String PKG_TAG_THEME_PACK_DESCRIPTION = "themepack-description";
    private static final String PKG_TAG_THEME_PACK_NAME = "themepack-name";
    private static final String PREVIEW_FOLDER = "previews";
    private static final ThemeModule sDeviceDefaultThemeModule;
    private static final ThemePack sDeviceDefaultThemePack;
    protected final String mPkgName;
    protected final ThemeDescription mThemeDesc;
    protected final Map<String, ThemeModule> mThemeModules = new HashMap<String, ThemeModule>();

    static {
        EMPTY_STRING = new String();
        EMPTY_THEME_DESC = new ThemeDescription();
        sDeviceDefaultThemePack = new ThemePack("com.asus.res.defaulttheme", new HashMap<String, ThemeModule>(0));
        sDeviceDefaultThemeModule = new ThemeModule("com.asus.res.defaulttheme");
        CREATOR = new Parcelable.Creator<ThemePack>(){

            @Override
            public ThemePack createFromParcel(Parcel parcel) {
                return JsonSerializer.fromJson(parcel.readString());
            }

            public ThemePack[] newArray(int n) {
                return new ThemePack[n];
            }
        };
    }

    public ThemePack(ThemePack themePack) {
        if (themePack != null) {
            this.mPkgName = themePack.mPkgName;
            this.mThemeDesc = themePack.mThemeDesc;
            this.mThemeModules.putAll(themePack.mThemeModules);
            return;
        }
        this.mPkgName = ThemePack.sDeviceDefaultThemePack.mPkgName;
        this.mThemeDesc = ThemePack.sDeviceDefaultThemePack.mThemeDesc;
        this.mThemeModules.putAll(ThemePack.sDeviceDefaultThemePack.mThemeModules);
    }

    public ThemePack(String string2, ThemeDescription themeDescription, Map<String, ThemeModule> map) {
        this.mPkgName = string2;
        this.mThemeDesc = themeDescription;
        if (map != null) {
            this.mThemeModules.putAll(map);
        }
    }

    private ThemePack(String string2, String string3, String string4, String string5, List<ThemeModule> list) {
        this.mPkgName = string2;
        this.mThemeDesc = new ThemeDescription(string3, string4, string5);
        if (list != null) {
            for (ThemeModule themeModule : list) {
                this.mThemeModules.put(themeModule.getTargetPkgName(), themeModule);
            }
        }
    }

    public ThemePack(String string2, String string3, String string4, String string5, Map<String, ThemeModule> map) {
        this.mPkgName = string2;
        this.mThemeDesc = new ThemeDescription(string3, string4, string5);
        if (map != null) {
            this.mThemeModules.putAll(map);
        }
    }

    public ThemePack(String string2, Map<String, ThemeModule> map) {
        this.mPkgName = string2;
        this.mThemeDesc = new ThemeDescription(EMPTY_STRING, EMPTY_STRING, EMPTY_STRING);
        if (map != null) {
            this.mThemeModules.putAll(map);
        }
    }

    static /* synthetic */ ThemeDescription access$100() {
        return EMPTY_THEME_DESC;
    }

    public static ThemePack getBootTheme() {
        return sDeviceDefaultThemePack;
    }

    private ThemeModule getDefaultThemeModule() {
        ThemeModule themeModule = this.mThemeModules.get(KEY_DEFAULT_PKG);
        if (themeModule == null) {
            themeModule = sDeviceDefaultThemeModule;
        }
        return themeModule;
    }

    private String[] getPaths(Context context) {
        AssetManager assetManager = new AssetManager();
        String[] stringArray = this.getPaths(context, assetManager);
        if (assetManager != null) {
            assetManager.close();
        }
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getPaths(Context context, AssetManager assetManager) {
        Object[] objectArray = new String[]{};
        PackageManager packageManager = context.getPackageManager();
        try {
            assetManager.addAssetPath(packageManager.getPackageInfo((String)this.mPkgName, (int)0).applicationInfo.sourceDir);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.d(ThemeManager.ASUS_THEME_LOG_TAG, "pkg name not found", nameNotFoundException);
        }
        try {
            objectArray = assetManager.list(PREVIEW_FOLDER);
            Arrays.sort(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            Log.d(ThemeManager.ASUS_THEME_LOG_TAG, "fail to list paths", exception);
            return objectArray;
        }
    }

    public static ThemePack getSystemTheme() {
        return sDeviceDefaultThemePack;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Bundle parseMetaData(Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, Bundle bundle, String[] stringArray) throws XmlPullParserException, IOException {
        TypedArray typedArray;
        block7: {
            block9: {
                TypedValue typedValue;
                String string2;
                block11: {
                    block10: {
                        block8: {
                            String string3;
                            typedArray = resources.obtainAttributes(attributeSet, R.styleable.AndroidManifestMetaData);
                            if (bundle == null) {
                                bundle = new Bundle();
                            }
                            if ((string3 = typedArray.getNonConfigurationString(0, 0)) == null) {
                                stringArray[0] = "<meta-data> requires an android:name attribute";
                                typedArray.recycle();
                                return null;
                            }
                            string2 = string3.intern();
                            TypedValue typedValue2 = typedArray.peekValue(2);
                            if (typedValue2 == null || typedValue2.resourceId == 0) break block8;
                            bundle.putInt(string2, typedValue2.resourceId);
                            break block7;
                        }
                        typedValue = typedArray.peekValue(1);
                        if (typedValue == null) break block9;
                        if (typedValue.type != 3) break block10;
                        CharSequence charSequence = typedValue.coerceToString();
                        String string4 = null;
                        if (charSequence != null) {
                            string4 = charSequence.toString().intern();
                        }
                        bundle.putString(string2, string4);
                        break block7;
                    }
                    if (typedValue.type != 18) break block11;
                    boolean bl = typedValue.data != 0;
                    bundle.putBoolean(string2, bl);
                    break block7;
                }
                if (typedValue.type >= 16 && typedValue.type <= 31) {
                    bundle.putInt(string2, typedValue.data);
                    break block7;
                } else if (typedValue.type == 4) {
                    bundle.putFloat(string2, typedValue.getFloat());
                    break block7;
                } else {
                    stringArray[0] = "<meta-data> only supports string, integer, float, color, boolean, and resource reference types";
                    bundle = null;
                }
                break block7;
            }
            stringArray[0] = "<meta-data> requires an android:value or android:resource attribute";
            bundle = null;
        }
        typedArray.recycle();
        XmlUtils.skipCurrentTag(xmlPullParser);
        return bundle;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ThemeModule parseThemeModule(PackageParser.Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        int n;
        Bundle bundle = new Bundle();
        String string2 = null;
        String string3 = null;
        int n2 = xmlPullParser.getDepth();
        while ((n = xmlPullParser.next()) != 1 && (n != 3 || xmlPullParser.getDepth() > n2)) {
            if (!xmlPullParser.getName().equals("meta-data")) continue;
            Bundle bundle2 = ThemePack.parseMetaData(resources, xmlPullParser, attributeSet, bundle, stringArray);
            if (bundle2 == null) {
                return null;
            }
            if (bundle2.containsKey(PKG_TAG_THEME_MODULE_ASSET_PATH)) {
                string2 = bundle2.getString(PKG_TAG_THEME_MODULE_ASSET_PATH);
            } else if (bundle2.containsKey(PKG_TAG_THEME_MODULE_OVERLAY)) {
                string3 = bundle2.getString(PKG_TAG_THEME_MODULE_OVERLAY);
            }
            bundle.clear();
        }
        if (TextUtils.isEmpty(string2)) {
            stringArray[0] = "<theme-module> does not specify asset-path";
            return null;
        }
        if (TextUtils.isEmpty(string3)) {
            stringArray[0] = "<theme-pack> does not specify overlay target";
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append(Environment.getDataDirectory()).append("/").append("themepack-module").append("/").append(package_.packageName).append("/").append(string2);
        return new ThemeModule(string3, string2, stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean parseThemePack(PackageParser.Package package_, Resources resources, XmlPullParser xmlPullParser, AttributeSet attributeSet, String[] stringArray) throws XmlPullParserException, IOException {
        if (package_.mThemePack != null) {
            stringArray[0] = "Multiple <theme-pack> elements definition found in manifest";
            return false;
        }
        Bundle bundle = new Bundle();
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ArrayList<ThemeModule> arrayList = new ArrayList<ThemeModule>();
        int n = xmlPullParser.getDepth();
        while (true) {
            Iterator iterator;
            ThemeModule themeModule;
            block20: {
                int n2;
                if ((n2 = xmlPullParser.next()) != 1 && (n2 != 3 || xmlPullParser.getDepth() > n)) {
                    if (xmlPullParser.getName().equals("meta-data")) {
                        Bundle bundle2 = ThemePack.parseMetaData(resources, xmlPullParser, attributeSet, bundle, stringArray);
                        if (bundle2 == null) {
                            return false;
                        }
                        if (bundle2.containsKey(PKG_TAG_THEME_PACK_NAME)) {
                            string2 = bundle2.getString(PKG_TAG_THEME_PACK_NAME);
                        } else if (bundle2.containsKey(PKG_TAG_THEME_PACK_AUTHOR)) {
                            string3 = bundle2.getString(PKG_TAG_THEME_PACK_AUTHOR);
                        } else if (bundle2.containsKey(PKG_TAG_THEME_PACK_DESCRIPTION)) {
                            string4 = bundle2.getString(PKG_TAG_THEME_PACK_DESCRIPTION);
                        } else {
                            XmlUtils.skipCurrentTag(xmlPullParser);
                        }
                        bundle.clear();
                        continue;
                    }
                    if (xmlPullParser.getName().equals(PKG_TAG_THEME_MODULE)) {
                        themeModule = ThemePack.parseThemeModule(package_, resources, xmlPullParser, attributeSet, stringArray);
                        if (themeModule == null) {
                            return false;
                        }
                        iterator = arrayList.iterator();
                        break block20;
                    } else {
                        XmlUtils.skipCurrentTag(xmlPullParser);
                        continue;
                    }
                }
                if (TextUtils.isEmpty(string2)) {
                    stringArray[0] = "<theme-pack> does not specify themepack-name";
                    return false;
                }
                if (TextUtils.isEmpty(string3)) {
                    stringArray[0] = "<theme-pack> does not specify themepack-author";
                    return false;
                }
                if (TextUtils.isEmpty(string4)) {
                    stringArray[0] = "<theme-pack> does not specify themepack-description";
                    return false;
                }
                if (arrayList.isEmpty()) {
                    stringArray[0] = "<theme-pack> must have at least one <theme-module> element";
                    return false;
                }
                package_.mIsThemePack = true;
                package_.mThemePack = new ThemePack(package_.packageName, string2, string3, string4, arrayList);
                package_.applicationInfo.isThemeable = false;
                return true;
            }
            while (iterator.hasNext()) {
                ThemeModule themeModule2 = (ThemeModule)iterator.next();
                if (themeModule2.getTargetPkgName().equals(themeModule.getTargetPkgName())) {
                    stringArray[0] = "Duplicate overlay targets found " + themeModule.getTargetPkgName();
                    return false;
                }
                if (!themeModule2.getAssetPath().equals(themeModule.getAssetPath())) continue;
                stringArray[0] = "Duplicate asset-path found " + themeModule.getAssetPath();
                return false;
            }
            arrayList.add(themeModule);
        }
    }

    public Object clone() {
        try {
            Object object = super.clone();
            return object;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log.d(ThemeManager.ASUS_THEME_LOG_TAG, "clone not supported", cloneNotSupportedException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(ThemePack themePack) {
        if (themePack == null) {
            return -1;
        }
        if (this.mPkgName == null) return -1;
        if (themePack.mPkgName == null) return -1;
        int n = this.mPkgName.compareTo(themePack.mPkgName);
        if (n != 0) return n;
        if (this.mThemeDesc == null) return -1;
        if (themePack.mThemeDesc == null) return -1;
        n = this.mThemeDesc.compareTo(themePack.mThemeDesc);
        if (n != 0) return n;
        if (!this.mThemeModules.equals(themePack.mThemeModules)) return 1;
        return 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block5: {
            block4: {
                if (object == this) break block4;
                if (!(object instanceof ThemePack)) {
                    return false;
                }
                ThemePack themePack = (ThemePack)object;
                String string2 = this.mPkgName == null ? EMPTY_STRING : this.mPkgName;
                String string3 = themePack.mPkgName == null ? EMPTY_STRING : themePack.mPkgName;
                ThemeDescription themeDescription = this.mThemeDesc == null ? EMPTY_THEME_DESC : this.mThemeDesc;
                ThemeDescription themeDescription2 = themePack.mThemeDesc == null ? EMPTY_THEME_DESC : themePack.mThemeDesc;
                Map<String, ThemeModule> map = this.mThemeModules == null ? new HashMap<String, ThemeModule>() : this.mThemeModules;
                Map<String, ThemeModule> map2 = themePack.mThemeModules == null ? new HashMap<String, ThemeModule>() : themePack.mThemeModules;
                if (!string2.equals(string3) || !themeDescription.equals(themeDescription2) || !map.equals(map2)) break block5;
            }
            return true;
        }
        return false;
    }

    public String getPkgName() {
        return this.mPkgName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Bitmap> getPreviews(Context context, ArrayList<Bitmap> arrayList) {
        if (arrayList != null) {
            AssetManager assetManager = new AssetManager();
            String[] stringArray = this.getPaths(context, assetManager);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                try {
                    arrayList.add(BitmapFactory.decodeStream(assetManager.open("previews/" + string2)));
                    continue;
                }
                catch (Exception exception) {
                    Log.d(ThemeManager.ASUS_THEME_LOG_TAG, "fail to read bitmap", exception);
                }
            }
            if (assetManager != null) {
                assetManager.close();
            }
        }
        return arrayList;
    }

    public String[] getPreviewsPath(Context context) {
        String[] stringArray = this.getPaths(context);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "previews/" + stringArray[i];
        }
        return stringArray;
    }

    public ThemeDescription getThemeDescription() {
        return this.mThemeDesc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap getThemeIcon(Context context) {
        AssetManager assetManager = new AssetManager();
        String[] stringArray = this.getPaths(context, assetManager);
        int n = stringArray.length;
        Bitmap bitmap = null;
        if (n > 0) {
            String string2 = stringArray[0];
            try {
                Bitmap bitmap2;
                bitmap = bitmap2 = BitmapFactory.decodeStream(assetManager.open("previews/" + string2));
            }
            catch (Exception exception) {
                Log.d(ThemeManager.ASUS_THEME_LOG_TAG, "fail to read bitmap", exception);
                bitmap = null;
            }
        }
        if (assetManager != null) {
            assetManager.close();
        }
        return bitmap;
    }

    public String getThemeIconPath(Context context) {
        String[] stringArray = this.getPaths(context);
        return "previews/" + stringArray[0];
    }

    public ThemeModule getThemeModuleForApp(String string2) {
        ThemeModule themeModule = this.mThemeModules.get(string2);
        if (themeModule == null) {
            themeModule = this.getDefaultThemeModule();
        }
        return themeModule;
    }

    public HashMap<String, ThemeModule> getThemeModules() {
        if (this.mThemeModules != null) {
            return new HashMap<String, ThemeModule>(this.mThemeModules);
        }
        return new HashMap<String, ThemeModule>();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mPkgName != null) {
            stringBuilder.append("theme:");
            stringBuilder.append(this.mPkgName);
        }
        if (this.mThemeDesc != null) {
            stringBuilder.append("theme-desc:");
            stringBuilder.append(this.mThemeDesc);
        }
        if (this.mThemeModules != null) {
            stringBuilder.append("theme-modules:");
            stringBuilder.append(this.mThemeModules);
        }
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(JsonSerializer.toJson(this));
    }

    public static class JsonSerializer {
        private static final String NAME_THEME_DESC_AUTHOR = "mAuthor";
        private static final String NAME_THEME_DESC_DESCRIPTION = "mDescription";
        private static final String NAME_THEME_DESC_NAME = "mName";
        private static final String NAME_THEME_DESC_TAG = "desc-info";
        private static final String NAME_THEME_MODULE_ARCHIVE_SRC_PATH = "mArchiveSrcPath";
        private static final String NAME_THEME_MODULE_ASSET_PATH = "mAssetPath";
        private static final String NAME_THEME_MODULE_TARGET_PKG = "mTargetPkgName";
        private static final String NAME_THEME_PACK_PKG = "mPkgName";

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void closeQuietly(JsonReader jsonReader) {
            if (jsonReader == null) return;
            try {
                jsonReader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void closeQuietly(JsonWriter jsonWriter) {
            if (jsonWriter == null) return;
            try {
                jsonWriter.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void closeQuietly(Reader reader) {
            if (reader == null) return;
            try {
                reader.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static void closeQuietly(Writer writer) {
            if (writer == null) return;
            try {
                writer.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ThemePack fromJson(String var0) {
            if (TextUtils.isEmpty(var0)) {
                return null;
            }
            var1_1 = ThemePack.access$000();
            var2_2 = ThemePack.access$100();
            var3_3 = new HashMap<String, ThemeModule>();
            var4_4 = null;
            var5_5 = null;
            var6_6 = new StringReader(var0);
            var7_7 = new JsonReader(var6_6);
            try {
                var7_7.beginObject();
                var1_1 = JsonSerializer.readThemePackPkgName(var7_7);
                var2_2 = JsonSerializer.readThemeDesc(var7_7);
                while (var7_7.hasNext()) {
                    var11_8 = new ThemeModule();
                    var3_3.put(JsonSerializer.readThemeModule(var7_7, var11_8), var11_8);
                }
                var7_7.endObject();
                ** GOTO lbl27
            }
            catch (Exception var9_9) {
                block14: {
                    var5_5 = var7_7;
                    var4_4 = var6_6;
                    break block14;
lbl27:
                    // 1 sources

                    JsonSerializer.closeQuietly(var6_6);
                    JsonSerializer.closeQuietly(var7_7);
                    return new ThemePack(var1_1, var2_2, var3_3);
                    catch (Throwable var8_15) {
                        var4_4 = var6_6;
                        var5_5 = null;
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var8_16) {
                        var5_5 = var7_7;
                        var4_4 = var6_6;
                        ** GOTO lbl-1000
                    }
                    catch (Exception var9_12) {
                        var4_4 = var6_6;
                        var5_5 = null;
                    }
                }
lbl42:
                // 2 sources

                while (true) {
                    try {
                        Log.e(ThemeManager.ASUS_THEME_LOG_TAG, "Could not parse ThemePack from: " + var0, (Throwable)var9_10);
                    }
                    catch (Throwable var8_13) lbl-1000:
                    // 3 sources

                    {
                        JsonSerializer.closeQuietly(var4_4);
                        JsonSerializer.closeQuietly(var5_5);
                        throw var8_14;
                    }
                    JsonSerializer.closeQuietly(var4_4);
                    JsonSerializer.closeQuietly(var5_5);
                    return new ThemePack(var1_1, var2_2, var3_3);
                }
            }
            catch (Exception var9_11) {
                var5_5 = null;
                var4_4 = null;
                ** continue;
            }
        }

        private static ThemeDescription readThemeDesc(JsonReader jsonReader) throws IOException {
            String string2 = jsonReader.nextName();
            if (!NAME_THEME_DESC_TAG.equals(string2) || jsonReader.peek() == JsonToken.NULL) {
                throw new IllegalStateException("Expected a desc-info but was " + string2);
            }
            ThemeDescription themeDescription = new ThemeDescription();
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String string3 = jsonReader.nextName();
                if (NAME_THEME_DESC_NAME.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeDescription.mName = jsonReader.nextString();
                    continue;
                }
                if (NAME_THEME_DESC_AUTHOR.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeDescription.mAuthor = jsonReader.nextString();
                    continue;
                }
                if (NAME_THEME_DESC_DESCRIPTION.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeDescription.mDescription = jsonReader.nextString();
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return themeDescription;
        }

        private static String readThemeModule(JsonReader jsonReader, ThemeModule themeModule) throws IOException {
            String string2 = jsonReader.nextName();
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                String string3 = jsonReader.nextName();
                if (NAME_THEME_MODULE_TARGET_PKG.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeModule.mTargetPkgName = jsonReader.nextString();
                    continue;
                }
                if (NAME_THEME_MODULE_ASSET_PATH.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeModule.mAssetPath = jsonReader.nextString();
                    continue;
                }
                if (NAME_THEME_MODULE_ARCHIVE_SRC_PATH.equals(string3) && jsonReader.peek() != JsonToken.NULL) {
                    themeModule.mArchiveSrcPath = jsonReader.nextString();
                    continue;
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return string2;
        }

        private static String readThemePackPkgName(JsonReader jsonReader) throws IOException {
            String string2 = EMPTY_STRING;
            if (NAME_THEME_PACK_PKG.equals(jsonReader.nextName()) && jsonReader.peek() != JsonToken.NULL) {
                return jsonReader.nextString();
            }
            jsonReader.skipValue();
            return string2;
        }

        /*
         * Unable to fully structure code
         */
        public static String toJson(ThemePack var0) {
            var1_1 = null;
            var2_2 = null;
            var3_3 = new StringWriter();
            var4_4 = new JsonWriter(var3_3);
            try {
                JsonSerializer.writeTheme(var4_4, var0);
                var8_5 = var3_3.toString();
            }
            catch (Throwable var6_13) {
                var2_2 = var4_4;
                var1_1 = var3_3;
                ** continue;
            }
            JsonSerializer.closeQuietly(var3_3);
            JsonSerializer.closeQuietly(var4_4);
            return var8_5;
            catch (IOException var5_6) lbl-1000:
            // 3 sources

            {
                while (true) {
                    try {
                        Log.e(ThemeManager.ASUS_THEME_LOG_TAG, "Could not write theme mapping", (Throwable)var5_7);
                    }
                    catch (Throwable var6_10) lbl-1000:
                    // 3 sources

                    {
                        while (true) {
                            JsonSerializer.closeQuietly(var1_1);
                            JsonSerializer.closeQuietly(var2_2);
                            throw var6_11;
                        }
                    }
                    JsonSerializer.closeQuietly(var1_1);
                    JsonSerializer.closeQuietly(var2_2);
                    return null;
                }
            }
            catch (Throwable var6_12) {
                var1_1 = var3_3;
                var2_2 = null;
                ** GOTO lbl-1000
            }
            catch (IOException var5_8) {
                var1_1 = var3_3;
                var2_2 = null;
                ** GOTO lbl-1000
            }
            catch (IOException var5_9) {
                var2_2 = var4_4;
                var1_1 = var3_3;
                ** continue;
            }
        }

        private static void writeTheme(JsonWriter jsonWriter, ThemePack themePack) throws IOException {
            jsonWriter.beginObject();
            JsonSerializer.writeThemePackPkgName(jsonWriter, themePack);
            JsonSerializer.writeThemeDesc(jsonWriter, themePack);
            for (Map.Entry<String, ThemeModule> entry : themePack.mThemeModules.entrySet()) {
                JsonSerializer.writeThemeModule(jsonWriter, entry.getKey(), entry.getValue());
            }
            jsonWriter.endObject();
        }

        private static void writeThemeDesc(JsonWriter jsonWriter, ThemePack themePack) throws IOException {
            jsonWriter.name(NAME_THEME_DESC_TAG);
            jsonWriter.beginObject();
            jsonWriter.name(NAME_THEME_DESC_NAME).value(themePack.mThemeDesc.mName);
            jsonWriter.name(NAME_THEME_DESC_AUTHOR).value(themePack.mThemeDesc.mAuthor);
            jsonWriter.name(NAME_THEME_DESC_DESCRIPTION).value(themePack.mThemeDesc.mDescription);
            jsonWriter.endObject();
        }

        private static void writeThemeModule(JsonWriter jsonWriter, String string2, ThemeModule themeModule) throws IOException {
            jsonWriter.name(string2);
            jsonWriter.beginObject();
            jsonWriter.name(NAME_THEME_MODULE_TARGET_PKG).value(themeModule.mTargetPkgName);
            jsonWriter.name(NAME_THEME_MODULE_ASSET_PATH).value(themeModule.mAssetPath);
            jsonWriter.name(NAME_THEME_MODULE_ARCHIVE_SRC_PATH).value(themeModule.mArchiveSrcPath);
            jsonWriter.endObject();
        }

        private static void writeThemePackPkgName(JsonWriter jsonWriter, ThemePack themePack) throws IOException {
            jsonWriter.name(NAME_THEME_PACK_PKG).value(themePack.mPkgName);
        }
    }

    public static class ThemeDescription
    implements Cloneable,
    Comparable<ThemeDescription> {
        String mAuthor;
        String mDescription;
        String mName;

        ThemeDescription() {
            this.mName = EMPTY_STRING;
            this.mAuthor = EMPTY_STRING;
            this.mDescription = EMPTY_STRING;
        }

        public ThemeDescription(String string2, String string3, String string4) {
            this.mName = string2;
            this.mAuthor = string3;
            this.mDescription = string4;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(ThemeDescription themeDescription) {
            if (themeDescription == null) {
                return -1;
            }
            if (this.mName == null) return -1;
            if (themeDescription.mName == null) return -1;
            int n = this.mName.compareTo(themeDescription.mName);
            if (n != 0) return n;
            if (this.mAuthor == null) return -1;
            if (themeDescription.mAuthor == null) return -1;
            n = this.mAuthor.compareTo(themeDescription.mAuthor);
            if (n != 0) return n;
            if (this.mDescription == null) return -1;
            if (themeDescription.mDescription == null) return -1;
            return this.mDescription.compareTo(themeDescription.mDescription);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (object == this) break block4;
                    if (!(object instanceof ThemeDescription)) {
                        return false;
                    }
                    ThemeDescription themeDescription = (ThemeDescription)object;
                    String string2 = this.mName == null ? EMPTY_STRING : this.mName;
                    String string3 = themeDescription.mName == null ? EMPTY_STRING : themeDescription.mName;
                    String string4 = this.mAuthor == null ? EMPTY_STRING : this.mAuthor;
                    String string5 = themeDescription.mAuthor == null ? EMPTY_STRING : themeDescription.mAuthor;
                    String string6 = this.mDescription == null ? EMPTY_STRING : this.mDescription;
                    String string7 = themeDescription.mDescription == null ? EMPTY_STRING : themeDescription.mDescription;
                    if (!string2.equals(string3) || !string4.equals(string5) || !string6.equals(string7)) break block5;
                }
                return true;
            }
            return false;
        }

        public String getAuthor() {
            return this.mAuthor;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getName() {
            return this.mName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int hashCode() {
            synchronized (this) {
                int n;
                int n2 = this.mName == null ? 0 : this.mName.hashCode();
                int n3 = 31 * (n2 + 527);
                int n4 = this.mAuthor == null ? 0 : this.mAuthor.hashCode();
                int n5 = 31 * (n3 + n4);
                String string2 = this.mDescription;
                int n6 = 0;
                if (string2 == null) return n5 + n6;
                n6 = n = this.mDescription.hashCode();
                return n5 + n6;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mName != null) {
                stringBuilder.append("name:");
                stringBuilder.append(this.mName);
            }
            if (this.mAuthor != null) {
                stringBuilder.append("author:");
                stringBuilder.append(this.mAuthor);
            }
            if (this.mDescription != null) {
                stringBuilder.append("description:");
                stringBuilder.append(this.mDescription);
            }
            return stringBuilder.toString();
        }
    }

    public static class ThemeModule
    implements Cloneable,
    Comparable<ThemeModule> {
        String mArchiveSrcPath;
        String mAssetPath;
        String mTargetPkgName;

        ThemeModule() {
            this.mTargetPkgName = EMPTY_STRING;
            this.mAssetPath = EMPTY_STRING;
            this.mArchiveSrcPath = EMPTY_STRING;
        }

        public ThemeModule(String string2) {
            this.mTargetPkgName = string2;
            this.mAssetPath = EMPTY_STRING;
            this.mArchiveSrcPath = EMPTY_STRING;
        }

        public ThemeModule(String string2, String string3, String string4) {
            this.mTargetPkgName = string2;
            this.mAssetPath = string3;
            this.mArchiveSrcPath = string4;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compareTo(ThemeModule themeModule) {
            if (themeModule == null) {
                return -1;
            }
            if (this.mArchiveSrcPath == null) return -1;
            if (themeModule.mArchiveSrcPath == null) return -1;
            int n = this.mArchiveSrcPath.compareTo(themeModule.mArchiveSrcPath);
            if (n != 0) return n;
            if (this.mAssetPath == null) return -1;
            if (themeModule.mAssetPath == null) return -1;
            n = this.mAssetPath.compareTo(themeModule.mAssetPath);
            if (n != 0) return n;
            if (this.mTargetPkgName == null) return -1;
            if (themeModule.mTargetPkgName == null) return -1;
            return this.mTargetPkgName.compareTo(themeModule.mTargetPkgName);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (object == this) break block4;
                    if (!(object instanceof ThemeModule)) {
                        return false;
                    }
                    ThemeModule themeModule = (ThemeModule)object;
                    String string2 = this.mTargetPkgName == null ? EMPTY_STRING : this.mTargetPkgName;
                    String string3 = themeModule.mTargetPkgName == null ? EMPTY_STRING : themeModule.mTargetPkgName;
                    String string4 = this.mAssetPath == null ? EMPTY_STRING : this.mAssetPath;
                    String string5 = themeModule.mAssetPath == null ? EMPTY_STRING : themeModule.mAssetPath;
                    String string6 = this.mArchiveSrcPath == null ? EMPTY_STRING : this.mArchiveSrcPath;
                    String string7 = themeModule.mArchiveSrcPath == null ? EMPTY_STRING : themeModule.mArchiveSrcPath;
                    if (!string2.equals(string3) || !string4.equals(string5) || !string6.equals(string7)) break block5;
                }
                return true;
            }
            return false;
        }

        public String getArchiveSrcPath() {
            return this.mArchiveSrcPath;
        }

        public String getAssetPath() {
            return this.mAssetPath;
        }

        public String getTargetPkgName() {
            return this.mTargetPkgName;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int hashCode() {
            synchronized (this) {
                int n;
                int n2 = this.mTargetPkgName == null ? 0 : this.mTargetPkgName.hashCode();
                int n3 = 31 * (n2 + 527);
                int n4 = this.mAssetPath == null ? 0 : this.mAssetPath.hashCode();
                int n5 = 31 * (n3 + n4);
                String string2 = this.mArchiveSrcPath;
                int n6 = 0;
                if (string2 == null) return n5 + n6;
                n6 = n = this.mArchiveSrcPath.hashCode();
                return n5 + n6;
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mTargetPkgName != null) {
                stringBuilder.append("module:");
                stringBuilder.append(this.mTargetPkgName);
            }
            if (this.mAssetPath != null) {
                stringBuilder.append("asset-path:");
                stringBuilder.append(this.mAssetPath);
            }
            if (this.mArchiveSrcPath != null) {
                stringBuilder.append("archive:");
                stringBuilder.append(this.mArchiveSrcPath);
            }
            return stringBuilder.toString();
        }
    }
}

