/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.AssetFileDescriptor;
import android.content.res.StringBlock;
import android.content.res.XmlBlock;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.SparseArray;
import android.util.TypedValue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public final class AssetManager
implements AutoCloseable {
    public static final int ACCESS_BUFFER = 3;
    public static final int ACCESS_RANDOM = 1;
    public static final int ACCESS_STREAMING = 2;
    public static final int ACCESS_UNKNOWN = 0;
    private static final boolean DEBUG_REFS = false;
    static final int STYLE_ASSET_COOKIE = 2;
    static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    static final int STYLE_DATA = 1;
    static final int STYLE_DENSITY = 5;
    static final int STYLE_NUM_ENTRIES = 6;
    static final int STYLE_RESOURCE_ID = 3;
    static final int STYLE_TYPE = 0;
    private static final String TAG = "AssetManager";
    private static final boolean localLOGV;
    private static final Object sSync;
    static AssetManager sSystem;
    private String mAppPackageName;
    private int mNumRefs = 1;
    private long mObject;
    private final long[] mOffsets;
    private boolean mOpen = true;
    private HashMap<Long, RuntimeException> mRefStacks;
    private StringBlock[] mStringBlocks = null;
    private HashMap<Integer, String> mThemeCookies;
    private boolean mThemeEnabled;
    private final TypedValue mValue = new TypedValue();

    static {
        sSync = new Object();
        sSystem = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AssetManager() {
        this.mOffsets = new long[2];
        this.mThemeCookies = new HashMap(2);
        synchronized (this) {
            this.init(false);
            AssetManager.ensureSystemAssets();
            return;
        }
    }

    private AssetManager(boolean bl) {
        this.mOffsets = new long[2];
        this.mThemeCookies = new HashMap(2);
        this.init(true);
    }

    private final native int addAssetPathNative(String var1);

    private final native int addOverlayPathNative(String var1, String var2);

    static final native boolean applyStyle(long var0, int var2, int var3, long var4, int[] var6, int[] var7, int[] var8);

    static final native void applyThemeStyle(long var0, int var2, boolean var3);

    static final native void copyTheme(long var0, long var2);

    private final void decRefsLocked(long l) {
        this.mNumRefs = -1 + this.mNumRefs;
        if (this.mNumRefs == 0) {
            this.destroy();
        }
    }

    private final native void deleteTheme(long var1);

    private final native void destroy();

    private final native void destroyAsset(long var1);

    static final native void dumpTheme(long var0, int var2, String var3, String var4);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void ensureSystemAssets() {
        Object object = sSync;
        synchronized (object) {
            if (sSystem == null) {
                AssetManager assetManager = new AssetManager(true);
                assetManager.makeStringBlocks(null);
                sSystem = assetManager;
            }
            return;
        }
    }

    private final native int[] getArrayStringInfo(int var1);

    private final native String[] getArrayStringResource(int var1);

    public static final native String getAssetAllocations();

    private final native long getAssetLength(long var1);

    private final native long getAssetRemainingLength(long var1);

    public static final native int getGlobalAssetCount();

    public static final native int getGlobalAssetManagerCount();

    private final native long getNativeStringBlock(int var1);

    private final native int getStringBlockCount();

    public static AssetManager getSystem() {
        AssetManager.ensureSystemAssets();
        return sSystem;
    }

    private final void incRefsLocked(long l) {
        this.mNumRefs = 1 + this.mNumRefs;
    }

    private final native void init(boolean var1);

    private final native int loadResourceBagValue(int var1, int var2, TypedValue var3, boolean var4);

    private final native int loadResourceValue(int var1, short var2, TypedValue var3, boolean var4);

    static final native int loadThemeAttributeValue(long var0, int var2, TypedValue var3, boolean var4);

    private final native long newTheme();

    private final native long openAsset(String var1, int var2);

    private final native ParcelFileDescriptor openAssetFd(String var1, long[] var2) throws IOException;

    private native ParcelFileDescriptor openNonAssetFdNative(int var1, String var2, long[] var3) throws IOException;

    private final native long openNonAssetNative(int var1, String var2, int var3);

    private final native long openXmlAssetNative(int var1, String var2);

    private final native int readAsset(long var1, byte[] var3, int var4, int var5);

    private final native int readAssetChar(long var1);

    private final native boolean removeOverlayPathNative(String var1, int var2);

    static final native boolean resolveAttrs(long var0, int var2, int var3, int[] var4, int[] var5, int[] var6, int[] var7);

    private final native long seekAsset(long var1, long var3, int var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int addAssetPath(String string2) {
        synchronized (this) {
            int n = this.addAssetPathNative(string2);
            this.makeStringBlocks(this.mStringBlocks);
            return n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int[] addAssetPaths(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            nArray[n] = this.addAssetPath(stringArray[n]);
            ++n;
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int addOverlayPath(String string2, String string3) {
        synchronized (this) {
            int n = this.addOverlayPathNative(string2, string3);
            this.makeStringBlocks(this.mStringBlocks);
            return n;
        }
    }

    public void addThemeCookie(int n, String string2) {
        this.mThemeCookies.put(n, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        synchronized (this) {
            if (this.mOpen) {
                this.mOpen = false;
                this.decRefsLocked(this.hashCode());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final long createTheme() {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long l = this.newTheme();
            this.incRefsLocked(l);
            return l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void ensureStringBlocks() {
        if (this.mStringBlocks != null) {
            return;
        }
        synchronized (this) {
            if (this.mStringBlocks == null) {
                this.makeStringBlocks(AssetManager.sSystem.mStringBlocks);
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            return;
        }
        finally {
            super.finalize();
        }
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    final native int[] getArrayIntResource(int var1);

    final native int getArraySize(int var1);

    public final native SparseArray<String> getAssignedPackageIdentifiers();

    public final native String getCookieName(int var1);

    public final native String[] getLocales();

    final CharSequence getPooledStringForCookie(int n, int n2) {
        return this.mStringBlocks[n - 1].get(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final CharSequence getResourceBagText(int n, int n2) {
        synchronized (this) {
            TypedValue typedValue = this.mValue;
            int n3 = this.loadResourceBagValue(n, n2, typedValue, true);
            if (n3 < 0) {
                return null;
            }
            if (typedValue.type != 3) return typedValue.coerceToString();
            return this.mStringBlocks[n3].get(typedValue.data);
        }
    }

    final native String getResourceEntryName(int var1);

    final native int getResourceIdentifier(String var1, String var2, String var3);

    final native String getResourceName(int var1);

    final native String getResourcePackageName(int var1);

    final String[] getResourceStringArray(int n) {
        return this.getArrayStringResource(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final CharSequence getResourceText(int n) {
        synchronized (this) {
            TypedValue typedValue = this.mValue;
            int n2 = this.loadResourceValue(n, (short)0, typedValue, true);
            if (n2 < 0) {
                return null;
            }
            if (typedValue.type != 3) return typedValue.coerceToString();
            return this.mStringBlocks[n2].get(typedValue.data);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final CharSequence[] getResourceTextArray(int n) {
        int[] nArray = this.getArrayStringInfo(n);
        int n2 = nArray.length;
        CharSequence[] charSequenceArray = new CharSequence[n2 / 2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = nArray[n3];
            int n6 = nArray[n3 + 1];
            CharSequence charSequence = n6 >= 0 ? this.mStringBlocks[n5].get(n6) : null;
            charSequenceArray[n4] = charSequence;
            n3 += 2;
            ++n4;
        }
        return charSequenceArray;
    }

    final native String getResourceTypeName(int var1);

    final boolean getResourceValue(int n, int n2, TypedValue typedValue, boolean bl) {
        int n3 = this.loadResourceValue(n, (short)n2, typedValue, bl);
        if (n3 >= 0) {
            if (typedValue.type != 3) {
                return true;
            }
            typedValue.string = this.mStringBlocks[n3].get(typedValue.data);
            return true;
        }
        return false;
    }

    final native int[] getStyleAttributes(int var1);

    public HashMap<Integer, String> getThemeCookies() {
        return this.mThemeCookies;
    }

    final boolean getThemeValue(long l, int n, TypedValue typedValue, boolean bl) {
        int n2 = AssetManager.loadThemeAttributeValue(l, n, typedValue, bl);
        if (n2 >= 0) {
            if (typedValue.type != 3) {
                return true;
            }
            StringBlock[] stringBlockArray = this.mStringBlocks;
            if (stringBlockArray == null) {
                this.ensureStringBlocks();
                stringBlockArray = this.mStringBlocks;
            }
            typedValue.string = stringBlockArray[n2].get(typedValue.data);
            return true;
        }
        return false;
    }

    public final boolean isThemeEnabled() {
        return this.mThemeEnabled;
    }

    public final native boolean isUpToDate();

    public final native String[] list(String var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     */
    final void makeStringBlocks(StringBlock[] stringBlockArray) {
        int n = stringBlockArray != null ? stringBlockArray.length : 0;
        int n2 = this.getStringBlockCount();
        this.mStringBlocks = new StringBlock[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.mStringBlocks[n3] = n3 < n ? stringBlockArray[n3] : new StringBlock(this.getNativeStringBlock(n3), true);
            ++n3;
        }
        return;
    }

    public final InputStream open(String string2) throws IOException {
        return this.open(string2, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream open(String string2, int n) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long l = this.openAsset(string2, n);
            if (l != 0L) {
                AssetInputStream assetInputStream = new AssetInputStream(l);
                this.incRefsLocked(assetInputStream.hashCode());
                return assetInputStream;
            }
            throw new FileNotFoundException("Asset file: " + string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AssetFileDescriptor openFd(String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor parcelFileDescriptor = this.openAssetFd(string2, this.mOffsets);
            if (parcelFileDescriptor == null) throw new FileNotFoundException("Asset file: " + string2);
            return new AssetFileDescriptor(parcelFileDescriptor, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    public final InputStream openNonAsset(int n, String string2) throws IOException {
        return this.openNonAsset(n, string2, 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final InputStream openNonAsset(int n, String string2, int n2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long l = this.openNonAssetNative(n, string2, n2);
            if (l != 0L) {
                AssetInputStream assetInputStream = new AssetInputStream(l);
                this.incRefsLocked(assetInputStream.hashCode());
                return assetInputStream;
            }
            throw new FileNotFoundException("Asset absolute file: " + string2);
        }
    }

    public final InputStream openNonAsset(String string2) throws IOException {
        return this.openNonAsset(0, string2, 2);
    }

    public final InputStream openNonAsset(String string2, int n) throws IOException {
        return this.openNonAsset(0, string2, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AssetFileDescriptor openNonAssetFd(int n, String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            ParcelFileDescriptor parcelFileDescriptor = this.openNonAssetFdNative(n, string2, this.mOffsets);
            if (parcelFileDescriptor == null) throw new FileNotFoundException("Asset absolute file: " + string2);
            return new AssetFileDescriptor(parcelFileDescriptor, this.mOffsets[0], this.mOffsets[1]);
        }
    }

    public final AssetFileDescriptor openNonAssetFd(String string2) throws IOException {
        return this.openNonAssetFd(0, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final XmlBlock openXmlBlockAsset(int n, String string2) throws IOException {
        synchronized (this) {
            if (!this.mOpen) {
                throw new RuntimeException("Assetmanager has been closed");
            }
            long l = this.openXmlAssetNative(n, string2);
            if (l != 0L) {
                XmlBlock xmlBlock = new XmlBlock(this, l);
                this.incRefsLocked(xmlBlock.hashCode());
                return xmlBlock;
            }
            throw new FileNotFoundException("Asset XML file: " + string2);
        }
    }

    final XmlBlock openXmlBlockAsset(String string2) throws IOException {
        return this.openXmlBlockAsset(0, string2);
    }

    public final XmlResourceParser openXmlResourceParser(int n, String string2) throws IOException {
        XmlBlock xmlBlock = this.openXmlBlockAsset(n, string2);
        XmlResourceParser xmlResourceParser = xmlBlock.newParser();
        xmlBlock.close();
        return xmlResourceParser;
    }

    public final XmlResourceParser openXmlResourceParser(String string2) throws IOException {
        return this.openXmlResourceParser(0, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void recreateStringBlocks() {
        synchronized (this) {
            this.makeStringBlocks(null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void releaseTheme(long l) {
        synchronized (this) {
            this.deleteTheme(l);
            this.decRefsLocked(l);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean removeOverlayPath(String string2, int n) {
        synchronized (this) {
            return this.removeOverlayPathNative(string2, n);
        }
    }

    final native int retrieveArray(int var1, int[] var2);

    final native boolean retrieveAttributes(long var1, int[] var3, int[] var4, int[] var5);

    public void setAppPackageName(String string2) {
        this.mAppPackageName = string2;
    }

    public final native void setConfiguration(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, int var17);

    public final native void setLocale(String var1);

    public final void setThemeEnabled(boolean bl) {
        this.mThemeEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void xmlBlockGone(int n) {
        synchronized (this) {
            long l = n;
            this.decRefsLocked(l);
            return;
        }
    }

    public final class AssetInputStream
    extends InputStream {
        private long mAsset;
        private long mLength;
        private long mMarkPos;

        private AssetInputStream(long l) {
            this.mAsset = l;
            this.mLength = AssetManager.this.getAssetLength(l);
        }

        @Override
        public final int available() throws IOException {
            long l = AssetManager.this.getAssetRemainingLength(this.mAsset);
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void close() throws IOException {
            AssetManager assetManager = AssetManager.this;
            synchronized (assetManager) {
                if (this.mAsset != 0L) {
                    AssetManager.this.destroyAsset(this.mAsset);
                    this.mAsset = 0L;
                    AssetManager.this.decRefsLocked(this.hashCode());
                }
                return;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public final int getAssetInt() {
            throw new UnsupportedOperationException();
        }

        public final long getNativeAsset() {
            return this.mAsset;
        }

        @Override
        public final void mark(int n) {
            this.mMarkPos = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
        }

        @Override
        public final boolean markSupported() {
            return true;
        }

        @Override
        public final int read() throws IOException {
            return AssetManager.this.readAssetChar(this.mAsset);
        }

        @Override
        public final int read(byte[] byArray) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, byArray, 0, byArray.length);
        }

        @Override
        public final int read(byte[] byArray, int n, int n2) throws IOException {
            return AssetManager.this.readAsset(this.mAsset, byArray, n, n2);
        }

        @Override
        public final void reset() throws IOException {
            AssetManager.this.seekAsset(this.mAsset, this.mMarkPos, -1);
        }

        @Override
        public final long skip(long l) throws IOException {
            long l2 = AssetManager.this.seekAsset(this.mAsset, 0L, 0);
            if (l2 + l > this.mLength) {
                l = this.mLength - l2;
            }
            if (l > 0L) {
                AssetManager.this.seekAsset(this.mAsset, l, 0);
            }
            return l;
        }
    }
}

