/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import android.util.AtomicFile;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class RegisteredServicesCache<V> {
    private static final boolean DEBUG = false;
    private static final String TAG = "PackageManager";
    private final String mAttributesName;
    public final Context mContext;
    private final BroadcastReceiver mExternalReceiver;
    private Handler mHandler;
    private final String mInterfaceName;
    private RegisteredServicesCacheListener<V> mListener;
    private final String mMetaDataName;
    private final BroadcastReceiver mPackageReceiver;
    private final AtomicFile mPersistentServicesFile;
    @GuardedBy(value="mServicesLock")
    private boolean mPersistentServicesFileDidNotExist;
    private final XmlSerializerAndParser<V> mSerializerAndParser;
    private final Object mServicesLock = new Object();
    @GuardedBy(value="mServicesLock")
    private final SparseArray<UserServices<V>> mUserServices = new SparseArray(2);

    public RegisteredServicesCache(Context context, String string2, String string3, String string4, XmlSerializerAndParser<V> xmlSerializerAndParser) {
        this.mPackageReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int n = intent.getIntExtra("android.intent.extra.UID", -1);
                if (n != -1) {
                    RegisteredServicesCache.this.handlePackageEvent(intent, UserHandle.getUserId(n));
                }
            }
        };
        this.mExternalReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                RegisteredServicesCache.this.handlePackageEvent(intent, 0);
            }
        };
        this.mContext = context;
        this.mInterfaceName = string2;
        this.mMetaDataName = string3;
        this.mAttributesName = string4;
        this.mSerializerAndParser = xmlSerializerAndParser;
        this.mPersistentServicesFile = new AtomicFile(new File(new File(new File(Environment.getDataDirectory(), "system"), "registered_services"), string2 + ".xml"));
        this.readPersistentServicesLocked();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mPackageReceiver, UserHandle.ALL, intentFilter, null, null);
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        intentFilter2.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mExternalReceiver, intentFilter2);
    }

    private boolean containsType(ArrayList<ServiceInfo<V>> arrayList, V v) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (!arrayList.get((int)i).type.equals(v)) continue;
            return true;
        }
        return false;
    }

    private boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> arrayList, V v, int n) {
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            ServiceInfo<V> serviceInfo = arrayList.get(i);
            if (!serviceInfo.type.equals(v) || serviceInfo.uid != n) continue;
            return true;
        }
        return false;
    }

    private UserServices<V> findOrCreateUserLocked(int n) {
        UserServices<V> userServices = this.mUserServices.get(n);
        if (userServices == null) {
            userServices = new UserServices();
            this.mUserServices.put(n, userServices);
        }
        return userServices;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateServicesMap(int n) {
        PackageManager packageManager = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> arrayList = new ArrayList<ServiceInfo<V>>();
        for (ResolveInfo resolveInfo : packageManager.queryIntentServicesAsUser(new Intent(this.mInterfaceName), 128, n)) {
            try {
                ServiceInfo<V> serviceInfo = this.parseServiceInfo(resolveInfo);
                if (serviceInfo == null) {
                    Log.w(TAG, "Unable to load service info " + resolveInfo.toString());
                }
                arrayList.add(serviceInfo);
            }
            catch (XmlPullParserException xmlPullParserException) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), xmlPullParserException);
            }
            catch (IOException iOException) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), iOException);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> userServices = this.findOrCreateUserLocked(n);
            boolean bl = userServices.services == null;
            if (bl) {
                userServices.services = Maps.newHashMap();
            } else {
                userServices.services.clear();
            }
            new StringBuilder();
            boolean bl2 = false;
            for (ServiceInfo serviceInfo : arrayList) {
                Integer n2 = userServices.persistentServices.get(serviceInfo.type);
                if (n2 == null) {
                    bl2 = true;
                    userServices.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    userServices.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (this.mPersistentServicesFileDidNotExist && bl) continue;
                    this.notifyListener(serviceInfo.type, n, false);
                    continue;
                }
                if (n2 == serviceInfo.uid) {
                    userServices.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (!this.inSystemImage(serviceInfo.uid) && this.containsTypeAndUid(arrayList, serviceInfo.type, n2)) continue;
                bl2 = true;
                userServices.services.put((ServiceInfo)serviceInfo.type, serviceInfo);
                userServices.persistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                this.notifyListener(serviceInfo.type, n, false);
            }
            ArrayList arrayList2 = Lists.newArrayList();
            for (Object v : userServices.persistentServices.keySet()) {
                if (this.containsType(arrayList, v)) continue;
                arrayList2.add(v);
            }
            for (Object e : arrayList2) {
                bl2 = true;
                userServices.persistentServices.remove(e);
                this.notifyListener(e, n, true);
            }
            if (bl2) {
                this.writePersistentServicesLocked();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void handlePackageEvent(Intent intent, int n) {
        String string2 = intent.getAction();
        boolean bl = "android.intent.action.PACKAGE_REMOVED".equals(string2) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(string2);
        boolean bl2 = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
        if (bl && bl2) {
            return;
        }
        this.generateServicesMap(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean inSystemImage(int n) {
        String[] stringArray = this.mContext.getPackageManager().getPackagesForUid(n);
        int n2 = stringArray.length;
        int n3 = 0;
        while (true) {
            boolean bl = false;
            if (n3 >= n2) return bl;
            String string2 = stringArray[n3];
            try {
                int n4 = this.mContext.getPackageManager().getPackageInfo((String)string2, (int)0).applicationInfo.flags;
                if ((n4 & 1) != 0) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return false;
            }
            ++n3;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void notifyListener(final V v, final int n, final boolean bl) {
        // MONITORENTER : this
        final RegisteredServicesCacheListener<V> registeredServicesCacheListener = this.mListener;
        Handler handler = this.mHandler;
        // MONITOREXIT : this
        if (registeredServicesCacheListener == null) {
            return;
        }
        handler.post(new Runnable(){

            @Override
            public void run() {
                registeredServicesCacheListener.onServiceChanged(v, n, bl);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ServiceInfo<V> parseServiceInfo(ResolveInfo resolveInfo) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo serviceInfo = resolveInfo.serviceInfo;
        ComponentName componentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        PackageManager packageManager = this.mContext.getPackageManager();
        XmlResourceParser xmlResourceParser = null;
        try {
            ServiceInfo<V> serviceInfo2;
            int n;
            block12: {
                xmlResourceParser = serviceInfo.loadXmlMetaData(packageManager, this.mMetaDataName);
                if (xmlResourceParser != null) break block12;
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attributeSet = Xml.asAttributeSet(xmlResourceParser);
            while ((n = xmlResourceParser.next()) != 1 && n != 2) {
            }
            String string2 = xmlResourceParser.getName();
            if (!this.mAttributesName.equals(string2)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(packageManager.getResourcesForApplication(serviceInfo.applicationInfo), serviceInfo.packageName, attributeSet);
            if (v == null) {
                serviceInfo2 = null;
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            try {
                serviceInfo2 = new ServiceInfo<V>(v, componentName, resolveInfo.serviceInfo.applicationInfo.uid);
                if (xmlResourceParser == null) return serviceInfo2;
                xmlResourceParser.close();
                return serviceInfo2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {}
            throw new XmlPullParserException("Unable to load resources for pacakge " + serviceInfo.packageName);
        }
        catch (Throwable throwable) {
            if (xmlResourceParser == null) throw throwable;
            xmlResourceParser.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readPersistentServicesLocked() {
        this.mUserServices.clear();
        if (this.mSerializerAndParser == null) {
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            boolean bl = !this.mPersistentServicesFile.getBaseFile().exists();
            this.mPersistentServicesFileDidNotExist = bl;
            boolean bl2 = this.mPersistentServicesFileDidNotExist;
            if (bl2) {
                return;
            }
            fileInputStream = this.mPersistentServicesFile.openRead();
            XmlPullParser xmlPullParser = Xml.newPullParser();
            xmlPullParser.setInput(fileInputStream, null);
            int n = xmlPullParser.getEventType();
            while (n != 2 && n != 1) {
                n = xmlPullParser.next();
            }
            if ("services".equals(xmlPullParser.getName())) {
                int n2 = xmlPullParser.next();
                while (true) {
                    int n3;
                    if (n2 != 2 || xmlPullParser.getDepth() != 2 || !"service".equals(xmlPullParser.getName())) continue;
                    V v = this.mSerializerAndParser.createFromXml(xmlPullParser);
                    if (v == null) break;
                    int n4 = Integer.parseInt(xmlPullParser.getAttributeValue(null, "uid"));
                    this.findOrCreateUserLocked((int)UserHandle.getUserId((int)n4)).persistentServices.put((Integer)v, n4);
                    if ((n2 = (n3 = xmlPullParser.next())) != 1) continue;
                    break;
                }
            }
            if (fileInputStream == null) return;
            try {
                fileInputStream.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (Exception exception) {
                Log.w(TAG, "Error reading persistent services, starting from scratch", exception);
                if (fileInputStream == null) return;
                try {
                    fileInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw throwable;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void writePersistentServicesLocked() {
        if (this.mSerializerAndParser == null) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = this.mPersistentServicesFile.startWrite();
            FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
            fastXmlSerializer.setOutput(fileOutputStream, "utf-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            fastXmlSerializer.startTag(null, "services");
            for (int i = 0; i < this.mUserServices.size(); ++i) {
                for (Map.Entry entry : this.mUserServices.valueAt((int)i).persistentServices.entrySet()) {
                    fastXmlSerializer.startTag(null, "service");
                    fastXmlSerializer.attribute(null, "uid", Integer.toString(entry.getValue()));
                    this.mSerializerAndParser.writeAsXml(entry.getKey(), fastXmlSerializer);
                    fastXmlSerializer.endTag(null, "service");
                }
            }
            fastXmlSerializer.endTag(null, "services");
            fastXmlSerializer.endDocument();
            this.mPersistentServicesFile.finishWrite(fileOutputStream);
            return;
        }
        catch (IOException iOException) {
            Log.w(TAG, "Error writing accounts", iOException);
            if (fileOutputStream == null) return;
            this.mPersistentServicesFile.failWrite(fileOutputStream);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray, int n) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> userServices = this.findOrCreateUserLocked(n);
            if (userServices.services != null) {
                printWriter.println("RegisteredServicesCache: " + userServices.services.size() + " services");
                for (ServiceInfo serviceInfo : userServices.services.values()) {
                    printWriter.println("  " + serviceInfo);
                }
            } else {
                printWriter.println("RegisteredServicesCache: services not loaded");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ServiceInfo<V>> getAllServices(int n) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> userServices = this.findOrCreateUserLocked(n);
            if (userServices.services != null) return Collections.unmodifiableCollection(new ArrayList(userServices.services.values()));
            this.generateServicesMap(n);
            return Collections.unmodifiableCollection(new ArrayList(userServices.services.values()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegisteredServicesCacheListener<V> getListener() {
        synchronized (this) {
            return this.mListener;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceInfo<V> getServiceInfo(V v, int n) {
        Object object = this.mServicesLock;
        synchronized (object) {
            UserServices<V> userServices = this.findOrCreateUserLocked(n);
            if (userServices.services != null) return userServices.services.get(v);
            this.generateServicesMap(n);
            return userServices.services.get(v);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidateCache(int n) {
        Object object = this.mServicesLock;
        synchronized (object) {
            this.findOrCreateUserLocked((int)n).services = null;
            return;
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setListener(RegisteredServicesCacheListener<V> registeredServicesCacheListener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        synchronized (this) {
            this.mHandler = handler;
            this.mListener = registeredServicesCacheListener;
            return;
        }
    }

    public static class ServiceInfo<V> {
        public final ComponentName componentName;
        public final V type;
        public final int uid;

        public ServiceInfo(V v, ComponentName componentName, int n) {
            this.type = v;
            this.componentName = componentName;
            this.uid = n;
        }

        public String toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }
    }

    private static class UserServices<V> {
        @GuardedBy(value="mServicesLock")
        public final Map<V, Integer> persistentServices = Maps.newHashMap();
        @GuardedBy(value="mServicesLock")
        public Map<V, ServiceInfo<V>> services = null;

        private UserServices() {
        }
    }
}

