/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.text.TextUtils;
import android.util.Printer;
import java.text.Collator;
import java.util.Comparator;

public class PackageItemInfo {
    public int banner;
    public int icon;
    public int labelRes;
    public int logo;
    public Bundle metaData;
    public String name;
    public CharSequence nonLocalizedLabel;
    public String packageName;
    public int showUserIcon;

    public PackageItemInfo() {
        this.showUserIcon = -10000;
    }

    public PackageItemInfo(PackageItemInfo packageItemInfo) {
        this.name = packageItemInfo.name;
        if (this.name != null) {
            this.name = this.name.trim();
        }
        this.packageName = packageItemInfo.packageName;
        this.labelRes = packageItemInfo.labelRes;
        this.nonLocalizedLabel = packageItemInfo.nonLocalizedLabel;
        if (this.nonLocalizedLabel != null) {
            this.nonLocalizedLabel = this.nonLocalizedLabel.toString().trim();
        }
        this.icon = packageItemInfo.icon;
        this.banner = packageItemInfo.banner;
        this.logo = packageItemInfo.logo;
        this.metaData = packageItemInfo.metaData;
        this.showUserIcon = packageItemInfo.showUserIcon;
    }

    protected PackageItemInfo(Parcel parcel) {
        this.name = parcel.readString();
        this.packageName = parcel.readString();
        this.labelRes = parcel.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.icon = parcel.readInt();
        this.logo = parcel.readInt();
        this.metaData = parcel.readBundle();
        this.banner = parcel.readInt();
        this.showUserIcon = parcel.readInt();
    }

    protected void dumpBack(Printer printer, String string2) {
    }

    protected void dumpFront(Printer printer, String string2) {
        if (this.name != null) {
            printer.println(string2 + "name=" + this.name);
        }
        printer.println(string2 + "packageName=" + this.packageName);
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0 || this.banner != 0) {
            printer.println(string2 + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon) + " banner=0x" + Integer.toHexString(this.banner));
        }
    }

    protected ApplicationInfo getApplicationInfo() {
        return null;
    }

    public Drawable loadBanner(PackageManager packageManager) {
        Drawable drawable2;
        if (this.banner != 0 && (drawable2 = packageManager.getDrawable(this.packageName, this.banner, this.getApplicationInfo())) != null) {
            return drawable2;
        }
        return this.loadDefaultBanner(packageManager);
    }

    protected Drawable loadDefaultBanner(PackageManager packageManager) {
        return null;
    }

    public Drawable loadDefaultIcon(PackageManager packageManager) {
        return packageManager.getDefaultActivityIcon();
    }

    protected Drawable loadDefaultLogo(PackageManager packageManager) {
        return null;
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return packageManager.loadItemIcon(this, this.getApplicationInfo());
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        CharSequence charSequence;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.labelRes != 0 && (charSequence = packageManager.getText(this.packageName, this.labelRes, this.getApplicationInfo())) != null) {
            return charSequence.toString().trim();
        }
        if (this.name != null) {
            return this.name;
        }
        return this.packageName;
    }

    public Drawable loadLogo(PackageManager packageManager) {
        Drawable drawable2;
        if (this.logo != 0 && (drawable2 = packageManager.getDrawable(this.packageName, this.logo, this.getApplicationInfo())) != null) {
            return drawable2;
        }
        return this.loadDefaultLogo(packageManager);
    }

    public XmlResourceParser loadXmlMetaData(PackageManager packageManager, String string2) {
        int n;
        if (this.metaData != null && (n = this.metaData.getInt(string2)) != 0) {
            return packageManager.getXml(this.packageName, n, this.getApplicationInfo());
        }
        return null;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.name);
        parcel.writeString(this.packageName);
        parcel.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, parcel, n);
        parcel.writeInt(this.icon);
        parcel.writeInt(this.logo);
        parcel.writeBundle(this.metaData);
        parcel.writeInt(this.banner);
        parcel.writeInt(this.showUserIcon);
    }

    public static class DisplayNameComparator
    implements Comparator<PackageItemInfo> {
        private PackageManager mPM;
        private final Collator sCollator = Collator.getInstance();

        public DisplayNameComparator(PackageManager packageManager) {
            this.mPM = packageManager;
        }

        @Override
        public final int compare(PackageItemInfo packageItemInfo, PackageItemInfo packageItemInfo2) {
            CharSequence charSequence;
            CharSequence charSequence2 = packageItemInfo.loadLabel(this.mPM);
            if (charSequence2 == null) {
                charSequence2 = packageItemInfo.name;
            }
            if ((charSequence = packageItemInfo2.loadLabel(this.mPM)) == null) {
                charSequence = packageItemInfo2.name;
            }
            return this.sCollator.compare(charSequence2.toString(), charSequence.toString());
        }
    }
}

