/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Printer;
import com.android.internal.util.ArrayUtils;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;

public class ApplicationInfo
extends PackageItemInfo
implements Parcelable {
    public static final Parcelable.Creator<ApplicationInfo> CREATOR = new Parcelable.Creator<ApplicationInfo>(){

        @Override
        public ApplicationInfo createFromParcel(Parcel parcel) {
            return new ApplicationInfo(parcel);
        }

        public ApplicationInfo[] newArray(int n) {
            return new ApplicationInfo[n];
        }
    };
    public static final int FLAG_ALLOW_BACKUP = 32768;
    public static final int FLAG_ALLOW_CLEAR_USER_DATA = 64;
    public static final int FLAG_ALLOW_TASK_REPARENTING = 32;
    public static final int FLAG_ASUS_APPS = 8;
    public static final int FLAG_ASUS_DIL = 4;
    public static final int FLAG_CANT_SAVE_STATE = 0x10000000;
    public static final int FLAG_DEBUGGABLE = 2;
    public static final int FLAG_EXTERNAL_STORAGE = 262144;
    public static final int FLAG_FACTORY_TEST = 16;
    public static final int FLAG_FORWARD_LOCK = 0x20000000;
    public static final int FLAG_FULL_BACKUP_ONLY = 0x4000000;
    public static final int FLAG_HAS_CODE = 4;
    public static final int FLAG_HIDDEN = 0x8000000;
    public static final int FLAG_INSTALLED = 0x800000;
    public static final int FLAG_IS_DATA_ONLY = 0x1000000;
    public static final int FLAG_IS_GAME = 0x2000000;
    public static final int FLAG_KILL_AFTER_RESTORE = 65536;
    public static final int FLAG_LARGE_HEAP = 0x100000;
    public static final int FLAG_MULTIARCH = Integer.MIN_VALUE;
    public static final int FLAG_PERSISTENT = 8;
    public static final int FLAG_PRIVILEGED = 0x40000000;
    public static final int FLAG_RESIZEABLE_FOR_SCREENS = 4096;
    public static final int FLAG_RESTORE_ANY_VERSION = 131072;
    public static final int FLAG_SEC_PART_APP = 2;
    public static final int FLAG_STICKY_PRELOADED_APP = 1;
    public static final int FLAG_STOPPED = 0x200000;
    public static final int FLAG_SUPPORTS_LARGE_SCREENS = 2048;
    public static final int FLAG_SUPPORTS_NORMAL_SCREENS = 1024;
    public static final int FLAG_SUPPORTS_RTL = 0x400000;
    public static final int FLAG_SUPPORTS_SCREEN_DENSITIES = 8192;
    public static final int FLAG_SUPPORTS_SMALL_SCREENS = 512;
    public static final int FLAG_SUPPORTS_XLARGE_SCREENS = 524288;
    public static final int FLAG_SYSTEM = 1;
    public static final int FLAG_TEST_ONLY = 256;
    public static final int FLAG_UPDATED_SYSTEM_APP = 128;
    public static final int FLAG_VM_SAFE_MODE = 16384;
    public String backupAgentName;
    public String className;
    public int compatibleWidthLimitDp;
    public String dataDir;
    public int descriptionRes;
    public boolean enabled;
    public int enabledSetting;
    public int flags;
    public int flagsAsus;
    public int installLocation;
    public boolean isMoving;
    public boolean isThemeable;
    public int largestWidthLimitDp;
    public String manageSpaceActivityName;
    public String nativeLibraryDir;
    public String nativeLibraryRootDir;
    public boolean nativeLibraryRootRequiresIsa;
    public String permission;
    public String primaryCpuAbi;
    public String processName;
    public String publicSourceDir;
    public int requiresSmallestWidthDp;
    public String[] resourceDirs;
    public String scanPublicSourceDir;
    public String scanSourceDir;
    public String secondaryCpuAbi;
    public String secondaryNativeLibraryDir;
    public String seinfo;
    public String[] sharedLibraryFiles;
    public String sourceDir;
    public String[] splitPublicSourceDirs;
    public String[] splitSourceDirs;
    public int targetSdkVersion;
    public String taskAffinity;
    public int theme;
    public int uiOptions;
    public int uid;
    public int versionCode;

    public ApplicationInfo() {
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = true;
        this.isMoving = false;
        this.enabledSetting = 0;
        this.isThemeable = true;
        this.installLocation = -1;
        this.flagsAsus = 0;
    }

    public ApplicationInfo(ApplicationInfo applicationInfo) {
        super(applicationInfo);
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = true;
        this.isMoving = false;
        this.enabledSetting = 0;
        this.isThemeable = true;
        this.installLocation = -1;
        this.flagsAsus = 0;
        this.taskAffinity = applicationInfo.taskAffinity;
        this.permission = applicationInfo.permission;
        this.processName = applicationInfo.processName;
        this.className = applicationInfo.className;
        this.theme = applicationInfo.theme;
        this.flags = applicationInfo.flags;
        this.requiresSmallestWidthDp = applicationInfo.requiresSmallestWidthDp;
        this.compatibleWidthLimitDp = applicationInfo.compatibleWidthLimitDp;
        this.largestWidthLimitDp = applicationInfo.largestWidthLimitDp;
        this.scanSourceDir = applicationInfo.scanSourceDir;
        this.scanPublicSourceDir = applicationInfo.scanPublicSourceDir;
        this.sourceDir = applicationInfo.sourceDir;
        this.publicSourceDir = applicationInfo.publicSourceDir;
        this.splitSourceDirs = applicationInfo.splitSourceDirs;
        this.splitPublicSourceDirs = applicationInfo.splitPublicSourceDirs;
        this.nativeLibraryDir = applicationInfo.nativeLibraryDir;
        this.secondaryNativeLibraryDir = applicationInfo.secondaryNativeLibraryDir;
        this.nativeLibraryRootDir = applicationInfo.nativeLibraryRootDir;
        this.nativeLibraryRootRequiresIsa = applicationInfo.nativeLibraryRootRequiresIsa;
        this.primaryCpuAbi = applicationInfo.primaryCpuAbi;
        this.secondaryCpuAbi = applicationInfo.secondaryCpuAbi;
        this.resourceDirs = applicationInfo.resourceDirs;
        this.seinfo = applicationInfo.seinfo;
        this.sharedLibraryFiles = applicationInfo.sharedLibraryFiles;
        this.dataDir = applicationInfo.dataDir;
        this.uid = applicationInfo.uid;
        this.targetSdkVersion = applicationInfo.targetSdkVersion;
        this.versionCode = applicationInfo.versionCode;
        this.enabled = applicationInfo.enabled;
        this.enabledSetting = applicationInfo.enabledSetting;
        this.installLocation = applicationInfo.installLocation;
        this.manageSpaceActivityName = applicationInfo.manageSpaceActivityName;
        this.descriptionRes = applicationInfo.descriptionRes;
        this.uiOptions = applicationInfo.uiOptions;
        this.backupAgentName = applicationInfo.backupAgentName;
        this.flagsAsus = applicationInfo.flagsAsus;
        this.isThemeable = applicationInfo.isThemeable;
        this.isMoving = applicationInfo.isMoving;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ApplicationInfo(Parcel parcel) {
        boolean bl = true;
        super(parcel);
        this.uiOptions = 0;
        this.flags = 0;
        this.requiresSmallestWidthDp = 0;
        this.compatibleWidthLimitDp = 0;
        this.largestWidthLimitDp = 0;
        this.enabled = bl;
        this.isMoving = false;
        this.enabledSetting = 0;
        this.isThemeable = bl;
        this.installLocation = -1;
        this.flagsAsus = 0;
        this.taskAffinity = parcel.readString();
        this.permission = parcel.readString();
        this.processName = parcel.readString();
        this.className = parcel.readString();
        this.theme = parcel.readInt();
        this.flags = parcel.readInt();
        this.requiresSmallestWidthDp = parcel.readInt();
        this.compatibleWidthLimitDp = parcel.readInt();
        this.largestWidthLimitDp = parcel.readInt();
        this.scanSourceDir = parcel.readString();
        this.scanPublicSourceDir = parcel.readString();
        this.sourceDir = parcel.readString();
        this.publicSourceDir = parcel.readString();
        this.splitSourceDirs = parcel.readStringArray();
        this.splitPublicSourceDirs = parcel.readStringArray();
        this.nativeLibraryDir = parcel.readString();
        this.secondaryNativeLibraryDir = parcel.readString();
        this.nativeLibraryRootDir = parcel.readString();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.nativeLibraryRootRequiresIsa = bl2;
        this.primaryCpuAbi = parcel.readString();
        this.secondaryCpuAbi = parcel.readString();
        this.resourceDirs = parcel.readStringArray();
        this.seinfo = parcel.readString();
        this.sharedLibraryFiles = parcel.readStringArray();
        this.dataDir = parcel.readString();
        this.uid = parcel.readInt();
        this.targetSdkVersion = parcel.readInt();
        this.versionCode = parcel.readInt();
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.enabled = bl3;
        this.enabledSetting = parcel.readInt();
        this.installLocation = parcel.readInt();
        this.manageSpaceActivityName = parcel.readString();
        this.backupAgentName = parcel.readString();
        this.descriptionRes = parcel.readInt();
        this.uiOptions = parcel.readInt();
        this.flagsAsus = parcel.readInt();
        boolean bl4 = parcel.readInt() != 0 ? bl : false;
        this.isThemeable = bl4;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.isMoving = bl;
    }

    private boolean isPackageUnavailable(PackageManager packageManager) {
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(this.packageName, 0);
            return packageInfo == null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return true;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void disableCompatibilityMode() {
        this.flags = 0x83E00 | this.flags;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(Printer printer, String string2) {
        super.dumpFront(printer, string2);
        if (this.className != null) {
            printer.println(string2 + "className=" + this.className);
        }
        if (this.permission != null) {
            printer.println(string2 + "permission=" + this.permission);
        }
        printer.println(string2 + "processName=" + this.processName);
        printer.println(string2 + "taskAffinity=" + this.taskAffinity);
        printer.println(string2 + "uid=" + this.uid + " flags=0x" + Integer.toHexString(this.flags) + " theme=0x" + Integer.toHexString(this.theme));
        printer.println(string2 + "requiresSmallestWidthDp=" + this.requiresSmallestWidthDp + " compatibleWidthLimitDp=" + this.compatibleWidthLimitDp + " largestWidthLimitDp=" + this.largestWidthLimitDp);
        printer.println(string2 + "sourceDir=" + this.sourceDir);
        if (!Objects.equals(this.sourceDir, this.publicSourceDir)) {
            printer.println(string2 + "publicSourceDir=" + this.publicSourceDir);
        }
        if (!ArrayUtils.isEmpty(this.splitSourceDirs)) {
            printer.println(string2 + "splitSourceDirs=" + Arrays.toString(this.splitSourceDirs));
        }
        if (!ArrayUtils.isEmpty(this.splitPublicSourceDirs) && !Arrays.equals(this.splitSourceDirs, this.splitPublicSourceDirs)) {
            printer.println(string2 + "splitPublicSourceDirs=" + Arrays.toString(this.splitPublicSourceDirs));
        }
        if (this.resourceDirs != null) {
            printer.println(string2 + "resourceDirs=" + this.resourceDirs);
        }
        if (this.seinfo != null) {
            printer.println(string2 + "seinfo=" + this.seinfo);
        }
        printer.println(string2 + "dataDir=" + this.dataDir);
        if (this.sharedLibraryFiles != null) {
            printer.println(string2 + "sharedLibraryFiles=" + this.sharedLibraryFiles);
        }
        printer.println(string2 + "enabled=" + this.enabled + " targetSdkVersion=" + this.targetSdkVersion + " versionCode=" + this.versionCode);
        if (this.manageSpaceActivityName != null) {
            printer.println(string2 + "manageSpaceActivityName=" + this.manageSpaceActivityName);
        }
        if (this.descriptionRes != 0) {
            printer.println(string2 + "description=0x" + Integer.toHexString(this.descriptionRes));
        }
        if (this.uiOptions != 0) {
            printer.println(string2 + "uiOptions=0x" + Integer.toHexString(this.uiOptions));
        }
        StringBuilder stringBuilder = new StringBuilder().append(string2).append("supportsRtl=");
        String string3 = this.hasRtlSupport() ? "true" : "false";
        printer.println(stringBuilder.append(string3).toString());
        printer.println(string2 + "uid=" + this.uid + " flagsAsus=0x" + Integer.toHexString(this.flagsAsus));
        super.dumpBack(printer, string2);
    }

    @Override
    protected ApplicationInfo getApplicationInfo() {
        return this;
    }

    public String getBaseCodePath() {
        return this.sourceDir;
    }

    public String getBaseResourcePath() {
        return this.publicSourceDir;
    }

    public String getCodePath() {
        return this.scanSourceDir;
    }

    public String getResourcePath() {
        return this.scanPublicSourceDir;
    }

    public String[] getSplitCodePaths() {
        return this.splitSourceDirs;
    }

    public String[] getSplitResourcePaths() {
        return this.splitSourceDirs;
    }

    public boolean hasRtlSupport() {
        return (0x400000 & this.flags) == 0x400000;
    }

    @Override
    public Drawable loadDefaultIcon(PackageManager packageManager) {
        if ((0x40000 & this.flags) != 0 && this.isPackageUnavailable(packageManager)) {
            return Resources.getSystem().getDrawable(17303461);
        }
        return packageManager.getDefaultActivityIcon();
    }

    public CharSequence loadDescription(PackageManager packageManager) {
        CharSequence charSequence;
        if (this.descriptionRes != 0 && (charSequence = packageManager.getText(this.packageName, this.descriptionRes, this)) != null) {
            return charSequence;
        }
        return null;
    }

    public void setBaseCodePath(String string2) {
        this.sourceDir = string2;
    }

    public void setBaseResourcePath(String string2) {
        this.publicSourceDir = string2;
    }

    public void setCodePath(String string2) {
        this.scanSourceDir = string2;
    }

    public void setResourcePath(String string2) {
        this.scanPublicSourceDir = string2;
    }

    public void setSplitCodePaths(String[] stringArray) {
        this.splitSourceDirs = stringArray;
    }

    public void setSplitResourcePaths(String[] stringArray) {
        this.splitPublicSourceDirs = stringArray;
    }

    public String toString() {
        return "ApplicationInfo{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.packageName + "}";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        super.writeToParcel(parcel, n);
        parcel.writeString(this.taskAffinity);
        parcel.writeString(this.permission);
        parcel.writeString(this.processName);
        parcel.writeString(this.className);
        parcel.writeInt(this.theme);
        parcel.writeInt(this.flags);
        parcel.writeInt(this.requiresSmallestWidthDp);
        parcel.writeInt(this.compatibleWidthLimitDp);
        parcel.writeInt(this.largestWidthLimitDp);
        parcel.writeString(this.scanSourceDir);
        parcel.writeString(this.scanPublicSourceDir);
        parcel.writeString(this.sourceDir);
        parcel.writeString(this.publicSourceDir);
        parcel.writeStringArray(this.splitSourceDirs);
        parcel.writeStringArray(this.splitPublicSourceDirs);
        parcel.writeString(this.nativeLibraryDir);
        parcel.writeString(this.secondaryNativeLibraryDir);
        parcel.writeString(this.nativeLibraryRootDir);
        int n3 = this.nativeLibraryRootRequiresIsa ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeString(this.primaryCpuAbi);
        parcel.writeString(this.secondaryCpuAbi);
        parcel.writeStringArray(this.resourceDirs);
        parcel.writeString(this.seinfo);
        parcel.writeStringArray(this.sharedLibraryFiles);
        parcel.writeString(this.dataDir);
        parcel.writeInt(this.uid);
        parcel.writeInt(this.targetSdkVersion);
        parcel.writeInt(this.versionCode);
        int n4 = this.enabled ? n2 : 0;
        parcel.writeInt(n4);
        parcel.writeInt(this.enabledSetting);
        parcel.writeInt(this.installLocation);
        parcel.writeString(this.manageSpaceActivityName);
        parcel.writeString(this.backupAgentName);
        parcel.writeInt(this.descriptionRes);
        parcel.writeInt(this.uiOptions);
        parcel.writeInt(this.flagsAsus);
        int n5 = this.isThemeable ? n2 : 0;
        parcel.writeInt(n5);
        if (!this.isMoving) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }

    public static class DisplayNameComparator
    implements Comparator<ApplicationInfo> {
        private PackageManager mPM;
        private final Collator sCollator = Collator.getInstance();

        public DisplayNameComparator(PackageManager packageManager) {
            this.mPM = packageManager;
        }

        @Override
        public final int compare(ApplicationInfo applicationInfo, ApplicationInfo applicationInfo2) {
            CharSequence charSequence;
            CharSequence charSequence2 = this.mPM.getApplicationLabel(applicationInfo);
            if (charSequence2 == null) {
                charSequence2 = applicationInfo.packageName;
            }
            if ((charSequence = this.mPM.getApplicationLabel(applicationInfo2)) == null) {
                charSequence = applicationInfo2.packageName;
            }
            return this.sCollator.compare(charSequence2.toString(), charSequence.toString());
        }
    }
}

