/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ISyncContext;
import android.content.SyncResult;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;

public class SyncContext {
    private static final long HEARTBEAT_SEND_INTERVAL_IN_MS = 1000L;
    private long mLastHeartbeatSendTime;
    private ISyncContext mSyncContext;

    public SyncContext(ISyncContext iSyncContext) {
        this.mSyncContext = iSyncContext;
        this.mLastHeartbeatSendTime = 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateHeartbeat() {
        long l = SystemClock.elapsedRealtime();
        if (l < 1000L + this.mLastHeartbeatSendTime) return;
        try {
            this.mLastHeartbeatSendTime = l;
            if (this.mSyncContext == null) return;
            this.mSyncContext.sendHeartbeat();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public IBinder getSyncContextBinder() {
        if (this.mSyncContext == null) {
            return null;
        }
        return this.mSyncContext.asBinder();
    }

    public void onFinished(SyncResult syncResult) {
        try {
            if (this.mSyncContext != null) {
                this.mSyncContext.onFinished(syncResult);
            }
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setStatusText(String string2) {
        this.updateHeartbeat();
    }
}

