/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

public class SearchRecentSuggestionsProvider
extends ContentProvider {
    public static final int DATABASE_MODE_2LINES = 2;
    public static final int DATABASE_MODE_QUERIES = 1;
    private static final int DATABASE_VERSION = 512;
    private static final String NULL_COLUMN = "query";
    private static final String ORDER_BY = "date DESC";
    private static final String TAG = "SuggestionsProvider";
    private static final int URI_MATCH_SUGGEST = 1;
    private static final String sDatabaseName = "suggestions.db";
    private static final String sSuggestions = "suggestions";
    private String mAuthority;
    private int mMode;
    private SQLiteOpenHelper mOpenHelper;
    private String mSuggestSuggestionClause;
    private String[] mSuggestionProjection;
    private Uri mSuggestionsUri;
    private boolean mTwoLineDisplay;
    private UriMatcher mUriMatcher;

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        if (uri.getPathSegments().size() != 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        if (uri.getPathSegments().get(0).equals(sSuggestions)) {
            int n = sQLiteDatabase.delete(sSuggestions, string2, stringArray);
            this.getContext().getContentResolver().notifyChange(uri, null);
            return n;
        }
        throw new IllegalArgumentException("Unknown Uri");
    }

    @Override
    public String getType(Uri uri) {
        if (this.mUriMatcher.match(uri) == 1) {
            return "vnd.android.cursor.dir/vnd.android.search.suggest";
        }
        int n = uri.getPathSegments().size();
        if (n >= 1 && uri.getPathSegments().get(0).equals(sSuggestions)) {
            if (n == 1) {
                return "vnd.android.cursor.dir/suggestion";
            }
            if (n == 2) {
                return "vnd.android.cursor.item/suggestion";
            }
        }
        throw new IllegalArgumentException("Unknown Uri");
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getWritableDatabase();
        int n = uri.getPathSegments().size();
        if (n < 1) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        long l = -1L;
        boolean bl = uri.getPathSegments().get(0).equals(sSuggestions);
        Uri uri2 = null;
        if (bl) {
            uri2 = null;
            if (n == 1) {
                l = sQLiteDatabase.insert(sSuggestions, NULL_COLUMN, contentValues);
                long l2 = l - 0L;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                uri2 = null;
                if (l3 > 0) {
                    uri2 = Uri.withAppendedPath(this.mSuggestionsUri, String.valueOf(l));
                }
            }
        }
        if (l < 0L) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        this.getContext().getContentResolver().notifyChange(uri2, null);
        return uri2;
    }

    @Override
    public boolean onCreate() {
        if (this.mAuthority == null || this.mMode == 0) {
            throw new IllegalArgumentException("Provider not configured");
        }
        int n = 512 + this.mMode;
        this.mOpenHelper = new DatabaseHelper(this.getContext(), n);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        SQLiteDatabase sQLiteDatabase = this.mOpenHelper.getReadableDatabase();
        if (this.mUriMatcher.match(uri) == 1) {
            String[] stringArray3;
            String string4;
            if (TextUtils.isEmpty(stringArray2[0])) {
                string4 = null;
                stringArray3 = null;
            } else {
                String string5 = "%" + stringArray2[0] + "%";
                stringArray3 = this.mTwoLineDisplay ? new String[]{string5, string5} : new String[]{string5};
                string4 = this.mSuggestSuggestionClause;
            }
            Cursor cursor = sQLiteDatabase.query(sSuggestions, this.mSuggestionProjection, string4, stringArray3, null, null, ORDER_BY, null);
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
            return cursor;
        }
        int n = uri.getPathSegments().size();
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String string6 = uri.getPathSegments().get(0);
        if (!string6.equals(sSuggestions)) {
            throw new IllegalArgumentException("Unknown Uri");
        }
        String[] stringArray4 = null;
        if (stringArray != null) {
            int n2 = stringArray.length;
            stringArray4 = null;
            if (n2 > 0) {
                stringArray4 = new String[1 + stringArray.length];
                System.arraycopy(stringArray, 0, stringArray4, 0, stringArray.length);
                stringArray4[stringArray.length] = "_id AS _id";
            }
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        if (n == 2) {
            stringBuilder.append("(_id = ").append(uri.getPathSegments().get(1)).append(")");
        }
        if (string2 != null && string2.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append('(');
            stringBuilder.append(string2);
            stringBuilder.append(')');
        }
        Cursor cursor = sQLiteDatabase.query(string6, stringArray4, stringBuilder.toString(), stringArray2, null, null, string3, null);
        cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return cursor;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void setupSuggestions(String string2, int n) {
        if (TextUtils.isEmpty(string2) || (n & 1) == 0) {
            throw new IllegalArgumentException();
        }
        boolean bl = (n & 2) != 0;
        this.mTwoLineDisplay = bl;
        this.mAuthority = new String(string2);
        this.mMode = n;
        this.mSuggestionsUri = Uri.parse("content://" + this.mAuthority + "/suggestions");
        this.mUriMatcher = new UriMatcher(-1);
        this.mUriMatcher.addURI(this.mAuthority, "search_suggest_query", 1);
        if (this.mTwoLineDisplay) {
            this.mSuggestSuggestionClause = "display1 LIKE ? OR display2 LIKE ?";
            this.mSuggestionProjection = new String[]{"0 AS suggest_format", "'android.resource://system/17301578' AS suggest_icon_1", "display1 AS suggest_text_1", "display2 AS suggest_text_2", "query AS suggest_intent_query", "_id"};
            return;
        }
        this.mSuggestSuggestionClause = "display1 LIKE ?";
        this.mSuggestionProjection = new String[]{"0 AS suggest_format", "'android.resource://system/17301578' AS suggest_icon_1", "display1 AS suggest_text_1", "query AS suggest_intent_query", "_id"};
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private int mNewVersion;

        public DatabaseHelper(Context context, int n) {
            super(context, SearchRecentSuggestionsProvider.sDatabaseName, null, n);
            this.mNewVersion = n;
        }

        @Override
        public void onCreate(SQLiteDatabase sQLiteDatabase) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CREATE TABLE suggestions (_id INTEGER PRIMARY KEY,display1 TEXT UNIQUE ON CONFLICT REPLACE");
            if ((2 & this.mNewVersion) != 0) {
                stringBuilder.append(",display2 TEXT");
            }
            stringBuilder.append(",query TEXT,date LONG);");
            sQLiteDatabase.execSQL(stringBuilder.toString());
        }

        @Override
        public void onUpgrade(SQLiteDatabase sQLiteDatabase, int n, int n2) {
            Log.w(SearchRecentSuggestionsProvider.TAG, "Upgrading database from version " + n + " to " + n2 + ", which will destroy all old data");
            sQLiteDatabase.execSQL("DROP TABLE IF EXISTS suggestions");
            this.onCreate(sQLiteDatabase);
        }
    }
}

