/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.AndroidException;

public class IntentSender
implements Parcelable {
    public static final Parcelable.Creator<IntentSender> CREATOR = new Parcelable.Creator<IntentSender>(){

        @Override
        public IntentSender createFromParcel(Parcel parcel) {
            IBinder iBinder = parcel.readStrongBinder();
            if (iBinder != null) {
                return new IntentSender(iBinder);
            }
            return null;
        }

        public IntentSender[] newArray(int n) {
            return new IntentSender[n];
        }
    };
    private final IIntentSender mTarget;

    public IntentSender(IIntentSender iIntentSender) {
        this.mTarget = iIntentSender;
    }

    public IntentSender(IBinder iBinder) {
        this.mTarget = IIntentSender.Stub.asInterface(iBinder);
    }

    public static IntentSender readIntentSenderOrNullFromParcel(Parcel parcel) {
        IBinder iBinder = parcel.readStrongBinder();
        if (iBinder != null) {
            return new IntentSender(iBinder);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void writeIntentSenderOrNullToParcel(IntentSender intentSender, Parcel parcel) {
        IBinder iBinder = intentSender != null ? intentSender.mTarget.asBinder() : null;
        parcel.writeStrongBinder(iBinder);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof IntentSender) {
            return this.mTarget.asBinder().equals(((IntentSender)object).mTarget.asBinder());
        }
        return false;
    }

    public String getCreatorPackage() {
        try {
            String string2 = ActivityManagerNative.getDefault().getPackageForIntentSender(this.mTarget);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getCreatorUid() {
        try {
            int n = ActivityManagerNative.getDefault().getUidForIntentSender(this.mTarget);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public UserHandle getCreatorUserHandle() {
        block3: {
            int n;
            try {
                n = ActivityManagerNative.getDefault().getUidForIntentSender(this.mTarget);
                if (n <= 0) break block3;
            }
            catch (RemoteException remoteException) {
                return null;
            }
            UserHandle userHandle = new UserHandle(UserHandle.getUserId(n));
            return userHandle;
        }
        return null;
    }

    public IIntentSender getTarget() {
        return this.mTarget;
    }

    @Deprecated
    public String getTargetPackage() {
        try {
            String string2 = ActivityManagerNative.getDefault().getPackageForIntentSender(this.mTarget);
            return string2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int hashCode() {
        return this.mTarget.asBinder().hashCode();
    }

    public void sendIntent(Context context, int n, Intent intent, OnFinished onFinished, Handler handler) throws SendIntentException {
        this.sendIntent(context, n, intent, onFinished, handler, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendIntent(Context context, int n, Intent intent, OnFinished onFinished, Handler handler, String string2) throws SendIntentException {
        String string3;
        if (intent != null) {
            try {
                string3 = intent.resolveTypeIfNeeded(context.getContentResolver());
            }
            catch (RemoteException remoteException) {
                throw new SendIntentException();
            }
        } else {
            string3 = null;
        }
        IIntentSender iIntentSender = this.mTarget;
        FinishedDispatcher finishedDispatcher = null;
        if (onFinished != null) {
            finishedDispatcher = new FinishedDispatcher(this, onFinished, handler);
        }
        if (iIntentSender.send(n, intent, string3, finishedDispatcher, string2) >= 0) return;
        throw new SendIntentException();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("IntentSender{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(": ");
        IBinder iBinder = this.mTarget != null ? this.mTarget.asBinder() : null;
        stringBuilder.append(iBinder);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeStrongBinder(this.mTarget.asBinder());
    }

    private static class FinishedDispatcher
    extends IIntentReceiver.Stub
    implements Runnable {
        private final Handler mHandler;
        private Intent mIntent;
        private final IntentSender mIntentSender;
        private int mResultCode;
        private String mResultData;
        private Bundle mResultExtras;
        private final OnFinished mWho;

        FinishedDispatcher(IntentSender intentSender, OnFinished onFinished, Handler handler) {
            this.mIntentSender = intentSender;
            this.mWho = onFinished;
            this.mHandler = handler;
        }

        @Override
        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
            this.mIntent = intent;
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
            if (this.mHandler == null) {
                this.run();
                return;
            }
            this.mHandler.post(this);
        }

        @Override
        public void run() {
            this.mWho.onSendFinished(this.mIntentSender, this.mIntent, this.mResultCode, this.mResultData, this.mResultExtras);
        }
    }

    public static interface OnFinished {
        public void onSendFinished(IntentSender var1, Intent var2, int var3, String var4, Bundle var5);
    }

    public static class SendIntentException
    extends AndroidException {
        public SendIntentException() {
        }

        public SendIntentException(Exception exception) {
            super(exception);
        }

        public SendIntentException(String string2) {
            super(string2);
        }
    }
}

