/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ContentValues
implements Parcelable {
    public static final Parcelable.Creator<ContentValues> CREATOR = new Parcelable.Creator<ContentValues>(){

        @Override
        public ContentValues createFromParcel(Parcel parcel) {
            return new ContentValues(parcel.readHashMap(null));
        }

        public ContentValues[] newArray(int n) {
            return new ContentValues[n];
        }
    };
    public static final String TAG = "ContentValues";
    private HashMap<String, Object> mValues;

    public ContentValues() {
        this.mValues = new HashMap(8);
    }

    public ContentValues(int n) {
        this.mValues = new HashMap(n, 1.0f);
    }

    public ContentValues(ContentValues contentValues) {
        this.mValues = new HashMap<String, Object>(contentValues.mValues);
    }

    private ContentValues(HashMap<String, Object> hashMap) {
        this.mValues = hashMap;
    }

    public void clear() {
        this.mValues.clear();
    }

    public boolean containsKey(String string2) {
        return this.mValues.containsKey(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ContentValues)) {
            return false;
        }
        return this.mValues.equals(((ContentValues)object).mValues);
    }

    public Object get(String string2) {
        return this.mValues.get(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Boolean getAsBoolean(String string2) {
        Object object = this.mValues.get(string2);
        try {
            return (Boolean)object;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                return Boolean.valueOf(object.toString());
            }
            if (object instanceof Number) {
                boolean bl;
                if (((Number)object).intValue() != 0) {
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Boolean: " + object, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Byte getAsByte(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Byte by = ((Number)object).byteValue();
            return by;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Byte.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Byte value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Byte: " + object, classCastException);
            return null;
        }
    }

    public byte[] getAsByteArray(String string2) {
        Object object = this.mValues.get(string2);
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Double getAsDouble(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Double d = ((Number)object).doubleValue();
            return d;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Double.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Double value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Double: " + object, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Float getAsFloat(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Float f = Float.valueOf(((Number)object).floatValue());
            return f;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Float.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Float value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Float: " + object, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Integer getAsInteger(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Integer n = ((Number)object).intValue();
            return n;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Integer.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Integer value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Integer: " + object, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long getAsLong(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Long l = ((Number)object).longValue();
            return l;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Long.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Long value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Long: " + object, classCastException);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Short getAsShort(String string2) {
        Object object = this.mValues.get(string2);
        if (object == null) return null;
        try {
            Short s = ((Number)object).shortValue();
            return s;
        }
        catch (ClassCastException classCastException) {
            if (object instanceof CharSequence) {
                try {
                    return Short.valueOf(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Log.e(TAG, "Cannot parse Short value for " + object + " at key " + string2);
                    return null;
                }
            }
            Log.e(TAG, "Cannot cast value for " + string2 + " to a Short: " + object, classCastException);
            return null;
        }
    }

    public String getAsString(String string2) {
        Object object = this.mValues.get(string2);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    @Deprecated
    public ArrayList<String> getStringArrayList(String string2) {
        return (ArrayList)this.mValues.get(string2);
    }

    public int hashCode() {
        return this.mValues.hashCode();
    }

    public Set<String> keySet() {
        return this.mValues.keySet();
    }

    public void put(String string2, Boolean bl) {
        this.mValues.put(string2, bl);
    }

    public void put(String string2, Byte by) {
        this.mValues.put(string2, by);
    }

    public void put(String string2, Double d) {
        this.mValues.put(string2, d);
    }

    public void put(String string2, Float f) {
        this.mValues.put(string2, f);
    }

    public void put(String string2, Integer n) {
        this.mValues.put(string2, n);
    }

    public void put(String string2, Long l) {
        this.mValues.put(string2, l);
    }

    public void put(String string2, Short s) {
        this.mValues.put(string2, s);
    }

    public void put(String string2, String string3) {
        this.mValues.put(string2, string3);
    }

    public void put(String string2, byte[] byArray) {
        this.mValues.put(string2, byArray);
    }

    public void putAll(ContentValues contentValues) {
        this.mValues.putAll(contentValues.mValues);
    }

    public void putNull(String string2) {
        this.mValues.put(string2, null);
    }

    @Deprecated
    public void putStringArrayList(String string2, ArrayList<String> arrayList) {
        this.mValues.put(string2, arrayList);
    }

    public void remove(String string2) {
        this.mValues.remove(string2);
    }

    public int size() {
        return this.mValues.size();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.mValues.keySet()) {
            String string3 = this.getAsString(string2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string2 + "=" + string3);
        }
        return stringBuilder.toString();
    }

    public Set<Map.Entry<String, Object>> valueSet() {
        return this.mValues.entrySet();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeMap(this.mValues);
    }
}

